

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GettmActionDetails.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2GettmActionDetails.sp,v $ $Id: MMS2GettmActionDetails.sp,v 1.14.210.3 2018/03/20 19:46:16 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2GettmActionDetails <<<'

IF EXISTS (select * from sysobjects where name='MMS2GettmActionDetails')
	drop procedure MMS2GettmActionDetails
IF EXISTS (select * from GxQscripts where name='MMS2GettmActionDetails')
	delete from GxQscripts where name = 'MMS2GettmActionDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GettmActionDetails')
	delete from GXDBVersions where aliasname = 'MMS2GettmActionDetails'
GO
print '... Creating Procedure: MMS2GettmActionDetails'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2GettmActionDetails
  @i_ActionId integer,
  @i_HistoryId integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_ActionId integer
  DECLARE @o_HistoryId integer
  DECLARE @o_MediaId integer
  DECLARE @o_MediaBarCode char(255)
  DECLARE @o_ActionState integer
  DECLARE @o_ActionFlag integer
  DECLARE @o_OperationId integer
  DECLARE @o_OperationState integer
  DECLARE @o_StartTime integer
  DECLARE @o_EndTime integer
  DECLARE @o_CurrentLocId integer
  DECLARE @o_LocationName NVARCHAR(255)
  DECLARE @o_LocationType integer
  DECLARE @o_ExportLocType integer
  DECLARE @o_ContainerId integer
  DECLARE @o_ContainerName NVARCHAR(255)
  DECLARE @o_sourceId integer
  DECLARE @o_sourceLocType integer
  DECLARE @o_sourceLocValue integer
  DECLARE @o_sourceLocName NVARCHAR(255)
  DECLARE @o_destinationId integer
  DECLARE @o_destLocType integer
  DECLARE @o_destLocValue integer
  DECLARE @o_destLocName NVARCHAR(255)
  DECLARE @o_mediaLibId integer
  DECLARE @o_mediaLibName NVARCHAR(255)
  DECLARE @o_exportError integer
  DECLARE @o_dueBackTime varchar(255)
  DECLARE @o_dueBackTimeInt bigint
	if object_id('tempdb.dbo.#tmpTMActionMedia') is not null DROP TABLE #tmpTMActionMedia
	create table #tmpTMActionMedia(	ActionId	integer,
					HistoryId	integer,
					MediaId		integer,
					BarCode		varchar(255),
					ActionState	integer,
					ActionFlag	integer,
					Operation	integer,
					OperationState	integer,
					Starttime	DATETIME,
					EndTime		DATETIME,
					currentLocId	integer,
					locationName	nvarchar(255),
					locationType	integer,
					exportLocType	integer,
					ContainerId	integer,
					sourceLocId	integer,
					sourceLocType	integer,
					sourceLocValue	integer,
					sourceLocName	nvarchar(255),
					destinationId	integer,
					destinationType	integer,
					destLocValue	integer,
					destLocName	nvarchar(255),
					mediaLibraryId	integer,
					libAliasName	nvarchar(255),
					exportError		integer,
					DueBackTimeInt	bigint,
					DueBackTime		varchar(255)
					)
	if(@i_HistoryId = 0)
	begin
		declare @l_DestinationLocId	integer
		declare	@l_DestinationLocType	integer
		declare	@l_destinationLocValue	integer
		declare	@l_destinationLocName	nvarchar(255)
		declare @l_sourceLocId	integer
		declare	@l_sourceLocType	integer
		declare	@l_sourceLocValue	integer
		declare	@l_sourceLocName	nvarchar(255)
		select
		@l_sourceLocId = isnull(b.locationId, 0),
		@l_sourceLocType = isnull(b.locationType, 0),
		@l_sourceLocValue = isnull(b.locationValue, 0),
		@l_sourceLocName = isnull(b.locationName, '')
		from VTAction a, VTLocationView b
		where a.actionId = @i_ActionId and a.sourceId = b.locationId
		select
		@l_DestinationLocId = isnull(b.locationId, 0),
		@l_DestinationLocType = isnull(b.locationType, 0),
		@l_destinationLocValue = isnull(b.locationValue, 0),
		@l_destinationLocName = isnull(b.locationName, '')
		from VTAction a, VTLocationView b
		where a.actionId = @i_ActionId and a.DestinationId = b.locationId
		insert into #tmpTMActionMedia
		select distinct TMAM.ActionId, 0, TMAM.MediaId, MM.Barcode, TMAM.State, TMAM.Flag,
		TMAM.Operation, TMAM.OperationState, TMAM.TimeStamp, 0,
		TMAM.CurrentId, tt.LocationName, tt.LocationType, tt.ExportLocationType, MM.ContainerId,
		@l_sourceLocId, @l_sourceLocType, @l_sourceLocValue, @l_sourceLocName,
		@l_DestinationLocId, @l_DestinationLocType, @l_destinationLocValue, @l_destinationLocName,
		MM.LibraryId, libAliasName = (select AliasName from MMLibrary where LibraryId = MM.LibraryId),
		TMAM.ExportError, MM.retentionExpireTime, ''
		from VTActionMedia as TMAM, VTAction as TMA, VTLocationView as tt, MMMedia as MM
		where TMAM.MediaId = MM.MediaId and TMAM.CurrentId = tt.LocationId and
		TMAM.ActionId = TMA.ActionId and TMA.ActionId = @i_ActionId
		update #tmpTMActionMedia
		set locationName = tt.locationName + ' (' + MS.slotName + ')'
		from MMSlot as MS, #tmpTMActionMedia as tt
		where MS.MediaId = tt.MediaId
		AND (tt.locationType = 4 OR tt.locationType = 1)
		update #tmpTMActionMedia
		set locationName = tt.locationName + ' (In the drive ' + MD.AliasName+ ')'
		from MMDrive as MD, #tmpTMActionMedia as tt
		where MD.MediaId = tt.MediaId and exists(select * from MMDrive where MediaId = tt.MediaId)
		AND tt.locationType = 1
	end
	else
	begin
		DECLARE @l_ActionIdByHistoryId integer
		set @l_ActionIdByHistoryId = (select ActionId from VTHistory where HistoryId = @i_HistoryId)
		insert into #tmpTMActionMedia
		select distinct TMH.ActionId, TMH.HistoryId, TMH.MediaId, TMH.Barcode, TMH.State, 0,
		0, TMH.State, TMH.StartTime, TMH.EndTime,
		0, '', 0, 0,
 		isnull((select ContainerId from MMMedia where MediaId = TMH.MediaId), 0),
 		TMH.SourceId, 0, 0, TMH.SourceLocation,
 		TMH.DestinationId, 0, 0, TMH.DestinationLocation,
 		isnull((select LibraryId from MMMedia where MediaId = TMH.MediaId), 0),
 		isnull((select AliasName from MMLibrary where LibraryId =
 		isnull((select LibraryId from MMMedia where MediaId = TMH.MediaId), 0)), 0),
 		TMH.ExportError, TMH.DueBackTime, ''
 		from VTHistory as TMH
 		where TMH.actionId = @l_ActionIdByHistoryId
		update #tmpTMActionMedia
			set ContainerId = a.ContainerId,
				locationName =
				case a.MediaLocation
				when 1 then c.AliasName
				when 2 then c.AliasName
				when 3 then (
					case c.LibraryTypeId when 8 then c.AliasName else b.ExportLocation end
				) else '' end
		FROM #tmpTMActionMedia tt, MMMedia a, MMExportLocation b, MMLibrary c
		WHERE tt.MediaId = a.MediaId
		AND a.ExportLocationId = b.ExportLocationId
		AND a.LibraryId = c.LibraryId
	end
	DECLARE @l_currentUTCTime INTEGER
	SET @l_currentUTCTime = dbo.GetUnixTime(GetUTCDate())
	update #tmpTMActionMedia
	set DueBackTime = CASE
				WHEN DueBackTimeInt = -1 then 'Never'
				WHEN DueBackTimeInt >=0 AND  DueBackTimeInt <= @l_currentUTCTime then 'Now'
				ELSE cast ( dbo.GetDateTimeBig(DueBackTimeInt) as varchar(255))
			  END,
	    DueBackTimeInt = CASE
							WHEN DueBackTimeInt >0 AND  DueBackTimeInt <= @l_currentUTCTime then 0
						 	ELSE DueBackTimeInt
						 END
	select tt.ActionId, tt.HistoryId, tt.MediaId, tt.BarCode, tt.ActionState, tt.ActionFlag, tt.Operation, tt.OperationState,
	dbo.getUnixTime(tt.StartTime),
	dbo.getUnixTime(tt.EndTime),
	tt.currentLocId, tt.locationName, tt.locationType, tt.exportLocType, MC.ContainerId, MC.ContainerName,
	tt.sourceLocId, tt.sourceLocType, tt.sourceLocValue, tt.sourceLocName,
	tt.destinationId, tt.destinationType, tt.destLocValue, tt.destLocName,
	tt.mediaLibraryId, tt.libAliasName, tt.exportError, tt.DueBackTime, tt.DueBackTimeInt
	from #tmpTMActionMedia as tt, MMContainer as MC
	where tt.ContainerId = MC.ContainerId
	drop table #tmpTMActionMedia
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2GettmActionDetails')
	delete from GxQscripts where name = 'MMS2GettmActionDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GettmActionDetails')
	delete from GXDBVersions where aliasname = 'MMS2GettmActionDetails'
GO

insert into GXDBVersions values(2, 'MMS2GettmActionDetails',  '00010014021000030000', 'MMS2GettmActionDetails', '00010014021000030000')
GO

