

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GetVolumesToUpdateSize.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2GetVolumesToUpdateSize.sp,v $ $Id: MMS2GetVolumesToUpdateSize.sp,v 1.9.2.12 2019/10/09 16:46:11 anarulkar Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Cursor: "MMS2GetVolumesToUpdateSize"		|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMS2GetVolumesToUpdateSize')
BEGIN
	print '>>> Drop Stored Procedure: MMS2GetVolumesToUpdateSize <<<'
	drop procedure MMS2GetVolumesToUpdateSize
END
IF EXISTS (select * from GxQscripts where name='MMS2GetVolumesToUpdateSize')
	delete from GxQscripts where name = 'MMS2GetVolumesToUpdateSize'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetVolumesToUpdateSize')
	delete from GXDBVersions where aliasname = 'MMS2GetVolumesToUpdateSize'
GO
print '... Creating Procedure: MMS2GetVolumesToUpdateSize'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MMS2GetVolumesToUpdateSize
-- The following two lines indicate, in order, parameters that will be
--  expected in the "setValues()" method, as well as the order in which
--  they will be provided as arguments to the SQLSTRING command
  @i_MaxVolumesPerMA INTEGER,
  @i_MediaAgentId INTEGER,
  @i_reserveParamStr VARCHAR(1024)
AS
--	The next few lines are the columns, in order, that will be in the
--  result set for this cursor.  EXTREME CAUTION must be exercised to
--  ensure that these match up with the result set in terms of type, size,
--  and order!
  DECLARE @o_VolumeId INTEGER
  DECLARE @o_VolumeName VARCHAR(112)
  DECLARE @o_OMLVersion INTEGER
  DECLARE @o_lastPruneTime INTEGER
  DECLARE @o_HostId INTEGER
  DECLARE @o_devicePath NVARCHAR(1024)
  DECLARE @o_MountPathId INTEGER
  DECLARE @o_MountPathName NVARCHAR(1024)
  DECLARE @o_MountPathTypeId INTEGER
  DECLARE @o_DeviceTypeId INTEGER
  DECLARE @o_UserName varchar(1024)
  DECLARE @o_Password varchar(2048)
-- These lines represent the actual SQL code that will get executed.  Note
-- The "printf" style substitutions.  These should match up exactly with
-- :PARAM input lines
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
if object_id('tempdb.dbo.#tmpMLList') is not null DROP TABLE #tmpMLList
create table #tmpMLList
(
	MediaSideId			INTEGER,
	ClientId			INTEGER,
Folder				NVARCHAR(1024),
	MountPathID			INTEGER,
MountPathName		NVARCHAR(1024),
	MountPathTypeId		INTEGER,
	DeviceTypeId		INTEGER,
UserName			varchar(1024),
UserPassword		NVARCHAR(2048),
	CredentialAssocId	INTEGER
)
if object_id('tempdb.dbo.#tmpTblVolumeList') is not null DROP TABLE #tmpTblVolumeList
CREATE TABLE #tmpTblVolumeList
(
    id			INT IDENTITY(1,1) ,
    VolumeID            INTEGER,
volumeName          VARCHAR(112),
    OMLVersion          INTEGER,
    LastPruneTime       INTEGER,
    HostId          	INTEGER,
DevicePath          NVARCHAR(1024),
    MountPathID         INTEGER,
MountPathName       NVARCHAR(1024),
    MountPathTypeId     INTEGER,
    DeviceTypeId	INTEGER,
UserName            varchar(1024),
Password            NVARCHAR(2048)
)
if object_id('tempdb.dbo.#tmpTblVolumeListInactive') is not null DROP TABLE #tmpTblVolumeListInactive
CREATE TABLE #tmpTblVolumeListInactive
(
    VolumeID            INTEGER,
volumeName          VARCHAR(112),
    OMLVersion          INTEGER,
    LastPruneTime       INTEGER,
    HostId          	INTEGER,
DevicePath          NVARCHAR(1024),
    MountPathID         INTEGER,
MountPathName       NVARCHAR(1024),
    MountPathTypeId     INTEGER,
    DeviceTypeId	INTEGER,
UserName            varchar(1024),
Password            NVARCHAR(2048),
    LastSizeUpdateTime INTEGER
)
if object_id('tempdb.dbo.#tmpTblVolUpdMap') is not null DROP TABLE #tmpTblVolUpdMap
CREATE TABLE #tmpTblVolUpdMap
(
    MountPathId		INTEGER,
    HostId		INTEGER,
    MaxVolId		INTEGER,
    MaxVolIdInactive	INTEGER,
	MaxLastUpdTime		INTEGER
)
if object_id('tempdb.dbo.#tmpTblInActiveVolMap') is not null DROP TABLE #tmpTblInActiveVolMap
CREATE TABLE #tmpTblInActiveVolMap
(
    MountPathId		INTEGER,
    MaxVolIdInactive	INTEGER,
	MaxLastUpdTime		INTEGER
)
DECLARE @doNotPickCCMVolumes	TINYINT
DECLARE @hostId 			INTEGER
DECLARE @volCnt			INTEGER
DECLARE @volUpdMap		XML
DECLARE @volsAvailableInBatch	INTEGER
DECLARE @daysToRefreshVolume	INT = 7 -- default to 7 days
DECLARE @MaxVols5Percent INT = (@i_MaxVolumesPerMA / 20)
DECLARE @rowCnt			INTEGER = 0
DECLARE @regularVolsToPick	INTEGER = 0
SET @doNotPickCCMVolumes = 0
IF EXISTS (SELECT value FROM MMConfigs WITH (NOLOCK) WHERE name = 'MMS2_CONFIG_DO_NOT_PICK_GRC_VOLUMES_FOR_SIZE_UPDATE')
	SELECT @doNotPickCCMVolumes = value FROM MMConfigs WITH (NOLOCK) WHERE name = 'MMS2_CONFIG_DO_NOT_PICK_GRC_VOLUMES_FOR_SIZE_UPDATE'
SELECT @daysToRefreshVolume = value FROM MMConfigs WITH (NOLOCK) WHERE name = 'MMS2_CONFIG_REFRESH_VOLSIZE_IN_DAYS'
declare @timeNow int = (datediff(second,'01/01/1970', getutcdate()))
declare @shouldIncludeCloud int = 0
set @shouldIncludeCloud = ISNULL((SELECT TOP 1 value FROM MMConfigs with (readuncommitted) WHERE name = 'MMCONFIG_INCLUDE_CLOUD_MOUNTPATHS_FOR_SIZE_UPDATES'), 1)
SET @volUpdMap = ISNULL((SELECT stringVal FROM MMEntityProp WITH (READUNCOMMITTED) WHERE EntityType = 11 AND propertyName = 'VolumeSizeUpdateMap'), '')
INSERT INTO #tmpTblVolUpdMap
SELECT  T.c.value('@mpId', 'int'), T.c.value('@maId', 'int'), T.c.value('@maxVId', 'int'), T.c.value('@maxVIdle', 'int'), T.c.value('@maxUpdTime', 'int')
FROM    @volUpdMap.nodes('/r/h') T(c)
INSERT INTO #tmpMLList
SELECT	MP.MediaSideId, H.ClientId, DC.Folder, MP.MountPathId, MP.MountPathName, MP.MountPathTypeId, D.DeviceTypeId, DC.UserName, DC.UserPassword, DC.CredentialAssocId
FROM		MMHost H WITH (NOLOCK)
		INNER JOIN MMDeviceController DC WITH (NOLOCK)
			ON H.ClientId = DC.ClientId
			AND H.MmHostEnabled = 1 AND H.MmHostSoftState = 1
		INNER JOIN MMDevice D WITH (NOLOCK)
			ON D.DeviceId = DC.DeviceId
		INNER JOIN MMMountPathToStorageDevice MSD WITH (NOLOCK)
ON DC.DeviceId = MSD.DeviceId AND DC.DeviceControllerEnabled = 1 AND DC.DeviceAccessible = 1  AND (DC.DeviceAccessType & (16|32|128)) = 0
		INNER JOIN MMMountPath MP WITH (NOLOCK)
			ON MSD.MountPathId  = MP.MountPathId AND MP.isEnabled = 1 AND MP.isOffline = 0
				AND MP.MountPathTypeId IN (4, 5, (case when @shouldIncludeCloud > 0 then 7 else 5 end))
				-- 4 - MOUNT_PATH_SHARED_STATIC, 5 - MOUNT_PATH_SHARED_REPLICA,  7 - MOUNT_PATH_EXTERNAL_REMOTE_HOST
		WHERE H.ClientId = @i_MediaAgentId
-- Update user name and password for entries that use credentials
EXEC MMS2GetDeviceControllerCredentials '#tmpMLList', 'CredentialAssocId', 'UserName', 'UserPassword'
-- Before we pick actual volumes see if there are any volumes to clean up which has physically delete attrib set.
-- Pick only 5% if the batch load so that vol size update is not affected.
INSERT INTO #tmpTblVolumeList
SELECT	TOP(@MaxVols5Percent) V.VolumeId, V.VolumeName, V.OMLVersion, V.RMSpareStatusUpdateTime,
	MPList.ClientId, MPList.Folder, MPList.MountPathId, MPList.MountPathName, MPList.MountPathTypeId, MPList.DeviceTypeId,
		MPList.UserName, MPList.UserPassword
FROM	MMVolume V WITH (NOLOCK), #tmpMLList MPList
				LEFT OUTER JOIN (SELECT MountPathId, Max(MaxVolId) as MaxVolId FROM #tmpTblVolUpdMap GROUP BY MountPathId) T ON MPList.MountPathId = T.MountPathId
WHERE	V.MediaSideId = MPList.MediaSideId
AND (V.Attributes & 512) = 512
AND ( ((V.Attributes & 1024) = 0) OR ((@doNotPickCCMVolumes & 1) = 0) )
AND ( (V.origCCcommCellID = 2) OR ((@doNotPickCCMVolumes & 2) = 0) )
		AND (V.SiloStatus <> 3) -- Do not update silo volumes that have been deleted from disk by cleanup
        	AND ((V.VolumeId > T.MaxVolId) OR (T.MountPathId IS NULL))
	ORDER BY VolumeID
SELECT @rowCnt = @@ROWCOUNT
--See if we have picked enough. Else pick the input count.
SET @regularVolsToPick = @i_MaxVolumesPerMA - @rowCnt
INSERT INTO #tmpTblVolumeList
SELECT	TOP(@regularVolsToPick) V.VolumeId, V.VolumeName, V.OMLVersion, V.RMSpareStatusUpdateTime,
	MPList.ClientId, MPList.Folder, MPList.MountPathId, MPList.MountPathName, MPList.MountPathTypeId, MPList.DeviceTypeId,
		MPList.UserName, MPList.UserPassword
FROM	MMVolume V WITH (NOLOCK), #tmpMLList MPList
				LEFT OUTER JOIN (SELECT MountPathId, Max(MaxVolId) as MaxVolId FROM #tmpTblVolUpdMap GROUP BY MountPathId) T ON MPList.MountPathId = T.MountPathId
WHERE	V.MediaSideId = MPList.MediaSideId
		AND V.RMSpareStatusUpdateTime <= @timeNow AND V.RMSpareStatusUpdateTime > 0
AND (V.Attributes & 512) <> 512
AND ( ((V.Attributes & 1024) = 0) OR ((@doNotPickCCMVolumes & 1) = 0) )
AND ( (V.origCCcommCellID = 2) OR ((@doNotPickCCMVolumes & 2) = 0) )
		AND (V.SiloStatus <> 3) -- Do not update silo volumes that have been deleted from disk by cleanup
        	AND ((V.VolumeId > T.MaxVolId) OR (T.MountPathId IS NULL))
	ORDER BY VolumeID
INSERT INTO #tmpTblVolUpdMap
SELECT MountPathId, @i_MediaAgentId, Max(VolumeId), 0, 0
FROM #tmpTblVolumeList
GROUP BY MountPathId
SET @volsAvailableInBatch =  (@i_MaxVolumesPerMA - ISNULL((SELECT MAX(id) FROM #tmpTblVolumeList), 0))
IF (@volsAvailableInBatch > 0)
BEGIN
	INSERT INTO #tmpTblVolumeListInactive
	SELECT	TOP(@volsAvailableInBatch) V.VolumeId, V.VolumeName, V.OMLVersion, V.RMSpareStatusUpdateTime,
		MPList.ClientId, MPList.Folder, MPList.MountPathId, MPList.MountPathName, MPList.MountPathTypeId, MPList.DeviceTypeId,
			MPList.UserName, MPList.UserPassword, V.LastSizeUpdateTime
	FROM	MMVolume V WITH (NOLOCK), #tmpMLList MPList
				LEFT OUTER JOIN (SELECT MountPathId, Max(MaxVolIdInactive) as MaxVolId, Max(MaxLastUpdTime) as MaxLastUpdTime FROM #tmpTblVolUpdMap GROUP BY MountPathId) T ON MPList.MountPathId = T.MountPathId
	WHERE	V.MediaSideId = MPList.MediaSideId
		AND V.RMSpareStatusUpdateTime <=  0
--AND (V.Attributes & 512) <> 512
AND ( ((V.Attributes & 1024) = 0) OR ((@doNotPickCCMVolumes & 1) = 0) )
AND ( (V.origCCcommCellID = 2) OR ((@doNotPickCCMVolumes & 2) = 0) )
		AND (V.SiloStatus <> 3) -- Do not update silo volumes that have been deleted from disk by cleanup
        	AND (((V.VolumeId > T.MaxVolId) AND V.LastSizeUpdateTime >= T.MaxLastUpdTime) OR (T.MountPathId IS NULL))
		AND V.LastSizeUpdateTime <= (@timeNow - (@daysToRefreshVolume * 24 * 60 * 60)) -- pick entries older than 7 days so that we do not keep picking too often.
	ORDER BY V.LastSizeUpdateTime, V.VolumeId
	INSERT INTO #tmpTblInActiveVolMap
	SELECT MountPathId, 0, 0
	FROM #tmpTblVolumeListInactive
	GROUP BY MountPathId
	UPDATE T0
	SET MaxLastUpdTime = T1.MaxLastUpdTime
	FROM #tmpTblInActiveVolMap T0,
		(SELECT MountPathId, Max(LastSizeUpdateTime) AS MaxLastUpdTime
		 FROM #tmpTblVolumeListInactive
		 GROUP BY MountPathId
		) T1
	WHERE T0.MountPathId = T1.MountPathId
	UPDATE T0
	SET MaxVolIdInactive = T1.MaxVolId
	FROM #tmpTblInActiveVolMap T0,
		(SELECT A.MountPathId, Max(A.VolumeId) AS MaxVolId
		 FROM #tmpTblVolumeListInactive A, #tmpTblInActiveVolMap B
		 WHERE A.LastSizeUpdateTime = B.MaxLastUpdTime
		 AND A.MountPathId = B.MountPathId
		 GROUP BY A.MountPathId
		) T1
	WHERE T0.MountPathId = T1.MountPathId
    MERGE #tmpTblVolUpdMap AS T
	USING #tmpTblInActiveVolMap AS S
	ON T.MountPathId = S.MountPathId and T.HostId=@i_MediaAgentId
	WHEN MATCHED THEN
		UPDATE SET T.MaxLastUpdTime = S.MaxLastUpdTime, T.MaxVolIdInactive=S.MaxVolIdInactive
	WHEN NOT MATCHED THEN
	INSERT (MountPathId, HostId, MaxVolId, MaxVolIdInactive, MaxLastUpdTime) VALUES (S.MountPathId, @i_MediaAgentId, 0, S.MaxVolIdInactive, S.MaxLastUpdTime);
END
SET @volUpdMap = (SELECT MountPathId as '@mpId', HostId as '@maId', MaxVolId as '@maxVId', MaxVolIdInactive as '@maxVIdle', MaxLastUpdTime as '@maxUpdTime' FROM #tmpTblVolUpdMap FOR XML PATH ('h'), ROOT('r'))
DECLARE @now INT = dbo.getunixtime(GETUTCDATE())
UPDATE MMEntityProp
SET stringVal = CONVERT(NVARCHAR(MAX), @volUpdMap),
modified = @now
WHERE EntityType = 11 AND propertyName = 'VolumeSizeUpdateMap'
IF @@ROWCOUNT = 0
BEGIN
	INSERT	INTO MMEntityProp (EntityId, EntityType, propertyName, propDataType, intVal, longlongVal, stringVal, created, modified, CommCellId)
SELECT 0, 11, 'VolumeSizeUpdateMap', 3, 0, 0, CONVERT(NVARCHAR(MAX), @volUpdMap), @now, @now, 2
END
SELECT *
FROM (
	SELECT VolumeID, volumeName, OMLVersion, LastPruneTime, HostId, DevicePath, MountPathID, MountPathName, MountPathTypeId, DeviceTypeId, UserName, Password
	FROM #tmpTblVolumeList
	UNION
	SELECT VolumeID, volumeName, OMLVersion, LastPruneTime, HostId, DevicePath, MountPathID, MountPathName, MountPathTypeId, DeviceTypeId, UserName, Password
	FROM #tmpTblVolumeListInactive
     ) T
ORDER BY T.MountPathID
DROP TABLE #tmpMLList
DROP TABLE #tmpTblVolumeList
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2GetVolumesToUpdateSize')
	delete from GxQscripts where name = 'MMS2GetVolumesToUpdateSize'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetVolumesToUpdateSize')
	delete from GXDBVersions where aliasname = 'MMS2GetVolumesToUpdateSize'
GO

insert into GXDBVersions values(2, 'MMS2GetVolumesToUpdateSize',  '00010009000200120000', 'MMS2GetVolumesToUpdateSize', '00010009000200120000')
GO

