

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GetVolumeRecycleInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2GetVolumeRecycleInfo.sp,v $ $Id: MMS2GetVolumeRecycleInfo.sp,v 1.29.2.4 2020/07/21 23:45:11 cliu Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 						Cursor: "MMS2GetVolumeRecycleInfo"								|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMS2GetVolumeRecycleInfo')
BEGIN
	print '>>> Drop Stored Procedure: MMS2GetVolumeRecycleInfo <<<'
	drop procedure MMS2GetVolumeRecycleInfo
END
IF EXISTS (select * from GxQscripts where name='MMS2GetVolumeRecycleInfo')
	delete from GxQscripts where name = 'MMS2GetVolumeRecycleInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetVolumeRecycleInfo')
	delete from GXDBVersions where aliasname = 'MMS2GetVolumeRecycleInfo'
GO
print '... Creating Procedure: MMS2GetVolumeRecycleInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2GetVolumeRecycleInfo
-- The following two lines indicate, in order, parameters that will be
--  expected in the "setValues()" method, as well as the order in which
--  they will be provided as arguments to the SQLSTRING command
  @i_MountPathType integer
AS
--	The next few lines are the columns, in order, that will be in the
--  result set for this cursor.  EXTREME CAUTION must be exercised to
--  ensure that these match up with the result set in terms of type, size,
--  and order!
  DECLARE @o_VolumeId integer
  DECLARE @o_VolumeName varchar(255)
  DECLARE @o_OMLVersion integer
  DECLARE @o_HostId integer
  DECLARE @o_MountPathId integer
  DECLARE @o_MountPathName NVARCHAR(1024)
  DECLARE @o_MountPathTypeId integer
  DECLARE @o_UserName varchar(255)
  DECLARE @o_Password varchar(2048)
  DECLARE @o_SIDBStoreId integer
  DECLARE @o_VolOrigCCId integer
-- These lines represent the actual SQL code that will get executed.  Note
-- The "printf" style substitutions.  These should match up exactly with
-- :PARAM input lines
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
IF EXISTS (SELECT 1 FROM MMMountPath MP WITH (NOLOCK) WHERE MP.MountPathTypeId = @i_MountPathType)
BEGIN
SELECT	DISTINCT V.VolumeId, V.VolumeName, V.OMLVersion,
		H.ClientId, MP.MountPathId, MP.MountPathName, MP.MountPathTypeId,
		MP.UserName, MP.UserPassword, V.SIDBStoreId, V.origCCcommCellID
FROM	MMVolume V WITH (NOLOCK)
		INNER JOIN MMMountPath MP WITH (NOLOCK)
			/* Jai - Check for Mountpath being offline - change made after seeing issue in TR 1-245536 */
ON V.MediaSideId = MP.MediaSideId AND MP.MountPathTypeId = @i_MountPathType AND MP.isEnabled = 1 AND MP.isOffline = 0 AND ((MP.Attribute & 8) = 8) AND (MP.Attribute & 16 = 0)
		INNER JOIN MMMedia M WITH (NOLOCK)
			ON M.MediaId = V.Mediaid AND V.VolumeFlags = 6
		INNER JOIN MMLibraryController LC WITH (NOLOCK)
			ON LC.LibraryId = M.LibraryId
		INNER JOIN MMHost H WITH (NOLOCK)
			ON H.ClientId = LC.ClientId
		INNER JOIN IdxSIDBStore I WITH (NOLOCK)
			ON
			(
				(V.SIDBStoreId > 0 AND
					(I.SIDBStoreId = V.SIDBStoreId
						AND
						(
							I.CommCellId = 2 OR ((I.flags & 256 /*IDX_SIDBSTORE_FLAGS_SILO_AGED*/) > 0)
						)
						AND
						(
							((I.flags & 256 /*IDX_SIDBSTORE_FLAGS_SILO_AGED*/) > 0)
							OR
							(
								(I.flags & 2097152 /*IDX_SIDBSTORE_FLAGS_SILO_ENABLED*/) = 0
								AND
								(I.Status <> 1 /*IDX_SIDBSTORE_STATUS_CORRUPTED*/ AND (V.Attributes & 4) = 0)
							)
						)
						AND
( (I.Flags & 536870912) > 0)
					)
				)
				OR
				(V.SIDBStoreId = 0)
			)
--WHERE (0 = dbo.MMS2FUNC_CheckForPruningOpWindowOnMA(H.ClientId))
WHERE (1 = dbo.IsOperationAllowed(131072,2,H.ClientId,0,0,0,0))
AND		NOT EXISTS (SELECT 1 FROM ArchChunk WITH (NOLOCK) WHERE V.volumeId = volumeId
AND (physicalSize > 0 OR logicalSize > 0) AND flags & 256 = 0)
AND		NOT EXISTS (SELECT 1 FROM MMResource res WITH (NOLOCK), MMResourceToJob restojob WITH (NOLOCK)
					WHERE	V.VolumeId = res.VolumeId
					AND		res.ReservationId = resToJob.ReservationId)
ORDER BY H.ClientId, MP.MountPathId
END
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2GetVolumeRecycleInfo')
	delete from GxQscripts where name = 'MMS2GetVolumeRecycleInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetVolumeRecycleInfo')
	delete from GXDBVersions where aliasname = 'MMS2GetVolumeRecycleInfo'
GO

insert into GXDBVersions values(2, 'MMS2GetVolumeRecycleInfo',  '00010029000200040000', 'MMS2GetVolumeRecycleInfo', '00010029000200040000')
GO

