

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GetVolumeInfoForDeletedAF.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2GetVolumeInfoForDeletedAF.sp,v $ $Id: MMS2GetVolumeInfoForDeletedAF.sp,v 1.37.2.5 2018/11/12 21:52:30 chandru Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 						Cursor: "MMS2GetVolumeInfoForDeletedAF"				|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMS2GetVolumeInfoForDeletedAF')
BEGIN
	print '>>> Drop Stored Procedure: MMS2GetVolumeInfoForDeletedAF <<<'
	drop procedure MMS2GetVolumeInfoForDeletedAF
END
IF EXISTS (select * from GxQscripts where name='MMS2GetVolumeInfoForDeletedAF')
	delete from GxQscripts where name = 'MMS2GetVolumeInfoForDeletedAF'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetVolumeInfoForDeletedAF')
	delete from GXDBVersions where aliasname = 'MMS2GetVolumeInfoForDeletedAF'
GO
print '... Creating Procedure: MMS2GetVolumeInfoForDeletedAF'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2GetVolumeInfoForDeletedAF
-- The following two lines indicate, in order, parameters that will be
--  expected in the "setValues()" method, as well as the order in which
--  they will be provided as arguments to the SQLSTRING command
  @i_MountPathType integer
AS
--	The next few lines are the columns, in order, that will be in the
--  result set for this cursor.  EXTREME CAUTION must be exercised to
--  ensure that these match up with the result set in terms of type, size,
--  and order!
  DECLARE @o_VolumeId integer
  DECLARE @o_VolumeName varchar(255)
  DECLARE @o_OMLVersion integer
  DECLARE @o_AFileId integer
  DECLARE @o_ArchChunkId bigint
  DECLARE @o_HostId integer
  DECLARE @o_cclip varchar(255)
  DECLARE @o_MountPathId integer
  DECLARE @o_MountPathName NVARCHAR(1024)
  DECLARE @o_MountPathTypeId integer
  DECLARE @o_UserName varchar(255)
  DECLARE @o_Password varchar(2048)
  DECLARE @o_SIDBStoreId integer
  DECLARE @o_commCellId integer
  DECLARE @o_sidbPruningFlag integer
  DECLARE @o_subStoreBitField integer
-- These lines represent the actual SQL code that will get executed.  Note
-- The "printf" style substitutions.  These should match up exactly with
-- :PARAM input lines
--This will turn off message: "xxx rows affected".
	SET NOCOUNT ON
	IF object_id('tempdb.dbo.#tempVolAFList') is not null DROP TABLE #tempVolAFList
	CREATE TABLE #tempVolAFList(
		volumeId 	INT,
		volumeName 	varchar(256),
		MediaSideId	INT,
		MediaId		INT,
		OMLVersion 	INT,
		AFileId 	INT,
		ArchChunkId 	BIGINT,
cclip 		varchar(255),
		hostId		INT,
		sidbStoreId	INT,
		commCellId	INT,
		sidbPruningFlag INT,
		subStoreBitField INT,
		MountPathId		INT,
MountPathName	nvarchar(1024),
		MountPathTypeId	INT,
UserName		varchar(255),
Password		varchar(2048),
		rn INT,
		chunkCommCellId INT
		)
	DECLARE @batchCount INT = ISNULL((SELECT value from MMConfigs WHERE name = 'MMS2_CONFIG_DEDUP_PRUNE_BATCH_SIZE'), 0)
	-- Calculating the dense rank would give ranking to all the unique AFs within a store. For chunks belonging to same AF, same rank would be given.
	-- Once we get rank, then its only a matter of removing the rows which have larger rank than the batch size.
	INSERT	INTO #tempVolAFList
	SELECT	V.VolumeId, V.VolumeName, V.MediaSideId, V.MediaId, V.OMLVersion, DAF.archFileId,
				DAF.ArchChunkId, DAF.cclip, LC.ClientId, DAF.SIDBStoreId, DAF.commCellId, DAF.sidbPruningFlag, DAF.subStoreBitField,
				MP.MountPathId, MP.MountPathName, MP.MountPathTypeId , MP.UserName, MP.UserPassword,
CASE WHEN DAF.SIDBStoreId > 0  THEN DENSE_RANK() OVER (PARTITION BY DAF.SIDBStoreId ORDER BY (DAF.Status & 2) desc, DAF.archFileId asc) ELSE 0 END,
				DAF.chunkCommCellId
	FROM	MMMountPath MP WITH (READUNCOMMITTED), MMLibraryController LC WITH (READUNCOMMITTED), MMHost H WITH (READUNCOMMITTED), MMVolume V WITH (READUNCOMMITTED), MMDeletedAF DAF WITH (READUNCOMMITTED)
	WHERE	MP.MountPathTypeId = @i_MountPathType
AND MP.IsEnabled = 1 AND MP.IsOffline = 0 AND ((MP.Attribute & 8) = 8) AND (MP.Attribute & 16 = 0)
			AND MP.LibraryId = LC.LibraryId
			AND LC.ClientId = H.ClientId
			AND H.MmHostEnabled = 1 AND H.MmHostSoftState = 1
			AND MP.MediaSideId = V.MediaSideId
			AND V.VolumeId = DAF.VolumeId
			AND (DAF.archFileId > 0 OR DAF.ArchChunkId > 0)
			--AND (0 = dbo.MMS2FUNC_CheckForPruningOpWindowOnMA(H.ClientId))
AND (1 = dbo.IsOperationAllowed(131072,2,H.ClientId,0,0,0,0))
	-- Delete those rows which have valid AF entry in archFileCopy table.
	DELETE #tempVolAFList
	FROM #tempVolAFList T
			INNER JOIN archCopySIDBStore CS WITH (READUNCOMMITTED) ON CS.SIDBStoreId = T.sidbStoreId
			INNER JOIN archFileCopy AFC WITH (READUNCOMMITTED) ON T.AFileId = AFC.archFileId AND AFC.archCopyId = CS.CopyID AND AFC.lastChunkNumber > 0
	WHERE T.sidbStoreId > 0
	DELETE #tempVolAFList
	FROM #tempVolAFList T, IdxSIDBStore STORE WITH (READUNCOMMITTED),
			archCopySIDBStore S WITH (READUNCOMMITTED), ArchGroupCopy AC WITH (READUNCOMMITTED)
	WHERE T.SIDBStoreId = STORE.SIDBStoreId AND STORE.SIDBStoreId = S.SIDBStoreId AND S.CopyId = AC.id
		AND
		(
			(STORE.CommCellId <> 2)
			OR
			(
( (STORE.flags & 256) > 0)
					OR
( STORE.Status = 1 /* 1 */ )
					OR
( (AC.dedupeFlags & 2097152) > 0)
			)
			OR
((STORE.Flags & 536870912) = 0)
		)
	--
	-- Remove the entries belonging to orphaned store.  This will be taken care of by volume-level pruning.
	-- Regular SIDB pruning should not be sent for prunable stores since the volume folders will be gone via regular pruning.
	--
	DELETE #tempVolAFList
	FROM #tempVolAFList T, IdxSIDBStore STORE WITH (READUNCOMMITTED)
	WHERE T.SIDBStoreId > 0
	-- To prevent sending SIDB pruning for the aged stores
	AND T.SIDBStoreId = STORE.SIDBStoreId
AND ((STORE.flags & 256) > 0)
	AND NOT EXISTS
		(
			SELECT CopyId
			FROM archCopySIDBStore
			WHERE SIDBStoreId = T.SIDBStoreId
		)
	-- Do this only if the batch count is > 0. Otherwise send everything.
	IF (@batchCount > 0)
	BEGIN
		DECLARE @SIDBStoreId	INT = 0
		DECLARE @maxRank		INT = 0
		DECLARE SIDBCursor CURSOR FOR
		SELECT DISTINCT SIDBStoreId
		FROM #tempVolAFList
		WHERE SIDBStoreId > 0
		OPEN SIDBCursor
		FETCH NEXT FROM SIDBCursor INTO @SIDBStoreId
		WHILE @@FETCH_STATUS = 0
		BEGIN
			-- Do this only for non-sealed stores. For sealed stores, send everything->No batching.
			IF EXISTS (SELECT * FROM IdxSIDBStore WITH (NOLOCK) WHERE SIDBStoreId = @SIDBStoreId and SealedTime = 0)
			BEGIN
				SET @maxRank = ISNULL((SELECT MAX(T1.rn) FROM
									(SELECT DISTINCT TOP(@batchCount) rn FROM #tempVolAFList
									WHERE SIDBStoreId = @SIDBStoreId
									ORDER BY rn asc ) as T1
									), 0)
				IF (@maxRank > 0)
				BEGIN
					DELETE #tempVolAFList
					FROM #tempVolAFList T1
					WHERE T1.SIDBStoreId = @SIDBStoreId
					AND T1.rn > @maxRank
				END
			END
			FETCH NEXT FROM SIDBCursor INTO @SIDBStoreId
		END
		CLOSE SIDBCursor
		DEALLOCATE SIDBCursor
	END
	--Update MMDeletedAF with status as picked for pruning.
	UPDATE MMDeletedAF
SET Status	= Status | 2
	FROM #tempVolAFList T
	WHERE MMDeletedAF.archFileId = T.AFileId
	AND MMDeletedAF.archChunkId = T.ArchChunkId
	AND MMDeletedAF.SIDBStoreId = T.SIDBStoreId
	AND MMDeletedAF.commCellId = T.commCellId
	AND MMDeletedAF.VolumeId = T.volumeId
	AND MMDeletedAF.chunkCommCellId = T.chunkCommCellId
	SELECT DISTINCT T.VolumeId, T.VolumeName, T.OMLVersion, T.AFileId, T.ArchChunkId, T.hostId, T.cclip,
	T.MountPathId, T.MountPathName, T.MountPathTypeId , T.UserName, T.Password, T.sidbStoreId, (CASE WHEN T.chunkCommCellId <> 0 THEN chunkCommCellId ELSE T.commCellId END), T.sidbPruningFlag, T.subStoreBitField
	FROM  #tempVolAFList AS T
	ORDER BY T.hostId, T.MountPathId
	if object_id('tempdb.dbo.#tempVolAFList') is not null DROP TABLE #tempVolAFList
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2GetVolumeInfoForDeletedAF')
	delete from GxQscripts where name = 'MMS2GetVolumeInfoForDeletedAF'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetVolumeInfoForDeletedAF')
	delete from GXDBVersions where aliasname = 'MMS2GetVolumeInfoForDeletedAF'
GO

insert into GXDBVersions values(2, 'MMS2GetVolumeInfoForDeletedAF',  '00010037000200050000', 'MMS2GetVolumeInfoForDeletedAF', '00010037000200050000')
GO

