

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GetVolumeForJob.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2GetVolumeForJob.sp,v $ $Id: MMS2GetVolumeForJob.sp,v 1.96.44.5 2018/12/19 13:49:46 daruloli Exp $";
--
--  +========================================================================+
--  | Stored Precedure: MMS2GetVolumeForJob()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMS2GetVolumeForJob')
BEGIN
	print '>>> Drop Stored Procedure: MMS2GetVolumeForJob <<<'
	drop procedure MMS2GetVolumeForJob
END
IF EXISTS (select * from GxQscripts where name='MMS2GetVolumeForJob')
	delete from GxQscripts where name = 'MMS2GetVolumeForJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetVolumeForJob')
	delete from GXDBVersions where aliasname = 'MMS2GetVolumeForJob'
GO
print '... Creating Procedure: MMS2GetVolumeForJob'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2GetVolumeForJob
  @i_CommCellId integer,
  @i_MediaGroupID integer,
  @i_JobId bigint,
  @i_JobType integer,
  @i_UsePartialFullMedia integer,
  @i_ScheduleRunId bigint,
  @i_DoNotAllowOtherSchedule integer,
  @i_IgnoreReturn integer,
  @o_VolumeIdForJob integer OUTPUT
AS
  DECLARE @r_RetCode integer;
  DECLARE @r_VolumeIDForJob integer;
  DECLARE @r_SpareGroupID integer;
  DECLARE @r_LibraryID integer;
  DECLARE @r_MediaOfOtherSideSearched integer;
  DECLARE @r_MediaAppendibleSearched integer;
  DECLARE @r_MediaSpareSearched integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
declare @LibraryTypeID integer
declare @LibraryAttribute integer
declare @UseWithInDaysInSec integer
declare @MediaID integer
declare @VolumeID integer
declare @VolumeID2 integer
declare @SpareGroupAttributes integer
declare @DrivePoolID integer
declare @MediaTypeIDNewMedia integer
declare @RecordingFormatIDNewMedia integer
declare @MediaTypeID integer
declare @RecordingFormatID integer
declare @FlushBlockSizeKB integer
declare @Attributes integer
declare @bkpAttributes bigint
declare @SpareGroupId integer
declare @honourSpareGroup integer
set @r_SpareGroupID = 0
set @r_LibraryID	= 0
set @r_MediaOfOtherSideSearched = 0
set @r_MediaAppendibleSearched = 0
set @r_MediaSpareSearched = 0
set @r_VolumeIDForJob = 0
set @r_RetCode = 0
declare @isAllAppendableExportable integer
declare @exportableAppendableVolumeId integer
declare @exportableAppendableMediaId	integer
set @isAllAppendableExportable = 0
set @exportableAppendableVolumeId = 0
set @exportableAppendableMediaId = 0
DECLARE @isQuickMR INT = 0;
DECLARE @mediaGroupSrc INT = -1;
DECLARE @tblVolNotEligible TABLE (volId INT)
-- if media refresh with a config param set, then allow using all the available and appendable
IF (@i_JobType IN (74,127))
BEGIN
IF (cast(dbo.GetJobOption(@i_JobId, 1054046064) as int)) = 1
	BEGIN
		SET @isQuickMR =1;
		SELECT @mediaGroupSrc= SrcStrm.mediaGroupId FROM
		archStream DestStrm WITH (READUNCOMMITTED), archGroupCopy AGC WITH (READUNCOMMITTED), archStream SrcStrm WITH (READUNCOMMITTED)
		WHERE DestStrm.mediaGroupId = @i_MediaGroupId
		AND AGC.id = DestStrm.archGroupCopyId
		AND SrcStrm.archGroupCopyId = AGC.sourceCopyId
		AND DestStrm.stream = SrcStrm.stream
		INSERT INTO @tblVolNotEligible
		SELECT V.volumeId
		FROM archChunkToCopy A WITH (READUNCOMMITTED), MMVolume V WITH (READUNCOMMITTED)
		WHERE A.adminJobId = @i_JobId
			AND A.mediaGroupId = @mediaGroupSrc
			AND A.volumeId = V.VolumeId
			AND V.VolumeFlags IN (1,7)
	END
END
select top 1 @FlushBlockSizeKB = isnull(FlushBlockSizeKB, 0) from MMDataPath WITH (READUNCOMMITTED)
where DataPathId in (select DataPathId from MMMediaGroup WITH (READUNCOMMITTED) where MediaGroupId = @i_MediaGroupID)
if @FlushBlockSizeKB <= 0
begin
  select top 1 @FlushBlockSizeKB = isnull(FlushBlockSizeKB, 0) from MMRecordingFormats WITH (READUNCOMMITTED)
  where RecordingFormatId in (select RecordingFormatId from MMMediaGroup WITH (READUNCOMMITTED)
  where MediaGroupId = @i_MediaGroupID)
end
create table #tmptblVolumeMedia
(
	VolumeID int,
	MediaID int,
	Attributes int,
	origCCcommCellID int,
	MediaLocation int,
	LastBackupTime int,
	IsExportable int,
	NumberOfReUses int,
BarCode varchar(256)
)
declare @tmpreservations table (volumeid int, mediaid int, reservationtype int)
insert into @tmpreservations
select a.volumeid, a.mediaid, b.ReservationType
from MMResource a WITH (READUNCOMMITTED), MMResourceToJob b with (readuncommitted)
where a.reservationid = b.reservationid
select @r_LibraryID = LibraryId
from MMMasterPool mp WITH (READUNCOMMITTED), MMDrivePool hdp WITH (READUNCOMMITTED),
MMMediaGroup mg WITH (READUNCOMMITTED)
where mp.MasterPoolId = hdp.MasterPoolId
and hdp.DrivePoolId = mg.DrivePoolId
and mg.MediaGroupId = @i_MediaGroupID
select @LibraryTypeID = LibraryTypeId, @LibraryAttribute = LibraryAttribute, @UseWithInDaysInSec = UseWithinDaysInSec
from MMLibrary WITH (READUNCOMMITTED)
where LibraryId = @r_LibraryID
if @r_LibraryID <= 0
OR @LibraryTypeID <=0
begin
SET @r_RetCode = 251
  GOTO ERROR_EXIT
end
select @DrivePoolID = DrivePoolId from MMMediaGroup WITH (READUNCOMMITTED) where MediaGroupId = @i_MediaGroupId
SET @honourSpareGroup = ISNULL((select Value from MMConfigs (NOLOCK) where name = 'MMS2_CONFIG_HONOUR_SPAREGROUP_FOR_PICKING_MEDIA'), 0)
select @SpareGroupID = SpareGroupID
from MMMediaGroup WITH (READUNCOMMITTED)
where MediaGroupId = @i_MediaGroupID
-- optical, find the other side of the latest used media
if @LibraryTypeID = 2
or @LibraryTypeID = 5
or @LibraryTypeID = 7
-- job is not synthetic full (CVOpType::SYNTHFULL)
and @i_JobType != 14
begin
  insert into #tmptblVolumeMedia
  select VolumeId, MediaId, 0, 0, 0, LastBackupTime, 0, 0, ''
  from MMVolume WITH (READUNCOMMITTED)
  where MediaGroupID = @i_MediaGroupID
  AND VolumeId > 0
  AND MediaId NOT IN (SELECT MediaId FROM @tmpreservations where ReservationType = 1)
  AND MediaId IN (SELECT MediaId FROM MMMedia WITH (READUNCOMMITTED)
				  WHERE (ScheduleRunId > 0 AND ScheduleRunId = @i_ScheduleRunId)
				  OR	(ScheduleRunId > 0 AND ScheduleRunId != @i_ScheduleRunId
AND ( (Attributes & 134217728) = 0 or @i_DoNotAllowOtherSchedule = 0))
				  OR	ScheduleRunId = 0
AND (Attributes & 536870912) = 0
				 )
  select @r_MediaOfOtherSideSearched = @@rowcount
  if @r_MediaOfOtherSideSearched > 0
  begin
    select top 1 @VolumeID = VolumeID, @MediaID = MediaID
    from #tmptblVolumeMedia
    order by LastBackupTime desc
    select @VolumeID2 = isnull(v.VolumeId, 0)
    from MMVolume v WITH (READUNCOMMITTED), MMMedia m WITH (READUNCOMMITTED)
    where v.MediaGroupID = @i_MediaGroupID
    and v.MediaId = @MediaID
    and v.VolumeId != @VolumeID
    and v.MediaId = m.MediaId
    and v.VolumeFlags = 5
    and m.MediaFlags = 1
    AND VolumeState != 2
    -- do we check exportable?
    and m.barcode not in (select barcode from MMSlot with (readuncommitted)
where (MediaStatus & 1) > 0)
    and ( (m.MediaLocation in (1) and m.MediaId in
		(select mediaid from MMSlot with (readuncommitted) where SlotType = 1))
    or (m.MediaLocation in (2) and m.MediaId in
		(select mediaid from MMDrive with (readuncommitted)
		where DriveSoftState = 1 and DriveEnabled = 1 and DriveBroken = 0 and MountStatus != 4)))
    and m.LibraryId = @r_LibraryID
    if @VolumeID2 > 0
    begin
		select @MediaTypeID = MediaTypeId from MMMedia with (readuncommitted) where MediaId = @MediaID
		select top 1 @RecordingFormatID = RFMT.RecordingFormatId from MMRecFmtMedTyp RFMT WITH (READUNCOMMITTED),
							MMDrive D WITH (READUNCOMMITTED), MMDrivePool HDP WITH (READUNCOMMITTED)
							where RFMT.DriveTypeId = D.DriveTypeId AND
							D.MasterPoolId = HDP.MasterPoolId AND
							RFMT.MediaTypeID = @MediaTypeID AND
							HDP.DrivePoolId = @DrivePoolID
AND (RFMT.CompatibilityType & 2) > 0
							order by RFMT.RecordingFormatId DESC
		if @RecordingFormatID <= 0 or @RecordingFormatID is null
		begin
SET @r_RetCode = 281
			GOTO ERROR_EXIT
		end
        set @r_VolumeIDForJob = @VolumeID2
		update MMMedia
		set ScheduleRunId = @i_ScheduleRunId,
Attributes = Attributes | (134217728 * @i_DoNotAllowOtherSchedule)
		-- & ~MMS2_OVERWRITE_IF_DIFF_COMMCELL, origCCcommCellID = @i_CommCellId
		where MediaId = @MediaID
		--update MMVolume
		--set volumeflags = 7, VolumeFullReason = E_MM_VOL_FULL_NEW_SCHEDULE_RUN_INSTANCE
		--where volumeflags = 1 and mediagroupid = @i_mediagroupid
        update MMVolume
set VolumeFlags = 1, FlushBlockSizeKB = @FlushBlockSizeKB, RecordingFormatId = @RecordingFormatID, Attributes = (Attributes & ~(472))
        where VolumeId = @VolumeID2
        goto NORMAL_EXIT
    end
  end
  delete from #tmptblVolumeMedia
end
-- use appendiable media or not
if (@LibraryAttribute & 512) > 0
and @i_UsePartialFullMedia > 0
begin
  -- get all appendable media
  insert into #tmptblVolumeMedia
select v.VolumeId, v.MediaId, m.Attributes, 0, 0, v.LastBackupTime, (m.Attributes & 1), 0, ''
  from MMVolume v WITH (READUNCOMMITTED), MMMedia m WITH (READUNCOMMITTED)
  where v.MediaGroupID IN (@mediaGroupSrc, @i_MediaGroupID)
  and v.VolumeFlags = 7
  and v.VolumeState != 2
  and v.VolumeId > 0
  and v.mediaid not in (select mediaid from @tmpreservations where ReservationType = 1)
  and v.mediaid = m.mediaid
  and NOT EXISTS (select 1 from @tblVolNotEligible where volId = v.VolumeId)
and m.Attributes & 536870912 = 0
  select @r_MediaAppendibleSearched = @@rowcount
  if @r_MediaAppendibleSearched > 0
  begin
    declare @tmpmedia table
    (
		MediaId int,
		ScheduleRunId bigint,
		Attributes int,
		MediaLocation int,
		origCCcommCellID int,
		LastBackupTime int,
		MediaTypeId int,
		SpareGroupId int
	)
    insert into @tmpmedia
	select a.MediaId, a.ScheduleRunId, a.Attributes, a.MediaLocation, a.origCCcommCellID, a.LastBackupTime, a.MediaTypeId, a.SpareGroupId
    from MMMedia a with (readuncommitted), #tmptblVolumeMedia b
    where a.mediaid = b.mediaid
    and a.mediaflags = 1
    and a.libraryid = @r_LibraryID
	and a.barcode not in (select barcode from MMSlot with (readuncommitted)
where (MediaStatus & 1) > 0)
	and ( (a.MediaLocation in (1) and a.MediaId in (select mediaid from MMSlot with (readuncommitted) where SlotType = 1))
	   or (a.MediaLocation in (2) and a.MediaId in (select mediaid from MMDrive with (readuncommitted)
	   where DriveSoftState = 1 and DriveEnabled = 1 and DriveBroken = 0 and MountStatus != 4))
	    )
	--if honour spareGroup is set then delete media belongs to other sparegroups.
	IF @honourSpareGroup > 0 AND ISNULL(@SpareGroupId, 0) > 0
	BEGIN
		delete from @tmpmedia
		WHERE SpareGroupId <> @SpareGroupId
	END
	-- delete media in diff schedule run id
	delete from @tmpmedia
	WHERE ScheduleRunId > 0
	AND ScheduleRunId != @i_ScheduleRunId
AND ( (Attributes & 134217728) > 0 or @i_DoNotAllowOtherSchedule > 0)
	-- delete media with the non-supported media type
	delete from @tmpmedia
	FROM @tmpmedia tm, MMMedia mmm
	WHERE tm.MediaId = mmm.MediaId AND mmm.MediaTypeId NOT IN
	(SELECT mrfmt.MediaTypeId FROM MMDrivePool mmdp, MMDrive mmd, MMRecFmtMedTyp mrfmt
	WHERE mmdp.drivePoolId = @DrivePoolID AND mmd.MasterPoolId = mmdp.MasterPoolId
	AND mrfmt.DriveTypeId = mmd.DriveTypeId
AND (mrfmt.CompatibilityType & 2) > 0)
	-- check if can use media from wrong APP_CommCell
	delete from @tmpmedia
	where origCCcommCellID > 2
and (@LibraryAttribute & 32) = 0
AND (Attributes & 268435456) = 0
	-- check use with in days
	delete from @tmpmedia
	where LastBackupTime > 0
	AND DATEDIFF(second, DATEADD(second, LastBackupTime, '01/01/1970'), getutcdate()) > @UseWithInDaysInSec
	-- Thu Jul  3 15:46:47 EDT 2008
	-- Remove those that are in a drive which cannot be used due to its only MA being offline.
	-- See MR 108301 for details.
	delete from @tmpmedia
	where MediaLocation = 2 and MediaId in
	(
		select mediaid
		from mmdrive DRV with (readuncommitted), mmdrivecontroller DRVCTRL with (readuncommitted),
					MMHost HOST with (readuncommitted)
		where DRV.DriveId = DRVCTRL.DriveControllerId and DRVCTRL.ClientId = HOST.ClientId
			and HOST.MmHostSoftState = 0 OR HOST.MmHostEnabled = 0
	)
	-- Delete the media which is not in the drive for PnP library
	delete @tmpmedia
	from @tmpmedia a
	where (
a.MediaTypeId in (11002)
			or
@LibraryTypeID in (4, 5)
		)
	and not exists (select driveId from MMDrive with (NOLOCK) where mediaId = a.MediaId)
	-- Oct 10th 2007 cliu, MR 77361 Tape Optimization with Syn Full - use appendable media
	-- If the job type is SYNTHFULL, make sure appendable media has no data on current subclient.
	-- The correct way should also consider current job id, which should be allowed to use.
	-- More accurate check should include the appendable media that used by current app but not requried by current syn full jobs. (Another Enhancement?)
	if @i_JobType = 14
	begin
		declare @l_appId int
		select top 1 @l_appId = applicationId
		from JMBkpJobInfo WITH (READUNCOMMITTED)
		where jobId = @i_JobId and commCellId = @i_commcellId
		if @l_appId = 0
			select top 1 @l_appId = appId
			from JMBkpStats
			where jobId = @i_JobId and commCellId = @i_CommCellId
		if @l_appId <> 0
		begin
			declare @curMediaId int
			declare @curVolumeId int
			declare @hasChunkTmpTbl table (id integer)
			declare @hasChunk int
			declare checkArchChunkCur cursor for
			select v.volumeId, a.mediaId from @tmpmedia a, MMVolume v
			where a.mediaId = v.mediaId
and	  a.MediaTypeId NOT IN (10001)
			open checkArchChunkCur
			fetch next from checkArchChunkCur into @curVolumeId, @curMediaId
			while @@fetch_status = 0
			begin
			  set @hasChunk = 0
			  EXEC @hasChunk = archMediaHasChunkForApp @l_appId, @curVolumeId, @i_jobId, 1
			  -- output is hasChunk
			  if @hasChunk > 0
					delete @tmpmedia where mediaId = @curMediaId
				else
				begin
					delete @tmpmedia where mediaId <> @curMediaId
					break
				end
				fetch next from checkArchChunkCur into @curVolumeId, @curMediaId
			end
			close checkArchChunkCur
			deallocate checkArchChunkCur
		end
		else
			-- It will be safer just removing all
			delete @tmpmedia
	end
	delete from #tmptblVolumeMedia
	where mediaid not in (select mediaid from @tmpmedia)
	select @r_MediaAppendibleSearched = @r_MediaAppendibleSearched - @@rowcount
    if @r_MediaAppendibleSearched > 0
    begin
		select top 1 @r_VolumeIDForJob = VolumeID, @MediaID = MediaID, @isAllAppendableExportable = IsExportable
		from #tmptblVolumeMedia
		order by IsExportable, LastBackupTime DESC
		-- If all the appendable media are marked as exportable, we should try to get the spare media first.
		-- If later failing to get any spare media, return this appendable media even it has been marked as exportable.
		if @isAllAppendableExportable = 0
		begin
			UPDATE MMMedia
			SET ScheduleRunId = @i_ScheduleRunId,
Attributes = Attributes | (134217728 * @i_DoNotAllowOtherSchedule)
			-- & ~MMS2_OVERWRITE_IF_DIFF_COMMCELL,	origCCcommCellID = @i_CommCellId
			WHERE MediaId = @MediaID
			--update MMVolume
			--set volumeflags = 7, VolumeFullReason = E_MM_VOL_FULL_NEW_SCHEDULE_RUN_INSTANCE
			--where volumeflags = 1 and mediagroupid = @i_mediagroupid
			UPDATE MMVolume
SET VolumeFlags = 1, Attributes = (Attributes & ~(472))
			WHERE VolumeId = @r_VolumeIDForJob
			goto NORMAL_EXIT
		end
		else
		begin
			-- store the appendable and exportable media info here
			set @exportableAppendableVolumeId = @r_VolumeIDForJob
			set @exportableAppendableMediaId = @MediaID
			delete #tmptblVolumeMedia
			delete @tmpmedia
		end
    end
  end
end
-- now we consider spares --
select @r_SpareGroupID = SpareGroupID
from MMMediaGroup WITH (READUNCOMMITTED)
where MediaGroupId = @i_MediaGroupID
if @r_SpareGroupID <= 0
begin
SET @r_RetCode = 251
  GOTO ERROR_EXIT
end
select @SpareGroupAttributes = Attributes
from MMSpareGroup WITH (READUNCOMMITTED)
where SpareGroupId = @r_SpareGroupID
-----------------
-- Get All Spares
-----------------
insert into #tmptblVolumeMedia
select v.VolumeId, m.MediaId, m.Attributes, m.origCCcommCellID, m.MediaLocation,
m.LastBackupTime, (m.Attributes & 1), m.NumberOfReUses, m.BarCode
from MMVolume v WITH (READUNCOMMITTED), MMMedia m WITH (READUNCOMMITTED)
where
	(
		v.MediaGroupId = 0 or
	-- Do not pick aged media as the dummy media for reserving in stand-alone.
	-- Issue described in form 1861 and fix made for MR 96243.
		-- 7/13/2018 cliu, remove the limitation for standalone library and keep it for optical only.
(@LibraryTypeID not in (/*4,*/ 5) and (m.IsAged > 0))
	)
and v.VolumeFlags = 5
and v.VolumeId > 0
and v.VolumeState != 2
and v.MediaId = m.MediaId
and m.MediaFlags = 1
and m.LibraryId = @r_LibraryID
and (@LibraryTypeID in (4, 5) or MediaLocation in (1,2))
and m.SpareGroupId = @r_SpareGroupID
and m.MediaId not in (select MediaId from @tmpreservations)
--and m.barcode not in (select barcode from MMSlot with (readuncommitted) where (MediaStatus & MMS2_SLOT_MEDIA_DUPLICATE_BARCODE) > 0)
AND (m.Attributes & 536870912) = 0
--order by (m.Attributes & MEDIA_ATTRIBUTE_EXPORTABLE), m.NumberOfReUses, m.LastBackupTime, m.BarCode, v.VolumeId
select @r_MediaSpareSearched = @@rowcount
if exists (select MediaId from MMSlot with (readuncommitted) where (MediaStatus & 1) > 0)
begin
	delete #tmptblvolumeMedia
where barcode in (select barcode from MMSlot with (readuncommitted) where (MediaStatus & 1) > 0	)
	select @r_MediaSpareSearched = @r_MediaSpareSearched - @@rowcount
end
if @r_MediaSpareSearched > 0
begin
	-- media is outside
if @LibraryTypeID != 4
and @LibraryTypeID != 5
	begin
		delete from #tmptblVolumeMedia
		where MediaId in (select MediaId from MMMedia  WITH (READUNCOMMITTED)
					where (MediaLocation in (1) and MediaId not in
						  (select mediaid from MMSlot with (readuncommitted) where SlotType = 1))
					or (MediaLocation in (2) and MediaId not in
						  (select mediaid from MMDrive with (readuncommitted)
						   where DriveSoftState = 1 and DriveEnabled = 1 and DriveBroken = 0 and MountStatus != 4))
					or (MediaLocation in (2) and MediaId in
						  (select mediaid from MMDrive with (readuncommitted)
						   where DriveSoftState = 0 or DriveEnabled = 0 or DriveBroken = 1 or MountStatus = 4)))
		select @r_MediaSpareSearched = @r_MediaSpareSearched - @@rowcount
	end
	-- check if can use media from wrong APP_CommCell
	delete from #tmptblVolumeMedia
where (Attributes & 268435456) = 0
and (@LibraryAttribute & 32) = 0
	and origCCcommCellID > 2
	select @r_MediaSpareSearched = @r_MediaSpareSearched - @@rowcount
	-- delete media with the non-supported media type
	delete from #tmptblVolumeMedia
	FROM #tmptblVolumeMedia tv, MMVolume mmv, MMMedia mmm
	WHERE tv.VolumeId = mmv.VolumeId AND mmm.MediaId = mmv.MediaId AND mmm.MediaTypeId NOT IN
	(SELECT mrfmt.MediaTypeId FROM MMDrivePool mmdp, MMDrive mmd, MMRecFmtMedTyp mrfmt
	WHERE mmdp.drivePoolId = @DrivePoolID AND mmd.MasterPoolId = mmdp.MasterPoolId
	AND mrfmt.DriveTypeId = mmd.DriveTypeId
AND (mrfmt.CompatibilityType & 2) > 0)
	select @r_MediaSpareSearched = @r_MediaSpareSearched - @@rowcount
   	-- if media in drive, has to be accessible by the media group's drive pool
	if exists (select * from #tmptblVolumeMedia where MediaLocation = 2)
    begin
    	delete from #tmptblVolumeMedia
    	where MediaLocation = 2
    	and not exists (select * from MMdrive
    				where mediaid = #tmptblVolumeMedia.MediaId
    				and driveid in (select driveid from mmdrivecontroller
    								where drivepoolid = @DrivePoolID)
    				)
		select @r_MediaSpareSearched = @r_MediaSpareSearched - @@rowcount
	    delete from #tmptblVolumeMedia
		where MediaLocation = 2
		and not exists
		(
			SELECT *
			FROM MMDrive DRV WITH (NOLOCK), MMDriveController DRVCTRL WITH (NOLOCK),
					MMHost HOST WITH (NOLOCK)
			WHERE DRV.MediaId = #tmptblVolumeMedia.MediaId AND DRV.DriveSoftState = 1 AND
					DRV.DriveEnabled = 1 AND DRV.DriveBroken = 0 AND DRV.MountStatus != 4
			AND DRV.DriveId = DRVCTRL.DriveId AND DRVCTRL.DriveControllerSoftState = 1
			AND DRVCTRL.DriveControllerEnabled = 1 AND DRVCTRL.DriveAccessible = 1
			AND DRVCTRL.ClientId = HOST.ClientId AND HOST.MmHostSoftState = 1 AND MmHostEnabled = 1
		)
		select @r_MediaSpareSearched = @r_MediaSpareSearched - @@rowcount
	end
if (@LibraryTypeID = 4 or @LibraryTypeID = 5)
	and exists (select * from #tmptblVolumeMedia where MediaLocation = 2)
	begin
		delete from #tmptblVolumeMedia
		where MediaLocation != 2
    	select @r_MediaSpareSearched = @r_MediaSpareSearched - @@rowcount
	end
	-- Delete the media which is not in the drive for PnP library
	delete #tmptblVolumeMedia
	from #tmptblVolumeMedia a, MMMedia m WITH (NOLOCK)
	where	a.MediaId = m.MediaId
and		m.MediaTypeId in (11002)
	and 	not exists (select driveId from MMDrive with (NOLOCK) where mediaId = a.MediaId)
	select @r_MediaSpareSearched = @r_MediaSpareSearched - @@rowcount
end
if @r_MediaSpareSearched = 0
and	(@LibraryTypeID = 4
or @LibraryTypeID = 5)
begin
	-- create a dummy media
	select top 1 @MediaTypeIDNewMedia = DT.DefaultMediaTypeId from MMDriveType DT WITH (READUNCOMMITTED),
						MMDrive D WITH (READUNCOMMITTED), MMDrivePool HDP WITH (READUNCOMMITTED)
						where DT.DriveTypeId = D.DriveTypeId AND
						D.MasterPoolId = HDP.MasterPoolId AND
						HDP.DrivePoolId = @DrivePoolID
	if @MediaTypeIDNewMedia <= 0 or @MediaTypeIDNewMedia is null
	begin
SET @r_RetCode = 390
		GOTO ERROR_EXIT
	end
	select top 1 @RecordingFormatIDNewMedia = RFMT.RecordingFormatId from MMRecFmtMedTyp RFMT WITH (READUNCOMMITTED),
						MMDrive D WITH (READUNCOMMITTED), MMDrivePool HDP WITH (READUNCOMMITTED)
						where RFMT.DriveTypeId = D.DriveTypeId AND
						D.MasterPoolId = HDP.MasterPoolId AND
						RFMT.MediaTypeID = @MediaTypeIDNewMedia AND
						HDP.DrivePoolId = @DrivePoolID
AND (RFMT.CompatibilityType & 2) > 0
						order by RFMT.RecordingFormatId DESC
	if @RecordingFormatIDNewMedia <= 0 or @RecordingFormatIDNewMedia is null
	begin
SET @r_RetCode = 281
		GOTO ERROR_EXIT
	end
	-- identity a dummy standalone media
	create table #catchoutput(MediaId int, ErrCode int)
	insert into #catchoutput
EXEC @MediaId=MMS2AddMedia @i_CommCellID,'StdAln',@MediaTypeIDNewMedia,@RecordingFormatIDNewMedia,@r_LibraryID,@r_SpareGroupID,3,2,'',0
	select @MediaId = MediaId from #catchoutput
	drop table #catchoutput
	if @MediaId is not null and @MediaId != 0
	begin
		insert into #tmptblVolumeMedia
		select v.VolumeId, m.MediaId, m.Attributes, m.origCCcommCellID, m.MediaLocation,
		0, 0, 0, ''
		from MMVolume v WITH (READUNCOMMITTED), MMMedia m WITH (READUNCOMMITTED)
		where v.MediaId = m.MediaId
		and m.MediaId = @MediaId
		select @r_MediaSpareSearched = @@rowcount
	end
end
if @r_MediaSpareSearched > 0
begin
 GETSPAREMEDIAFROMLIST:
 	if exists (SELECT 1 FROM mmconfigs WHERE name = 'MMCONFIG_RESOURCEMANAGER_BACKUP_USE_SPARE_BY_BARCODE_ORDER_ONLY' and value = 1)
	begin
		  select top 1 @r_VolumeIDForJob = VolumeID, @MediaID = MediaID, @Attributes = Attributes
		  from #tmptblVolumeMedia
		  order by BarCode
	end
	else
	begin
if (@SpareGroupAttributes & 16) > 0
		  select top 1 @r_VolumeIDForJob = VolumeID, @MediaID = MediaID, @Attributes = Attributes
		  from #tmptblVolumeMedia
		  order by IsExportable, NumberOfReUses, LastBackupTime, BarCode, VolumeId
else if(@SpareGroupAttributes & 32) > 0
			SELECT TOP 1 @r_VolumeIDForJob = A.VolumeID, @MediaID = A.MediaID, @Attributes = A.Attributes
			FROM #tmptblVolumeMedia A, MMMedia M WITH (READUNCOMMITTED), MMMediaType MT WITH (READUNCOMMITTED)
			WHERE A.MediaID = M.MediaId AND M.MediaTypeId = MT.MediaTypeId
			ORDER BY A.IsExportable, MT.MaxUncompressCapacityMB, A.NumberOfReUses DESC, A.LastBackupTime DESC, A.BarCode, A.VolumeId
else if(@SpareGroupAttributes & 64) > 0
			SELECT TOP 1 @r_VolumeIDForJob = A.VolumeID, @MediaID = A.MediaID, @Attributes = A.Attributes
			FROM #tmptblVolumeMedia A, MMMedia M WITH (READUNCOMMITTED), MMMediaType MT WITH (READUNCOMMITTED)
			WHERE A.MediaID = M.MediaId AND M.MediaTypeId = MT.MediaTypeId
			ORDER BY  A.IsExportable, MT.MaxUncompressCapacityMB DESC, A.NumberOfReUses DESC, A.LastBackupTime DESC, A.BarCode, A.VolumeId
		else
		  select top 1 @r_VolumeIDForJob = VolumeID, @MediaID = MediaID, @Attributes = Attributes
		  from #tmptblVolumeMedia
		  order by IsExportable, NumberOfReUses desc, LastBackupTime desc, BarCode, VolumeId
	end
	select @MediaTypeID = MediaTypeId from MMMedia with (readuncommitted) where MediaId = @MediaID
	select top 1 @RecordingFormatID = RFMT.RecordingFormatId from MMRecFmtMedTyp RFMT WITH (READUNCOMMITTED),
						MMDrive D WITH (READUNCOMMITTED), MMDrivePool HDP WITH (READUNCOMMITTED)
						where RFMT.DriveTypeId = D.DriveTypeId AND
						D.MasterPoolId = HDP.MasterPoolId AND
						RFMT.MediaTypeID = @MediaTypeID AND
						HDP.DrivePoolId = @DrivePoolID
AND (RFMT.CompatibilityType & 2) > 0
						order by RFMT.RecordingFormatId DESC
	if @RecordingFormatID <= 0 or @RecordingFormatID is null
	begin
		-- we cannot use media of this media type. skip them.
		DELETE #tmptblVolumeMedia
		FROM #tmptblVolumeMedia tt INNER JOIN MMMedia M ON M.MediaId = tt.MediaId
		WHERE M.MediaTypeId = @MediaTypeID
		-- the rowcount check makes sure we definately cannot enter an infinite loop
		-- eventhough it would be very weird as we know for sure that we have a media with the
		-- mediatype we are deleting.
		IF (@@ROWCOUNT > 0) AND EXISTS (SELECT TOP 1 MediaId FROM #tmptblVolumeMedia)
		BEGIN
			 -- try again..
			 GOTO GETSPAREMEDIAFROMLIST
		END ELSE
		BEGIN
			-- no more media left to try... Let's see if we should autocorrect the mediatype
			DECLARE @l_autoCorrectMediaTypes INTEGER
			SELECT TOP 1 @l_autoCorrectMediaTypes = value
			FROM mmconfigs
			WHERE name = 'MMS2_CONFIG_AUTOCORRECT_MEDIATYPES'
			IF (@l_autoCorrectMediaTypes = 1)
			BEGIN
				set @MediaTypeID = null
				set @RecordingFormatID = null
				declare @l_DriveTypeId INTEGER
				select TOP 1 @l_DriveTypeId = D.DriveTypeId
				FROM MMDrive D WITH (READUNCOMMITTED)
				WHERE D.MasterPoolId =
				(	SELECT MasterPoolId
					FROM MMDrivePool DP WITH (READUNCOMMITTED)
					WHERE DP.DrivePoolId = @DrivePoolID
				)
				select @MediaTypeID = DefaultMediaTypeId
				FROM MMDriveType
				WHERE DriveTypeId = @l_DriveTypeId
				-- if l_drivetypeId is null, then the above does not return anything
				-- and mediatypeid stays null
				select TOP 1 @RecordingFormatID = RecordingFormatId
				from MMRecFmtMedTyp WITH (READUNCOMMITTED)
				where drivetypeid = @l_DriveTypeId AND MediaTypeId = @MediaTypeID
and (CompatibilityType & 2) > 0
				order by recordingformatid desc
				IF @RecordingFormatID is Null
				BEGIN
					-- one of the above operations failed - either we could not get a drivetype,
					-- or a mediatype or a recordingformat - the latter is most likely, so return that error
SET @r_RetCode = 281
					GOTO ERROR_EXIT
				END
				UPDATE MMMedia
				SET MediaTypeId = @MediaTypeID
				WHERE MediaId = @MediaID
			END ELSE
			BEGIN
				-- value not set (= null) or turned off - we should not auto correct recordingformats
SET @r_RetCode = 281
				GOTO ERROR_EXIT
			END
		END
	end
	-- moved vault tracker update down after the recordingformat check
if (@Attributes & 1) > 0
  	begin
    	if exists (select top 1 * from VTActionMedia with (readuncommitted) where MediaId = @MediaID)
	    begin
			DECLARE @tblActionCmdReturn table (retVal int, mediaProcessed int, mediaSkipped int, errString VARCHAR(1024))
			insert into @tblActionCmdReturn
EXEC VTRunActionCmd 2, 0, @mediaId, 0
		end
		update MMMedia
set Attributes = Attributes & ~1
		where mediaid = @MediaID
  end
-- clean up the archchunk reference
--  EXEC ArchDeleteBackupByMedia @MediaID, -1, 1
--  UPDATE MMMedia
--  SET LastWriteLibraryId = @r_LibraryID, IsInMediaGroup = 1, IsAged = 0,
--  NumberOfReUses = NumberOfReUses + 1,
--  origCCcommCellID = @i_CommCellId, origCCmediaID = @MediaID
--  WHERE MediaId = @MediaID
  UPDATE MMMedia
SET Attributes = (Attributes & ~134217728 & ~1) | (134217728 * @i_DoNotAllowOtherSchedule),
  -- & ~MMS2_OVERWRITE_IF_DIFF_COMMCELL,
  -- Jai - Wed Aug 30 22:33:39 EST 2006 - forward porting change made for GP CCM patch.
  -- Set the number of reuses in MediaManager after the media has been actually used.
  -- NumberOfReUses = NumberOfReUses + 1,
  --origCCcommCellID = @i_CommCellId, origCCmediaID = 0,
  ScheduleRunId = @i_ScheduleRunId,
  IsInMediaGroup = 1,
  LastBackupTime = dbo.GetUnixTime(getutcdate())
  WHERE MediaId = @MediaID
  UPDATE MMMediaSide
  SET FreeBytesMB = TotalSpaceMB,
  -- Jai - Wed Aug 30 22:33:39 EST 2006 - forward porting change made for GP CCM patch.
  -- Set the number of reuses in MediaManager after the media has been actually used.
  -- NumberOfReUses = NumberOfReUses + 1,
  LogicalBytesMB = 0, PhysicalBytesMB = 0, IsOMLValid = 0,
  LastBackupTime = dbo.GetUnixTime(getutcdate())
  WHERE MediaId = @MediaID
  --update MMVolume
  --set volumeflags = 7, VolumeFullReason = E_MM_VOL_FULL_NEW_SCHEDULE_RUN_INSTANCE
  --where volumeflags = 1 and mediagroupid = @i_mediagroupid
  UPDATE MMVolume
  SET VolumeFlags = 1, MediaGroupId = @i_MediaGroupId, FlushBlockSizeKB = @FlushBlockSizeKB,
  --origCCcommCellID = @i_CommCellId, origCCvolumeID = 0,
  LogicalBytesMB = 0, PhysicalBytesMB = 0, NumberOfActiveFiles = 0, LastFile = 0,
  ReformatTime = dbo.GetUnixTime(getutcdate()), RecordingFormatId = @RecordingFormatID,
  LastBackupTime = dbo.GetUnixTime(getutcdate()),
Attributes = (Attributes & ~(472))
  WHERE VolumeId = @r_VolumeIDForJob
if @LibraryTypeID = 2
or @LibraryTypeID = 5
or @LibraryTypeID = 7
  begin
	UPDATE MMVolume
	SET MediaGroupId = @i_MediaGroupId, FlushBlockSizeKB = @FlushBlockSizeKB,
	--origCCcommCellID = @i_CommCellId, origCCvolumeID = 0,
	LogicalBytesMB = 0, PhysicalBytesMB = 0, NumberOfActiveFiles = 0, LastFile = 0,
	ReformatTime = dbo.GetUnixTime(getutcdate()), RecordingFormatId = @RecordingFormatID,
	LastBackupTime = dbo.GetUnixTime(getutcdate())
	WHERE MediaId = @MediaID and VolumeId != @r_VolumeIDForJob
  end
--  UPDATE MMVolume
--  SET NumberOfActiveFiles = 0
--  WHERE MediaId = @MediaID
--  AND MediaSideId IN (SELECT MediaSideId FROM MMMediaSide WITH (READUNCOMMITTED)
--	WHERE MediaId = @MediaID AND IsOMLValid <= 0)
  goto NORMAL_EXIT
end
else if (@r_MediaAppendibleSearched > 0 and @isAllAppendableExportable > 0)
begin
	-- Have appendable but no spare. However, all appendable are marked as exportable
	set @r_VolumeIDForJob = @exportableAppendableVolumeId
	set @MediaID = @exportableAppendableMediaId
	-- moved vault tracker update down after the recordingformat check
	if exists (select top 1 * from VTActionMedia with (readuncommitted) where MediaId = @MediaID)
	begin
			DECLARE @tblActionCmdReturn1 table (retVal int, mediaProcessed int, mediaSkipped int, errString VARCHAR(1024))
			insert into @tblActionCmdReturn1
EXEC VTRunActionCmd 2, 0, @mediaId, 0
	end
	update MMMedia
set Attributes = Attributes & ~1
	where mediaid = @MediaID
	UPDATE MMMedia
	SET ScheduleRunId = @i_ScheduleRunId,
Attributes = Attributes | (134217728 * @i_DoNotAllowOtherSchedule)
	-- & ~MMS2_OVERWRITE_IF_DIFF_COMMCELL,	origCCcommCellID = @i_CommCellId
	WHERE MediaId = @MediaID
	UPDATE MMVolume
SET VolumeFlags = 1, Attributes = (Attributes & ~(472))
	WHERE VolumeId = @r_VolumeIDForJob
	goto NORMAL_EXIT
end
else
begin
SET @r_RetCode = 280
  GOTO ERROR_EXIT
end
NORMAL_EXIT:
ERROR_EXIT:
  drop table #tmptblVolumeMedia
    IF (@isQuickMR = 1 AND @r_retcode = 0 AND @r_VolumeIDForJob > 0)
BEGIN
	UPDATE MMVolume
	SET MediaGroupId = @i_MediaGroupId
	WHERE VolumeId = @r_VolumeIDForJob
		AND MediaGroupId = @mediaGroupSrc
END
  if @i_ignoreReturn = 0
	begin
	  select @r_RetCode, @r_VolumeIDForJob, @r_SpareGroupID, @r_LibraryID, @r_MediaOfOtherSideSearched,
			 @r_MediaAppendibleSearched, @r_MediaSpareSearched
	end
	else
	begin
		set @o_VolumeIdForJob = @r_VolumeIDForJob
	end
  return @r_RetCode
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2GetVolumeForJob')
	delete from GxQscripts where name = 'MMS2GetVolumeForJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetVolumeForJob')
	delete from GXDBVersions where aliasname = 'MMS2GetVolumeForJob'
GO

insert into GXDBVersions values(2, 'MMS2GetVolumeForJob',  '00010096004400050000', 'MMS2GetVolumeForJob', '00010096004400050000')
GO

