

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GetVaultTrackerPoliciesforLibrary.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2GetVaultTrackerPoliciesforLibrary.sp
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMS2GetVaultTrackerPoliciesforLibrary')
BEGIN
	print '>>> Drop Stored Procedure: MMS2GetVaultTrackerPoliciesforLibrary <<<'
	drop procedure MMS2GetVaultTrackerPoliciesforLibrary
END
IF EXISTS (select * from GxQscripts where name='MMS2GetVaultTrackerPoliciesforLibrary')
	delete from GxQscripts where name = 'MMS2GetVaultTrackerPoliciesforLibrary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetVaultTrackerPoliciesforLibrary')
	delete from GXDBVersions where aliasname = 'MMS2GetVaultTrackerPoliciesforLibrary'
GO
print '... Creating Procedure: MMS2GetVaultTrackerPoliciesforLibrary'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2GetVaultTrackerPoliciesforLibrary
  @i_UserId INTEGER,
  @i_LibraryId INTEGER
AS
  DECLARE @o_VaultTrackerPolicyId INTEGER
  DECLARE @o_VaultTrackerPolicyName NVARCHAR(255)
  DECLARE @o_VaultTrackerPolicyType INTEGER
  DECLARE @o_Flags INTEGER
  DECLARE @o_LibraryType INTEGER
  DECLARE @o_DestinationType INTEGER
  DECLARE @o_DestinationId INTEGER
  DECLARE @o_DestExpLocType INTEGER
  DECLARE @o_DestinationName NVARCHAR(255)
  DECLARE @o_Description NVARCHAR(max)
 --
 --   o_VaultTrackerPolicyType "1" means EXPORT
 --   o_VaultTrackerPolicyType "2" means DUE_BACK
 --
 DECLARE @vtPoliciesForLibrary table
  ( vtPolicyId integer,
vtPolicyName NVARCHAR(255),
	vtPolicyType integer,
	vtRuleId   integer,
    flags integer,
    libraryType integer,
    destinationId integer,
    destType integer,
    destValue integer,
    description NVARCHAR(max),
    accesible integer,
    Primary key (vtPolicyId))
INSERT INTO @vtPoliciesForLibrary
SELECT vtPolicy.policyId, vtPolicy.PolicyName,1,vtRuleToSchema.RuleId , vtPolicy.flag AS Flags ,
       library.LibraryTypeId AS LibraryType, destinationid,0,0,
       vtPolicy.Descript AS 'Description',0
FROM VTPolicy vtPolicy  WITH(READUNCOMMITTED), VTPolicyToRule vtRule  WITH(READUNCOMMITTED), VTRuleToSchema vtRuleToSchema  WITH(READUNCOMMITTED), MMLibrary library  WITH(READUNCOMMITTED)
WHERE vtPolicy.PolicyId = vtRule.PolicyId
AND vtRule.RuleId = vtRuleToSchema.RuleId
AND vtRuleToSchema.SchemaId = 2
AND vtRuleToSchema.Flag = 1
AND ( vtRuleToSchema.Param = library.LibraryId OR vtRuleToSchema.Param = -1 )
AND library.LibraryTypeId <> 3
AND library.LibraryId = @i_LibraryId
ORDER BY vtPolicy.PolicyName
UPDATE @vtPoliciesForLibrary
SET destType = type,
destValue = value
FROM VTLocation WITH(READUNCOMMITTED) WHERE
locationid = destinationid
UPDATE @vtPoliciesForLibrary
SET vtPolicyType = 2
FROM VTRuleToSchema  WITH(READUNCOMMITTED)
WHERE RuleId = vtRuleId AND SchemaId = 6 AND Param > -1
DECLARE @accessible INT
DECLARE @iterationId INT = (SELECT MIN(vtPolicyId) FROM @vtPoliciesForLibrary)
WHILE @iterationId IS NOT NULL BEGIN
    SET @accessible = 0
    -- check capability
EXEC sec_checkPermissionOnEntity @i_UserId, 26, @accessible OUTPUT, 21, @iterationId
    -- update temporary table
    UPDATE @vtPoliciesForLibrary SET accesible = @accessible WHERE vtPolicyId = @iterationId
    -- next iteration
    SELECT @iterationId = MIN(vtPolicyId) FROM @vtPoliciesForLibrary WHERE vtPolicyId > @iterationId
END
SELECT vtPolicyId, vtPolicyName, vtPolicyType, flags, libraryType, destType, destValue,
    CASE destType
        WHEN 2 then (CASE destValue
                WHEN 0 then 0
                ELSE (SELECT Type FROM MMExportLocation WITH(READUNCOMMITTED) WHERE ExportLocationId = destValue)
            END)
        WHEN 1 then (CASE destValue
                WHEN 0 then 0
                ELSE (SELECT LibraryTypeId FROM MMLibrary WITH(READUNCOMMITTED) WHERE LibraryId = destValue)
            END)
            ELSE 0
        END as DestExpLocType,
     CASE destType
        WHEN 1 then (   CASE destValue
            WHEN 0 then 'Inside Library'
            ELSE (SELECT AliasName FROM MMLibrary WITH(READUNCOMMITTED) WHERE LibraryId = destValue)
            END
            )
            WHEN 2 then (   CASE destValue
            WHEN 0 then 'Outside'
            ELSE (SELECT ExportLocation FROM MMExportLocation WITH(READUNCOMMITTED) WHERE ExportLocationId = destValue)
            END
            )
            WHEN 4 then (   CASE destValue
            WHEN 0 then 'At virtual mailslots'
            ELSE (SELECT AliasName + ' virtual mailslots' FROM MMLibrary WITH(READUNCOMMITTED) WHERE LibraryId = destValue)
            END
            )
            ELSE 'Not Available'
        END as DestLocName,
		description from  @vtPoliciesForLibrary
WHERE accesible>0
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2GetVaultTrackerPoliciesforLibrary')
	delete from GxQscripts where name = 'MMS2GetVaultTrackerPoliciesforLibrary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetVaultTrackerPoliciesforLibrary')
	delete from GXDBVersions where aliasname = 'MMS2GetVaultTrackerPoliciesforLibrary'
GO

insert into GXDBVersions values(2, 'MMS2GetVaultTrackerPoliciesforLibrary',  '00000000000000000000', 'MMS2GetVaultTrackerPoliciesforLibrary', '00000000000000000000')
GO

