

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GetVTAlerts.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2GetVTAlerts.sp,v $ $Id: MMS2GetVTAlerts.sp,v 1.5.278.2 2018/03/20 20:03:26 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "MMS2GetVTAlerts"				|
--	|									|
--	| Execute the System stored procedure to fetch the physical files	|
--	| .. for the (current) database.					|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2GetVTAlerts <<<'

IF EXISTS (select * from sysobjects where name='MMS2GetVTAlerts')
	drop procedure MMS2GetVTAlerts
IF EXISTS (select * from GxQscripts where name='MMS2GetVTAlerts')
	delete from GxQscripts where name = 'MMS2GetVTAlerts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetVTAlerts')
	delete from GXDBVersions where aliasname = 'MMS2GetVTAlerts'
GO
print '... Creating Procedure: MMS2GetVTAlerts'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2GetVTAlerts
  @i_commCellId integer
AS
  DECLARE @o_AlertAction integer
  DECLARE @o_Initiator char(255)
  DECLARE @o_ActionId integer
  DECLARE @o_MediaId integer
  DECLARE @o_SourceLoc NVARCHAR(255)
  DECLARE @o_IntransitLoc NVARCHAR(255)
  DECLARE @o_DestinationLoc NVARCHAR(255)
  DECLARE @o_CurrentLoc NVARCHAR(255)
  DECLARE @o_ContainerId integer
  DECLARE @o_PolicyId integer
  DECLARE @o_PolicyName NVARCHAR(255)
	if object_id('tempdb.dbo.#tmalertstmp') is not null DROP TABLE #tmalertstmp
	create table #tmalertstmp
	(
		AlertAction			integer not null,
		Initiator			varchar(128) not null,
		ActionId			integer not null,
		MediaId				integer not null,
		SourceId			integer not null,
		InTransitId			integer not null,
		DestinationId		integer not null,
		SourceLoc			nvarchar(256),
		InTransitLoc		nvarchar(256),
		DestinationLoc		nvarchar(256),
		CurrentLoc			nvarchar(256),
		ContainerId			integer not null,
		PolicyId			integer not null,
		PolicyName			nvarchar(256)
	)
	create clustered index #tmAlerts_actionId ON #tmalertstmp(actionId)
	insert into #tmalertstmp
	select distinct alertaction, initiator, actionid, mediaid, sourceid, intransitid, destinationid, '', '', '', '', 0, 0, ''
	from VTAlerts
	where alertaction <> 41
	update #tmalertstmp
	set sourceloc = (select aliasname from MMLibrary where libraryid = b.value)
	from #tmalertstmp a, VTLocation b
	where a.sourceid > 0
	and a.sourceloc = ''
	and a.sourceid = b.locationid
	and b.type = 1
	and b.value > 0
	update #tmalertstmp
	set sourceloc = 'Inside Library'
	from #tmalertstmp a, VTLocation b
	where a.sourceid > 0
	and a.sourceloc = ''
	and a.sourceid = b.locationid
	and b.type = 1
	and b.value = 0
	update #tmalertstmp
	set sourceloc = (select exportlocation from MMExportLocation where exportlocationid = b.value)
	from #tmalertstmp a, VTLocation b
	where a.sourceid > 0
	and a.sourceloc = ''
	and a.sourceid = b.locationid
	and b.type = 2
	update #tmalertstmp
	set sourceloc = ''
	where sourceloc is null
	update #tmalertstmp
	set InTransitLoc = (select exportlocation from MMExportLocation where exportlocationid = b.value)
	from #tmalertstmp a, VTLocation b
	where a.intransitid > 0
	and a.InTransitLoc = ''
	and a.intransitid = b.locationid
	and b.type = 2
	update #tmalertstmp
	set InTransitLoc = ''
	where InTransitLoc is null
	update #tmalertstmp
	set DestinationLoc = (select aliasname from MMLibrary where libraryid = b.value)
	from #tmalertstmp a, VTLocation b
	where a.destinationid > 0
	and a.DestinationLoc = ''
	and a.destinationid = b.locationid
	and b.type = 1
	and b.value > 0
	update #tmalertstmp
	set DestinationLoc = 'Inside Library'
	from #tmalertstmp a, VTLocation b
	where a.destinationid > 0
	and a.DestinationLoc = ''
	and a.destinationid = b.locationid
	and b.type = 1
	and b.value = 0
	update #tmalertstmp
	set DestinationLoc = (select exportlocation from MMExportLocation where exportlocationid = b.value)
	from #tmalertstmp a, VTLocation b
	where a.destinationid > 0
	and a.DestinationLoc = ''
	and a.destinationid = b.locationid
	and b.type = 2
	update #tmalertstmp
	set DestinationLoc = ''
	where DestinationLoc is null
	update #tmalertstmp
	set currentLoc = d.aliasname + '(' + b.slotname + ')'
	from #tmalertstmp a, MMSlot b, MMMedia c, MMLibrary d
	where a.mediaid > 0
	and a.mediaid = c.mediaid
	and c.libraryid > 0
	and c.libraryid = d.libraryid
	and c.mediaid = b.mediaid
	update #tmalertstmp
	set currentLoc = d.aliasname
	from #tmalertstmp a, MMMedia c, MMLibrary d
	where currentloc = ''
	and a.mediaid > 0
	and a.mediaid = c.mediaid
	and c.libraryid > 0
	and c.libraryid = d.libraryid
	update #tmalertstmp
	set currentLoc = d.exportlocation
	from #tmalertstmp a, MMMedia c, MMExportLocation d
	where currentloc = ''
	and a.mediaid > 0
	and a.mediaid = c.mediaid
	and c.libraryid = 0
	and c.exportlocationid = d.exportlocationid
	update #tmalertstmp
	set currentloc = ''
	where currentloc is null
	update #tmalertstmp
	set containerid = b.containerId
	from #tmalertstmp a, MMMedia b
	where a.mediaid > 0
	and a.mediaid = b.mediaid
	update #tmalertstmp
	set PolicyId = TMA.PolicyId, PolicyName = TMP.PolicyName
	from #tmalertstmp as tt, VTAction as TMA, VTPolicy as TMP
	where tt.ActionId > 0 AND tt.ActionId = TMA.ActionId AND TMA.PolicyId = TMP.PolicyId
	declare @lt_tmpActionIds TABLE (actionId Integer primary key)
	insert into @lt_tmpActionIds
	select distinct actionId from #tmalertstmp as tt
	where tt.PolicyId = 0 AND tt.ActionId > 0
	declare @lt_ActionIdsWhereHistoryExists TABLE (actionId Integer, PolicyId Integer, PolicyName varchar(128))
	insert into @lt_ActionIdsWhereHistoryExists
	select distinct tt.actionId, TMH.PolicyId, TMH.PolicyName
	from @lt_tmpActionIds as tt, VTHistory as TMH
	where TMH.ActionId = tt.ActionId
	update #tmalertstmp
	set PolicyId = TMH.PolicyId, PolicyName = TMH.PolicyName
	from #tmalertstmp as tt, @lt_ActionIdsWhereHistoryExists as TMH
	where tt.PolicyId = 0 AND tt.ActionId > 0 AND tt.ActionId = TMH.ActionId
	select alertaction, initiator, actionid, mediaid, sourceloc, intransitloc, destinationloc, currentloc, containerid, PolicyId, PolicyName
	from #tmalertstmp
	where PolicyId > 0
	order by alertaction, initiator, actionid
	drop table #tmalertstmp
	--Keep the ones with the alertaction = 41 for the mediaInCAPReady alert
	delete from VTAlerts
	where AlertAction <> 41
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2GetVTAlerts')
	delete from GxQscripts where name = 'MMS2GetVTAlerts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetVTAlerts')
	delete from GXDBVersions where aliasname = 'MMS2GetVTAlerts'
GO

insert into GXDBVersions values(2, 'MMS2GetVTAlerts',  '00010005027800020000', 'MMS2GetVTAlerts', '00010005027800020000')
GO

