

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GetTmPolicyToCopyUpdateList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2018  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- Stored procedure supports update of multiple VaultTracker policies
--
-- XML sample
-- 	<MediaManager_VTPolicyToCopyList>
--		<vtPolicyToCopyList archCopyId="0" archGroupId="13" vtPolicyId="3"/>
--		<vtPolicyToCopyList archCopyId="20" archGroupId="19" vtPolicyId="4"/>
--		<vtPolicyToCopyList archCopyId="0" archGroupId="0" vtPolicyId="5"/>
--	</MediaManager_VTPolicyToCopyList>
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMS2GetTmPolicyToCopyUpdateList')
BEGIN
	print '>>> Drop Stored Procedure: MMS2GetTmPolicyToCopyUpdateList <<<'
	drop procedure MMS2GetTmPolicyToCopyUpdateList
END
IF EXISTS (select * from GxQscripts where name='MMS2GetTmPolicyToCopyUpdateList')
	delete from GxQscripts where name = 'MMS2GetTmPolicyToCopyUpdateList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetTmPolicyToCopyUpdateList')
	delete from GXDBVersions where aliasname = 'MMS2GetTmPolicyToCopyUpdateList'
GO
print '... Creating Procedure: MMS2GetTmPolicyToCopyUpdateList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MMS2GetTmPolicyToCopyUpdateList
  @i_userId int,
  @i_xml xml
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_policyId integer
  DECLARE @o_archGroupId integer
  DECLARE @o_copyId integer
set nocount on
--Get Storage Policies selected by user
if object_id('tempdb.dbo.#policyToCopySelected') is not null drop table #policyToCopySelected
create table #policyToCopySelected(vtPolicyId int, archGroupId int, archCopyId int)
insert into #policyToCopySelected(vtPolicyId, archGroupId, archCopyId)
select tbl.col.value('@vtPolicyId','int')
	, tbl.col.value('@archGroupId','int')
	, tbl.col.value('@archCopyId','int')
from @i_xml.nodes('//MediaManager_VTPolicyToCopyList/vtPolicyToCopyList') as tbl(col)
--Get Storage Policies with permission
if object_id('tempdb.dbo.#spPolicyPermissions') is not null drop table #spPolicyPermissions
create table #spPolicyPermissions(archGroupId int)
exec sec_getNonIdaObjectsForThisUser @i_userId, 17, 4, '#spPolicyPermissions'
--Get VT Policies with permission
if object_id('tempdb.dbo.#vtPolicyPermissions') is not null drop table #vtPolicyPermissions
create table #vtPolicyPermissions(vtPolicyId int)
exec sec_getNonIdaObjectsForThisUser @i_userId, 21, 26, '#vtPolicyPermissions'
--Update Storage Policies when all are selected
if exists(select 1 from #policyToCopySelected where archGroupId = 0 and archCopyId = 0)
begin
	insert into #policyToCopySelected(vtPolicyId, archGroupId, archCopyId)
	select pc.vtPolicyId, sp.archGroupId, 0
	from #policyToCopySelected pc
	cross join #spPolicyPermissions sp
	where pc.archGroupId = 0 and archCopyId = 0
	delete from #policyToCopySelected
	where archGroupId = 0 and archCopyId = 0
end
--Clean up user selection based on permissions
delete pc
from #policyToCopySelected pc
left join #spPolicyPermissions s on s.archGroupId = pc.archGroupId
where s.archGroupId is null
and pc.archGroupId <> -1
delete pc
from #policyToCopySelected pc
left join #vtPolicyPermissions p on p.vtPolicyId = pc.vtPolicyId
where p.vtPolicyId is null
and pc.archGroupId <> -1
and p.vtPolicyId  <> -1
--Add existing associations for the VT Policies
if object_id('tempdb.dbo.#policyToCopyExisting') is not null drop table #policyToCopyExisting
create table #policyToCopyExisting(vtPolicyId int, archGroupId int, archCopyId int)
insert into #policyToCopyExisting(vtPolicyId, archGroupId, archCopyId)
select distinct vtpc.PolicyId, vtpc.ArchGroupId, vtpc.CopyId
from VTPolicyToCopy(nolock) vtpc
join #policyToCopySelected pcs on pcs.vtPolicyId = vtpc.PolicyId
if exists(select 1 from #policyToCopyExisting where archGroupId = 0 and archCopyId = 0)
begin
	insert into #policyToCopyExisting(vtPolicyId, archGroupId, archCopyId)
	select pc.vtPolicyId, agc.id, 0
	from #policyToCopyExisting pc
	cross join archGroupCopy(nolock) agc
	where pc.archGroupId = 0 and archCopyId = 0
	delete from #policyToCopyExisting
	where archGroupId = 0 and archCopyId = 0
end
--Remove associations which user has permission to
delete pc
from #policyToCopyExisting pc
left join #spPolicyPermissions s on s.archGroupId = pc.archGroupId
where s.archGroupId is not null
select vtPolicyId, archGroupId, archCopyId
from
(select vtPolicyId, archGroupId, archCopyId
from #policyToCopyExisting
union
select vtPolicyId, archGroupId, archCopyId
from #policyToCopySelected
where archGroupId <> -1) final_set
order by vtPolicyId, archGroupId, archCopyId
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2GetTmPolicyToCopyUpdateList')
	delete from GxQscripts where name = 'MMS2GetTmPolicyToCopyUpdateList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetTmPolicyToCopyUpdateList')
	delete from GXDBVersions where aliasname = 'MMS2GetTmPolicyToCopyUpdateList'
GO

insert into GXDBVersions values(2, 'MMS2GetTmPolicyToCopyUpdateList',  '00000000000000000000', 'MMS2GetTmPolicyToCopyUpdateList', '00000000000000000000')
GO

