

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GetTMMediaTime.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2GetTMMediaTime.sp,v $ $Id: MMS2GetTMMediaTime.sp,v 1.4.304.1 2018/03/20 19:49:31 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "MMS2GetTMMediaTime"				|
--	|									|
--	| Execute the System stored procedure to fetch the physical files	|
--	| .. for the (current) database.					|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2GetTMMediaTime <<<'

IF EXISTS (select * from sysobjects where name='MMS2GetTMMediaTime')
	drop procedure MMS2GetTMMediaTime
IF EXISTS (select * from GxQscripts where name='MMS2GetTMMediaTime')
	delete from GxQscripts where name = 'MMS2GetTMMediaTime'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetTMMediaTime')
	delete from GXDBVersions where aliasname = 'MMS2GetTMMediaTime'
GO
print '... Creating Procedure: MMS2GetTMMediaTime'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2GetTMMediaTime
  @i_commcellId integer,
  @i_actionId integer,
  @i_mediaId integer
AS
  DECLARE @o_minutes integer
  DECLARE @o_operation integer
  DECLARE @o_opstate integer
  DECLARE @o_minutesSinceActionStart integer
  DECLARE @o_actionStatTime integer
  DECLARE @o_policyId integer
	SET NOCOUNT ON
	DECLARE @minute			integer
	DECLARE @operation		integer
	DECLARE @opstate		integer
	DECLARE @minutesSinceActionStart integer
	SET	@operation = 0
	SET	@opstate = 0
	SET @minutesSinceActionStart = -1
	SET @o_actionStatTime = 0
	SET @o_policyId = 0
	SELECT @minute = DATEDIFF(mi, TimeStamp, GETUTCDATE())
	FROM 	VTActionMedia
	WHERE ActionId = @i_actionId
	AND MediaId = @i_mediaId
	IF @minute is null
	BEGIN
		SET @minute = -1
	END
	ELSE
	BEGIN
		SELECT @operation = Operation, @opstate = OperationState
		FROM 	VTActionMedia
		WHERE ActionId = @i_actionId
		AND MediaId = @i_mediaId
		SELECT @minutesSinceActionStart = DATEDIFF(mi, StartTime, GETUTCDATE()),
				@o_policyId = PolicyId,
				@o_actionStatTime = ISNULL((select dbo.getUnixTime(StartTime)), 0)
		FROM 	VTAction
		WHERE ActionId = @i_actionId
	END
	SELECT @minute, @operation, @opstate, @minutesSinceActionStart, @o_actionStatTime, @o_policyId
	SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2GetTMMediaTime')
	delete from GxQscripts where name = 'MMS2GetTMMediaTime'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetTMMediaTime')
	delete from GXDBVersions where aliasname = 'MMS2GetTMMediaTime'
GO

insert into GXDBVersions values(2, 'MMS2GetTMMediaTime',  '00010004030400010000', 'MMS2GetTMMediaTime', '00010004030400010000')
GO

