

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GetStdAlnDrivesToCheck.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2GetStdAlnDrivesToCheck.sp,v $ $Id: MMS2GetStdAlnDrivesToCheck.sp,v 1.14.294.2 2018/03/20 19:54:52 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2GetStdAlnDrivesToCheck <<<'

IF EXISTS (select * from sysobjects where name='MMS2GetStdAlnDrivesToCheck')
	drop procedure MMS2GetStdAlnDrivesToCheck
IF EXISTS (select * from GxQscripts where name='MMS2GetStdAlnDrivesToCheck')
	delete from GxQscripts where name = 'MMS2GetStdAlnDrivesToCheck'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetStdAlnDrivesToCheck')
	delete from GXDBVersions where aliasname = 'MMS2GetStdAlnDrivesToCheck'
GO
print '... Creating Procedure: MMS2GetStdAlnDrivesToCheck'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2GetStdAlnDrivesToCheck
  @i_hostClientId integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_DriveId integer	
  DECLARE @o_DriveName varchar(256)
  DECLARE @o_AliasName NVARCHAR(256)
  DECLARE @o_DriveSoftState integer
  DECLARE @o_DriveEnabled integer
  DECLARE @o_DriveBroken integer
  DECLARE @o_CleaningRequired integer
  DECLARE @o_DriveOccupied integer
  DECLARE @o_MediaId integer
  DECLARE @o_MasterPoolId integer
  DECLARE @o_SerialNumber varchar(256)
  DECLARE @o_DriveTypeId integer
  DECLARE @o_DriveNumber integer
  DECLARE @o_VolumeId integer
  DECLARE @o_MountStatus integer
  DECLARE @o_ElementAddress integer
  DECLARE @o_Attributes integer
	if object_id('tempdb.dbo.#tmpMasterPool') is not null DROP TABLE #tmpMasterPool
	if object_id('tempdb.dbo.#tmpDriveAndControllers') is not null DROP TABLE #tmpDriveAndControllers
	create table #tmpMasterPool(MasterPoolId	integer)
	create table #tmpDriveAndControllers(	DriveId		integer,
						ClientId	integer,
						DriveControllerId	integer,
						ElementAddress	integer,
						MasterPoolId integer,
						LibraryId	integer,
						LibraryAttributes integer,
						ExtendedAttributes integer,
						LowWaterMarkMB		integer,
						DriveMountStatus	integer)
	declare @CurrentDateInSeconds	integer
	set @CurrentDateInSeconds = datediff(second,'01/01/1970', getutcdate())
	IF EXISTS(select * from MMLibrary where LibraryTypeId in(4, 5))
	BEGIN
		insert into #tmpMasterPool
		select MP.MasterPoolId
		from MMMasterPool as MP, MMLibrary as L
		where L.LibraryTypeId in(4, 5) AND L.LibraryId = MP.LibraryId
		AND (
				((@i_hostClientId <= 0) AND (L.StdAlnNextChkTime < @CurrentDateInSeconds))
				OR
				(@i_hostClientId > 0)
			)
		AND (L.LibraryAttribute & 134217728) > 0 AND L.InventoryInProgress = 0
		and L.LibrarySoftState = 1 and L.LibraryEnabled = 1 and L.LibraryBroken = 0
		and MP.MasterPoolSoftState = 1 and MP.MasterPoolEnabled = 1
		delete from #tmpMasterPool
		where exists (select MasterPoolId from MMDrivePool MDP
			where #tmpMasterPool.MasterPoolId = MDP.MasterPoolId AND
			MDP.DrivePoolSoftState = 0 and MDP.DrivePoolEnabled = 0)
		insert into #tmpDriveAndControllers
		select MDC.DriveId, MDC.ClientId, MDC.DriveControllerId, 0, MD.MasterPoolId, 0, 0, 0, 0, MD.MountStatus
		from MMDrive as MD, MMDriveController as MDC
		where
		(
			-- If hostId is specified, then only get StdAlnDrives for this host otherwise get all in
			-- the commcell.
			(@i_hostClientId > 0 AND MDC.ClientId = @i_hostClientId)
			OR (@i_hostClientId <= 0)
		)
		AND	MasterPoolId in (select MasterPoolId from #tmpMasterPool)
		AND MD.DriveSoftState = 1 AND MD.DriveEnabled = 1 AND MD.DriveBroken = 0 AND MD.CleaningRequired = 0
		AND MD.DriveId = MDC.DriveId
		AND MDC.DriveControllerId = MDC.DriveControllerId and
		MDC.DriveControllerSoftState = 1 and MDC.DriveControllerEnabled = 1 AND MDC.DriveAccessible = 1
		UPDATE #tmpDriveAndControllers
		SET #tmpDriveAndControllers.LibraryId = L.LibraryId, #tmpDriveAndControllers.LibraryAttributes = L.LibraryAttribute, #tmpDriveAndControllers.ExtendedAttributes = L.ExtendedAttributes, #tmpDriveAndControllers.LowWaterMarkMB = L.LowWaterMarkMB
		FROM MMMasterPool MP, MMLibrary L
		WHERE #tmpDriveAndControllers.MasterPoolId = MP.MasterPoolId AND MP.LibraryId = L.LibraryId
		-- Remove all drives that are in mounting/unmounting state --> only do this for non-PNP drives.
		delete from #tmpDriveAndControllers
		where
		(
((#tmpDriveAndControllers.ExtendedAttributes & 4096) = 0) AND
					(#tmpDriveAndControllers.DriveMountStatus IN (2, 3))
		)
		-- Remove all the drives that are currently reserved of they are not of type PNP.
		delete from #tmpDriveAndControllers
		where EXISTS
		(
			Select DriveId from MMResource as MR
			where MR.DriveId = #tmpDriveAndControllers.DriveId AND
((#tmpDriveAndControllers.ExtendedAttributes & 4096) = 0 )
		)
		--Remove all the Drives whose softState is off or is not enabled.
		delete from #tmpDriveAndControllers
		where EXISTS (select MH.clientid from MMHost AS MH where #tmpDriveAndControllers.ClientId = MH.ClientId AND
							(MH.MMHostSoftState = 0 OR MH.MMHostEnabled = 0) )
	END
	update #tmpDriveAndControllers
	set ElementAddress = (MD.DriveNumber + ML.BaseAddress -1)
	from MMDrive as MD, MMLibrary as ML, #tmpDriveAndControllers as tt
	where MD.DriveId = tt.DriveId AND tt.LibraryId = ML.LibraryId
	--We need to do this select even if there are no rows exists in the temp table as the Cursor output expects a structure to be returned
	--rather than returning nothing.
	select distinct MD.DriveId, MD.DriveName, MD.AliasName, MD.DriveSoftState, MD.DriveEnabled,
	MD.DriveBroken, MD.CleaningRequired, MD.DriveOccupied, MD.MediaId, MD.MasterPoolId, MD.SerialNumber,
	MD.DriveTypeId, MD.DriveNumber, MD.VolumeId, MD.MountStatus, tt.ElementAddress, MD.Attributes
	from #tmpDriveAndControllers as tt, MMDrive as MD
	where MD.DriveId = tt.DriveId
	drop table #tmpMasterPool
	drop table #tmpDriveAndControllers
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2GetStdAlnDrivesToCheck')
	delete from GxQscripts where name = 'MMS2GetStdAlnDrivesToCheck'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetStdAlnDrivesToCheck')
	delete from GXDBVersions where aliasname = 'MMS2GetStdAlnDrivesToCheck'
GO

insert into GXDBVersions values(2, 'MMS2GetStdAlnDrivesToCheck',  '00010014029400020000', 'MMS2GetStdAlnDrivesToCheck', '00010014029400020000')
GO

