

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GetSpareGroupsByLibraryOrDrivePool.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2GetSpareGroupsByLibraryOrDrivePool.sp,v $ $Id: MMS2GetSpareGroupsByLibraryOrDrivePool.sp,v 1.2.294.2 2018/03/20 20:03:50 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "MMS2GetSpareGroupsByLibraryOrDrivePool"	|
--	|									|
--	| Get the spare groups for a library or drive poool. This should help   |
--	| speed up creations of storage policies, or storage policy copies      |
-- 	| author: Michael Klose							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2GetSpareGroupsByLibraryOrDrivePool <<<'

IF EXISTS (select * from sysobjects where name='MMS2GetSpareGroupsByLibraryOrDrivePool')
	drop procedure MMS2GetSpareGroupsByLibraryOrDrivePool
IF EXISTS (select * from GxQscripts where name='MMS2GetSpareGroupsByLibraryOrDrivePool')
	delete from GxQscripts where name = 'MMS2GetSpareGroupsByLibraryOrDrivePool'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetSpareGroupsByLibraryOrDrivePool')
	delete from GXDBVersions where aliasname = 'MMS2GetSpareGroupsByLibraryOrDrivePool'
GO
print '... Creating Procedure: MMS2GetSpareGroupsByLibraryOrDrivePool'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2GetSpareGroupsByLibraryOrDrivePool
  @i_libraryId integer,
  @i_drivePoolId integer,
  @i_typeBitmask integer
AS
  DECLARE @o_spareGroupId integer
  DECLARE @o_spareGroupName NVARCHAR(255)
  DECLARE @o_LowWaterMark integer
  DECLARE @o_SpareGroupType integer
  DECLARE @o_IsLowWaterMark integer
  DECLARE @o_HighWaterMark integer
  DECLARE @o_Attributes integer
  DECLARE @o_MediaTypeId integer
  DECLARE @o_LibraryId integer
	SET NOCOUNT ON
	DECLARE @l_libID integer
	IF (@i_libraryId = 0)
	BEGIN
		SET @l_libId =
		(
			SELECT LibraryId from MMMasterPool
			WHERE MasterPoolId =
			(
				select MasterPoolId from MMDrivePool WHERE DrivePoolId = @i_drivePoolId
			)
		)
	END ELSE SET @l_libId = @i_libraryId
	-- #define	REGULAR_SPARE_GROUP	1
	-- #define	DEFAULT_SPARE_GROUP	2
	-- 1 + 2 = 3 regular or default spare group
	SELECT spareGroupId, spareGroupName, LowWaterMark, SpareGroupType, IsLowWaterMark, HighWaterMark, Attributes, MediaTypeId, @l_libId
	FROM MMSpareGroup
	WHERE LibraryId = @l_libId AND (SpareGroupType & @i_typeBitmask > 0)
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2GetSpareGroupsByLibraryOrDrivePool')
	delete from GxQscripts where name = 'MMS2GetSpareGroupsByLibraryOrDrivePool'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetSpareGroupsByLibraryOrDrivePool')
	delete from GXDBVersions where aliasname = 'MMS2GetSpareGroupsByLibraryOrDrivePool'
GO

insert into GXDBVersions values(2, 'MMS2GetSpareGroupsByLibraryOrDrivePool',  '00010002029400020000', 'MMS2GetSpareGroupsByLibraryOrDrivePool', '00010002029400020000')
GO

