

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GetSpareGroupForBarCode.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2015  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2GetSpareGroupForBarCode <<<'

IF EXISTS (select * from sysobjects where name='MMS2GetSpareGroupForBarCode')
	drop procedure MMS2GetSpareGroupForBarCode
IF EXISTS (select * from GxQscripts where name='MMS2GetSpareGroupForBarCode')
	delete from GxQscripts where name = 'MMS2GetSpareGroupForBarCode'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetSpareGroupForBarCode')
	delete from GXDBVersions where aliasname = 'MMS2GetSpareGroupForBarCode'
GO
print '... Creating Procedure: MMS2GetSpareGroupForBarCode'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2GetSpareGroupForBarCode
  @i_mediaId INT
AS
  DECLARE @o_spareGroupId INT = -1
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @l_spareGroupId INT = 0
DECLARE @l_patternId INT = 0
DECLARE @l_matches INT = 0
DECLARE @l_barCode varchar(255)
DECLARE	@l_libraryId INT = 0
IF OBJECT_ID('tempdb..#tmpBarCodePatternsForSpareGp') IS NOT NULL
    DROP TABLE #tmpBarCodePatternsForSpareGp
CREATE TABLE #tmpBarCodePatternsForSpareGp
	(spareGroupId					integer,
	patternId						integer,
	patternParamBeginsWith			varchar(255),
	patternParamEndsWith			varchar(255),
	patternParamContains			varchar(255),
	patternParamExcludes			varchar(255),
	patternParamRangeFrom			varchar(255),
	patternParamRangeTo				varchar(255),
	patternParamExcludeRangeFrom	varchar(255),
	patternParamExcludeRangeTo		varchar(255))
SELECT  @l_barCode = BarCode, @l_libraryId = LibraryId
FROM	MMMedia
WHERE	MediaId = @i_mediaId
IF(@l_barCode IS NOT NULL)
BEGIN
	INSERT INTO #tmpBarCodePatternsForSpareGp
	SELECT SPAREGP.spareGroupId, SPAREGP.patternId, PATTERN.patternBeginsWith, PATTERN.patternEndsWith, PATTERN.patternContains,
			PATTERN.patternExcludes, PATTERN.patternRangeFrom, PATTERN.patternRangeTo, PATTERN.patternExcludesRangeFrom,PATTERN.patternExcludesRangeTo
	FROM
		(SELECT	MMS.SpareGroupId as spareGroupId, MMSGP.PatternId as patternId
			FROM	MMSpareGroup MMS WITH(READUNCOMMITTED)
			JOIN	MMSpareGroupToPatterns MMSGP WITH(READUNCOMMITTED)	ON MMS.SpareGroupId = MMSGP.SpareGroupId
			WHERE	MMS.LibraryId = @l_libraryId) SPAREGP
		JOIN
		(SELECT  PrimPattern.PatternId, PrimPattern.patternBeginsWith, PrimPattern.patternEndsWith, PrimPattern.patternContains, PrimPattern.patternExcludes,
				PrimPattern.patternRangeFrom, AuxPattern.patternRangeTo,	PrimPattern.patternExcludesRangeFrom, AuxPattern.patternExcludesRangeTo
		FROM
			(SELECT PatternId, [1] as patternBeginsWith, [2] as patternEndsWith, [4] as patternContains, [8] as patternExcludes,
					[16] as patternRangeFrom, [32] as patternExcludesRangeFrom FROM
					(SELECT PatternId, PatternType, Pattern FROM MMBarCodePatternConditions WITH(READUNCOMMITTED)) as TEMP1
					PIVOT(MAX([Pattern]) FOR [PatternType] in ([1],[2],[4],[8],[16],[32])) as PIV1
			)AS PrimPattern
			JOIN
			(SELECT PatternId, [16] as patternRangeTo, [32] as patternExcludesRangeTo FROM
				(SELECT PatternId, PatternType, PatternAuxParam FROM MMBarCodePatternConditions WITH(READUNCOMMITTED)) as TEMP2
				PIVOT(MAX(PatternAuxParam) FOR [PatternType] in ([16],[32])) as PIV2
			) AS AuxPattern
			ON PrimPattern.PatternId = AuxPattern.PatternId) PATTERN
	ON SPAREGP.PatternId = PATTERN.PatternId
	DECLARE SPARE_GP_CURSOR CURSOR FOR
	SELECT	spareGroupId, patternId
	FROM	#tmpBarCodePatternsForSpareGp
	OPEN	SPARE_GP_CURSOR
	FETCH 	NEXT FROM	SPARE_GP_CURSOR
	INTO	@l_spareGroupId, @l_patternId
	WHILE	@@FETCH_STATUS = 0
	BEGIN
		SELECT @l_matches =
		(CASE WHEN patternParamBeginsWith 		IS NULL or @l_barCode like patternParamBeginsWith + '%' 										THEN 1 ELSE 0 END) +
		(CASE WHEN patternParamEndsWith 		IS NULL or @l_barCode like '%' +  patternParamEndsWith 										THEN 1 ELSE 0 END) +
		(CASE WHEN patternParamContains 		IS NULL or @l_barCode like '%' +  patternParamContains + '%' 									THEN 1 ELSE 0 END) +
		(CASE WHEN patternParamExcludes 		IS NULL or @l_barCode not like '%' +  patternParamExcludes + '%' 								THEN 1 ELSE 0 END) +
		(CASE WHEN patternParamRangeFrom 		IS NULL or @l_barCode between patternParamRangeFrom and patternParamRangeTo 					THEN 1 ELSE 0 END) +
		(CASE WHEN patternParamExcludeRangeFrom IS NULL or @l_barCode not between patternParamExcludeRangeFrom and patternParamExcludeRangeTo	THEN 1 ELSE 0 END)
		FROM #tmpBarCodePatternsForSpareGp
		WHERE spareGroupId = @l_spareGroupId AND patternId = @l_patternId
		IF @l_matches = 6
		BEGIN
			SET @o_spareGroupId = @l_spareGroupId
			BREAK
		END
		FETCH NEXT FROM	SPARE_GP_CURSOR
		INTO	@l_spareGroupId, @l_patternId
	END
END
SELECT @o_spareGroupId
DROP TABLE #tmpBarCodePatternsForSpareGp
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2GetSpareGroupForBarCode')
	delete from GxQscripts where name = 'MMS2GetSpareGroupForBarCode'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetSpareGroupForBarCode')
	delete from GXDBVersions where aliasname = 'MMS2GetSpareGroupForBarCode'
GO

insert into GXDBVersions values(2, 'MMS2GetSpareGroupForBarCode',  '00000000000000000000', 'MMS2GetSpareGroupForBarCode', '00000000000000000000')
GO

