

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GetShelfLibList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2GetShelfLibList.sp,v $ $Id: MMS2GetShelfLibList.sp,v 1.6.46.2 2018/03/20 20:05:43 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "MMS2getLibList"				|
--	|									|
--	| Execute the System stored procedure to fetch the physical files	|
--	| .. for the (current) database.					|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2GetShelfLibList <<<'

IF EXISTS (select * from sysobjects where name='MMS2GetShelfLibList')
	drop procedure MMS2GetShelfLibList
IF EXISTS (select * from GxQscripts where name='MMS2GetShelfLibList')
	delete from GxQscripts where name = 'MMS2GetShelfLibList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetShelfLibList')
	delete from GXDBVersions where aliasname = 'MMS2GetShelfLibList'
GO
print '... Creating Procedure: MMS2GetShelfLibList'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2GetShelfLibList
  @i_userId integer,
  @i_shelfId integer
AS
  DECLARE @o_LibraryId integer
  DECLARE @o_AliasName NVARCHAR(255)
  DECLARE @o_LibraryTypeId integer
  DECLARE @o_librarySoftState integer
  DECLARE @o_libraryEnabled integer
  DECLARE @o_libraryBroken integer
  DECLARE @o_libraryVendor char(255)
  DECLARE @o_libraryModel char(255)
  DECLARE @o_libraryAttribute integer
  DECLARE @o_libraryInstallTime integer
  DECLARE @o_libraryTotalNumMedia integer
  DECLARE @o_libraryDescription NVARCHAR(max)
----------------------------------------------
--------------- Security Check ---------------
----------------------------------------------
DECLARE @userId	INTEGER = @i_userId
DECLARE @secObjectType	INTEGER = 8180
IF object_id('tempdb.dbo.#tblSecObjForUser') is not null DROP TABLE #tblSecObjForUser
create table  #tblSecObjForUser ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
IF @userId > 0
BEGIN
	EXEC sec_getUserObjects @userId, @secObjectType, 0, '#tblSecObjForUser'
END
DECLARE @tblSecShelf table (vtShelfId int)
DECLARE @allVisible INTEGER = 0
IF EXISTS (SELECT * FROM #tblSecObjForUser sec WHERE (sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0))
	SET @allVisible = 1
ELSE
	INSERT INTO @tblSecShelf SELECT vtShelfId from #tblSecObjForUser
----------------------------------------------
		select ml.libraryid, ml.aliasname, ml.librarytypeid, ml.LibrarySoftState, ml.LibraryEnabled,
		ml.LibraryBroken, ml.LibraryVendor, ml.LibraryModel, ml.LibraryAttribute, ml.LibraryInstallTime,
		(select count(*) from MMMedia where MMMedia.libraryid = ml.libraryId),isnull(ml.descript, N'')
		from MMLibrary as ml
		where libraryid > 0 and libraryTypeId = 8
		and (@i_shelfId > 0 and libraryid = @i_shelfId or @i_shelfId = 0)
		and (@allVisible > 0 or libraryId in (select vtShelfId from @tblSecShelf))
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2GetShelfLibList')
	delete from GxQscripts where name = 'MMS2GetShelfLibList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetShelfLibList')
	delete from GXDBVersions where aliasname = 'MMS2GetShelfLibList'
GO

insert into GXDBVersions values(2, 'MMS2GetShelfLibList',  '00010006004600020000', 'MMS2GetShelfLibList', '00010006004600020000')
GO

