

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GetSharedStVolumeRecycleInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2GetSharedStVolumeRecycleInfo.sp,v $ $Id: MMS2GetSharedStVolumeRecycleInfo.sp,v 1.49.2.23 2020/10/16 16:43:18 prasanthm Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 						Cursor: "MMS2GetSharedStVolumeRecycleInfo"								|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMS2GetSharedStVolumeRecycleInfo')
BEGIN
	print '>>> Drop Stored Procedure: MMS2GetSharedStVolumeRecycleInfo <<<'
	drop procedure MMS2GetSharedStVolumeRecycleInfo
END
IF EXISTS (select * from GxQscripts where name='MMS2GetSharedStVolumeRecycleInfo')
	delete from GxQscripts where name = 'MMS2GetSharedStVolumeRecycleInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetSharedStVolumeRecycleInfo')
	delete from GXDBVersions where aliasname = 'MMS2GetSharedStVolumeRecycleInfo'
GO
print '... Creating Procedure: MMS2GetSharedStVolumeRecycleInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MMS2GetSharedStVolumeRecycleInfo
-- The following two lines indicate, in order, parameters that will be
--  expected in the "setValues()" method, as well as the order in which
--  they will be provided as arguments to the SQLSTRING command
  @i_MountPathType1 integer,
  @i_MountPathType2 integer,
  @i_storeIds xml
AS
--	The next few lines are the columns, in order, that will be in the
--  result set for this cursor.  EXTREME CAUTION must be exercised to
--  ensure that these match up with the result set in terms of type, size,
--  and order!
  DECLARE @o_VolumeId integer
  DECLARE @o_VolumeName varchar(112)
  DECLARE @o_OMLVersion integer
  DECLARE @o_HostId integer
  DECLARE @o_MountPathId integer
  DECLARE @o_MountPathName NVARCHAR(1024)
  DECLARE @o_MountPathTypeId integer
  DECLARE @o_UserName varchar(1024)
  DECLARE @o_Password varchar(2048)
  DECLARE @o_Folder varchar(1024)
  DECLARE @o_SIDBStoreId integer
  DECLARE @o_VolOrigCCId integer
-- These lines represent the actual SQL code that will get executed.  Note
-- The "printf" style substitutions.  These should match up exactly with
-- :PARAM input lines
--This will turn off message: "xxx rows affected".
	SET NOCOUNT ON
	declare @MOUNT_PATH_MAGNETIC		integer
	declare @MOUNT_PATH_CENTERA			integer
	declare @MOUNT_PATH_DYNAMIC_SHARED	integer
	declare @MOUNT_PATH_TAPE			integer
	declare @MOUNT_PATH_SHARED_STATIC	integer
	declare @MOUNT_PATH_SHARED_REPLICA	integer
	declare @MOUNT_PATH_DRU				integer
	declare @MOUNT_PATH_EXTERNAL_REMOTE_HOST	integer
	set @MOUNT_PATH_MAGNETIC			=	0
	set @MOUNT_PATH_CENTERA				=	1
	set @MOUNT_PATH_DYNAMIC_SHARED		=	2
	set @MOUNT_PATH_TAPE				=	3
	set @MOUNT_PATH_SHARED_STATIC		=	4
	set @MOUNT_PATH_SHARED_REPLICA		=	5
	set @MOUNT_PATH_DRU					=	6
	set @MOUNT_PATH_EXTERNAL_REMOTE_HOST	=	7
	declare @zeroRefDDBs table (SIDBStoreId int)
	declare @zeroRefDDBToMP table (SIDBStoreId int, VolId int, mountPathId int)
	CREATE TABLE #tempVolList(
		volumeId 	INT,
volumeName 	varchar(112),
		OMLVersion		INT,
		HostId	INT,
		DeviceId	INT,
		MountPathId 	INT,
MountPathName nvarchar(1024),
		MountPathTypeId INT,
UserName varchar(1024),
Password varchar (2048),
Folder varchar (1024),
		SIDBStoreId		INT,
		VolOrigCCId		INT,
		VolAttributes INT,
		FailureErrorCode INT,
		MPAttribute	INT,
		CopyId INT,
		IsAgedStore INT,
		dc              INT,
		NewId		binary(6)
	)
	CREATE UNIQUE INDEX IX_tempVolList_VolumeId ON #tempVolList(VolumeId) WITH (IGNORE_DUP_KEY = ON)
	CREATE TABLE #tmpUniqueMountPaths
	(
		MountPathId INT,
		MediaSideId INT,
		MPAttribute INT
	)
	CREATE UNIQUE INDEX IX_tmpUniqueMountPaths_mediaSideId ON #tmpUniqueMountPaths(MediaSideId)
	if object_id('tempdb.dbo.#tempHybridMPList') is not null DROP TABLE #tempHybridMPList
	CREATE TABLE #tempHybridMPList(
		MountPathId	INT
	)
	DECLARE @tblStoresToPrune TABLE (SIDBStoreId INTEGER, commCellId INTEGER, StoreFlags INTEGER)
	DECLARE @recyclableVolCount INT = 0
SET @recyclableVolCount = ISNULL((SELECT value FROM MMConfigs WITH (READUNCOMMITTED) WHERE name = 'MMCONFIG_RECYCLABLE_VOLUME_FOR_PRUNING_COUNT'), 50000)
	DECLARE @storeBatchPruning INT = ISNULL((SELECT value from MMConfigs WHERE name = 'MMCONFIG_STORE_BATCH_PRUNING_OPTION'), 0)
	DECLARE @maxAllowedMAs INT = ISNULL((SELECT value from MMConfigs WHERE name = 'MMCONFIG_MAX_NUMBER_OF_MAS_TO_USE_FOR_PRUNING'), 0)
	IF @maxAllowedMAs = 0
		SET @maxAllowedMAs = 2147483647 /*MAX INT Don't limit*/
INSERT INTO #tmpUniqueMountPaths
SELECT DISTINCT MountPathId, MediaSideId, MPAttribute
FROM MMMountPathOnlineStatus WITH (READUNCOMMITTED)
WHERE MountPathTypeId IN (@i_MountPathType1, @i_MountPathType2)
	IF (@i_MountPathType1 = @MOUNT_PATH_EXTERNAL_REMOTE_HOST)
	BEGIN
		INSERT INTO #tempHybridMPList
		SELECT DISTINCT MP.MountPathId
		FROM MMMountPathOnlineStatus MP WITH (READUNCOMMITTED)
WHERE (MP.MPAttribute & 2048) > 0
	END
	IF (@storeBatchPruning > 0)
	BEGIN
			INSERT INTO @tblStoresToPrune
			SELECT  T.c.value('@StoreId', 'int'), 0, 0
			FROM    @i_storeIds.nodes('/r/h') T(c)
			IF EXISTS (SELECT 1 FROM @tblStoresToPrune)
			BEGIN
				UPDATE T
				SET T.commCellId = M.commCellId,
				T.StoreFlags = M.StoreFlags
				FROM @tblStoresToPrune T, MMDataToPruneForDDB M WITH (READUNCOMMITTED)
				WHERE T.SIDBStoreId = M.SIDBStoreId
				INSERT	INTO #tempVolList
				SELECT	TOP(@recyclableVolCount) V.VolumeId, V.VolumeName, V.OMLVersion, 0, 0, MP.MountPathId,'', 0, '', '', '',
V.SIDBStoreId, V.origCCcommCellID, V.Attributes, V.FailureErrorCode, MP.MPAttribute, ISNULL(ASR.ArchGroupCopyId, 0), STORE.flags & 256, 0, CAST(NEWID() AS binary(6))
				FROM		MMVolume V (READUNCOMMITTED) INNER JOIN #tmpUniqueMountPaths MP ON V.MediaSideId = MP.MediaSideId
					INNER JOIN @tblStoresToPrune S
					ON V.SIDBStoreId = S.SIDBStoreId AND V.SIDBStoreId > 0
					INNER JOIN IdxSIDBStore STORE WITH (READUNCOMMITTED) ON S.SIDBStoreId = STORE.SIDBStoreId
					LEFT OUTER JOIN ArchStream ASR WITH (READUNCOMMITTED) ON ASR.MediaGroupId = V.MediaGroupId
				WHERE		V.VolumeFlags = 6 AND NOT (
					-- Pruning is allowed for migrated commcells also
(STORE.CommCellId <> 2 AND (STORE.flags & 256/* 256 */) = 0)
					OR
					(
( (STORE.flags & 256/* 256 */) = 0 AND STORE.Status = 1 /* 1 */)
						OR
( (V.Attributes & 4) > 0 AND (STORE.flags & 256/* 256 */) = 0)
						OR
( (STORE.Flags & 2097152) > 0)
						OR
( (STORE.Flags & 536870912) = 0 AND (EXISTS (SELECT CopyId FROM archCopySIDBStore WHERE SIDBStoreId = STORE.SIDBStoreId)) )
						)
					)
				ORDER BY ABS(V.FailureErrorCode) ASC
				-- Work on Zeroref for only the stores which are being worked on.
				--Check if there are some stores with zeroref count set. If so send them a prunable vol request to trigger pruning.
				INSERT INTO @zeroRefDDBs
				SELECT distinct I.SIDBStoreId
				FROM @tblStoresToPrune TS, IdxSIDBStore I WITH (READUNCOMMITTED),
					(SELECT UT.SIDBStoreId, max(ModifiedTime) as ModifiedTime
					 FROM IdxSIDBUsageHistory UT WITH (READUNCOMMITTED), @tblStoresToPrune TT
					 WHERE UT.SIDBStoreId = TT.SIDBStoreId
					 GROUP BY UT.SIDBStoreId, UT.SubStoreId) T
					INNER JOIN IdxSIDBUsageHistory U ON T.SIDBStoreId = U.SIDBStoreId AND T.ModifiedTime = U.ModifiedTime
				WHERE I.commCellId = 2
				AND I.SIDBStoreId = T.SIDBStoreId
				AND I.SIDBStoreId = TS.SIDBStoreId
AND I.flags & 256 = 0
				AND I.Status <> 1
AND I.flags & 2097152 = 0
				AND U.ZeroRefCount > 0
AND I.flags & 536870912 > 0
				--Pick any one volume associated to this store with VolFlags = 6. We'll send that vol for pruning to MA to trigger zeroref pruning on sidb.
				;WITH VolPicker (SIDBStoreId, VolId, MPId, rn)
				AS
				(
				SELECT D.SIDBStoreId, V.VolumeId, MP.MountPathId, row_number() over (partition by D.SIDBStoreId, MP.MountPathId ORDER BY V.VolumeId) as rn
					FROM @zeroRefDDBs D, MMVolume V WITH (READUNCOMMITTED), #tmpUniqueMountPaths MP WITH (READUNCOMMITTED)
					WHERE D.SIDBStoreId = V.SIDBStoreId
					AND V.MediaSideId = MP.MediaSideId
					AND V.VolumeFlags = 6
				)
				INSERT INTO @zeroRefDDBToMP
				SELECT distinct T.SIDBStoreId, P.VolId, P.MPId
				FROM @zeroRefDDBs T, VolPicker P
				WHERE T.SIDBStoreId = P.SIDBStoreId
				AND P.rn = 1
			END
			ELSE -- non dedup
			BEGIN
				INSERT	INTO #tempVolList
				SELECT	TOP(@recyclableVolCount) V.VolumeId, V.VolumeName, V.OMLVersion, 0, 0, MP.MountPathId,
						'', 0, '', '', '', V.SIDBStoreId, V.origCCcommCellID, V.Attributes, V.FailureErrorCode, MP.MPAttribute, ISNULL(ASR.ArchGroupCopyId, 0), 0, 0, CAST(NEWID() AS binary(6))
				FROM		MMVolume V (READUNCOMMITTED) INNER JOIN #tmpUniqueMountPaths MP ON V.MediaSideId = MP.MediaSideId
							LEFT OUTER JOIN ArchStream ASR WITH (READUNCOMMITTED) ON ASR.MediaGroupId = V.MediaGroupId
				WHERE		V.VolumeFlags = 6 AND V.SIDBStoreId = 0
				ORDER BY ABS(V.FailureErrorCode) ASC
			END
	END
	ELSE
	BEGIN
		--Check if there are some stores with zeroref count set. If so send them a prunable vol request to trigger pruning.
		INSERT INTO @zeroRefDDBs
		SELECT distinct I.SIDBStoreId
		FROM IdxSIDBStore I WITH (READUNCOMMITTED)
			INNER JOIN archCopySIDBStore C WITH (READUNCOMMITTED) ON I.SIDBStoreId = C.SIDBStoreId
			INNER JOIN IdxSIDBSubStore SUB ON I.SIDBStoreId = SUB.SIDBStoreId,
			(SELECT SIDBStoreId, max(ModifiedTime) as ModifiedTime
			 FROM IdxSIDBUsageHistory WITH (READUNCOMMITTED)
			 GROUP BY SIDBStoreId, SubStoreId) T
			INNER JOIN IdxSIDBUsageHistory U ON T.SIDBStoreId = U.SIDBStoreId AND T.ModifiedTime = U.ModifiedTime
		WHERE I.commCellId = 2
		AND I.SIDBStoreId = T.SIDBStoreId
AND I.flags & 256 = 0
		AND I.Status <> 1
AND I.flags & 2097152 = 0
		AND U.ZeroRefCount > 0
AND I.flags & 536870912 > 0
AND (1 = dbo.IsOperationAllowed(131072,2,SUB.ClientId,0,0,0,0))
		--Pick any one volume associated to this store with VolFlags = 6. We'll send that vol for pruning to MA to trigger zeroref pruning on sidb.
		;WITH VolPicker (SIDBStoreId, VolId, MPId, rn)
		AS
		(
		SELECT D.SIDBStoreId, V.VolumeId, MP.MountPathId, row_number() over (partition by D.SIDBStoreId, MP.MountPathId ORDER BY V.VolumeId) as rn
			FROM @zeroRefDDBs D, MMVolume V WITH (READUNCOMMITTED), #tmpUniqueMountPaths MP WITH (READUNCOMMITTED)
			WHERE D.SIDBStoreId = V.SIDBStoreId
			AND V.MediaSideId = MP.MediaSideId
			AND V.VolumeFlags = 6
		)
		INSERT INTO @zeroRefDDBToMP
		SELECT distinct T.SIDBStoreId, P.VolId, P.MPId
		FROM @zeroRefDDBs T, VolPicker P
		WHERE T.SIDBStoreId = P.SIDBStoreId
		AND P.rn = 1
		INSERT	INTO #tempVolList
		SELECT	TOP(@recyclableVolCount) V.VolumeId, V.VolumeName, V.OMLVersion, 0, 0, MP.MountPathId,
				'', 0, '', '', '', V.SIDBStoreId, V.origCCcommCellID, V.Attributes, V.FailureErrorCode, MP.MPAttribute, ISNULL(ASR.ArchGroupCopyId, 0), 0, 0, CAST(NEWID() AS binary(6))
		FROM		MMVolume V (READUNCOMMITTED) INNER JOIN #tmpUniqueMountPaths MP ON V.MediaSideId = MP.MediaSideId
					LEFT OUTER JOIN ArchStream ASR WITH (READUNCOMMITTED) ON ASR.MediaGroupId = V.MediaGroupId
		WHERE		V.VolumeFlags = 6 AND V.SIDBStoreId = 0
		ORDER BY V.VolumeId desc
		INSERT	INTO #tempVolList
		SELECT	TOP(@recyclableVolCount) V.VolumeId, V.VolumeName, V.OMLVersion, 0, 0, MP.MountPathId,'', 0, '', '', '',
V.SIDBStoreId, V.origCCcommCellID, V.Attributes, V.FailureErrorCode, MP.MPAttribute, ISNULL(ASR.ArchGroupCopyId, 0), STORE.flags & 256, 0, CAST(NEWID() AS binary(6))
		FROM		MMVolume V (READUNCOMMITTED) INNER JOIN #tmpUniqueMountPaths MP ON V.MediaSideId = MP.MediaSideId
					INNER JOIN IdxSIDBStore STORE WITH (READUNCOMMITTED)
					ON V.SIDBStoreId = STORE.SIDBStoreId AND V.SIDBStoreId > 0
					LEFT OUTER JOIN ArchStream ASR WITH (READUNCOMMITTED) ON ASR.MediaGroupId = V.MediaGroupId
		WHERE		V.VolumeFlags = 6 AND NOT (
					-- Pruning is allowed for migrated commcells also
(STORE.CommCellId <> 2 AND (STORE.flags & 256/* 256 */) = 0)
					OR
					(
( (STORE.flags & 256/* 256 */) = 0 AND STORE.Status = 1 /* 1 */)
						OR
( (V.Attributes & 4) > 0 AND (STORE.flags & 256/* 256 */) = 0)
						OR
( (STORE.Flags & 2097152) > 0)
						OR
( (STORE.Flags & 536870912) = 0 AND (EXISTS (SELECT CopyId FROM archCopySIDBStore WHERE SIDBStoreId = STORE.SIDBStoreId)) )
					)
				)
			ORDER BY V.VolumeId desc
	END
--Create pruning records for stores with zeroRefCount > 0 so that it triggers pruning on those stores.
INSERT INTO #tempVolList
SELECT Z.VolId, 'V_DUMMY', 0, 0, 0, MP.MountPathId,
'', 0, '', '', '', Z.SIDBStoreId, 0, 0, 0, MP.MPAttribute, ACSS.CopyId, STORE.flags & 256, 0, CAST(NEWID() AS binary(6))
FROM	@zeroRefDDBToMP Z INNER JOIN #tmpUniqueMountPaths MP  ON MP.MountPathId = Z.mountPathId
			INNER JOIN IdxSIDBSTore STORE WITH(READUNCOMMITTED) ON Z.SIDBStoreId = STORE.SIDBStoreId
			INNER JOIN archCopySIDBStore ACSS WITH (READUNCOMMITTED) ON Z.SIDBStoreId = ACSS.SIDBStoreId
--In GDSP case it can be any copy id. All copies will have same datapaths
--UPDATE #tempVolList
--SET CopyId = ACSS.CopyId
--FROM #tempVolList Vol INNER JOIN ArchCopySIDBStore ACSS WITH(NOLOCK) ON Vol.SIDBStoreId = ACSS.SIDBStoreId
--WHERE VolumeId = 0
--
-- For Cloud mountpaths, we only do store-level pruning, so remove rows here that belong to SIDB stores that are not aged.
--
IF (@i_MountPathType1 = @MOUNT_PATH_EXTERNAL_REMOTE_HOST)
BEGIN
	DELETE #tempVolList
	FROM #tempVolList T, IdxSIDBStore STORE WITH (READUNCOMMITTED)
WHERE T.SIDBStoreId = STORE.SIDBStoreId AND (STORE.flags & 256/* 256 */) = 0
			AND T.SIDBStoreId > 0
AND (T.MPAttribute & 32) = 0
	-- Ignore the volumes which are Object-based Cloud Storage if there are some chunks in MMDeletedAF
	DELETE #tempVolList
	FROM #tempVolList T
		INNER JOIN MMMountPathToStorageDevice MSD WITH (READUNCOMMITTED) ON T.MountPathId = MSD.MountPathId
		INNER JOIN MMDevice D WITH (READUNCOMMITTED) ON MSD.DeviceId = D.DeviceId
		INNER JOIN MMDeletedAF DAF WITH (READUNCOMMITTED) ON T.MountPathId = DAF.MountPathId
	WHERE D.DeviceTypeId > 41 /* TYPE_SAN_MAGNETIC_REMOTE_HOST_OBJECT_BASE_START */
	AND D.DeviceTypeId < 60 /* TYPE_SAN_MAGNETIC_REMOTE_HOST_OBJECT_BASE_END */
	-- For hybrid cloud if the local device is not accessible or enabled then we need to drop the rows
	DELETE T
	FROM #tempVolList T
		INNER JOIN #tempHybridMPList HY WITH (READUNCOMMITTED) ON T.MountPathId = HY.MountPathId
		INNER JOIN MMCloudVolCacheMountPath VMP WITH (READUNCOMMITTED) ON T.VolumeId = VMP.VolumeId
		LEFT OUTER JOIN MMMountPathOnlineStatus MP WITH (READUNCOMMITTED) ON VMP.cacheMountPathId = MP.MountPathId
	WHERE MP.MountPathId IS NULL
END
ELSE IF (@i_MountPathType1 = @MOUNT_PATH_SHARED_STATIC)
BEGIN
	DELETE #tempVolList
	FROM #tempVolList T, IdxSIDBStore STORE WITH (READUNCOMMITTED)
WHERE T.SIDBStoreId = STORE.SIDBStoreId AND (STORE.flags & 256/* 256 */) = 0
			AND T.SIDBStoreId > 0
	AND T.MountPathTypeId = @MOUNT_PATH_SHARED_STATIC
AND (T.MPAttribute & 32768) = 0
END
DECLARE @tempCopyMPMap table (CopyId int, MountPathId int)
INSERT @tempCopyMPMap
SELECT DISTINCT CopyId, MountPathId FROM #tempVolList
-- Remove the volume that is referenced by chunk
DELETE #tempVolList
FROM	#tempVolList V, ArchChunk chunk WITH (NOLOCK)
WHERE	V.VolumeId = chunk.VolumeId
AND		(chunk.physicalSize > 0  OR chunk.logicalSize > 0)
AND		chunk.flags & 256 = 0
-- Remove the volume that is reserved
DELETE #tempVolList
FROM	#tempVolList V, MMResource res WITH (NOLOCK), MMResourceToJob restojob WITH (NOLOCK)
WHERE	V.VolumeId = res.VolumeId
AND		res.ReservationId = resToJob.ReservationId
IF(@i_MountPathType1 <> @MOUNT_PATH_EXTERNAL_REMOTE_HOST)
BEGIN
        --Set device controller based on data path settings
        WITH MAPicker (CopyId, MountPathId, rn, randorder)
        AS
        (
        	SELECT copyId, mountPathId, rn, row_number() over (partition by copyId, mountPathId order by NEWID()) as randorder FROM
        	(
	        	SELECT * FROM
	        	(
		            SELECT T.copyId, MP.mountPathId, MP.rn, dense_rank() over (partition by T.copyId, MP.mountPathId order by MP.HostId) as serialorder
		            FROM @tempCopyMPMap T
		            INNER JOIN MMDataPath DP WITH (READUNCOMMITTED) ON T.copyId = DP.copyId
		            INNER JOIN MMMountPathOnlineStatus MP WITH (READUNCOMMITTED) ON T.MountPathId = MP.MountPathId
		            INNER JOIN MMDrivePool DPOOL WITH (READUNCOMMITTED) ON DP.DrivePoolId = DPOOL.DrivePoolId AND MP.masterPoolId = DPOOL.MasterPoolId AND DPOOL.ClientId = MP.HostId
WHERE MP.MPAttribute & 256 > 0 AND DP.flag & (4 /*| MMS2_PREFERRED_PRUNER*/) = (4 /*| MMS2_PREFERRED_PRUNER*/)
			    	AND T.CopyId > 0
			    ) DT
			    WHERE serialorder <= @maxAllowedMAs
			) TEMP
        )
        UPDATE T1
        SET dc =  T2.rn
        FROM #tempVolList T1 INNER JOIN MAPicker T2 ON T1.CopyId = T2.CopyId AND T1.MountPathId = T2.MountPathId
        INNER JOIN (SELECT CopyId, MountPathId, MAX(randorder) maxRowNumber FROM MAPicker GROUP BY copyId, MountPathId) T3
        ON T1.CopyId = T3.CopyId AND T1.MountPathId = T3.MountPathId AND T2.randorder = ABS(T1.newid % T3.maxRowNumber) + 1 AND T1.dc = 0;
        --Set device controller NOT based on data path settings
        WITH MAPicker (CopyId, MountPathId, rn, randorder)
        AS
        (
        	SELECT copyId, mountPathId, rn, row_number() over (partition by copyId, mountPathId order by NEWID()) as randorder FROM
        	(
	        	SELECT * FROM
	        	(
		            SELECT T.copyId, MP.mountPathId, MP.rn, dense_rank() over (partition by T.copyId, MP.mountPathId order by MP.HostId) as serialorder
		            FROM @tempCopyMPMap T
		            INNER JOIN MMMountPathOnlineStatus MP WITH (READUNCOMMITTED) ON T.MountPathId = MP.MountPathId
WHERE MP.MPAttribute & 256 = 0 OR T.CopyId = 0
		        ) DT
		        WHERE serialorder <= @maxAllowedMAs
		    ) TEMP
        )
        UPDATE T1
        SET dc =  T2.rn
        FROM #tempVolList T1 INNER JOIN MAPicker T2 ON T1.CopyId = T2.CopyId AND T1.MountPathId = T2.MountPathId
        INNER JOIN (SELECT CopyId, MountPathId, MAX(randorder) maxRowNumber FROM MAPicker GROUP BY copyId, MountPathId) T3
        ON T1.CopyId = T3.CopyId AND T1.MountPathId = T3.MountPathId AND T2.randorder = ABS(T1.newid % T3.maxRowNumber) + 1 AND T1.dc = 0;
	UPDATE T
        SET HostId = MP.HostId,
        UserName = MP.UserName,
        Password = MP.UserPassword,
        Folder = MP.Folder,
        MountPathName = MP.MountPathName,
        MountPathTypeId = MP.MountPathTypeId,
        MPAttribute = MP.MPAttribute
        FROM #tempVolList T
            INNER JOIN MMMountPathOnlineStatus MP WITH (READUNCOMMITTED) ON T.MountPathId = MP.MountPathId AND T.dc = MP.rn
        WHERE T.HostId = 0
END
ELSE
BEGIN
    --Set device controller based on data path settings if granular pruning is enabled. For aged stores pruner MA flag need not be set
    WITH MAPicker (CopyId, MountPathId, rn, randorder, preferredCloud)
    AS
    (
    	SELECT copyId, mountPathId, rn, row_number() over (partition by copyId, mountPathId order by NEWID()) as randorder, preferredCloud FROM
    	(
	    	SELECT * FROM
	    	(
SELECT T.copyId, MP.mountPathId, MP.rn, dense_rank() over (partition by T.copyId, MP.mountPathId order by (DP.flag & 64) DESC, MP.HostId) as serialorder, (case when (DP.flag & 64) > 0 then 1 else 0 end) as preferredCloud
		        FROM @tempCopyMPMap T
		        INNER JOIN MMDataPath DP WITH (READUNCOMMITTED) ON T.copyId = DP.copyId
		        INNER JOIN MMMountPathOnlineStatus MP WITH (READUNCOMMITTED) ON T.MountPathId = MP.MountPathId
		        INNER JOIN MMDrivePool DPOOL WITH (READUNCOMMITTED) ON DP.DrivePoolId = DPOOL.DrivePoolId AND MP.masterPoolId = DPOOL.MasterPoolId AND DPOOL.ClientId = MP.HostId
WHERE MP.MPAttribute & 256 > 0
AND MP.MPAttribute & 32 > 0
AND DP.flag & (4) = (4)
		    ) DT
		    WHERE serialorder <= @maxAllowedMAs
		) TEMP
    )
    UPDATE T1
    SET dc =  T2.rn
    FROM #tempVolList T1 INNER JOIN MAPicker T2 ON T1.CopyId = T2.CopyId AND T1.MountPathId = T2.MountPathId
    INNER JOIN (SELECT CopyId, MountPathId, MAX(randorder) maxRowNumber FROM MAPicker GROUP BY copyId, MountPathId) T3
    ON T1.CopyId = T3.CopyId AND T1.MountPathId = T3.MountPathId
	AND ((T2.randorder = ABS(T1.newid % T3.maxRowNumber) + 1) AND (T1.IsAgedStore > 0)
		OR (T2.preferredCloud = 1 AND T1.IsAgedStore = 0));
    --Set device controller based on data path settings if granular pruning is not enabled
    WITH MAPicker (CopyId, MountPathId, rn, randorder)
    AS
    (
    	SELECT copyId, mountPathId, rn, row_number() over (partition by copyId, mountPathId order by NEWID()) as randorder FROM
    	(
	    	SELECT * FROM
	    	(
		        SELECT T.copyId, MP.mountPathId, MP.rn, dense_rank() over (partition by T.copyId, MP.mountPathId order by MP.HostId) as serialorder
		        FROM @tempCopyMPMap T
		        INNER JOIN MMDataPath DP WITH (READUNCOMMITTED) ON T.copyId = DP.copyId
		        INNER JOIN MMMountPathOnlineStatus MP WITH (READUNCOMMITTED) ON T.MountPathId = MP.MountPathId
		        INNER JOIN MMDrivePool DPOOL WITH (READUNCOMMITTED) ON DP.DrivePoolId = DPOOL.DrivePoolId AND MP.masterPoolId = DPOOL.MasterPoolId AND DPOOL.ClientId = MP.HostId
WHERE MP.MPAttribute & 256 > 0
AND MP.MPAttribute & 32 = 0
AND DP.flag & (/*MMS2_PREFERRED_PRUNER |*/ 4) = (/*MMS2_PREFERRED_PRUNER |*/ 4)
		    ) DT
	        WHERE serialorder <= @maxAllowedMAs
       	) TEMP
    )
    UPDATE T1
    SET dc =  T2.rn
    FROM #tempVolList T1 INNER JOIN MAPicker T2 ON T1.CopyId = T2.CopyId AND T1.MountPathId = T2.MountPathId
    INNER JOIN (SELECT CopyId, MountPathId, MAX(randorder) maxRowNumber FROM MAPicker GROUP BY copyId, MountPathId) T3
    ON T1.CopyId = T3.CopyId AND T1.MountPathId = T3.MountPathId AND T2.randorder = ABS(T1.newid % T3.maxRowNumber) + 1;
    --Set device controller not based on data path settings  if granular pruning is enabled or not enabled
    WITH MAPicker (CopyId, MountPathId, rn, randorder, preferredCloud)
    AS
    (
    	SELECT copyId, mountPathId, rn, row_number() over (partition by copyId, mountPathId order by NEWID()) as randorder, preferredCloud FROM
    	(
	    	SELECT * FROM
	    	(
SELECT T.copyId, MP.mountPathId, MP.rn, dense_rank() over (partition by T.copyId, MP.mountPathId order by (MP.DeviceControllerFlags & 1) DESC, MP.HostId) as serialorder, (case when (MP.DeviceControllerFlags & 1) > 0 then 1 else 0 end) as preferredCloud
		        FROM @tempCopyMPMap T
		        INNER JOIN MMMountPathOnlineStatus MP WITH (READUNCOMMITTED) ON T.MountPathId = MP.MountPathId
WHERE MP.MPAttribute & 256 = 0  OR T.CopyId = 0
		    ) DT
		    WHERE serialorder <= @maxAllowedMAs
		) TEMP
    )
    UPDATE T1
    SET dc =  T2.rn
    FROM #tempVolList T1 INNER JOIN MAPicker T2 ON T1.CopyId = T2.CopyId AND T1.MountPathId = T2.MountPathId
    INNER JOIN (SELECT CopyId, MountPathId, MAX(randorder) maxRowNumber FROM MAPicker GROUP BY copyId, MountPathId) T3
    ON T1.CopyId = T3.CopyId AND T1.MountPathId = T3.MountPathId
	AND ((T2.randorder = ABS(T1.newid % T3.maxRowNumber) + 1 AND T1.IsAgedStore > 0)
	OR (T2.preferredCloud = 1 AND T1.IsAgedStore = 0));
	UPDATE T
        SET HostId = MP.HostId,
        UserName = MP.UserName,
        Password = MP.UserPassword,
        Folder = MP.Folder,
        MountPathName = MP.MountPathName,
        MountPathTypeId = MP.MountPathTypeId,
        MPAttribute = MP.MPAttribute
        FROM #tempVolList T
            INNER JOIN MMMountPathOnlineStatus MP WITH (READUNCOMMITTED) ON T.MountPathId = MP.MountPathId AND T.dc = MP.rn
        WHERE T.HostId = 0
END
SELECT 		T.volumeId, T.volumeName, T.OMLVersion, T.HostId, T.MountPathId,
			T.MountPathName, T.MountPathTypeId, T.UserName, T.Password, T.Folder, T.SIDBStoreId, T.VolOrigCCId
FROM			#tempVolList as T WHERE T.HostId > 0
ORDER BY		T.FailureErrorCode, T.HostId, T.MountPathId
DROP TABLE #tempVolList
DROP TABLE #tmpUniqueMountPaths
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2GetSharedStVolumeRecycleInfo')
	delete from GxQscripts where name = 'MMS2GetSharedStVolumeRecycleInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetSharedStVolumeRecycleInfo')
	delete from GXDBVersions where aliasname = 'MMS2GetSharedStVolumeRecycleInfo'
GO

insert into GXDBVersions values(2, 'MMS2GetSharedStVolumeRecycleInfo',  '00010049000200230000', 'MMS2GetSharedStVolumeRecycleInfo', '00010049000200230000')
GO

