

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GetSharedStVolumeInfoForDeletedAF.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2GetSharedStVolumeInfoForDeletedAF.sp,v $ $Id: MMS2GetSharedStVolumeInfoForDeletedAF.sp,v 1.64.2.34 2020/10/16 16:43:15 prasanthm Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 						Cursor: "MMS2GetSharedStVolumeInfoForDeletedAF"		|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMS2GetSharedStVolumeInfoForDeletedAF')
BEGIN
	print '>>> Drop Stored Procedure: MMS2GetSharedStVolumeInfoForDeletedAF <<<'
	drop procedure MMS2GetSharedStVolumeInfoForDeletedAF
END
IF EXISTS (select * from GxQscripts where name='MMS2GetSharedStVolumeInfoForDeletedAF')
	delete from GxQscripts where name = 'MMS2GetSharedStVolumeInfoForDeletedAF'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetSharedStVolumeInfoForDeletedAF')
	delete from GXDBVersions where aliasname = 'MMS2GetSharedStVolumeInfoForDeletedAF'
GO
print '... Creating Procedure: MMS2GetSharedStVolumeInfoForDeletedAF'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MMS2GetSharedStVolumeInfoForDeletedAF
-- The following two lines indicate, in order, parameters that will be
--  expected in the "setValues()" method, as well as the order in which
--  they will be provided as arguments to the SQLSTRING command
  @i_MountPathType1 integer,
  @i_MountPathType2 integer,
  @i_storeIds xml
AS
--	The next few lines are the columns, in order, that will be in the
--  result set for this cursor.  EXTREME CAUTION must be exercised to
--  ensure that these match up with the result set in terms of type, size,
--  and order!
  DECLARE @o_VolumeId integer
  DECLARE @o_VolumeName varchar(112)
  DECLARE @o_OMLVersion integer
  DECLARE @o_AFileId integer
  DECLARE @o_ArchChunkId bigint
  DECLARE @o_HostId integer
  DECLARE @o_cclip varchar(255)
  DECLARE @o_MountPathId integer
  DECLARE @o_MountPathName NVARCHAR(1024)
  DECLARE @o_MountPathTypeId integer
  DECLARE @o_UserName varchar(1024)
  DECLARE @o_Password varchar(2048)
  DECLARE @o_Folder varchar(1024)
  DECLARE @o_SIDBStoreId integer
  DECLARE @o_CommCellId integer
  DECLARE @o_sidbPruningFlag integer
  DECLARE @o_subStoreBitField integer
-- These lines represent the actual SQL code that will get executed.  Note
-- The "printf" style substitutions.  These should match up exactly with
-- :PARAM input lines
--This will turn off message: "xxx rows affected".
	SET NOCOUNT ON
	if object_id('tempdb.dbo.#tempVolAFList') is not null DROP TABLE #tempVolAFList
	CREATE TABLE #tempVolAFList(
		volumeId		INT,
volumeName		varchar(112),
		OMLVersion		INT,
		AFileId			INT,
		ArchChunkId		BIGINT,
		HostId			INT,
cclip			varchar(255),
		DeviceId		INT,
		MountPathId		INT,
MountPathName	nvarchar(1024),
		MountPathTypeId	INT,
UserName		varchar(1024),
Password		varchar(2048),
Folder			varchar(1024),
		SIDBStoreId		INT,
		commCellId		INT,
		sidbPruningFlag INT,
		subStoreBitField	INT,
		rn			INT,
		chunkCommCellId INT,
		copyId			INT,
		dc				INT,
		MPAttribute		INT,
		NewId			binary(6)
	)
	if object_id('tempdb.dbo.#tempHybridMPList') is not null DROP TABLE #tempHybridMPList
	CREATE TABLE #tempHybridMPList(
		MountPathId	INT
	)
	DECLARE @tblStoresToPrune TABLE (SIDBStoreId INTEGER)
	CREATE INDEX IX_tempAFList_MountPathId ON #tempVolAFList(MountPathId)
	CREATE INDEX IX_tempAFList_AFileId ON #tempVolAFList(AFileId)
	declare @MOUNT_PATH_MAGNETIC		integer
	declare @MOUNT_PATH_CENTERA			integer
	declare @MOUNT_PATH_DYNAMIC_SHARED	integer
	declare @MOUNT_PATH_TAPE			integer
	declare @MOUNT_PATH_SHARED_STATIC	integer
	declare @MOUNT_PATH_SHARED_REPLICA	integer
	declare @MOUNT_PATH_DRU				integer
	declare @MOUNT_PATH_EXTERNAL_REMOTE_HOST	integer
	set @MOUNT_PATH_MAGNETIC			=	0
	set @MOUNT_PATH_CENTERA				=	1
	set @MOUNT_PATH_DYNAMIC_SHARED		=	2
	set @MOUNT_PATH_TAPE				=	3
	set @MOUNT_PATH_SHARED_STATIC		=	4
	set @MOUNT_PATH_SHARED_REPLICA		=	5
	set @MOUNT_PATH_DRU					=	6
	set @MOUNT_PATH_EXTERNAL_REMOTE_HOST	=	7
	DECLARE @batchCount INT = ISNULL((SELECT value from MMConfigs WHERE name = 'MMS2_CONFIG_DEDUP_PRUNE_BATCH_SIZE'), 0)
	DECLARE @NonDedupBatchCount INT = ISNULL((SELECT value from MMConfigs WHERE name = 'MMS2_CONFIG_NON_DEDUP_PRUNE_BATCH_SIZE'), 0)
	DECLARE @storeBatchPruning INT = ISNULL((SELECT value from MMConfigs WHERE name = 'MMCONFIG_STORE_BATCH_PRUNING_OPTION'), 0)
	IF (@i_MountPathType1 = @MOUNT_PATH_EXTERNAL_REMOTE_HOST)
	BEGIN
		INSERT INTO #tempHybridMPList
		SELECT DISTINCT MP.MountPathId
		FROM MMMountPathOnlineStatus MP WITH (READUNCOMMITTED)
WHERE (MP.MPAttribute & 2048) > 0
	END
	DECLARE @maxAllowedMAs INT = ISNULL((SELECT value from MMConfigs WHERE name = 'MMCONFIG_MAX_NUMBER_OF_MAS_TO_USE_FOR_PRUNING'), 0)
	IF @maxAllowedMAs = 0
		SET @maxAllowedMAs = 2147483647 /*MAX INT Don't limit*/
	--Insert the volumes to prune first
	-- Calculating the dense rank would give ranking to all the unique AFs within a store. For chunks belonging to same AF, same rank would be given.
	-- Once we get rank, then its only a matter of removing the rows which have larger rank than the batch size.
	IF (@storeBatchPruning > 0)
	BEGIN
			INSERT INTO @tblStoresToPrune
			SELECT  T.c.value('@StoreId', 'int')
			FROM    @i_storeIds.nodes('/r/h') T(c)
			-- Clean up stores which are marked as isVolRecycle=1. Those stores were not picked for granular.
			DELETE T
			FROM @tblStoresToPrune T
				INNER JOIN MMDataToPruneForDDB D ON T.SIDBStoreId = D.SIDBStoreId
			WHERE D.isVolRecycle = 1
			IF EXISTS (SELECT 1 FROM @tblStoresToPrune)
			BEGIN
				;WITH RowPicker (volumeId, volumeName, OMLVersion, AFileId, ArchChunkId, HostId, cclip, DeviceId, MountPathId, MountPathName, MountPathTypeId, UserName, Password, Folder, SIDBStoreId, commCellId, sidbPruningFlag,
							subStoreBitField, rn, chunkCommCellId, copyId, dc, MPAttribute,	NewId)
				AS
				(
					SELECT DISTINCT DAF.VolumeId, '', 0, DAF.archFileId, DAF.ArchChunkId, 0, DAF.cclip,0, DAF.MountPathId, '', 0, '', '', '', DAF.SIDBStoreId, DAF.commCellId, DAF.sidbPruningFlag, DAF.subStoreBitField,
								DENSE_RANK() OVER (PARTITION BY DAF.SIDBStoreId ORDER BY ABS(DAF.FailureErrorCode) desc, (DAF.Status & 2) desc, DAF.archFileId asc), chunkCommCellId,
							DAF.copyId, 0,0,
							CAST(NEWID() AS binary(6))
					FROM MMDeletedAF DAF WITH (READUNCOMMITTED)
								INNER JOIN @tblStoresToPrune T ON T.SIDBStoreId = DAF.SIDBStoreId
								 INNER JOIN (SELECT DISTINCT MountPathId FROM MMMountPathOnlineStatus WITH (READUNCOMMITTED) WHERE MountPathTypeId IN (@i_MountPathType1, @i_MountPathType2)) MP ON DAF.MountPathId = MP.MountPathId --This is to make sure we get only volumes of eligible mount paths/types
					WHERE		(DAF.archFileId > 0 OR DAF.ArchChunkId > 0)
				)
				INSERT INTO #tempVolAFList
				SELECT *
				FROM RowPicker P
				WHERE (P.rn < @batchCount AND @batchCount > 0) OR (@batchCount = 0)
			    	-- insert rows so that AFs with chunkId/volId/MPId = 0 will be processed. Just insert it with MPId here. Below logic will take care of finding MA for the MP.
				;WITH RowPickerAFPruning (volumeId, volumeName, OMLVersion, AFileId, ArchChunkId, HostId, cclip, DeviceId, MountPathId, MountPathName, MountPathTypeId, UserName, Password, Folder, SIDBStoreId, commCellId, sidbPruningFlag,
							subStoreBitField, rn, chunkCommCellId, copyId, dc, MPAttribute,	NewId)
				AS
				(
					SELECT DAF.VolumeId, '', 0, DAF.archFileId, DAF.ArchChunkId, 0, DAF.cclip, 0, M.MountPathId,
					'', 4/*MOUNT_PATH_SHARED_STATIC*/, '', '', '', DAF.SIDBStoreId, DAF.commcellId, DAF.sidbPruningFlag, DAF.subStoreBitField,
					DENSE_RANK() OVER (PARTITION BY DAF.SIDBStoreId ORDER BY ABS(DAF.FailureErrorCode) desc, (DAF.Status & 2) desc, DAF.archFileId asc), DAF.chunkCommCellId,
					CASE WHEN DAF.copyId > 0 THEN DAF.copyId ELSE AGC.id END, 0, 0, CAST(NEWID() AS binary(6))
					FROM MMDeletedAF DAF WITH (READUNCOMMITTED)
						INNER JOIN @tblStoresToPrune T ON T.SIDBStoreId = DAF.SIDBStoreId
						INNER JOIN archCopySIDBStore ACS WITH (READUNCOMMITTED) ON DAF.SIDBStoreId = ACS.SIDBStoreId
						INNER JOIN archGroupCopy AGC WITH (READUNCOMMITTED) ON ACS.copyId = AGC.id
						INNER JOIN MMDataPath D WITH (READUNCOMMITTED) ON ACS.CopyId = D.CopyId
						INNER JOIN MMDrivePool DP WITH (READUNCOMMITTED) ON D.DrivePoolId = DP.DrivePoolId
						INNER JOIN (SELECT MP.MasterPoolId, MIN(MP.MountPathId) AS MountPathId
							FROM MMMountPath MP WITH (READUNCOMMITTED)
							INNER JOIN MMMountPathOnlineStatus MS ON MP.MountPathId = MS.MountPathId
						WHERE MP.MountPathTypeId IN (@i_MountPathType1, @i_MountPathType2)
						GROUP BY MP.MasterPoolId) AS M ON DP.MasterPoolId = M.MasterPoolId
					WHERE  DAF.MountPathId = 0
					AND DAF.ArchChunkId = 0
					AND DAF.SIDBStoreId > 0 AND DAF.archFileId > 0
AND AGC.dedupeFlags & 134217728 = 0
AND D.flag & 1 = 1
				)
				INSERT INTO #tempVolAFList
				SELECT *
				FROM RowPickerAFPruning P
				WHERE (P.rn < @batchCount AND @batchCount > 0) OR (@batchCount = 0)
			END
			ELSE -- non dedup
			BEGIN
				INSERT INTO #tempVolAFList
				SELECT TOP (@NonDedupBatchCount) DAF.VolumeId, '', 0, DAF.archFileId, DAF.ArchChunkId, 0, DAF.cclip,0, DAF.MountPathId, '', 0, '', '', '', DAF.SIDBStoreId, DAF.commCellId, DAF.sidbPruningFlag, DAF.subStoreBitField,
								0, chunkCommCellId,
								DAF.copyId, 0,0,
								CAST(NEWID() AS binary(6))
				FROM MMDeletedAF DAF WITH (READUNCOMMITTED)
					 INNER JOIN (SELECT DISTINCT MountPathId FROM MMMountPathOnlineStatus WITH (READUNCOMMITTED) WHERE MountPathTypeId IN (@i_MountPathType1, @i_MountPathType2)) MP ON DAF.MountPathId = MP.MountPathId --This is to make sure we get only volumes of eligible mount paths/types
				WHERE DAF.SIDBStoreId = 0
				AND (DAF.archFileId > 0 OR DAF.ArchChunkId > 0)
				ORDER BY ABS(DAF.FailureErrorCode) ASC
			END
	END
	ELSE
	BEGIN
		;WITH RowPicker (volumeId, volumeName, OMLVersion, AFileId, ArchChunkId, HostId, cclip, DeviceId, MountPathId, MountPathName, MountPathTypeId, UserName, Password, Folder, SIDBStoreId, commCellId, sidbPruningFlag,
					subStoreBitField, rn, chunkCommCellId, copyId, dc, MPAttribute,	NewId)
		AS
		(
			SELECT DISTINCT DAF.VolumeId, '', 0, DAF.archFileId, DAF.ArchChunkId, 0, DAF.cclip,0, DAF.MountPathId, '', 0, '', '', '', DAF.SIDBStoreId, DAF.commCellId, DAF.sidbPruningFlag, DAF.subStoreBitField,
						CASE WHEN DAF.SIDBStoreId > 0  THEN DENSE_RANK() OVER (PARTITION BY DAF.SIDBStoreId ORDER BY (DAF.Status & 2) desc, DAF.archFileId asc) ELSE 0 END, chunkCommCellId,
					DAF.copyId, 0,0,
					CAST(NEWID() AS binary(6))
			FROM MMDeletedAF DAF WITH (READUNCOMMITTED)
					 INNER JOIN (SELECT DISTINCT MountPathId FROM MMMountPathOnlineStatus WITH (READUNCOMMITTED) WHERE MountPathTypeId IN (@i_MountPathType1, @i_MountPathType2)) MP ON DAF.MountPathId = MP.MountPathId --This is to make sure we get only volumes of eligible mount paths/types
			WHERE		(DAF.archFileId > 0 OR DAF.ArchChunkId > 0)
		)
		INSERT INTO #tempVolAFList
		SELECT *
		FROM RowPicker P
		WHERE (P.rn < @batchCount
		AND @batchCount > 0 AND P.SIDBStoreId > 0) OR (@batchCount = 0) OR (P.SIDBStoreId = 0)
	    	-- insert rows so that AFs with chunkId/volId/MPId = 0 will be processed. Just insert it with MPId here. Below logic will take care of finding MA for the MP.
		;WITH RowPickerAFPruning (volumeId, volumeName, OMLVersion, AFileId, ArchChunkId, HostId, cclip, DeviceId, MountPathId, MountPathName, MountPathTypeId, UserName, Password, Folder, SIDBStoreId, commCellId, sidbPruningFlag,
					subStoreBitField, rn, chunkCommCellId, copyId, dc, MPAttribute,	NewId)
		AS
		(
			SELECT DAF.VolumeId, '', 0, DAF.archFileId, DAF.ArchChunkId, 0, DAF.cclip, 0, M.MountPathId,
			'', 4/*MOUNT_PATH_SHARED_STATIC*/, '', '', '', DAF.SIDBStoreId, DAF.commcellId, DAF.sidbPruningFlag, DAF.subStoreBitField,
			DENSE_RANK() OVER (PARTITION BY DAF.SIDBStoreId ORDER BY ABS(DAF.FailureErrorCode) desc, (DAF.Status & 2) desc, DAF.archFileId asc), DAF.chunkCommCellId,
			CASE WHEN DAF.copyId > 0 THEN DAF.copyId ELSE AGC.id END, 0, 0, CAST(NEWID() AS binary(6))
			FROM MMDeletedAF DAF WITH (READUNCOMMITTED)
				INNER JOIN archCopySIDBStore ACS WITH (READUNCOMMITTED) ON DAF.SIDBStoreId = ACS.SIDBStoreId
				INNER JOIN archGroupCopy AGC WITH (READUNCOMMITTED) ON ACS.copyId = AGC.id
				INNER JOIN MMDataPath D WITH (READUNCOMMITTED) ON ACS.CopyId = D.CopyId
				INNER JOIN MMDrivePool DP WITH (READUNCOMMITTED) ON D.DrivePoolId = DP.DrivePoolId
				INNER JOIN (SELECT MP.MasterPoolId, MIN(MP.MountPathId) AS MountPathId
							FROM MMMountPath MP WITH (READUNCOMMITTED)
							INNER JOIN MMMountPathOnlineStatus MS ON MP.MountPathId = MS.MountPathId
						WHERE MP.MountPathTypeId IN (@i_MountPathType1, @i_MountPathType2)
						GROUP BY MP.MasterPoolId) AS M ON DP.MasterPoolId = M.MasterPoolId
			WHERE  DAF.MountPathId = 0
			AND DAF.ArchChunkId = 0
			AND DAF.SIDBStoreId > 0 AND DAF.archFileId > 0
AND AGC.dedupeFlags & 134217728 = 0
AND D.flag & 1 = 1
		)
		INSERT INTO #tempVolAFList
		SELECT *
		FROM RowPickerAFPruning P
		WHERE (P.rn < @batchCount AND @batchCount > 0) OR (@batchCount = 0)
	END
	UPDATE T
	SET volumeName = V.VolumeName,
	OMLVersion = V.OMLVersion,
	copyId = (CASE WHEN T.copyId > 0 THEN T.copyId ELSE ISNULL(ASR.archGroupCopyId, 0) END)
	FROM #tempVolAFList T
			INNER JOIN MMVolume V WITH (READUNCOMMITTED) ON T.VolumeId = V.VolumeId
			LEFT OUTER JOIN MMMediaGroup MGROUP WITH(NOLOCK) ON V.MediaGroupId = MGROUP.MediaGroupId
			LEFT OUTER JOIN archStream ASR WITH(NOLOCK) ON MGROUP.MediaGroupId = ASR.mediaGroupId
	DECLARE @configUseDDBMAForPruning INT = ISNULL((SELECT value from MMConfigs WITH(READUNCOMMITTED) WHERE name = 'MM_CONFIG_USE_DDB_MA_FOR_PRUNING'), 0)
    --Find if we have DDB MAs that have access to the mount path. This is done only for non-cloud mount path
	IF(@i_MountPathType1 <> @MOUNT_PATH_EXTERNAL_REMOTE_HOST AND @configUseDDBMAForPruning = 1)
	BEGIN
		IF OBJECT_ID('tempdb..#tempCopyMPStoreMap') IS NOT NULL
			DROP TABLE #tempCopyMPStoreMap
		CREATE TABLE #tempCopyMPStoreMap (CopyId int, MountPathId int, SIDBStoreId int)
		INSERT #tempCopyMPStoreMap
		SELECT DISTINCT CopyId, MountPathId, SIDBStoreId FROM #tempVolAFList WHERE SIDBStoreId > 0
		;WITH MAPicker (CopyId, MountPathId, SIDBStoreId, rn, randorder)
		AS
		(
			SELECT copyId, mountPathId, SIDBStoreId, rn, row_number() over (partition by copyId, mountPathId, SIDBStoreId order by NEWID()) as randorder FROM
			(
				SELECT * FROM
				(
					SELECT T.copyId, MP.mountPathId, T.SIDBStoreId, MP.rn, dense_rank() over (partition by T.copyId, MP.mountPathId, T.SIDBStoreId order by MP.HostId) as serialorder
					FROM #tempCopyMPStoreMap T
					INNER JOIN MMMountPathOnlineStatus MP WITH (READUNCOMMITTED) ON T.MountPathId = MP.MountPathId
					INNER JOIN MMMountPathToDDBMediaAgent DDBMA WITH (READUNCOMMITTED) ON T.MountPathId = DDBMA.MountPathId AND T.SIDBStoreId = DDBMA.SIDBStoreId AND MP.HostId = DDBMA.HostId
LEFT OUTER JOIN MMDataPath DP WITH (READUNCOMMITTED) ON T.copyId = DP.copyId AND DP.flag & (4 /*| MMS2_PREFERRED_PRUNER*/) = (4 /*| MMS2_PREFERRED_PRUNER*/)
					LEFT OUTER JOIN MMDrivePool DPOOL WITH (READUNCOMMITTED) ON DP.DrivePoolId = DPOOL.DrivePoolId AND MP.masterPoolId = DPOOL.MasterPoolId AND DPOOL.ClientId = MP.HostId
WHERE MP.MPAttribute & 256 = 0 OR (DP.HostClientId IS NOT NULL AND DPOOL.DrivePoolId IS NOT NULL)
				) DT
				WHERE serialorder <= @maxAllowedMAs
			) TEMP
		)
		UPDATE T1
		SET dc =  T2.rn
		FROM #tempVolAFList T1 INNER JOIN MAPicker T2 ON T1.CopyId = T2.CopyId AND T1.MountPathId = T2.MountPathId AND T1.SIDBStoreId = T2.SIDBStoreId
		INNER JOIN (SELECT CopyId, MountPathId, SIDBStoreId, MAX(randorder) maxRowNumber FROM MAPicker GROUP BY copyId, MountPathId, SIDBStoreId) T3
		ON T1.CopyId = T3.CopyId AND T1.MountPathId = T3.MountPathId AND T1.SIDBStoreId = T3.SIDBStoreId AND T2.randorder = ABS(T1.newid % T3.maxRowNumber) + 1
		IF OBJECT_ID('tempdb..#tempCopyMPStoreMap') IS NOT NULL
			DROP TABLE #tempCopyMPStoreMap
	END
	--Phase 3 distribution logic is for non-cloud MP only.
IF (@i_MountPathType1 <> @MOUNT_PATH_EXTERNAL_REMOTE_HOST) AND EXISTS (SELECT 1 FROM #tempVolAFList WHERE AFileId = 0x7FFFFFFF AND archChunkId = 0 AND SIDBStoreId > 0)
	BEGIN
		-- Insert additional rows for AFId - 2147483647 to be submitted to all eligible MAs.
		;WITH StoreMAMap (SIDBStoreId, MAId, RandomMountPathId)
		AS
		(
			SELECT SIDBStoreId, HostId, RandomMountPathId FROM
			(
				SELECT T.SIDBStoreId, MS.HostId, MIN(MS.mountPathId) "RandomMountPathId", dense_rank() over (partition by T.SIDBStoreId order by MS.HostId) as serialorder /*dense_rank() ensures the serial order will be the same for duplicate host ids*/
FROM (SELECT DISTINCT SIDBStoreId FROM #tempVolAFList WHERE AFileId = 0x7FFFFFFF AND ArchChunkId = 0 AND SIDBStoreId > 0) T
				INNER JOIN archCopySIDBStore ACS WITH (READUNCOMMITTED) ON T.SIDBStoreId = ACS.SIDBStoreId
				INNER JOIN archGroupCopy AGC WITH (READUNCOMMITTED) ON ACS.copyId = AGC.id
				INNER JOIN MMDataPath D WITH (READUNCOMMITTED) ON AGC.Id = D.CopyId
				INNER JOIN MMDrivePool DP WITH (READUNCOMMITTED) ON D.DrivePoolId = DP.DrivePoolId
				INNER JOIN MMMountPathOnlineStatus MS WITH(READUNCOMMITTED) ON DP.MasterPoolId = MS.MasterPoolId
WHERE AGC.dedupeFlags & 134217728 = 0
				GROUP BY T.SIDBStoreId, MS.HostId
			) IT
			WHERE serialorder <= @maxAllowedMAs
		)
		INSERT INTO #tempVolAFList
		SELECT DISTINCT T.volumeId, T.volumeName, T.OMLVersion, T.AFileId, T.ArchChunkId, T1.MAId, T.cclip, T.DeviceId, T1.RandomMountPathId, '', T.MountPathTypeId, T.UserName, T.Password, T.Folder, T.SIDBStoreId, T.commCellId, T.sidbPruningFlag,
					T.subStoreBitField, 0, T.chunkCommCellId, T.copyId, 1 /*Populating dc as 1 as default value so the later queries will not bother picking MA for these rows*/, T.MPAttribute, CAST(NEWID() AS binary(6))
		FROM #tempVolAFList T
				INNER JOIN StoreMAMap T1 ON T.SIDBStoreId = T1.SIDBStoreId
WHERE T.AFileId = 0x7FFFFFFF
		AND T.ArchChunkId = 0
		AND T.SIDBStoreId > 0; -- with store batch pruning we'll have only rows for selected stores.
		/*There will be a left over row for each store, that was originally populated from MMDeletedAF to initiate zeroref pruning with Host Id = 0. It is not needed any more as in above query we populated all MAs*/
DELETE #tempVolAFList WHERE AFileId = 0x7FFFFFFF AND ArchChunkId = 0 AND SIDBStoreId > 0 AND HostId = 0
	END
	DECLARE @tempCopyMPMap table (CopyId int, MountPathId int)
	INSERT @tempCopyMPMap
	SELECT DISTINCT CopyId, MountPathId FROM #tempVolAFList WHERE dc = 0 --If dc has already been chosen due to DDB MA no need to process them
	IF(@i_MountPathType1 <> @MOUNT_PATH_EXTERNAL_REMOTE_HOST)
	BEGIN
		--Set device controller based on data path settings
		WITH MAPicker (CopyId, MountPathId, rn, randorder)
		AS
		(
			SELECT copyId, mountPathId, rn, row_number() over (partition by copyId, mountPathId order by NEWID()) as randorder FROM
			(
				SELECT * FROM
				(
					SELECT T.copyId, MP.mountPathId, MP.rn, dense_rank() over (partition by T.copyId, MP.mountPathId order by MP.HostId) as serialorder
					FROM @tempCopyMPMap T
					INNER JOIN MMDataPath DP WITH (READUNCOMMITTED) ON T.copyId = DP.copyId
					INNER JOIN MMMountPathOnlineStatus MP WITH (READUNCOMMITTED) ON T.MountPathId = MP.MountPathId
					INNER JOIN MMDrivePool DPOOL WITH (READUNCOMMITTED) ON DP.DrivePoolId = DPOOL.DrivePoolId AND MP.masterPoolId = DPOOL.MasterPoolId AND DPOOL.ClientId = MP.HostId
WHERE MP.MPAttribute & 256 > 0 AND DP.flag & (4 /*| MMS2_PREFERRED_PRUNER*/) = (4 /*| MMS2_PREFERRED_PRUNER*/)
				) DT
				WHERE serialorder <= @maxAllowedMAs
			) TEMP
		)
		UPDATE T1
		SET dc =  T2.rn
		FROM #tempVolAFList T1 INNER JOIN MAPicker T2 ON T1.CopyId = T2.CopyId AND T1.MountPathId = T2.MountPathId
		INNER JOIN (SELECT CopyId, MountPathId, MAX(randorder) maxRowNumber FROM MAPicker GROUP BY copyId, MountPathId) T3
		ON T1.CopyId = T3.CopyId AND T1.MountPathId = T3.MountPathId AND T2.randorder = ABS(T1.newid % T3.maxRowNumber) + 1 AND T1.dc = 0 ; --If dc has already been chosen due to DDB MA don't overwrite
		--Set device controller not based on data path settings (for deleted copies also we will ignore datapath settings)
		WITH MAPicker (CopyId, MountPathId, rn, randorder)
		AS
		(
			SELECT copyId, mountPathId, rn, row_number() over (partition by copyId, mountPathId order by NEWID()) as randorder FROM
			(
				SELECT * FROM
				(
					SELECT T.copyId, MP.mountPathId, MP.rn, dense_rank() over (partition by T.copyId, MP.mountPathId order by MP.HostId) as serialorder
					FROM @tempCopyMPMap T
					LEFT OUTER JOIN archGroupCopy AGC WITH (READUNCOMMITTED) ON T.CopyId = AGC.id
					INNER JOIN MMMountPathOnlineStatus MP WITH (READUNCOMMITTED) ON T.MountPathId = MP.MountPathId
WHERE MP.MPAttribute & 256 = 0 OR AGC.id IS NULL
				) DT
				WHERE serialorder <= @maxAllowedMAs
			) TEMP
		)
		UPDATE T1
		SET dc =  T2.rn
		FROM #tempVolAFList T1 INNER JOIN MAPicker T2 ON T1.CopyId = T2.CopyId AND T1.MountPathId = T2.MountPathId
		INNER JOIN (SELECT CopyId, MountPathId, MAX(randorder) maxRowNumber FROM MAPicker GROUP BY copyId, MountPathId) T3
		ON T1.CopyId = T3.CopyId AND T1.MountPathId = T3.MountPathId AND T2.randorder = ABS(T1.newid % T3.maxRowNumber) + 1 AND T1.dc = 0; --If dc has already been chosen due to DDB MA don't overwrite
	END
	ELSE
	BEGIN
		--Set device controller based on data path settings if granular pruning is enabled
		WITH MAPicker (CopyId, MountPathId, rn, randorder)
		AS
		(
			SELECT copyId, mountPathId, rn, row_number() over (partition by copyId, mountPathId order by NEWID()) as randorder FROM
			(
				SELECT * FROM
				(
					SELECT T.copyId, MP.mountPathId, MP.rn, dense_rank() over (partition by T.copyId, MP.mountPathId order by MP.HostId) as serialorder
					FROM @tempCopyMPMap T
					INNER JOIN MMDataPath DP WITH (READUNCOMMITTED) ON T.copyId = DP.copyId
					INNER JOIN MMMountPathOnlineStatus MP WITH (READUNCOMMITTED) ON T.MountPathId = MP.MountPathId
					INNER JOIN MMDrivePool DPOOL WITH (READUNCOMMITTED) ON DP.DrivePoolId = DPOOL.DrivePoolId AND MP.masterPoolId = DPOOL.MasterPoolId AND DPOOL.ClientId = MP.HostId
WHERE MP.MPAttribute & 256 > 0
AND MP.MPAttribute & 32 > 0
AND DP.flag & (/*MMS2_PREFERRED_PRUNER |*/ 64 | 4) = (/*MMS2_PREFERRED_PRUNER |*/ 64 | 4)
				) DT
				WHERE serialorder <= @maxAllowedMAs
			) TEMP
		)
		UPDATE T1
		SET dc =  T2.rn
		FROM #tempVolAFList T1 INNER JOIN MAPicker T2 ON T1.CopyId = T2.CopyId AND T1.MountPathId = T2.MountPathId
		INNER JOIN (SELECT CopyId, MountPathId, MAX(randorder) maxRowNumber FROM MAPicker GROUP BY copyId, MountPathId) T3
		ON T1.CopyId = T3.CopyId AND T1.MountPathId = T3.MountPathId AND T2.randorder = ABS(T1.newid % T3.maxRowNumber) + 1;
        --Set device controller based on data path settings if granular pruning is not enabled
		WITH MAPicker (CopyId, MountPathId, rn, randorder)
		AS
		(
			SELECT copyId, mountPathId, rn, row_number() over (partition by copyId, mountPathId order by NEWID()) as randorder FROM
			(
				SELECT * FROM
				(
					SELECT T.copyId, MP.mountPathId, MP.rn, dense_rank() over (partition by T.copyId, MP.mountPathId order by MP.HostId) as serialorder
					FROM @tempCopyMPMap T
					INNER JOIN MMDataPath DP WITH (READUNCOMMITTED) ON T.copyId = DP.copyId
					INNER JOIN MMMountPathOnlineStatus MP WITH (READUNCOMMITTED) ON T.MountPathId = MP.MountPathId
					INNER JOIN MMDrivePool DPOOL WITH (READUNCOMMITTED) ON DP.DrivePoolId = DPOOL.DrivePoolId AND MP.masterPoolId = DPOOL.MasterPoolId AND DPOOL.ClientId = MP.HostId
WHERE MP.MPAttribute & 256 > 0
AND MP.MPAttribute & 32 = 0
AND DP.flag & (/*MMS2_PREFERRED_PRUNER |*/ 4) = (/*MMS2_PREFERRED_PRUNER |*/ 4)
				) DT
				WHERE serialorder <= @maxAllowedMAs
			) TEMP
		)
		UPDATE T1
		SET dc =  T2.rn
		FROM #tempVolAFList T1 INNER JOIN MAPicker T2 ON T1.CopyId = T2.CopyId AND T1.MountPathId = T2.MountPathId
		INNER JOIN (SELECT CopyId, MountPathId, MAX(randorder) maxRowNumber FROM MAPicker GROUP BY copyId, MountPathId) T3
		ON T1.CopyId = T3.CopyId AND T1.MountPathId = T3.MountPathId AND T2.randorder = ABS(T1.newid % T3.maxRowNumber) + 1;
		--Set device controller not based on data path settings  if granular pruning is enabled or not enabled, or for deleted copies data
		WITH MAPicker (CopyId, MountPathId, rn, randorder)
		AS
		(
			SELECT copyId, mountPathId, rn, row_number() over (partition by copyId, mountPathId order by NEWID()) as randorder FROM
			(
				SELECT * FROM
				(
					SELECT T.copyId, MP.mountPathId, MP.rn, dense_rank() over (partition by T.copyId, MP.mountPathId order by MP.HostId) as serialorder
					FROM @tempCopyMPMap T
					INNER JOIN MMMountPathOnlineStatus MP WITH (READUNCOMMITTED) ON T.MountPathId = MP.MountPathId
					LEFT OUTER JOIN archGroupCopy AGC WITH (READUNCOMMITTED) ON T.CopyId = AGC.id
WHERE (MP.MPAttribute & 256 = 0 OR AGC.id IS NULL)
AND (MP.MPAttribute & 32 = 0 OR MP.DeviceControllerFlags & 1 > 0)
				) DT
				WHERE serialorder <= @maxAllowedMAs
			) TEMP
		)
		UPDATE T1
		SET dc =  T2.rn
		FROM #tempVolAFList T1 INNER JOIN MAPicker T2 ON T1.CopyId = T2.CopyId AND T1.MountPathId = T2.MountPathId
		INNER JOIN (SELECT CopyId, MountPathId, MAX(randorder) maxRowNumber FROM MAPicker GROUP BY copyId, MountPathId) T3
		ON T1.CopyId = T3.CopyId AND T1.MountPathId = T3.MountPathId AND T2.randorder = ABS(T1.newid % T3.maxRowNumber) + 1
		WHERE T1.SIDBStoreId > 0; -- stick to pruner for dedup data only.
		-- distribute the pruning load for non-dedup data.
		WITH MAPicker (CopyId, MountPathId, rn, randorder)
		AS
		(
			SELECT copyId, mountPathId, rn, row_number() over (partition by copyId, mountPathId order by NEWID()) as randorder FROM
			(
				SELECT * FROM
				(
					SELECT T.copyId, MP.mountPathId, MP.rn, dense_rank() over (partition by T.copyId, MP.mountPathId order by MP.HostId) as serialorder
					FROM @tempCopyMPMap T
					INNER JOIN MMMountPathOnlineStatus MP WITH (READUNCOMMITTED) ON T.MountPathId = MP.MountPathId
WHERE MP.MPAttribute & 256 = 0
				) DT
				WHERE serialorder <= @maxAllowedMAs
			) TEMP
		)
		UPDATE T1
		SET dc =  T2.rn
		FROM #tempVolAFList T1 INNER JOIN MAPicker T2 ON T1.CopyId = T2.CopyId AND T1.MountPathId = T2.MountPathId
		INNER JOIN (SELECT CopyId, MountPathId, MAX(randorder) maxRowNumber FROM MAPicker GROUP BY copyId, MountPathId) T3
		ON T1.CopyId = T3.CopyId AND T1.MountPathId = T3.MountPathId AND T2.randorder = ABS(T1.newid % T3.maxRowNumber) + 1 AND T1.dc = 0 --If dc has already been chosen due to DDB MA don't overwrite
		WHERE T1.SIDBStoreId = 0;
	END
	/*
	--Remove those that do not have a valid device controller to prune
	DELETE #tempVolAFList WHERE dc = 0
	-- first check if we are able to find DDB MA for this MountPath and Store
	UPDATE T
	SET HostId = DDBMA.HostId,
	UserName = DDBMA.UserName,
	Password = DDBMA.UserPassword,
	Folder = DDBMA.Folder,
	MountPathName = DDBMA.MountPathName,
	MountPathTypeId = DDBMA.MountPathTypeId
	FROM #tempVolAFList T
		INNER JOIN #tempDDBMountPathMA DDBMA ON T.MountPathId = DDBMA.MountPathId AND T.SIDBStoreId = DDBMA.SIDBStoreId
		INNER JOIN MMMountPath MP WITH (READUNCOMMITTED) ON T.MountPathId = MP.MountPathId
LEFT OUTER JOIN MMDataPath DP ON T.CopyId = DP.CopyId AND DP.flag & (4 /*| MMS2_PREFERRED_PRUNER*/) = (4 /*| MMS2_PREFERRED_PRUNER*/)
		LEFT OUTER JOIN MMDrivePool DPOOL WITH (READUNCOMMITTED) ON DP.DrivePoolId = DPOOL.DrivePoolId AND MP.masterPoolId = DPOOL.MasterPoolId AND DPOOL.ClientId = DDBMA.HostId
WHERE T.HostId = 0 AND (MP.Attribute & 256 = 0 OR (DP.HostClientId IS NOT NULL AND DPOOL.DrivePoolId IS NOT NULL))
	*/
	-- if not able to find DDB MA then fall back to traditional method.
	UPDATE T
	SET HostId = MP.HostId,
	UserName = MP.UserName,
	Password = MP.UserPassword,
	Folder = MP.Folder,
	MountPathName = MP.MountPathName,
	MountPathTypeId = MP.MountPathTypeId,
	MPAttribute = MP.MPAttribute
	FROM #tempVolAFList T
		INNER JOIN MMMountPathOnlineStatus MP WITH (READUNCOMMITTED) ON T.MountPathId = MP.MountPathId AND T.dc = MP.rn
	WHERE T.HostId = 0
    --Remove those that do not have a valid MA to prune
	DELETE #tempVolAFList WHERE HostId = 0
	-- Delete those rows which have valid AF entry in archFileCopy table.
	DELETE #tempVolAFList
	FROM #tempVolAFList T
			INNER JOIN archCopySIDBStore CS WITH (READUNCOMMITTED) ON CS.SIDBStoreId = T.sidbStoreId
			INNER JOIN archFileCopy AFC WITH (READUNCOMMITTED) ON T.AFileId = AFC.archFileId AND AFC.archCopyId = CS.CopyId AND AFC.lastChunkNumber > 0
	WHERE T.sidbStoreId > 0
	-- Delete those rows with AFs which have auxcopy job running. (For backup it has to be prevented in DA itself, since by the time in comes to DAF, we have lost AF-job relation)
	DELETE T
	FROM #tempVolAFList T
		INNER JOIN archChunkToReplicate ACR WITH (READUNCOMMITTED) ON T.AFileId = ACR.archFileId AND T.copyId = ACR.DestCopyId AND T.commCellId = ACR.commCellId
		INNER JOIN JMJobInfo JM WITH (READUNCOMMITTED) ON ACR.adminJobId = JM.jobId
	WHERE T.sidbStoreId > 0
AND ACR.Status IN (1)
	AND JM.state NOT IN (4, 5, 9, 10, 12, 19)
	/*COMPLETE, STOPPED, COMPLETEDSUCCESS, COMPLETEDFAIL, COMPLETEDPARTIAL, COMPLETEDWITHWARNINGS*/
	IF (@storeBatchPruning = 0)
	BEGIN
		DELETE #tempVolAFList
		FROM #tempVolAFList T, IdxSIDBStore STORE WITH (READUNCOMMITTED)
		WHERE T.SIDBStoreID > 0
			AND	T.SIDBStoreId = STORE.SIDBStoreId
			AND
			(
				(STORE.CommCellId <> 2)
				OR
				(
( (STORE.flags & 256) > 0)
						OR
( STORE.Status = 1 /* 1 */ )
						OR
( (STORE.Flags & 2097152) > 0)
						OR
					( NOT EXISTS
						(
							SELECT CopyId FROM archCopySIDBStore
							WHERE SIDBStoreId = T.SIDBStoreId
						)
					)
						OR
					(
(STORE.Flags & 536870912) = 0
					)
						OR
					( EXISTS
						(
							SELECT 	SubStoreId FROM IdxSIDBSubStore WITH (READUNCOMMITTED)
							WHERE 	SIDBStoreId = T.SIDBStoreId
AND flags & 1024 = 1024
						)
					)
				)
			)
	END
-- Enable granular pruning on cloud targets
	--
	-- For Cloud mountpaths, we only do store-level pruning, so remove rows here that belong to SIDB stores.
	--
	IF (@i_MountPathType1 = @MOUNT_PATH_EXTERNAL_REMOTE_HOST)
	BEGIN
		DELETE #tempVolAFList
		FROM #tempVolAFList T
		WHERE T.SIDBStoreId > 0
AND (T.MPAttribute & 32) = 0
		-- For hybrid cloud if the local device is not accessible or enabled then we need to drop the rows
		DELETE T
		FROM #tempVolAFList T
			INNER JOIN #tempHybridMPList HY WITH (READUNCOMMITTED) ON T.MountPathId = HY.MountPathId
			INNER JOIN MMCloudVolCacheMountPath VMP WITH (READUNCOMMITTED) ON T.VolumeId = VMP.VolumeId
			LEFT OUTER JOIN MMMountPathOnlineStatus MP WITH (READUNCOMMITTED) ON VMP.cacheMountPathId = MP.MountPathId
		WHERE MP.MountPathId IS NULL
	END
	ELSE IF (@i_MountPathType1 = @MOUNT_PATH_SHARED_STATIC)
	BEGIN
		DELETE #tempVolAFList
		FROM #tempVolAFList T
		WHERE T.SIDBStoreId > 0
		AND MountPathTypeId = @MOUNT_PATH_SHARED_STATIC
AND (T.MPAttribute & 32768) > 0
	END
/*	Fix for AuxCopy after CCM scenario -
	CommcellId is set -ve here to the rows
	to identify those volumes whose archFiles that are with commcellid <> 2 but those are belonging to
	copies that are migrated and auxcopied here locally and we allow to prune..
	By default we don't prune SIDB of such volumes..
	Such CopyIds which we allow to prune we have in GxGlobalParam xml value...
	GxGlobalParamValue should be of the format
				Name										Value
			---------------                           ------------------
	ArchCopyIds_AuxCopiedMigrated_AllowedToPrune		'<copy id = "1"/>
														<copy id = "2"/>
														<copy id = "3"/>'
*/
	DECLARE @AuxCopiedMigratedCopies  xml
	SELECT @AuxCopiedMigratedCopies = CAST(value as XML) from GXGlobalParam where name = 'ArchCopyIds_AuxCopiedMigrated_AllowedToPrune'
	IF @AuxCopiedMigratedCopies IS NOT NULL
	BEGIN
		DECLARE @CopyIdsList table(id integer)
		INSERT INTO @CopyIdsList
		SELECT col.value('@id', 'integer')
		FROM   @AuxCopiedMigratedCopies.nodes('copy') idlist(col)
		UPDATE #tempVolAFList
		SET commcellId = (commcellId * (-1)), chunkCommcellId = (chunkCommcellId * (-1))
		WHERE (select top 1 ACM.archCopyId from ArchChunkMapping ACM inner join ArchChunk AC
		ON ACM.chunkCommcellId = AC.commcellId AND ACM.archChunkId = AC.id
		WHERE AC.VolumeId = #tempVolAFList.VolumeId) IN (SELECT id FROM @CopyIdsList)
		AND commcellId <> 2
		AND commcellId > 0
	END
	-- Do this only if the batch count is > 0. Otherwise send everything.
	--IF (@batchCount > 0)
	--BEGIN
	--	DECLARE @SIDBStoreId	INT = 0
	--	DECLARE @maxRank		INT = 0
	--	DECLARE SIDBCursor CURSOR FOR
	--	SELECT DISTINCT SIDBStoreId
	--	FROM #tempVolAFList
	--	WHERE SIDBStoreId > 0
	--
	--	OPEN SIDBCursor
	--	FETCH NEXT FROM SIDBCursor INTO @SIDBStoreId
	--
	--	WHILE @@FETCH_STATUS = 0
	--	BEGIN
	--		-- MR - 138858 - From now perform batching for sealed stores also. Reason: We may reconstruct sealed stores, and it can be used to control AFs sent for pruning.
	--		SET @maxRank = ISNULL((SELECT MAX(T1.rn) FROM
	--							(SELECT DISTINCT TOP(@batchCount) rn FROM #tempVolAFList
	--							WHERE SIDBStoreId = @SIDBStoreId
	--							ORDER BY rn asc ) as T1
	--							), 0)
	--		IF (@maxRank > 0)
	--		BEGIN
	--			DELETE #tempVolAFList
	--			FROM #tempVolAFList T1
	--			WHERE T1.SIDBStoreId = @SIDBStoreId
	--			AND T1.rn > @maxRank
	--		END
	--
	--		FETCH NEXT FROM SIDBCursor INTO @SIDBStoreId
	--	END
	--
	--	CLOSE SIDBCursor
	--	DEALLOCATE SIDBCursor
	--
	--END
IF (@storeBatchPruning = 0) OR EXISTS (SELECT 1 FROM @tblStoresToPrune)
BEGIN
	--Update MMDeletedAF with status as picked for pruning.
	UPDATE MMDeletedAF
SET Status	= Status | 2,
	reserveInt = T.HostId
	FROM #tempVolAFList T
	WHERE MMDeletedAF.archFileId = T.AFileId
	AND MMDeletedAF.archChunkId = T.ArchChunkId
	AND MMDeletedAF.SIDBStoreId = T.SIDBStoreId
	AND MMDeletedAF.commCellId = T.commCellId
    AND MMDeletedAF.volumeId = T.volumeId
	AND MMDeletedAF.archChunkId = T.ArchChunkId
	AND MMDeletedAF.chunkCommcellId = T.chunkCommCellId
END
	SELECT 				T.volumeId, T.volumeName, T.OMLVersion, T.AFileId,
						T.ArchChunkId, T.HostId, T.cclip, T.MountPathId,
						T.MountPathName, T.MountPathTypeId, T.UserName,
						T.Password, T.Folder, T.SIDBStoreId, (CASE WHEN T.chunkCommCellId <> 0 THEN chunkCommCellId ELSE T.commCellId END), T.sidbPruningFlag, T.subStoreBitField
	FROM				#tempVolAFList AS T
	ORDER BY			T.HostId, T.MountPathId
	if object_id('tempdb.dbo.#tempVolAFList') is not null DROP TABLE #tempVolAFList
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2GetSharedStVolumeInfoForDeletedAF')
	delete from GxQscripts where name = 'MMS2GetSharedStVolumeInfoForDeletedAF'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetSharedStVolumeInfoForDeletedAF')
	delete from GXDBVersions where aliasname = 'MMS2GetSharedStVolumeInfoForDeletedAF'
GO

insert into GXDBVersions values(2, 'MMS2GetSharedStVolumeInfoForDeletedAF',  '00010064000200340000', 'MMS2GetSharedStVolumeInfoForDeletedAF', '00010064000200340000')
GO

