

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GetSecurityEntityForMMEntity.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +-----------------------------------------------------------------------+
--  |       STORED PROCEDURE : "MMS2GetSecurityEntityForMMEntity"			|
--  |																		|
--  | DEMONSTRATES PASSING INTEGERS INTO A CURSOR FUNCTION					|
--  | AND RETURNING RESULTS													|
--  | This will return security entity which is available in APP_Entity		|
--  | table based on MM entity in EntityTypes.h								|
--  +-----------------------------------------------------------------------+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMS2GetSecurityEntityForMMEntity')
BEGIN
	print '>>> Drop Stored Procedure: MMS2GetSecurityEntityForMMEntity <<<'
	drop procedure MMS2GetSecurityEntityForMMEntity
END
IF EXISTS (select * from GxQscripts where name='MMS2GetSecurityEntityForMMEntity')
	delete from GxQscripts where name = 'MMS2GetSecurityEntityForMMEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetSecurityEntityForMMEntity')
	delete from GXDBVersions where aliasname = 'MMS2GetSecurityEntityForMMEntity'
GO
print '... Creating Procedure: MMS2GetSecurityEntityForMMEntity'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2GetSecurityEntityForMMEntity
  @i_entityId integer,
  @i_entityType integer
AS
  DECLARE @o_entityId integer
  DECLARE @o_entityType integer
SET NOCOUNT ON
	DECLARE @secEntityId integer
	DECLARE @secEntityType integer
IF (@i_entityType = 51)
	BEGIN
SELECT @secEntityId = MP.LibraryId, @secEntityType = 9 FROM MMDrive(NOLOCK) AS MD, MMMasterPool(NOLOCK) AS MP WHERE MD.MasterPoolId = MP.MasterPoolId AND MD.DriveId = @i_entityId
	END
ELSE IF (@i_entityType = 46)
	BEGIN
SELECT @secEntityId = LibraryId, @secEntityType = 9 FROM MMMedia(NOLOCK) WHERE MediaId = @i_entityId
	END
ELSE IF (@i_entityType = 67)
	BEGIN
SELECT @secEntityId = LibraryId, @secEntityType = 9 FROM MMSpareGroup(NOLOCK) WHERE SpareGroupId = @i_entityId
	END
	ELSE
	BEGIN
		SELECT @secEntityId = @i_entityId, @secEntityType = @i_entityType
	END
	SELECT ISNULL(@secEntityId,@i_entityId), ISNULL(@secEntityType,@i_entityType)
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2GetSecurityEntityForMMEntity')
	delete from GxQscripts where name = 'MMS2GetSecurityEntityForMMEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetSecurityEntityForMMEntity')
	delete from GXDBVersions where aliasname = 'MMS2GetSecurityEntityForMMEntity'
GO

insert into GXDBVersions values(2, 'MMS2GetSecurityEntityForMMEntity',  '00000000000000000000', 'MMS2GetSecurityEntityForMMEntity', '00000000000000000000')
GO

