

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GetScratchPoolInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2GetScratchPoolInfo.sp,v $ $Id: MMS2GetScratchPoolInfo.sp,v 1.3.294.2 2018/03/20 20:06:16 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "MMS2GetScratchPoolInfo"				|
--	|									|
--	| Execute the System stored procedure to fetch the physical files	|
--	| .. for the (current) database.					|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2GetScratchPoolInfo <<<'

IF EXISTS (select * from sysobjects where name='MMS2GetScratchPoolInfo')
	drop procedure MMS2GetScratchPoolInfo
IF EXISTS (select * from GxQscripts where name='MMS2GetScratchPoolInfo')
	delete from GxQscripts where name = 'MMS2GetScratchPoolInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetScratchPoolInfo')
	delete from GXDBVersions where aliasname = 'MMS2GetScratchPoolInfo'
GO
print '... Creating Procedure: MMS2GetScratchPoolInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2GetScratchPoolInfo
  @scratchPoolId integer
AS
  DECLARE @scratchPoolName NVARCHAR(255)
  DECLARE @lowWaterMark integer
  DECLARE @highWaterMark integer
  DECLARE @attributes integer
  DECLARE @numMedia integer
  DECLARE @lastUpdateTime integer
  DECLARE @scratchPoolType integer
  DECLARE @libraryId integer
  DECLARE @defaultMediaTypeId integer
  DECLARE @defaultMediaTypeName char(255)
	select distinct ms.sparegroupname,
  	case @scratchPoolId when 0
       then (select top 1 value from mmconfigs where name = 'MMS2_CONFIG_LOW_WATERMARK_THRESHOLD')
       else ms.lowwatermark end,
	ms.HighWaterMark, ms.Attributes,
	nummedia=(select count(*) from MMMedia where sparegroupid = ms.sparegroupid and IsInMediaGroup = 0),
	ms.lastupdatetime, ms.sparegrouptype, ms.libraryId, ms.MediatypeId, mmt.MediaTypeName
	from MMSpareGroup as ms, MMMediaType as mmt
	where ms.MediatypeId = mmt.MediatypeId and ms.sparegroupid = @scratchPoolId
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2GetScratchPoolInfo')
	delete from GxQscripts where name = 'MMS2GetScratchPoolInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetScratchPoolInfo')
	delete from GXDBVersions where aliasname = 'MMS2GetScratchPoolInfo'
GO

insert into GXDBVersions values(2, 'MMS2GetScratchPoolInfo',  '00010003029400020000', 'MMS2GetScratchPoolInfo', '00010003029400020000')
GO

