

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GetScaleOutStatusForHost.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2GetScaleOutStatusForHost.sp,v $ $Id: MMS2GetScaleOutStatusForHost.sp,v 1.1.4.5 2020/02/14 10:18:27 aselvanayagam Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMS2GetScaleOutStatusForHost')
BEGIN
	print '>>> Drop Stored Procedure: MMS2GetScaleOutStatusForHost <<<'
	drop procedure MMS2GetScaleOutStatusForHost
END
IF EXISTS (select * from GxQscripts where name='MMS2GetScaleOutStatusForHost')
	delete from GxQscripts where name = 'MMS2GetScaleOutStatusForHost'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetScaleOutStatusForHost')
	delete from GXDBVersions where aliasname = 'MMS2GetScaleOutStatusForHost'
GO
print '... Creating Procedure: MMS2GetScaleOutStatusForHost'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2GetScaleOutStatusForHost
  @i_mediaAgentId INT,
  @i_mountPathId INT
AS
  DECLARE @o_deviceId INT
  DECLARE @o_mountPathId INT
  DECLARE @o_storagePool NVARCHAR(512)
  DECLARE @o_dispFactor INT
  DECLARE @o_redFactor INT
  DECLARE @o_TotalDisks INT
  DECLARE @o_OfflineDisks INT
SET NOCOUNT ON
DECLARE @tbl TABLE ( deviceId INT, mountPathId INT, StoragePoolName nvarchar(1024), dispFactor INT, redFactor INT, TotalDisks INT, OfflineDisks INT)
IF (@i_mediaAgentId > 0 and @i_mountPathId = 0)
BEGIN
	IF  EXISTS (SELECT 1 from MMDiskHWInfo WHERE hostId = @i_mediaAgentId and flags & 1 = 1)
	BEGIN
		INSERT INTO @tbl
		SELECT DISTINCT deviceId,0,N'',0,0,0,0 from MMDiskHWInfo where hostId = @i_mediaAgentId and flags & 1 = 1
		UPDATE T
		SET mountPathId = (SELECT MountPathId from MMMountPathToStorageDevice (nolock) where DeviceId = T.deviceId)
		FROM @tbl T
		UPDATE T
		SET dispFactor = S.DisperseFactor, redFactor = S.RedundancyFactor, StoragePoolName = S.StoragePoolName
		FROM @tbl T, MMSDSStoragePool S (nolock), MMMountPath MP(nolock), MMMountPathToStorageDevice MSD(nolock)
		WHERE T.deviceId = MSD.DeviceId
		AND MSD.MountPathId = MP.MountPathId
		AND MP.LibraryId = S.LibraryId
		UPDATE T
		SET TotalDisks = (SELECT COUNT(D.diskId) FROM MMDiskHWInfo D (nolock) WHERE T.deviceId = D.deviceId AND  D.flags & 1 = 1 AND D.mountPathUsageType = 2)
		FROM @tbl T
		UPDATE T
		SET OfflineDisks = (SELECT COUNT(D.diskId) FROM MMDiskHWInfo D (nolock), MMHost H (nolock) WHERE T.deviceId = D.deviceId AND D.hostId = H.ClientId AND ( H.MmHostSoftState = 0 OR H.MmHostEnabled = 0) AND D.flags & 1 = 1 AND D.mountPathUsageType = 2)
		FROM @tbl T
	END
END
ELSE
BEGIN
	declare @deviceId INT = 0
	SELECT @deviceId = DeviceId FROM MMMountPathToStorageDevice WHERE MountPathId = @i_mountPathId
	IF EXISTS (SELECT 1 FROM MMDiskHWInfo (nolock) where deviceId = @deviceId AND flags & 1 = 1 )
	BEGIN
		INSERT INTO @tbl
		SELECT @deviceId,@i_mountPathId, N'',0,0,0,0
		UPDATE T
		SET dispFactor = S.DisperseFactor, redFactor = S.RedundancyFactor, StoragePoolName = S.StoragePoolName
		FROM @tbl T, MMSDSStoragePool S (nolock), MMMountPath MP(nolock), MMMountPathToStorageDevice MSD(nolock)
		WHERE T.deviceId = MSD.DeviceId
		AND MSD.MountPathId = MP.MountPathId
		AND MP.LibraryId = S.LibraryId
		UPDATE T
		SET TotalDisks = (SELECT COUNT(D.diskId) FROM MMDiskHWInfo D (nolock) WHERE T.deviceId = D.deviceId AND  D.flags & 1 = 1 AND D.mountPathUsageType = 2)
		FROM @tbl T
		UPDATE T
		SET OfflineDisks = (SELECT COUNT(D.diskId) FROM MMDiskHWInfo D (nolock), MMHost H (nolock) WHERE T.deviceId = D.deviceId AND D.hostId = H.ClientId AND ( H.MmHostSoftState = 0 OR H.MmHostEnabled = 0) AND D.flags & 1 = 1 AND D.mountPathUsageType = 2)
		FROM @tbl T
	END
END
SELECT * FROM @tbl
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2GetScaleOutStatusForHost')
	delete from GxQscripts where name = 'MMS2GetScaleOutStatusForHost'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetScaleOutStatusForHost')
	delete from GXDBVersions where aliasname = 'MMS2GetScaleOutStatusForHost'
GO

insert into GXDBVersions values(2, 'MMS2GetScaleOutStatusForHost',  '00010001000400050000', 'MMS2GetScaleOutStatusForHost', '00010001000400050000')
GO

