

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GetSIDBSubStoreInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2GetSIDBSubStoreInfo.sp,v $ $Id: MMS2GetSIDBSubStoreInfo.sp,v 1.9.34.4 2020/01/22 02:00:25 lviswambharan Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		SP: "MMS2GetSIDBSubStoreInfo"
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMS2GetSIDBSubStoreInfo')
BEGIN
	print '>>> Drop Stored Procedure: MMS2GetSIDBSubStoreInfo <<<'
	drop procedure MMS2GetSIDBSubStoreInfo
END
IF EXISTS (select * from GxQscripts where name='MMS2GetSIDBSubStoreInfo')
	delete from GxQscripts where name = 'MMS2GetSIDBSubStoreInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetSIDBSubStoreInfo')
	delete from GXDBVersions where aliasname = 'MMS2GetSIDBSubStoreInfo'
GO
print '... Creating Procedure: MMS2GetSIDBSubStoreInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2GetSIDBSubStoreInfo
-- ---------------------------------------------------------------
-- Function is used to lookup the client list using specified condition
-- ---------------------------------------------------------------
  @i_sidbStoreId integer
AS
  DECLARE @o_SIDBStoreId integer
  DECLARE @o_SubStoreId integer
  DECLARE @o_commCellId integer
  DECLARE @o_GroupNumber integer
  DECLARE @o_idxCacheId integer
  DECLARE @o_idxAccessPathId integer
  DECLARE @o_accessPath varchar(255)
  DECLARE @o_clientId integer
  DECLARE @o_clientName varchar(255)
  DECLARE @o_firstBackupTime integer
  DECLARE @o_flags integer
  DECLARE @o_totalDataSizeBytes bigint
  DECLARE @o_InstanceDataSizeBytes bigint
  DECLARE @o_Status integer
  DECLARE @o_LastAccessTime integer
  DECLARE @o_CreatedTime integer
  DECLARE @o_SealedTime integer
  DECLARE @o_Version integer
  DECLARE @o_SIDBSnapPath varchar(255)
  DECLARE @o_LastSnapTime integer
  DECLARE @o_origSubStoreId integer
  DECLARE @o_origCCId integer
  DECLARE @o_diskFreeThresholdMB integer
  DECLARE @o_diskFreeWarningThreshholdMB integer
  DECLARE @o_dataInterface varchar(64)
SET NOCOUNT ON
DECLARE @dataPathMATbl TABLE
(
  maId  int
)
INSERT INTO @dataPathMATbl
SELECT DISTINCT HostClientId FROM MMDataPath  WITH (NOLOCK)
WHERE (flag & (1 |2 |4)) = (1 |2 |4)
      AND copyId IN (
						SELECT	DISTINCT  AGC.id
						FROM	archGroupCopy AGC WITH (READUNCOMMITTED) INNER JOIN archCopySIDBStore CS WITH (READUNCOMMITTED) ON CS.copyId = AGC.id
						WHERE	CS.SIDBStoreId = @i_sidbStoreId
AND ((CS.Flags & 4) > 0)
AND ((AGC.dedupeFlags & 134217728)=0
					)
	)
SELECT	I.SIDBStoreId,
	I.SubStoreId,
	I.commCellId,
	I.GroupNumber,
	I.IdxCacheId,
	I.IdxAccessPathId,
	ISNULL((SELECT Path FROM IdxAccessPath WITH (NOLOCK) WHERE IdxAccessPathId = I.IdxAccessPathId), '') AS AccessPath,
	I.ClientId,
	ISNULL((SELECT Name FROM APP_Client WITH (NOLOCK) WHERE id = I.ClientId), '') AS ClientName,
	I.firstBackupTime,
	I.flags,
	I.TotalDataSizeBytes,
	I.InstancedDataSizeBytes,
	I.Status,
	I.LastAccessTime,
	I.CreatedTime,
	I.SealedTime,
	I.Version,
	I.SIDBSnapPath,
	I.LastSnapTime,
	I.origSubStoreId,
	I.ReconLevel,
	IC.DiskFreeThresholdMB,
	IC.DiskFreeWarningThreshholdMB,
	ISNULL((SELECT TOP 1 AR.destInterface FROM archPipeline AR WITH (NOLOCK) INNER JOIN @dataPathMATbl D ON AR.srcClientId = D.maId AND AR.destClientId = I.ClientId), '') AS DataInterface
FROM	IdxSIDBSubStore I WITH (NOLOCK), IdxCache IC WITH (NOLOCK)
WHERE	I.SIDBStoreId = @i_sidbStoreId
	AND I.IdxCacheId = IC.IdxCacheId
ORDER BY I.SubStoreId -- preserve order of creation
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2GetSIDBSubStoreInfo')
	delete from GxQscripts where name = 'MMS2GetSIDBSubStoreInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetSIDBSubStoreInfo')
	delete from GXDBVersions where aliasname = 'MMS2GetSIDBSubStoreInfo'
GO

insert into GXDBVersions values(2, 'MMS2GetSIDBSubStoreInfo',  '00010009003400040000', 'MMS2GetSIDBSubStoreInfo', '00010009003400040000')
GO

