

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GetResourceView.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2GetResourceView.sp,v $ $Id: MMS2GetResourceView.sp,v 1.2.294.2 2018/03/20 19:46:47 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2GetResourceView <<<'

IF EXISTS (select * from sysobjects where name='MMS2GetResourceView')
	drop procedure MMS2GetResourceView
IF EXISTS (select * from GxQscripts where name='MMS2GetResourceView')
	delete from GxQscripts where name = 'MMS2GetResourceView'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetResourceView')
	delete from GXDBVersions where aliasname = 'MMS2GetResourceView'
GO
print '... Creating Procedure: MMS2GetResourceView'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2GetResourceView
  @in_libraryId integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_mediaId integer
  DECLARE @o_MediaBarCode varchar(255)
  DECLARE @o_UniqueId varchar(255)
  DECLARE @o_driveId integer
  DECLARE @o_driveName varchar(255)
  DECLARE @o_driveStatus integer
  DECLARE @o_MMHostId integer
  DECLARE @o_clientId integer
  DECLARE @o_clientName varchar(255)
  DECLARE @o_netHostName varchar(255)
  DECLARE @o_drivePoolId integer
  DECLARE @o_masterPoolId integer
  DECLARE @o_JobId bigint
  DECLARE @o_Priority integer
  DECLARE @o_InUse integer
  DECLARE @o_DriveMountStatus integer
  DECLARE @o_ReserveBitMask integer
  DECLARE @o_ReleaseTime integer
  DECLARE @o_DriveNumber integer
  DECLARE @o_LogicalRelease integer
  DECLARE @o_OpPhase integer
  DECLARE @o_StoragePolicyId integer
  DECLARE @o_StoragePolicyName NVARCHAR(255)
	SET NOCOUNT ON
	if object_id('tempdb.dbo.#tmpResourceView') is not null DROP TABLE #tmpResourceView
	create table #tmpResourceView(	MediaId			integer,
									MediaBarCode	varchar(255),
									UniqueId		varchar(255),
									DriveId			integer,
									DriveName		varchar(255),
									DriveStatus		integer,
									MountStatus		integer,
									clientId		integer,
									clientName		varchar(255),
									net_hostName	varchar(255),
									DrivePoolId		integer,
									MasterPoolId	integer,
									JobId_h			integer,
									JobId_l			integer,
									Priority		integer,
									InUse			integer,
									ReservebitMask	integer,
									ReleaseTime		integer,
									DriveNumber		integer,
									LogicalRelease	integer,
									OpPhase			integer,
									CopyId			integer,
									SPId			integer,
									SPName			nvarchar(255))
	insert into #tmpResourceView
	select MR.MediaId, '', '', MR.DriveId, '', 0, 0,
	MR.ClientId, '', '', MR.DrivePoolId, MR.MasterPoolId,
	MRJ.JobId_h, MRJ.JobId_l, MRJ.Priority, MRJ.InUse, MRJ.ReserveBitMask,
	MRJ.ReleaseTime, 0, MR.LogicalRelease, 0, CopyId, 0, ''
	from MMResource as MR, MMResourceToJob as MRJ, MMMasterPool as MMP
	where MR.ReservationId = MRJ.ReservationId and MR.MasterPoolId = MMP.MasterPoolId
	and MMp.LibraryId = @in_libraryId
	insert into #tmpResourceView
	select distinct MD.MediaId, '', '', MD.DriveId, '', 0, md.MountStatus, 0, '', '',
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, MD.OpPhase, 0, 0, ''
	from MMDrive as MD, MMMasterPool as MMP
	where MD.DriveId not in(select DriveId from #tmpResourceView)
	and MD.DriveId <> 0
	and MD.MasterPoolId = MMP.MasterPoolId and MMP.libraryId = @in_libraryId
	update #tmpResourceView
	set LogicalRelease = MR.LogicalRelease
	from MMResource as MR, #tmpResourceView as tt
	where MR.DriveId = tt.DriveId
	update #tmpResourceView set ClientId = isnull(
	(select ClientId from MMDriveController where DriveControllerActive = 1
	and DriveId = #tmpResourceView.DriveId), 0)
	where ClientId = 0
	update #tmpResourceView set MediaBarCode = MM.BarCode, UniqueId = MM.UniqueId
	from MMMedia as MM, #tmpResourceView as tt
	where MM.MediaId = tt.MediaId and tt.MediaId <> 0
	update #tmpResourceView set DriveName = MD.AliasName,MountStatus = MD.MountStatus,
	DriveStatus = (MD.DriveSoftState & MD.DriveEnabled & ~MD.DriveBroken & ~MD.CleaningRequired),
	DriveNumber = MD.DriveNumber, OpPhase = MD.OpPhase
	from MMDrive as MD, #tmpResourceView as tt
	where MD.DriveId = tt.DriveId and tt.DriveId <> 0
	update #tmpResourceView set clientId = cl.id, clientName = cl.name,
	net_hostName = cl.net_hostName
	from MMHost as MH, APP_Client as cl, #tmpResourceView as tt
	where MH.clientid = tt.clientid and MH.clientId = cl.id and tt.clientid <> 0
	update #tmpResourceView set SPId = ag.id, SPName = ag.name
	from archGroupCopy as AGC, archGroup as AG, #tmpResourceView as tt
	where tt.CopyId > 0 AND tt.CopyId = AGC.Id AND AGC.ArchGroupId = ag.id
	select tt.MediaId, RTRIM(tt.MediaBarCode), RTRIM(tt.UniqueId), tt.DriveId, RTRIM(tt.DriveName), tt.DriveStatus,
	tt.clientid, tt.ClientId, RTRIM(tt.ClientName), RTRIM(tt.net_hostname), tt.DrivePoolId, tt.MasterPoolId,
	JobId = convert(bigint,tt.JobId_h)*2147483648+convert(bigint,tt.JobId_l),
	tt.Priority, tt.InUse, tt.MountStatus, tt.ReservebitMask, tt.ReleaseTime, tt.DriveNumber, tt.LogicalRelease,
	tt.OpPhase, tt.SPId, tt.SPName
	from #tmpResourceView as tt
	order by tt.DriveNumber, JobId
	drop table #tmpResourceView
	SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2GetResourceView')
	delete from GxQscripts where name = 'MMS2GetResourceView'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetResourceView')
	delete from GXDBVersions where aliasname = 'MMS2GetResourceView'
GO

insert into GXDBVersions values(2, 'MMS2GetResourceView',  '00010002029400020000', 'MMS2GetResourceView', '00010002029400020000')
GO

