

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GetRemovableMediaPruningInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2GetRemovableMediaPruningInfo.sp,v $ $Id: MMS2GetRemovableMediaPruningInfo.sp,v 1.1.2.4 2018/11/01 19:37:06 anarulkar Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 	Cursor: "MMS2GetRemovableMediaPruningInfo"			|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMS2GetRemovableMediaPruningInfo')
BEGIN
	print '>>> Drop Stored Procedure: MMS2GetRemovableMediaPruningInfo <<<'
	drop procedure MMS2GetRemovableMediaPruningInfo
END
IF EXISTS (select * from GxQscripts where name='MMS2GetRemovableMediaPruningInfo')
	delete from GxQscripts where name = 'MMS2GetRemovableMediaPruningInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetRemovableMediaPruningInfo')
	delete from GXDBVersions where aliasname = 'MMS2GetRemovableMediaPruningInfo'
GO
print '... Creating Procedure: MMS2GetRemovableMediaPruningInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MMS2GetRemovableMediaPruningInfo
-- The following two lines indicate, in order, parameters that will be
--  expected in the "setValues()" method, as well as the order in which
--  they will be provided as arguments to the SQLSTRING command
  @i_dummy integer
AS
--	The next few lines are the columns, in order, that will be in the
--  result set for this cursor.  EXTREME CAUTION must be exercised to
--  ensure that these match up with the result set in terms of type, size,
--  and order!
  DECLARE @o_VolumeId integer
  DECLARE @o_VolumeName varchar(112)
  DECLARE @o_OMLVersion integer
  DECLARE @o_HostId integer
  DECLARE @o_AFileId integer
  DECLARE @o_ArchChunkId integer
  DECLARE @o_Folder varchar(1024)
  DECLARE @o_VolOrigCCId integer
  DECLARE @o_mediaTypeId integer
-- These lines represent the actual SQL code that will get executed.  Note
-- The "printf" style substitutions.  These should match up exactly with
-- :PARAM input lines
--This will turn off message: "xxx rows affected".
	SET NOCOUNT ON
    CREATE TABLE #RemovableMediaVolume
    (
	MediaId		INT,
	VolumeId 	INT,
VolumeName	VARCHAR(112),
	OMLVersion      INT,
	HostId		INT,
Folder		VARCHAR(64),
	MediaTypeId	INT
    )
    IF NOT EXISTS (SELECT 1 FROM MMConfigs WITH (READUNCOMMITTED) WHERE (name = 'MMS2_CONFIG_ENABLE_REMOVABLE_MEDIA_PRUNING') AND value > 0)
    BEGIN
	-- Nothing to do. Just return
	SELECT 0, '', 0, 0, 0, 0, '', 0, 0
	RETURN
    END
    DECLARE @NonDedupBatchCount INT = ISNULL((SELECT value from MMConfigs WHERE name = 'MMS2_CONFIG_NON_DEDUP_PRUNE_BATCH_SIZE'), 0)
    -- There will be less volumes with this type, so get the vols first then filter DAF with those vols.
    INSERT INTO #RemovableMediaVolume
    SELECT M.MediaId, V.VolumeId, V.VolumeName, V.OMLVersion, 0, '', M.MediaTypeId
    FROM MMVolume V WITH (READUNCOMMITTED)
	INNER JOIN MMMedia M WITH (READUNCOMMITTED) ON V.MediaId = M.MediaId
WHERE M.MediaTypeId >= 11001 AND M.MediaTypeId <= 11999
	AND V.SIDBStoreId = 0
    -- Get the folder from the drive controller and also the media agent
    UPDATE T
    SET HostId = DC.ClientId,
    Folder     = DC.AccessPath
    FROM #RemovableMediaVolume T
	INNER JOIN MMDrive D WITH (READUNCOMMITTED) ON T.MediaId = D.MediaId
	INNER JOIN MMDrivePool DP WITH (READUNCOMMITTED) ON D.MasterPoolId = DP.MasterPoolId
	INNER JOIN MMDriveController DC WITH (READUNCOMMITTED) ON DP.DrivePoolId = DC.DrivePoolId AND DC.DriveId = D.DriveId
	LEFT OUTER JOIN APP_VMToPMMap MAP WITH (READUNCOMMITTED) ON MAP.VMClientId = DC.ClientId
	INNER JOIN SimInstalledPackages PKG WITH (READUNCOMMITTED) ON PKG.ClientId = ISNULL(MAP.PMClientId, DC.ClientId)
	INNER JOIN APP_Client CLIENT WITH (READUNCOMMITTED) ON CLIENT.id = ISNULL(MAP.PMClientId, DC.ClientId)
WHERE (CLIENT.releaseId > 16) OR ((CLIENT.releaseId = 16)  AND (PKG.HighestSP >= 11))
    -- Media Agent has to be SP11 or higher for pruning to work.
    -- Clean up media which is not in drive
    DELETE T
    FROM #RemovableMediaVolume T
    WHERE T.HostId = 0
    -- Get the pruning info from MMDeletedAF for the volumes identified as removable media.
    SELECT TOP (@NonDedupBatchCount) DAF.VolumeId, RV.VolumeName, RV.OMLVersion, RV.HostId, DAF.archFileId, DAF.ArchChunkId,  RV.Folder,
	(CASE WHEN DAF.chunkCommCellId <> 0 THEN DAF.chunkCommCellId ELSE DAF.commCellId END), RV.MediaTypeId
    FROM MMDeletedAF DAF WITH (READUNCOMMITTED)
	   INNER JOIN #RemovableMediaVolume RV WITH (READUNCOMMITTED) ON DAF.VolumeId = RV.VolumeId
    WHERE DAF.archChunkId > 0
    ORDER BY ABS(DAF.FailureErrorCode) ASC, RV.HostId ASC
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2GetRemovableMediaPruningInfo')
	delete from GxQscripts where name = 'MMS2GetRemovableMediaPruningInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetRemovableMediaPruningInfo')
	delete from GXDBVersions where aliasname = 'MMS2GetRemovableMediaPruningInfo'
GO

insert into GXDBVersions values(2, 'MMS2GetRemovableMediaPruningInfo',  '00010001000200040000', 'MMS2GetRemovableMediaPruningInfo', '00010001000200040000')
GO

