

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GetPreferredDataPath.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2GetPreferredDataPath.sp,v $ $Id: MMS2GetPreferredDataPath.sp,v 1.49.2.21.12.1 2021/05/10 20:41:06 cliu Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MMS2GetPreferredDataPath')
BEGIN
	print '>>> Drop Stored Procedure: MMS2GetPreferredDataPath <<<'
	drop procedure MMS2GetPreferredDataPath
END
IF EXISTS (select * from GxQscripts where name='MMS2GetPreferredDataPath')
	delete from GxQscripts where name = 'MMS2GetPreferredDataPath'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetPreferredDataPath')
	delete from GXDBVersions where aliasname = 'MMS2GetPreferredDataPath'
GO
print '... Creating Procedure: MMS2GetPreferredDataPath'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MMS2GetPreferredDataPath
  @i_JobId_l int,
  @i_JobId_h int,
  @i_CopyId int,
  @i_ClientId int,
  @i_AppId int,
  @i_PreferAvailableMA int = 0,
  @i_IncludePowerManagedMA int = 0, 
  @i_Flags int = 0
AS
  DECLARE @o_DrivePoolId integer;
  DECLARE @o_ErrorCodeVal integer;
  DECLARE @o_WarningBitMask integer;
-- Errors: (MMErrors)
-- Error 331: No datapaths in COpy/Selected for SC
-- Error 332: Default Datapath for copyId could not be found.
-- Warning bit 	- 0 (=1) - Could not determine AppId
-- 		- 1 (=2) - APP_iDAType does not require indexing, why is this sp being called?
--		- 2 (=4) - Datapath retrieved from resource manager tables is offline..
--		- 3 (=8) - All Datapaths that can be used are offline
-- set input variable for debugging (will be filtered out by build)
-- 								DECLARE @i_JobId_l  INTEGER
--                DECLARE @i_JobId_h INTEGER
--                DECLARE @i_CopyId	INTEGER
--                DECLARE @i_ClientId	INTEGER
--                DECLARE @i_AppId	INTEGER
--                SET @i_JobId_l = 5157
--                SET @i_JobId_h = 0
--                SET @i_CopyId = 9
--                SET @i_ClientId = 2
--                SET @i_AppId = 0
-- end set input variables
DECLARE @l_resulting_drivePoolId Integer
SET @l_resulting_drivePoolId = 0
DECLARE @l_ErrorCode	Integer
SET @l_ErrorCode = 0
DECLARE @l_WarningBitMask Integer
SET @l_WarningBitMask  = 0
DECLARE @l_BackupClientId Integer
SET @l_BackupClientId = @i_ClientId
DECLARE @l_UseSCDataPaths Integer
SET @l_UseSCDataPaths = 0
DECLARE @l_IsIndexingBackup Integer
SET @l_IsIndexingBackup = 1
DECLARE @l_UseSiloDatapath Integer
SET @l_UseSiloDatapath = 0
-- Default to data type - these are the only types of jobs requiring any indexing
DECLARE @l_DataType Integer
SET @l_DataType = 1
DECLARE @defaultCCId INT = 2
IF (@i_JobId_l > 0) OR (@i_JobId_h > 0)
BEGIN
	DECLARE @JobBasedDataPaths table (MediaAgentId int, LibraryId int, DrivePoolId int, SpareGroupId int)
	insert into @JobBasedDataPaths
	EXEC MMGetJobDataPathOptions @i_JobId_l
	DELETE FROM @JobBasedDataPaths WHERE MediaAgentId = 0 AND LibraryId = 0 AND DrivePoolId = 0 AND SpareGroupId = 0
	IF EXISTS (SELECT * FROM @JobBasedDataPaths)
	BEGIN
		DECLARE @FilterDataPath table (DataPathId int, MediaAgentId int, LibraryId int, DrivePoolId int, SpareGroupId int)
		insert into @FilterDataPath
		SELECT DISTINCT DP.DatapathId, DP.HostClientId, mp.LibraryId, DP.DrivePoolId, DP.SpareGroupId
		FROM MMDataPath DP, MMDrivePool p, MMMasterPool mp
		WHERE DataPathId IN (SELECT DataPathId FROM MMDataPath WHERE CopyId = @i_CopyId)
		AND	DP.DrivePoolId = p.DrivePoolId AND p.MasterPoolId = mp.MasterPoolId
		IF EXISTS (SELECT * FROM @JobBasedDataPaths WHERE MediaAgentId > 0)
		BEGIN
			DELETE @FilterDataPath WHERE MediaAgentId NOT IN (SELECT MediaAgentId FROM @JobBasedDataPaths WHERE MediaAgentId > 0)
		END
		IF EXISTS (SELECT * FROM @JobBasedDataPaths WHERE LibraryId > 0)
		BEGIN
			DELETE @FilterDataPath WHERE LibraryId NOT IN (SELECT LibraryId FROM @JobBasedDataPaths WHERE LibraryId > 0)
		END
		IF EXISTS (SELECT * FROM @JobBasedDataPaths WHERE DrivePoolId > 0)
		BEGIN
			DELETE @FilterDataPath WHERE DrivePoolId NOT IN (SELECT DrivePoolId FROM @JobBasedDataPaths WHERE DrivePoolId > 0)
		END
		IF EXISTS (SELECT * FROM @JobBasedDataPaths WHERE SpareGroupId > 0)
		BEGIN
			DELETE @FilterDataPath WHERE SpareGroupId NOT IN (SELECT SpareGroupId FROM @JobBasedDataPaths WHERE SpareGroupId > 0)
		END
		SELECT TOP 1 @l_resulting_drivePoolId = DrivePoolId
FROM MMDataPath Where DataPathId in (select datapathId from @FilterDataPath) And CopyId = @i_CopyId AND (Flag & 16) = 0
		if @l_resulting_drivePoolId > 0
		BEGIN
			-- Found
			goto EXITOK
		END
	END
END
DECLARE @isUsePreferredDP integer
SET @isUsePreferredDP = 1
SELECT @isUsePreferredDP = 1-sign(isnull(flags, 0) & (512 | 8 | 16) )
FROM	ArchGroupCopy WITH (NOLOCK) WHERE	id = @i_CopyId
-- now get appId, if not supplied
DECLARE @l_AppId Integer
SET @l_AppId = case
		 when @i_AppId > 0 then @i_AppId
		 else ISNULL (
		 (
			select applicationId
			from JMBkpJobInfo
			where jobId = @i_JobId_l
			and commCellId = @defaultCCId
		  ), 0)
		end
-- is Indexing
SET @l_IsIndexingBackup = dbo.IsIndexingApp(@l_AppId)
IF (@l_IsIndexingBackup  = 0)
BEGIN
	SET @l_WarningBitMask  = @l_WarningBitMask  | 2
END
-- #1 - check if there is already a reservation for this jobId
IF (@i_JobId_l > 0) OR (@i_JobId_h > 0)
BEGIN
	-- JM calls this proc at starting of every phase with input @i_AnyAvailableMA set to 1
	-- When this input is  set to 1 we return reserved MA or any available MA.
	-- This returned MA will be set as current index MA in job options
	-- We should use this MA for index from all modules (ida, dsbackup) in that phase.
	-- So if input is 0 always return the current index MA from job options even if it's offline.
	-- We should restart the phase when current index MA goes offline in middle of phase.
	DECLARE @l_currentIndexMA	Integer = 0
	SELECT 	@l_currentIndexMA = CN.id
	FROM 	JMJobOptions J WITH(READUNCOMMITTED), App_Client CN WITH(READUNCOMMITTED)
	WHERE 	J.jobId = @i_JobId_l
	AND		J.commCellId = @defaultCCId
AND		J.attributeId = 68
	AND		J.attributeValueInt = CN.id
	IF @i_PreferAvailableMA = 0 AND @l_currentIndexMA > 0
	BEGIN
		-- MA may not be part of copy datapath list for direct backups to cloud from client.
		-- So check all drivepools of the datapath library
		SELECT TOP 1 @l_resulting_drivePoolId = DPool.DrivePoolId
		FROM 	MMDataPath AS DPath, MMDrivePool AS H2DP, MMDrivePool DPool
		WHERE	DPath.CopyId = @i_CopyId
		AND 	H2DP.DrivePoolId = DPath.DrivePoolId
		AND		H2DP.MasterPoolId = DPool.MasterPoolId
		AND 	DPool.ClientId = @l_currentIndexMA
		ORDER BY (case when H2DP.ClientId = @l_currentIndexMA then 0 else 1 end),
				DPath.Priority
		IF @l_resulting_drivePoolId > 0
			GOTO EXITOK
		--
		-- MA always passes data type as data to getMediaAgent call
		-- if index MA is not part of the input copy then we fallback to reserved MA
		-- but for thirdparty log backups index MA will be set before reservation and it may be different than reserved MA.
		--	1.	The first GetMediaAgent call from client side will get one of the MA from the data paths of log storage policy and the same will be set as index MA in job options.
		--	2.	Reservation can happen on any of the MA but we still return the index MA for all GetMediaAgent from job option.
		--	3.	But MA side GetMediaAgent call uses data storage policy so if the index MA is not part of the data storage policy then we return reserved MA, this causes different index MA between client and MA.
		-- To cover this case check for index MA on the reserved copy
		--
		SELECT TOP 1 @l_resulting_drivePoolId = DPool.DrivePoolId
		FROM 	MMResource AS MR, MMResourceToJob AS MRJ,
				MMDataPath AS DPath, MMDrivePool DPool
		WHERE	MRJ.ReservationId = MR.ReservationId
				AND MRJ.JobId_l = @i_JobId_l
				AND MRJ.JobId_h = @i_JobId_h
				AND DPath.CopyId = MR.CopyId
				AND DPath.DrivePoolId = DPool.DrivePoolId
				AND DPool.ClientId = @l_currentIndexMA
		ORDER BY MRJ.RCID DESC
		IF @l_resulting_drivePoolId > 0
			GOTO EXITOK
	END
	SELECT 	TOP 1 @l_resulting_drivePoolId = MR.DrivePoolId
	FROM 	MMResource AS MR,
			MMResourceToJob AS MRJ
	WHERE 	MRJ.ReservationId = MR.ReservationId AND
			MRJ.JobId_l = @i_JobId_l AND
			MRJ.JobId_h = @i_JobId_h
	ORDER BY case when MR.clientId = @l_currentIndexMA then 0 else 1 end, RCID DESC
	IF @l_resulting_drivePoolId > 0
	BEGIN
		-- check the index cache for the current datapath to see if it is online
		IF ( @l_IsIndexingBackup = 1)
		BEGIN
			DECLARE @l_MediaAgentId INT
			DECLARE @l_MAReleaseId INT
			DECLARE @l_IsIdxCacheOnline INT
			SET @l_IsIdxCacheOnline = 0
			SELECT 	@l_MediaAgentId = C.Id, @l_MAReleaseId = C.ReleaseId
			FROM 	App_Client C WITH(READUNCOMMITTED), MMDrivePool DP WITH(READUNCOMMITTED)
			WHERE 	C.id = DP.clientId AND DP.DrivePoolId = @l_resulting_drivePoolId
			--If MA is 11.0 or later then check the index cache status prop in app_clientProp table
			IF @l_MAReleaseId >= 16
				AND EXISTS(SELECT 1 FROM App_ClientProp WITH(READUNCOMMITTED) WHERE componentNameId = @l_MediaAgentId AND attrName = 'Idx: cache enabled')
			BEGIN
				SELECT @l_IsIdxCacheOnline = CONVERT(INT, attrVal) FROM App_ClientProp WITH(READUNCOMMITTED) WHERE componentNameId = @l_MediaAgentId AND attrName = 'Idx: cache enabled'
			END
			ELSE
			BEGIN
				SELECT 	@l_IsIdxCacheOnline = ISNULL(IC.SoftState, 0)
				FROM  	IdxCache AS IC, IdxAccessPath AS IAP, MMDrivePool AS H2DP
				WHERE 	H2DP.DrivePoolId = @l_resulting_drivePoolId AND
							IAP.ClientId = H2DP.ClientId AND IAP.Enabled = 1 AND IAP.SoftState = 1 AND
							IC.IdxCacheId = IAP.IdxCacheId AND IC.Enabled = 1 AND IC.SoftState = 1 AND
							IC.IdxCacheType = 1
			END
			IF 1 <> @l_IsIdxCacheOnline
			BEGIN
				SET @l_WarningBitMask  = @l_WarningBitMask  | 4
				-- 4 means datapath in resource tables is offline
				-- According to Amey, we should return this datapath anyway.
			END
		END
		GOTO EXITOK
	END
END
-- with the AppId, determine the backup host (proxyhost or not) and if we are using subclient datapaths
-- and if this is a backup requiring indexing
DECLARE @nas_proxy_clientId Integer = 0
IF (@l_AppId > 0)
BEGIN
	-- Backup host
	IF EXISTS(SELECT id from APP_SubClientProp WITH (NOLOCK) where attrName = N'Proxy Host' and modified = 0 and componentnameId = @l_AppId )
	BEGIN
		SELECT @l_BackupClientId = id from APP_Client WITH (NOLOCK) where net_hostname = (SELECT TOP 1 attrVal from APP_SubClientProp WITH (NOLOCK) where componentnameId = @l_appId AND attrName = N'Proxy Host' and modified = 0 ORDER BY id DESC)
	END
	ELSE
	BEGIN
	   SELECT @l_BackupClientId = clientid from  APP_Application WITH (NOLOCK) where id = @l_AppId
	END
	IF EXISTS (SELECT 1 FROM APP_Client client WITH (NOLOCK), APP_Application app WITH (NOLOCK)
				WHERE app.Id = @l_AppId AND app.ClientId = client.Id
AND		(client.Status & 0x0080) > 0
			)
	BEGIN
		-- find the nas proxy clientId defined on subclient property
		IF EXISTS (SELECT id from APP_SubClientProp WITH (NOLOCK) where attrName = N'Turbo NAS Proxy Client' and modified = 0 and componentnameId = @l_AppId)
		BEGIN
			SELECT @l_BackupClientId = ISNULL(CONVERT(INT, attrVal), 0)
			FROM	App_subclientProp WITH (NOLOCK)
			WHERE	componentnameId = @l_AppId AND attrName = N'Turbo NAS Proxy Client' and modified = 0
			SET @nas_proxy_clientId = @l_BackupClientId
		END
		-- find the nas proxy clientId if it is set on client
		ELSE IF EXISTS (SELECT attrVal FROM App_Idaprop WITH (NOLOCK)
					WHERE componentNameId in (
								SELECT TOP 1 a.Id FROM App_IdaName a WITH (NOLOCK), App_Application b WITH (NOLOCK)
								WHERE	b.Id = @l_AppId -- AND b.ClientId = @i_clientId
								AND		a.ClientId = b.ClientId AND a.AppTypeId = b.AppTypeId
								)
					AND attrName = 'FPOLICY PRIMARY CLIENT'
					AND Modified = 0
					)
		BEGIN
			SELECT @l_BackupClientId = ISNULL(CONVERT(INT, attrVal), 0)
			FROM App_Idaprop WITH (NOLOCK)
			WHERE componentNameId in (
						SELECT TOP 1 a.Id FROM App_IdaName a WITH (NOLOCK), App_Application b WITH (NOLOCK)
						WHERE	b.Id = @l_AppId -- AND b.ClientId = @i_clientId
						AND		a.ClientId = b.ClientId AND a.AppTypeId = b.AppTypeId
						)
			AND attrName = 'FPOLICY PRIMARY CLIENT'
			AND Modified = 0
			SET @nas_proxy_clientId = @l_BackupClientId
		END
	END
	-- Subclient Datapaths
		-- Subclient Datapaths
	DECLARE @ArchGroupId INT
	SET @ArchGroupId = 0
	SELECT @ArchGroupId = ArchGroupId FROM ArchGroupCopy WITH (NOLOCK) WHERE Id = @i_CopyId
	IF EXISTS (SELECT Id FROM App_Application WITH (NOLOCK) WHERE Id = @l_appId AND dataArchGrpID = @ArchGroupId)
	BEGIN
		SET @l_UseSCDataPaths =
			isnull
						(
							( SELECT TOP 1 attrVal from APP_SubClientProp WITH (NOLOCK)
							  where componentnameId = @l_appId AND
							  attrName = N'Full Failover to SP dataPaths' and modified = 0
							  order by Id DESC
							), 0
						)
	END
	ELSE IF EXISTS (SELECT a.Id FROM App_Application a WITH (NOLOCK), ArchGroup b WITH (NOLOCK), ArchGroupCopy c WITH (NOLOCK)
					WHERE a.Id = @l_appId AND a.dataArchGrpId = b.Id
					AND	b.IncrSP = c.ArchGroupId AND c.Id = @i_CopyId)
	BEGIN
		SET @l_UseSCDataPaths =
			isnull
						(
							( SELECT TOP 1 attrVal from APP_SubClientProp WITH (NOLOCK)
							  where componentnameId = @l_appId AND
							  attrName = N'Non-Full Failover to SP dataPaths' and modified = 0
							  order by Id DESC
							), 0
						)
	END
	IF @l_UseSCDataPaths > 0
	AND NOT EXISTS (select * from App_AppToDataPath with (readuncommitted) where ComponentNameId = @l_AppId
and DataPathId in (select DataPathId from MMDataPath with (readuncommitted) where CopyId = @i_CopyId and (flag & 16) = 0))
	BEGIN
		SET @l_UseSCDataPaths = 0
	END
	-- note that the descriptive text is wrong... It is actually reversed.
	-- text should be - Override SP datapaths
END ELSE
BEGIN
	SET @l_WarningBitMask  = @l_WarningBitMask  | 1
	-- could not determine AppId, but continue anyway
END
-- get datapaths - even ones not enabled (needed to figure out Index)
DECLARE @l_DPList TABLE (
				DataPathID Integer,
				DrivePoolId Integer,
				DPFlags Integer,
				Priority Integer,
				ClientId Integer,
				IndexCacheId Integer,
				isLANFree	Integer,
				ClientVersion	Integer,
				isPreferredMAGroup integer default 0)
DECLARE @l_NoOfDataPaths INTEGER
IF (@l_UseSCDataPaths = 0)
BEGIN
	INSERT INTO @l_DPList (DataPathId, DrivePoolId, DPFlags, Priority, ClientId, IndexCacheId, isLANFree, ClientVersion)
	SELECT DPath.DataPathId, DPath.DrivePoolId, DPath.Flag, DPath.Priority, H2DP.ClientId, IDXAP.IdxCacheId,0, CL.ReleaseId
	FROM 	MMDataPath AS DPath, MMDrivePool AS H2DP, APP_Client as CL, IdxAccessPath AS IDXAP  INNER JOIN IdxCache AS IC ON IC.IdxCacheId = IDXAP.IdxCacheId
	WHERE	DPath.CopyId = @i_CopyId AND
		H2DP.DrivePoolId = DPath.DrivePoolId AND IDXAP.ClientId = H2DP.ClientId AND H2DP.ClientId = CL.id AND IC.IdxCacheType = 1 AND
(DPath.Flag & 16) = 0
AND (DPath.Flag & 4) > 0
	ORDER BY DPath.Priority
END ELSE
BEGIN
	INSERT INTO @l_DPList (DataPathId, DrivePoolId, DPFlags, Priority, ClientId, IndexCacheId, isLANFree, ClientVersion)
	SELECT 	DPath.DataPathId, DPath.DrivePoolId, DPath.Flag, A2DP.precedence, H2DP.ClientId, IDXAP.IdxCacheId, 0, CL.releaseId
	FROM 	MMDataPath AS DPath, MMDrivePool AS H2DP, APP_Client as CL, IdxAccessPath AS IDXAP  INNER JOIN IdxCache AS IC ON IC.IdxCacheId = IDXAP.IdxCacheId,
		APP_AppToDataPath AS A2DP
	WHERE	DPath.CopyId = @i_CopyId AND
		A2DP.dataType = @l_DataType AND A2DP.ComponentNameId = @l_AppId AND
		H2DP.DrivePoolId = DPath.DrivePoolId AND IDXAP.ClientId = H2DP.ClientId AND H2DP.ClientId = CL.id AND
		A2DP.DataPathId = DPath.DataPathId AND IC.IdxCacheType = 1 AND
(DPath.Flag & 16) = 0
AND (DPath.Flag & 4) > 0
	ORDER BY A2DP.precedence
END
SET @l_NoOfDataPaths = @@ROWCOUNT
IF ( @l_NoOfDataPaths  = 0)
BEGIN
SET @l_ErrorCode = 331
	GOTO EXITWITHERROR
END
IF ( @i_Flags & 1 = 1)
BEGIN
	DECLARE @l_clientOsGroup NVARCHAR(1024)
	SET @l_clientOsGroup = ISNULL(( SELECT APTYP.osGroup
							FROM APP_Application APP
							INNER JOIN APP_AppTypeGroups APTYP ON APP.appTypeId = APTYP.appTypeId
							AND @l_AppId > 0 AND APP.id = @l_AppId ), '')
	IF @l_clientOsGroup <> ''
	BEGIN
		DELETE @l_DPList
		FROM @l_DPList DP INNER JOIN APP_Client CL ON CL.id = DP.ClientId
		INNER JOIN simOperatingSystem simOS ON simOS.id = CL.simOperatingSystemId
		WHERE simOS.Type <> @l_clientOsGroup
	END
	ELSE
	BEGIN
SET @l_ErrorCode = 20177
		GOTO EXITWITHERROR
	END
	IF NOT EXISTS (SELECT 1 FROM @l_DPList)
	BEGIN
SET @l_ErrorCode = 20178
		GOTO EXITWITHERROR
	END
END
-- The SILO datapath should only be used for SILO backup
-- One exception is for secondary silo copy. It will behave like auxcopy and has no silo data paths.
IF @l_AppId > 0 AND EXISTS (SELECT id FROM archGroupCopy WHERE siloAppId = @l_AppId)
AND EXISTS (SELECT id FROM archGroupCopy WHERE Id = @i_CopyId AND (extendedFlags & 8) = 0)
	SET @l_UseSiloDatapath = 1
/*
IF @l_UseSiloDatapath = 1
BEGIN
DELETE FROM @l_DPList WHERE (DPFlags & 8) = 0
END
ELSE
DELETE FROM @l_DPList WHERE (DPFlags & 8) <> 0
*/
-- Index shared means all the Media Agents in the available data paths are using the same IdxCache or the same catalog server
DECLARE @l_isIndexShared INTEGER
SET @l_isIndexShared = case
			  when (SELECT COUNT(Distinct IndexCacheId) FROM @l_DPList) > 1 then 0
			  else 1
			end
-- If newer Media Agent exists, remove the Media Agent from early version.
declare @currentMAReleaseId int
set @currentMAReleaseId = 0
select @currentMAReleaseId = max(ClientVersion) from @l_DPList
IF @l_IsIndexingBackup = 1
AND @l_isIndexShared = 1
BEGIN
	DELETE @l_DPList WHERE ClientVersion < @currentMAReleaseId
END
-- If the job requires index, we cannot use 9.0 MA or earlier for 10.0 clients.
IF @l_IsIndexingBackup = 1
AND @l_BackupClientId > 0
-- Skip the version check for NAS apptype CV_APPTYPE_NAS_FS, UNUSED_CV_APPTYPE_88 like backup reservation logic
AND NOT EXISTS (SELECT ID FROM APP_Application WITH (NOLOCK) WHERE ID = @l_AppId AND AppTypeId IN (13, 88))
-- Make sure the job doesn't use NAS proxy
AND @nas_proxy_clientId = 0
-- Skip the version check for SILO restores (where jobId is 0)
AND (@i_JobId_l > 0 OR @i_JobId_h > 0)
BEGIN
	declare @clientReleaseId int
	set @clientReleaseId = 0
	select @clientReleaseId = ReleaseId from App_Client with (readuncommitted) where Id = @l_BackupClientId
	IF @clientReleaseId > 14 /* 9.0 RELEASE ID */
	BEGIN
		DELETE @l_DPList WHERE ClientVersion < @clientReleaseId
		IF NOT EXISTS (SELECT * FROM @l_DPList)
		BEGIN
SET @l_ErrorCode = 20012
			GOTO EXITWITHERROR
		END
	END
END
-- For NAS backup job, make sure the index MA have write access to the resources.
-- Since the selected Media Agent will be used for backup later
IF @l_IsIndexingBackup = 1
AND @l_BackupClientId > 0
AND EXISTS (SELECT ID FROM APP_Application WITH (NOLOCK) WHERE ID = @l_AppId AND AppTypeId IN (13, 88))
AND (@i_JobId_l > 0 OR @i_JobId_h > 0)
AND EXISTS (select value from MMConfigs where name = 'MMCONFIG_RESOURCEMANAGER_USE_SAME_MA_FOR_INDEX_AND_BACKUP_IN_NASBACKUP' and value = 1)
BEGIN
	DELETE	@l_DPList
	FROM	@l_DPList list, MMDrivePool dp WITH (NOLOCK)
	WHERE	list.DrivePoolId = dp.DrivePoolId AND dp.DrivePoolType = 10001
	AND		NOT EXISTS (
				SELECT	DISTINCT mp.MountPathId
				FROM	MMMountPath mp WITH (NOLOCK) LEFT JOIN	MMMountPathToStorageDevice device WITH (NOLOCK) ON mp.MountPathId = device.MountPathId
				WHERE	dp.MasterPoolId = mp.MasterPoolId
				AND		mp.IsEnabled = 1
				AND		mp.IsOffline = 0
				AND		mp.MaxConcurrentWriters > 0
				AND		( device.MountPathId IS NULL OR device.deviceId = 0
						OR EXISTS (
							SELECT	1
							FROM	MMDeviceController controller WITH (NOLOCK)
							WHERE	device.DeviceId = controller.DeviceId
							AND		dp.ClientId = controller.ClientId
							AND		controller.DeviceControllerEnabled = 1
							AND		controller.DeviceAccessible = 1
AND		controller.DeviceAccessType & 2 > 0
						))
			)
	IF NOT EXISTS (SELECT * FROM @l_DPList)
	BEGIN
SET @l_ErrorCode = 463
		GOTO EXITWITHERROR
	END
END
-- remove disabled paths and paths where the index cache accesspath is offline or the mediaagent is offline
-- HOST_STATUS_POWER_MANAGED_VM = 7
DELETE @l_DPList
FROM @l_DPList AS DPList, MMHost AS MH
WHERE MH.ClientId = DPList.ClientId AND (( MH.MMHostSoftState = 0 AND (@i_IncludePowerManagedMA = 0 OR MH.OfflineReason <> 7 OR (MH.Attribute & 32768) = 0) ) OR MH.MMHostEnabled = 0)
-- remove disabled data paths.
DELETE @l_DPList
FROM @l_DPList
WHERE DPFlags & 4 = 0
-- If the application requires index backup
IF @l_IsIndexingBackup = 1
BEGIN
/* When using catalog server, the media agent should always be used for index backup even the catalog server is offline because the index can be stored locally.
	-- If the Media Agent is using Catalog Server, check the media agent status for the Catalog Server.
	-- Make sure Media Agent for Catalog Server is online. Otherwise, remove such data paths.
	DELETE @l_DPList
	FROM @l_DPList AS DPList, IdxAccessPath AS IAP, IdxCache AS IC, MMHost AS MH
	WHERE
		IAP.ClientId = DPList.ClientId AND IC.IdxCacheId = IAP.IdxCacheId AND IC.IdxCacheType = 1 AND IC.CatalogServerClientId > 0 AND
		IC.CatalogServerClientId = MH.ClientId AND (MH.MMHostSoftState <> 1 OR MH.MMHostEnabled <> 1)
*/
	-- If the Media Agent is not using Catalog Server. Make sure the  Access Path and Index Cache is online.
	-- Otherwise, remove such data paths.
	DELETE @l_DPList
	FROM @l_DPList AS DPList, IdxAccessPath AS IAP, IdxCache AS IC, App_Client AS C
	WHERE
		IAP.ClientId = DPList.ClientId AND IC.IdxCacheId = IAP.IdxCacheId AND IC.IdxCacheType = 1 AND IC.CatalogServerClientId = 0 AND
		(IAP.Softstate = 0 OR IAP.Enabled = 0 OR IC.Softstate = 0 OR IC.Enabled = 0)
		AND DPList.ClientId = C.id AND C.ReleaseId < 16
	--If  MA is 11.0 or later check cache status in app_clientProp table
	DELETE 	@l_DPList
	FROM 	@l_DPList AS DPList, App_Client AS C, App_ClientProp AS CP
	WHERE 	C.Id = DPList.ClientId AND C.Id = CP.componentNameId
			AND C.ReleaseId >= 16 AND CP.attrName = 'Idx: cache enabled' AND CONVERT(INT, CP.attrVal) <> 1
END
IF ((SELECT count(*) FROM @l_DPList) = 0)
BEGIN
			SET @l_WarningBitMask  = @l_WarningBitMask  | 8
			-- there is no online datapath to use
			GOTO RETURNFALLBACKDP
END
DECLARE @l_LANFreeAvailable INTEGER
SET @l_LANFreeAvailable = 0
-- set LAN Free flag
UPDATE @l_DPList
SET isLANFree = CASE
									WHEN LFD.isVirtual = 0 then 2
									ELSE 1
									END
FROM 	dbo.MMS2Func_GetLANFreeDataPaths
					(@i_CopyId, @l_BackupClientId, @l_AppId, @l_UseSCDataPaths, @l_DataType) AS LFD,
	@l_DPList AS tmpDPL
WHERE LFD.DataPathId = 	tmpDPL.DataPathId
SET @l_LANFreeAvailable = CASE
														WHEN @@ROWCOUNT > 0 then 1
														ELSE 0
													END
DECLARE @l_checkLastSeenIndexMA INTEGER
SET @l_checkLastSeenIndexMA = ISNULL((SELECT value FROM MMConfigs WHERE name = 'MMCONFIG_CHECK_LAST_SEEN_INDEX_MEDIAAGENT'), 0)
--Check if index backup and lanfree not available then see if we can find MA based on last seen index MA. If so return that, else fall to old way
IF @l_IsIndexingBackup = 1 AND @l_LANFreeAvailable = 0 AND @l_checkLastSeenIndexMA > 0
BEGIN
	--get the MA name from JM options table here and see if that MA exists in @l_DPList table. If so return that MA. We have to find only regular index cache MA here.
	DECLARE @MaName     NVARCHAR(512) = ''
	DECLARE @MAId	    INT = 0
	DECLARE @jobId	    INT = 0
	DECLARE @commCellId INT = 0
	SELECT TOP 1 @jobId = jobId, @commCellId = commCellId FROM JMBkpStats WITH (NOLOCK) WHERE appId = @l_AppId AND status = 1 ORDER BY servEndDate DESC
SET @MaName = ISNULL((SELECT attributeValue FROM JMJobOptions WITH (NOLOCK) WHERE jobId=@jobId AND commCellId=@commCellId AND attributeId=28), '')
	IF @MaName <> ''
	BEGIN
		SET @MAId = ISNULL((SELECT TOP 1 id FROM APP_Client WITH (NOLOCK) WHERE name = @MaName), 0)
		IF @MAId <> 0
			IF EXISTS (SELECT * FROM @l_DPList WHERE ClientId = @MAId)
			BEGIN
				SET @l_resulting_drivePoolId = (SELECT TOP 1 DrivePoolId FROM @l_DPList WHERE ClientId = @MAId)
				GOTO EXITOK
			END
	END
END
-- Pick MA if it is specified in PreferredMediaAgentGroup of client
DECLARE @l_PreferredMAGroupAvailable INTEGER
SET @l_PreferredMAGroupAvailable = 0
IF EXISTS (select 1 from MMConfigs where name = 'RM_CONFIG_PREFER_MA_FROM_PREFERRED_MEDIA_AGENT_GROUP' and value > 0) AND @l_BackupClientId > 0 AND @l_LANFreeAvailable = 0
BEGIN
	DECLARE @preferredMediaAgentGroup nvarchar(max)
SET @preferredMediaAgentGroup = dbo.AppGetAdditionalSettingForClient(@l_BackupClientId, 'PreferredMediaAgentGroup', 'CommServDb.ResourceManager')
	IF ISNULL(@preferredMediaAgentGroup, '') <> ''
	BEGIN
		UPDATE	@l_DPList
		SET		isPreferredMAGroup = 1
WHERE	@preferredMediaAgentGroup = dbo.AppGetAdditionalSettingForClient(ClientId, 'PreferredMediaAgentGroup', 'CommServDb.ResourceManager')
		SET @l_PreferredMAGroupAvailable = CASE WHEN @@ROWCOUNT > 0 then 1 ELSE 0 END
	END
END
IF  @l_IsIndexingBackup = 1 AND
	@l_LANFreeAvailable = 0 AND
	@l_PreferredMAGroupAvailable = 0 AND
	(	@l_isIndexShared = 1	OR
		-- If there is only 10.0 MA or later exists, index cache doesn't need to be shared,
		(@currentMAReleaseId > 14 AND
			NOT EXISTS (SELECT DataPathId FROM @l_DPList WHERE ClientVersion < @currentMAReleaseId)
		)
	)	AND
	@isUsePreferredDP = 0
BEGIN
	IF EXISTS(SELECT 1 FROM MMConfigs WHERE name = 'MMCONFIG_RESOURCEMANAGER_PREFER_DEFAULT_DATAPATH' AND value = 1) AND
EXISTS(SELECT 1 FROM ArchGroupCopy WITH (NOLOCK) WHERE id = @i_CopyId AND Flags & (8 | 16) > 0)
	BEGIN
SET @l_resulting_drivePoolId = ISNULL((SELECT A.DrivePoolId FROM @l_DPList A INNER JOIN MMDataPath B ON A.DataPathID = B.DataPathId AND B.Flag & 1 > 0 ), 0)
		IF @l_resulting_drivePoolId > 0
			GOTO EXITOK
	END
	-- round robin
	  -- not sure if there is a better way to get the nth row in a table,
	  -- I couldn't find one.
	DECLARE @l_RRDPTable TABLE (id Integer IDENTITY, DrivePoolId INTEGER)
	DECLARE @l_RRDPTableRowNum Integer
	INSERT INTO @l_RRDPTable (DrivePoolId)
	SELECT DrivePoolId FROM @l_DPList
	SET @l_RRDPTAbleRowNum  = @@ROWCOUNT
	SET @l_resulting_drivePoolId =
	(	SELECT TOP 1 DrivePoolId FROM @l_RRDPTable
		WHERE  id = ( 1 + (@i_JobId_l % @l_RRDPTableRowNum ))
		-- the 1 + is there because identities start at 1, not at 0
	)
	GOTO EXITOK
END ELSE
BEGIN
	-- if sc datapath, and index is not shared => use top priority datapath
	-- if sc datapath and this is not an indexing backup, also choose the first in the list
	IF 	@l_UseSCDataPaths = 1 AND
			( @l_isIndexShared = 0 OR @l_IsIndexingBackup = 0)
	BEGIN
		-- in case of subclient datapath, we use the datapath with the highest priority of the available ones
		SET @l_resulting_drivePoolId =
		(	SELECT TOP 1 DrivePoolId FROM @l_DPList )
		-- the above worked because the temp list was sorted by prescendence
		GOTO EXITOK
	END ELSE
	BEGIN
		-- if using SC datapaths but the index is shared (and this is an indexing backup)
		-- it means we entered this section because LAN free datapaths are available..
		-- this section is also entered if index is shared, this is an indexing backup and lan free are available
		-- regardless of sc datapath or not
		--
		-- Here if not shared, get the last MA that had the backup for this app-id
		--  Only applicable if the last MA is of 10.0
		--
		IF (@l_isIndexShared = 0)
		BEGIN
			IF EXISTS (select * from MMConfigs where name = 'MMCONFIG_RESOURCEMANAGER_ALLOW_RESTORE_CONSIDER_GEOMETRY_LOCATION' and value > 0) AND (@l_BackupClientId > 0)
			BEGIN
			    -- select preferred media agent based on geometry information
				IF OBJECT_ID('tempdb..#resDataPath') IS NOT NULL
					DROP TABLE #resDataPath
				create table #resDataPath (drivePoolId int)
				DECLARE @SQLStr VARCHAR(2048)
				IF OBJECT_ID('tempdb..#l_DPList_dummy') IS NOT NULL
					DROP TABLE #l_DPList_dummy
				CREATE TABLE #l_DPList_dummy(
				DataPathID Integer,
				DrivePoolId Integer,
				DPFlags Integer,
				Priority Integer,
				ClientId Integer,
				IndexCacheId Integer,
				isLANFree	Integer,
				ClientVersion	Integer,
				isPreferredMAGroup integer default 0)
				INSERT INTO #l_DPList_dummy
				SELECT * FROM @l_DPList
				SET @SQLStr = '
				DECLARE @clientGeoInfo  geography
			    DECLARE @clientGeoXML   XML
			    SELECT @clientGeoXML = ISNULL(AttrVal, '''') FROM App_ClientProp with (NOLOCK) WHERE componentNameId = '+ CONVERT(VARCHAR(16), @l_BackupClientId) + ' AND AttrName = ''Client Geo Location'' AND Modified = 0 ' + '
			    SET @clientGeoInfo = geography::Point(ISNULL(@clientGeoXML.value(''/App_GeoLocation[1]/@latitude'', ''float''), 0),
                                        ISNULL(@clientGeoXML.value(''/App_GeoLocation[1]/@longitude'', ''float''), 0),
                                        4326)
				INSERT INTO #resDataPath
			    SELECT TOP 1 isnull(DPList.DrivePoolId, 0)
			    FROM    #l_DPList_dummy DPList, App_ClientProp client with (nolock)
			    WHERE   DPList.ClientId = client.componentNameId
			    AND     client.AttrName = ''Client Geo Location''
			    AND     client.Modified = 0
			    ORDER BY    @clientGeoInfo.STDistance(geography::Point(ISNULL(CAST(client.AttrVal AS XML).value(''/App_GeoLocation[1]/@latitude'', ''float''), 0),
                        	                                    ISNULL(CAST(client.AttrVal as XML).value(''/App_GeoLocation[1]/@longitude'', ''float''), 0),
                                	                            4326)
                                        	)
			'
				EXEC (@SQLStr)
				SELECT @l_resulting_drivePoolId = drivePoolId FROM #resDataPath
				DROP TABLE #l_DPList_dummy
			END
			-- Return last used MediaAgent only for browse operation.
			IF (@l_resulting_drivePoolId <= 0 and @i_JobId_l = 0 and @i_JobId_h = 0)
			BEGIN
				declare @l_drvPoolId integer
				declare @l_clientId integer
				declare @l_clientVersion integer
				declare @l_defaultCopy	integer
				SELECT @l_defaultCopy = (CASE WHEN AGC.isSnapCopy = 1 THEN AG.defaultSnapCopy ELSE AG.defaultCopy END)
				FROM archGroupCopy AGC WITH (READUNCOMMITTED)
					INNER JOIN archGroup AG WITH (READUNCOMMITTED) ON AGC.archGroupId = AG.id
				WHERE AGC.id = @i_CopyId
				select top 1 @l_drvPoolId = AFC.drivePoolId
				from archFileCopy AFC WITH (READUNCOMMITTED), archFile AF WITH (READUNCOMMITTED)
				where AFC.archFileId = AF.id AND AFC.commCellId = AF.commCellId
					AND  AF.appId = @l_AppId AND AFC.archCopyId = @l_defaultCopy
					AND AF.isValid = 1
				order by AF.cTime desc
				if (@l_drvPoolId > 0)
				begin
					set @l_clientId = (select clientid from MMDrivePool where DrivePoolId = @l_drvPoolId)
					set @l_clientVersion = (select releaseid from app_client where id = @l_clientId)
					if (@l_clientVersion >= 15)
						and
						not exists
						(
							select top 1 ClientVersion from @l_DPList where ClientVersion < 15
						)
						and exists (select 1 from @l_DPList where ClientId = @l_clientId)
					begin
						SELECT TOP 1 @l_resulting_drivePoolId = DrivePoolId
						FROM @l_DPList
						WHERE	ClientId = @l_clientId
					end
				end
			END
		END
		--
		-- If we didnt get anything above, go back to old way..
		--
		-- get lan-free if avaiable
		if (@l_resulting_drivePoolId <= 0)
		begin
			SET @l_resulting_drivePoolId =
			ISNULL
			(
				(
					SELECT TOP 1 DPL.DrivePoolId
					FROM @l_DPList AS DPL
					WHERE DPL.isLANFree > 0
					ORDER BY DPL.isLANFree DESC, DPL.DataPathId ASC
					-- first lan free datapaths of virtual (if this is a virtual APP_Client), then lan free of physical
				), 0
			)
		end
		IF (@l_resulting_drivePoolId > 0)
		BEGIN
			GOTO EXITOK
		END
		-- Pick MA if it is specified in PreferredMediaAgentGroup of client
		IF @l_PreferredMAGroupAvailable > 0
		BEGIN
			SET @l_resulting_drivePoolId =
			ISNULL
			(
				(
					SELECT TOP 1 DrivePoolId
					FROM @l_DPList
					WHERE isPreferredMAGroup > 0
					ORDER BY DataPathId ASC
				), 0
			)
		END
		IF (@l_resulting_drivePoolId > 0)
		BEGIN
			GOTO EXITOK
		END
		-- get default DataPath or available one
		SET @l_resulting_drivePoolId =
		ISNULL
		(
			(
				SELECT TOP 1 DPL.DrivePoolId
				FROM @l_DPList AS DPL
				ORDER BY CASE WHEN (DPFlags & 1) = 1 THEN 0 ELSE 1 END
			), 0
		)
		IF (@l_resulting_drivePoolId > 0)
		BEGIN
			GOTO EXITOK
		END
	END
END
RETURNFALLBACKDP:
SET @l_WarningBitMask  = @l_WarningBitMask  | 8
-- there is no online datapath to use
-- according to Amey, we should return a datapath anyway -
-- for SC datapaths, the one with the highest priority,
-- else, the default datapath
IF (@l_UseSCDataPaths = 1)
BEGIN
		-- return subclient datapath with highest priority
		SET @l_resulting_drivePoolId  =
			ISNULL
				(
					(  	SELECT TOP 1 b.DrivePoolId
							FROM APP_AppToDataPath a, MMDataPath b, MMHost AS MH
							WHERE a.ComponentNameId = @l_AppId
							AND	a.DataPathId = b.DataPathId
							AND MH.ClientId = b.HostClientId
							ORDER BY CASE WHEN (MH.MMHostSoftState = 1 AND MH.MMHostEnabled = 1) THEN 0 ELSE 1 END,
									precedence
					), 0
				)
		-- this cannot fail - if we didn't have any subclient datapaths then we would have quit right at
		-- the top when determining the shared index cache.
		IF (@l_resulting_drivePoolId = 0)
		BEGIN
SET @l_ErrorCode = 331
			GOTO EXITWITHERROR
		END
END ELSE
IF @l_UseSiloDatapath = 1
BEGIN
		SET @l_resulting_drivePoolId = ISNULL((SELECT TOP 1 DrivePoolId FROM @l_DPList), 0)
END
IF @l_resulting_drivePoolId = 0
BEGIN
		-- return default or available one
		SET @l_resulting_drivePoolId  =
			ISNULL
				(
					 (	SELECT TOP 1 a.DrivePoolId
						FROM MMDataPath a, MMHost AS MH, MMDrivePool DP
						WHERE a.CopyId = @i_CopyId
						AND A.DrivePoolId = DP.DrivePoolId
						AND DP.ClientId = MH.ClientId
						ORDER BY CASE WHEN (MH.MMHostSoftState = 1 AND MH.MMHostEnabled = 1) THEN 0 ELSE 1 END,
								CASE WHEN (a.Flag & 1) = 1 THEN 0 ELSE 1 END
						), 0
				)
		IF (@l_resulting_drivePoolId = 0)
		BEGIN
SET @l_ErrorCode = 332
			GOTO EXITWITHERROR
		END
END
EXITOK:
EXITWITHERROR:
SELECT 	@l_resulting_drivePoolId AS DrivePoolId,
				@l_ErrorCode AS ErrorCodeVal,
				@l_WarningBitMask AS WarningBitMask
return;
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2GetPreferredDataPath')
	delete from GxQscripts where name = 'MMS2GetPreferredDataPath'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetPreferredDataPath')
	delete from GXDBVersions where aliasname = 'MMS2GetPreferredDataPath'
GO

insert into GXDBVersions values(2, 'MMS2GetPreferredDataPath',  'v1.49.2.21.12.1', 'MMS2GetPreferredDataPath', 'v1.49.2.21.12.1')
GO

