

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GetOlderMediaAgentsList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2GetOlderMediaAgentsList.sp,v $ $Id: MMS2GetOlderMediaAgentsList.sp,v 1.5.88.2 2020/12/28 22:43:07 cliu Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "MMS2GetDriveInfo"				|
--	|									|
--	| Execute the System stored procedure to fetch the physical files	|
--	| .. for the (current) database.					|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MMS2GetOlderMediaAgentsList')
BEGIN
	print '>>> Drop Stored Procedure: MMS2GetOlderMediaAgentsList <<<'
	drop procedure MMS2GetOlderMediaAgentsList
END
IF EXISTS (select * from GxQscripts where name='MMS2GetOlderMediaAgentsList')
	delete from GxQscripts where name = 'MMS2GetOlderMediaAgentsList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetOlderMediaAgentsList')
	delete from GXDBVersions where aliasname = 'MMS2GetOlderMediaAgentsList'
GO
print '... Creating Procedure: MMS2GetOlderMediaAgentsList'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MMS2GetOlderMediaAgentsList
  @i_CommCellId integer
AS
  DECLARE @o_ClientId integer
  DECLARE @o_ClientName varchar(255)
  DECLARE @o_ReleaseId integer
  DECLARE @o_NumDaysSinceInstalled integer
  DECLARE @o_NumDaysSinceCSUpgraded integer
	SET NOCOUNT ON
	create table #tmpOutPut(clientId		integer,
				Net_HostName		varchar(256),
				ReleaseId		integer,
				NumDaysSinceInstalled	integer,
				NumDaysSinceCSUpgraded	integer)
	declare @l_hostid	integer
	declare @l_SecsInADay	integer
	declare @l_ReleaseId	integer
	declare @l_CSClientId	integer
	set @l_ReleaseId = (select TOP 1 ReleaseId from LicUsage AS LU with (nolock)
						where LU.AppType = 1000 AND LU.OpType = 'Install'
						AND LU.InstallFlag = 0)
	set @l_SecsInADay = 60*60*24
	set @l_CSClientId = (select clientId from APP_Platform with (nolock) where PlatformType & 1 = 1)
	DECLARE	MACursor CURSOR FOR
	select ClientId from MMHost with (nolock) where clientid > 1
	OPEN	MACursor
	FETCH	NEXT FROM MACursor
	INTO	@l_hostid
	WHILE	@@FETCH_STATUS = 0
	BEGIN
		IF(@l_hostid <> @l_CSClientId)
		BEGIN
			INSERT INTO #tmpOutPut
			select TOP 1 SIM.CId, cl.net_HostName, SIM.ReleaseId,
			((dbo.GetUnixTime(getUTCDate()) - dbo.GetUnixTime(SIM.OpTimeUTC))/@l_SecsInADay), 0
			from LicUsage as SIM with (nolock), APP_Client as cl with (nolock)
			where SIM.cID = @l_hostid AND cl.id = @l_hostid AND SIM.LicType NOT IN (71, 10, 26)
			AND SIM.ReleaseId < @l_ReleaseId
			AND SIM.AppType = 1002 AND SIM.OpType = 'Install'
			AND SIM.InstallFlag = 0
			order by SIM.ReleaseId desc
		END
		FETCH	NEXT FROM MACursor
		INTO	@l_hostid
	end
	delete from #tmpOutPut where ReleaseId = @l_ReleaseId
	update #tmpOutPut
	set NumDaysSinceCSUpgraded = (select (dbo.GetUnixTime(getUTCDate()) -
                                    (select TOP 1 dbo.GetUnixTime(LU.CreateTimeUTC) from LicUsageHistory AS LU with (nolock)
                                    where LU.AppType = 1000 AND LU.OpType = 'Install'
                                    AND LU.InstallFlag = 0
                                    order by lu.ReleaseId desc, CreateTimeUTC asc))/@l_SecsInADay)
	select tt.clientId, Net_HostName, ReleaseId, NumDaysSinceInstalled, NumDaysSinceCSUpgraded
	from #tmpOutPut as tt, MMHost as MH with (nolock)
	where tt.ClientId = MH.ClientId
	drop table #tmpOutPut
	CLOSE		MACursor
	DEALLOCATE	MACursor
	SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2GetOlderMediaAgentsList')
	delete from GxQscripts where name = 'MMS2GetOlderMediaAgentsList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetOlderMediaAgentsList')
	delete from GXDBVersions where aliasname = 'MMS2GetOlderMediaAgentsList'
GO

insert into GXDBVersions values(2, 'MMS2GetOlderMediaAgentsList',  '00010005008800020000', 'MMS2GetOlderMediaAgentsList', '00010005008800020000')
GO

