

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GetNonGalaxyMediaListForGUI.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2GetNonGalaxyMediaListForGUI.sp,v $ $Id: MMS2GetNonGalaxyMediaListForGUI.sp,v 1.4.274.3 2018/03/20 19:47:47 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 						Cursor: "MMS2GetNonGalaxyMediaListForGUI"								|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2GetNonGalaxyMediaListForGUI <<<'

IF EXISTS (select * from sysobjects where name='MMS2GetNonGalaxyMediaListForGUI')
	drop procedure MMS2GetNonGalaxyMediaListForGUI
IF EXISTS (select * from GxQscripts where name='MMS2GetNonGalaxyMediaListForGUI')
	delete from GxQscripts where name = 'MMS2GetNonGalaxyMediaListForGUI'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetNonGalaxyMediaListForGUI')
	delete from GXDBVersions where aliasname = 'MMS2GetNonGalaxyMediaListForGUI'
GO
print '... Creating Procedure: MMS2GetNonGalaxyMediaListForGUI'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2GetNonGalaxyMediaListForGUI
-- The following two lines indicate, in order, parameters that will be
--  expected in the "setValues()" method, as well as the order in which
--  they will be provided as arguments to the SQLSTRING command
  @i_libraryId integer
AS
--	The next two lines are the columns, in order, that will be in the
--  result set for this cursor.  EXTREME CAUTION must be exercised to
--  ensure that these match up with the result set in terms of type, size,
--  and order!
  DECLARE @o_MediaId integer
  DECLARE @o_SlotId integer
  DECLARE @o_SlotName char(255)
  DECLARE @o_BarCode char(255)
  DECLARE @o_SlotType integer
  DECLARE @o_MediaStatus integer
  DECLARE @o_LibraryTypeId integer
  DECLARE @o_LibraryExternalGUID char(255)
  DECLARE @o_libraryId integer
  DECLARE @o_libraryAliasName NVARCHAR(255)
  DECLARE @o_containerId integer
  DECLARE @o_containerName NVARCHAR(255)
  DECLARE @o_attributes integer
  DECLARE @o_numberOfSoftErrors_A integer
  DECLARE @o_numberOfHardErrors_A integer
  DECLARE @o_numberOfSoftErrors_B integer
  DECLARE @o_numberOfHardErrors_B integer
  DECLARE @o_isAged integer
  DECLARE @o_isInMediaGroup integer
  DECLARE @o_extendedAttributes integer
  DECLARE @o_mediaStatusReason integer
-- These lines represent the actual SQL code that will get executed.  Note
-- The "printf" style substitutions.  These should match up exactly with
-- :PARAM input lines
	IF object_id('tempdb.dbo.#tmpMediaList') is not null DROP TABLE #tmpMediaList
	select distinct s.mediaid, s.slotid, s.slotname, s.barcode, s.slottype, s.mediastatus,
	c.LibraryTypeId, c.ExternalGUID, c.LibraryId, c.aliasName, mc.ContainerId, mc.ContainerName,
	MM.Attributes,
	MM.MediaTypeId,
	numberOfSoftErrors_A = 0,
	numberOfHardErrors_A = 0,
	numberOfSoftErrors_B = 0,
	numberOfHardErrors_B = 0,
	MM.IsAged, MM.IsInMediaGroup,
	MM.ExtendedAttributes,
	MM.MediaStatusReason
	-- 01/18/06, insert into temporary table
	INTO #tmpMediaList
	from MMSlot as s, MMBay as b, MMLibrary as c, MMContainer as mc, MMMedia as MM
	where s.isgalaxymedia = 1 and (s.mediaid = 0 or (s.mediaid > 0 and s.mediastatus > 2)) and
	s.isoccupied = 1 and s.bayid = b.bayid and b.libraryid = c.LibraryId and c.LibraryId = @i_LibraryId
	and mc.ContainerId = MM.containerId and MM.MediaId = s.mediaid
	ORDER BY s.barcode
	-- 01/18/06 add soft and hard error counts to the output, including at most two sides
	DECLARE @tmpErrorInfo TABLE (
			mediaId					integer,
			totalNumberOfSoftErrors	integer,
			totalNumberOfHardErrors	integer
			)
	INSERT INTO @tmpErrorInfo
	SELECT	MediaId, SUM(NumberOfSoftErrors), SUM(NumberOfHardErrors)
	FROM	MMMediaSide as ms
	WHERE	EXISTS	(SELECT tt.MediaId FROM #tmpMediaList as tt, MMMediaType as mt
					 WHERE ms.MediaId = tt.MediaId and tt.MediaTypeId = mt.MediaTypeId and mt.NumberOfSides > 1)
	GROUP BY MediaId
	UPDATE	#tmpMediaList
	SET		numberOfSoftErrors_A = ISNULL(ms.NumberOfSoftErrors, 0),
			numberOfHardErrors_A = ISNULL(ms.NumberOfHardErrors, 0)
	FROM	#tmpMediaList as tt LEFT JOIN MMMediaSide as ms	ON tt.MediaId = ms.MediaId
	WHERE	ms.NumberOfSoftErrors != -1 and ms.NumberOfHardErrors != -1
	UPDATE	#tmpMediaList
	SET		numberOfSoftErrors_B = te.totalNumberOfSoftErrors - tt.numberOfSoftErrors_A,
			numberOfHardErrors_B = te.totalNumberOfHardErrors - tt.numberOfHardErrors_A
	FROM	@tmpErrorInfo as te, #tmpMediaList as tt
	WHERE	te.MediaId = tt.MediaId
	SELECT	mediaid, slotid, slotname, barcode, slottype, mediastatus,
			LibraryTypeId, ExternalGUID, LibraryId, aliasName, ContainerId, ContainerName,
			Attributes,
			numberOfSoftErrors_A, numberOfHardErrors_A, numberOfSoftErrors_B, numberOfHardErrors_B,
			IsAged, IsInMediaGroup, ExtendedAttributes, MediaStatusReason
	FROM #tmpMediaList
	DROP TABLE #tmpMediaList
	-- 01/18/06 end
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2GetNonGalaxyMediaListForGUI')
	delete from GxQscripts where name = 'MMS2GetNonGalaxyMediaListForGUI'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetNonGalaxyMediaListForGUI')
	delete from GXDBVersions where aliasname = 'MMS2GetNonGalaxyMediaListForGUI'
GO

insert into GXDBVersions values(2, 'MMS2GetNonGalaxyMediaListForGUI',  '00010004027400030000', 'MMS2GetNonGalaxyMediaListForGUI', '00010004027400030000')
GO

