

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GetMissingHybridCloudMAsForDisk.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2GetMissingHybridCloudMAsForDisk.sp,v $ $Id: MMS2GetMissingHybridCloudMAsForDisk.sp,v 1.1.2.1 2019/07/30 23:02:34 aselvanayagam Exp $";
--  +===========================================================================================================================+
--  | MMS2GetMissingHybridCloudMAsForDisk - Retrieve MAs that aren't present for disk library associated with the hybrid cloud  |
--  +===========================================================================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMS2GetMissingHybridCloudMAsForDisk')
BEGIN
	print '>>> Drop Stored Procedure: MMS2GetMissingHybridCloudMAsForDisk <<<'
	drop procedure MMS2GetMissingHybridCloudMAsForDisk
END
IF EXISTS (select * from GxQscripts where name='MMS2GetMissingHybridCloudMAsForDisk')
	delete from GxQscripts where name = 'MMS2GetMissingHybridCloudMAsForDisk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetMissingHybridCloudMAsForDisk')
	delete from GXDBVersions where aliasname = 'MMS2GetMissingHybridCloudMAsForDisk'
GO
print '... Creating Procedure: MMS2GetMissingHybridCloudMAsForDisk'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MMS2GetMissingHybridCloudMAsForDisk
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS                         ---
-----------------------------------------------------------
  @i_cloudLibraryId INT = 0
AS
  DECLARE @o_DeviceId integer
  DECLARE @o_Folder varchar(1024)
  DECLARE @o_UserName varchar(1024)
  DECLARE @o_UserPassword varchar(2048)
  DECLARE @o_CredentialId integer
  DECLARE @o_DevCtrlEnabled integer
  DECLARE @o_HostClientId integer
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @diskLibId INTEGER = 0
SET @diskLibId = (SELECT diskLibId FROM MMHybridCloudMapping WHERE @i_cloudLibraryId > 0 AND cloudLibId = @i_cloudLibraryId)
IF (@diskLibId > 0)
BEGIN
	IF OBJECT_ID('tempdb.dbo.#tmpCloudMAs') IS NOT NULL
		DROP TABLE #tmpCloudMAs
	CREATE TABLE #tmpCloudMAs
	( ClientId INT)
	IF OBJECT_ID('tempdb.dbo.#tmpDeviceCtrlsNeeded') IS NOT NULL
		DROP TABLE #tmpDeviceCtrlsNeeded
	CREATE TABLE #tmpDeviceCtrlsNeeded
	( DeviceId INT,
	ClientId INT,
UserName varchar(1024),
UserPassword varchar(2048),
Folder varchar(1024),
	CredentialId INT,
	DeviceControllerEnabled INT)
	-- Get all distinct MAs for the incoming cloud library
	-- that aren't already in the disk library
	INSERT INTO #tmpCloudMAs
	SELECT ClientId
	FROM MMDeviceController MDC
	INNER JOIN MMMountPathToStorageDevice MPSD ON MPSD.DeviceId = MDC.DeviceId
	INNER JOIN MMMountPath MP ON MPSD.MountPathId = MP.MountPathId
	WHERE MP.LibraryId = @i_cloudLibraryId
	GROUP BY ClientId;
	-- Generate device id and client id combinations
	WITH DeviceClientCombinations(DeviceId, ClientId)
	AS
	(
	SELECT DEVCTRL.DeviceId, CLDMAS.ClientId
	FROM MMDeviceController DEVCTRL
	INNER JOIN MMMountPathToStorageDevice MSD on MSD.DeviceId = DEVCTRL.DeviceId
	INNER JOIN MMMountPath MP on MP.MountPathId = MSD.MountPathId
	, #tmpCloudMAs CLDMAS
	WHERE MP.LibraryId = @diskLibId
	GROUP BY DEVCTRL.DeviceId, CLDMAS.ClientId
	)
	-- Only take in device id and client id combinations that don't exist
	INSERT INTO #tmpDeviceCtrlsNeeded (DeviceId, ClientId)
	SELECT DeviceId, ClientId FROM DeviceClientCombinations CLDMAS
	EXCEPT
	SELECT DEVCTRL.DeviceId, DEVCTRL.ClientId
	FROM MMDeviceController DEVCTRL
	INNER JOIN MMMountPathToStorageDevice MSD on MSD.DeviceId = DEVCTRL.DeviceId
	INNER JOIN MMMountPath MP on MP.MountPathId = MSD.MountPathId
	INNER JOIN DeviceClientCombinations CLDMAS on DEVCTRL.ClientId = CLDMAS.ClientId and DEVCTRL.DeviceId = CLDMAS.DeviceId
	WHERE MP.LibraryId = @diskLibId
	GROUP BY DEVCTRL.DeviceId, DEVCTRL.ClientId
	-- Use the R/W preferred device controller to copy the username, password / credential and folder info
	UPDATE DEVCTRLSNEEDED
	SET DEVCTRLSNEEDED.UserName = DEVCTRL.UserName,
	DEVCTRLSNEEDED.UserPassword = DEVCTRL.UserPassword,
	DEVCTRLSNEEDED.CredentialId = ISNULL(ACA.CredentialId, 0),
	DEVCTRLSNEEDED.Folder = DEVCTRL.FOLDER
	FROM #tmpDeviceCtrlsNeeded DEVCTRLSNEEDED
	INNER JOIN MMDeviceController DEVCTRL ON DEVCTRL.DeviceId = DEVCTRLSNEEDED.DeviceId
	LEFT JOIN APP_CredentialAssoc ACA ON ACA.assocId = DEVCTRL.CredentialAssocId
WHERE DEVCTRL.DeviceAccessType & 6 = 6
	SELECT DeviceId,
		Folder,
		UserName,
		UserPassword,
		CredentialId,
		DeviceControllerEnabled,
		ClientId
	FROM #tmpDeviceCtrlsNeeded
	ORDER BY DeviceId
	IF OBJECT_ID('tempdb.dbo.#tmpDeviceCtrlsNeeded') IS NOT NULL
		DROP TABLE #tmpDeviceCtrlsNeeded
	IF OBJECT_ID('tempdb.dbo.#tmpCloudMAs') IS NOT NULL
	DROP TABLE #tmpCloudMAs
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2GetMissingHybridCloudMAsForDisk')
	delete from GxQscripts where name = 'MMS2GetMissingHybridCloudMAsForDisk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetMissingHybridCloudMAsForDisk')
	delete from GXDBVersions where aliasname = 'MMS2GetMissingHybridCloudMAsForDisk'
GO

insert into GXDBVersions values(2, 'MMS2GetMissingHybridCloudMAsForDisk',  '00010001000200010000', 'MMS2GetMissingHybridCloudMAsForDisk', '00010001000200010000')
GO

