

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GetMediaSideList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2GetMediaSideList.sp,v $ $Id: MMS2GetMediaSideList.sp,v 1.3.190.2 2018/03/20 19:43:09 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "MMS2GetMediaSideList"				|
--	|									|
--	| Execute the System stored procedure to fetch the physical files	|
--	| .. for the (current) database.					|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2GetMediaSideList <<<'

IF EXISTS (select * from sysobjects where name='MMS2GetMediaSideList')
	drop procedure MMS2GetMediaSideList
IF EXISTS (select * from GxQscripts where name='MMS2GetMediaSideList')
	delete from GxQscripts where name = 'MMS2GetMediaSideList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetMediaSideList')
	delete from GXDBVersions where aliasname = 'MMS2GetMediaSideList'
GO
print '... Creating Procedure: MMS2GetMediaSideList'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2GetMediaSideList
  @mediaId integer
AS
  DECLARE @sideId integer
  DECLARE @sideName char(255)
  DECLARE @numMounts integer
  DECLARE @numSoftErrors integer
  DECLARE @numHardErrors integer
  DECLARE @logicalBytesMB integer
  DECLARE @physicalBytesMB integer
  DECLARE @totalSpaceMB bigint
  DECLARE @freeBytesMB bigint
  DECLARE @numReUses integer
  DECLARE @numBackups integer
  DECLARE @numRestores integer
  DECLARE @lastBackupTime integer
  DECLARE @lastRestoreTime integer
  DECLARE @volumeId integer
  DECLARE @volumeFlags integer
  DECLARE @recFormatId integer
  DECLARE @volumeFullReason integer
  DECLARE @volumeFullTime integer
  DECLARE @volumeFullJobId bigint
  DECLARE @fileMarkerCount integer
  DECLARE @mediaFlags integer
	SELECT ms.MediaSideId, ms.SideName, ms.NumberOfMounts, ms.NumberOfSoftErrors, ms.NumberOfHardErrors,
		ms.LogicalBytesMB, ms.PhysicalBytesMB, ms.TotalSpaceMB, ms.FreeBytesMB,
		ms.NumberOfReuses, ms.NumberOfBackups, ms.NumberOfRestores, ms.LastBackupTime, ms.LastRestoreTime,
		mv.VolumeId, mv.VolumeFlags, mv.RecordingFormatId,
		mv.VolumeFullReason, mv.VolumeFullTime, mv.VolumeFullJobId, mv.NumberOfActiveFiles, mm.MediaFlags
	FROM   MMMediaSide ms, MMVolume mv, MMMedia mm
	WHERE  mv.MediaSideId = ms.MediaSideId AND mv.MediaId = @mediaId AND mm.MediaId = @mediaId
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2GetMediaSideList')
	delete from GxQscripts where name = 'MMS2GetMediaSideList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetMediaSideList')
	delete from GXDBVersions where aliasname = 'MMS2GetMediaSideList'
GO

insert into GXDBVersions values(2, 'MMS2GetMediaSideList',  '00010003019000020000', 'MMS2GetMediaSideList', '00010003019000020000')
GO

