

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GetMediaListInContainer.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2GetMediaListInContainer.sp,v $ $Id: MMS2GetMediaListInContainer.sp,v 1.12.210.3 2018/07/12 22:03:04 rsivadas Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2GetMediaListInContainer <<<'

IF EXISTS (select * from sysobjects where name='MMS2GetMediaListInContainer')
	drop procedure MMS2GetMediaListInContainer
IF EXISTS (select * from GxQscripts where name='MMS2GetMediaListInContainer')
	delete from GxQscripts where name = 'MMS2GetMediaListInContainer'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetMediaListInContainer')
	delete from GXDBVersions where aliasname = 'MMS2GetMediaListInContainer'
GO
print '... Creating Procedure: MMS2GetMediaListInContainer'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2GetMediaListInContainer
  @i_containerId integer,
  @i_locationId integer
AS
  DECLARE @o_MediaId integer
  DECLARE @o_UniqueId varchar(64)
  DECLARE @o_BarCode varchar(64)
  DECLARE @o_LibraryId integer
  DECLARE @o_LibAliasName NVARCHAR(255)
  DECLARE @o_Attributes integer
  DECLARE @o_MediaLocation integer
  DECLARE @o_ExportLocId integer
  DECLARE @o_ExportLocName NVARCHAR(255)
  DECLARE @o_DueBackDateInt bigint
  DECLARE @o_DueBackDateChar varchar(255)
  DECLARE @o_IsAged integer
  DECLARE @o_MediaGroupId integer
  DECLARE @o_MediaSideNum integer
  DECLARE @o_VolumeFlag integer
  DECLARE @o_archiveGroupId integer               
  DECLARE @o_archiveGroupName NVARCHAR(255)
  DECLARE @o_archiveGroupCopyId integer               
  DECLARE @o_archiveGroupCopyName NVARCHAR(255)
--This will turn off message: "xxx rows affected".
	DECLARE @tblVolInfo TABLE (
			MediaId int,
			MediaSideId int,
			MediaGroupId int,
			VolumeFlags int
	)
	DECLARE @tblMediaInfo TABLE (
			MediaId int,
			NumSides int,
			MediaGroupId int,
			VolumeFlags int,
			ArchGroupId int,
			ArchGroupName nvarchar(1024),
			ArchGroupCopyId int,
			ArchGroupCopyName nvarchar(1024)
	)
	select M.MediaId, M.UniqueId, M.BarCode, M.LibraryId, L.AliasName,
	M.Attributes, M.MediaLocation, M.ExportLocationId,
	isnull(E.ExportLocation, '') AS c_ExportLocationName, M.RetentionExpireTime,
	CASE
			WHEN M.RetentionExpireTime > 0 then cast (dbo.getDateTimeBig(M.RetentionExpireTime) as varchar(128)) ELSE ''
	END AS RetentionExpireTimeStr,
	M.IsAged
	into #tmpMediaTbl
	from MMMedia as M
		INNER JOIN MMLibrary as L ON M.LibraryId = L.LibraryId
		LEFT OUTER JOIN MMExportLocation as E ON E.ExportLocationId = M.ExportLocationId
	WHERE	((@i_containerId > 0 AND M.ContainerId = @i_containerId)
	OR		(@i_locationId > 0 AND M.ExportLocationId = @i_locationId
			--For Transit locations, do not show tape if already in library. MR 206480
			AND (E.Type <> 2 OR M.MediaLocation = 3))
	-- Return this media under "not available"
	OR		(@i_containerId = 0 AND @i_locationId = 0 AND M.ExportLocationId = 0))
	AND		MediaTypeId <> 10001
	AND		MediaId > 0
	INSERT	INTO @tblVolInfo
	SELECT	distinct v.mediaId, v.MediaSideId, v.MediaGroupId, v.VolumeFlags
	FROM	#tmpMediaTbl tt, MMVolume v
	WHERE	tt.MediaId = v.MediaId
	INSERT	INTO @tblMediaInfo
	SELECT	mediaId, count(MediaSideId), max(MediaGroupId), max(VolumeFlags), 0, '', 0, ''
	FROM	@tblVolInfo
	GROUP	BY mediaId
	UPDATE	@tblMediaInfo
	SET		ArchGroupCopyId = s.ArchGroupCopyId, ArchGroupId = s.ArchGroupId
	FROM	@tblMediaInfo tm, ArchStream s
	WHERE	tm.MediaGroupId = s.MediaGroupId
	UPDATE	@tblMediaInfo
	SET		ArchGroupName = ag.name
	FROM	@tblMediaInfo tm, ArchGroup ag
	WHERE	tm.ArchGroupId = ag.id
	AND		tm.ArchGroupId > 0
	UPDATE	@tblMediaInfo
	SET		ArchGroupCopyName = agc.name
	FROM	@tblMediaInfo tm, ArchGroupCopy agc
	WHERE	tm.ArchGroupCopyId = agc.id
	AND		tm.ArchGroupCopyId > 0
	select	tmp.*, med.MediaGroupId, med.NumSides, med.VolumeFlags,
			med.ArchGroupId, med.ArchGroupName, med.ArchGroupCopyId, med.ArchGroupCopyName
	from #tmpMediaTbl as tmp, @tblMediaInfo med
	where tmp.MediaId = med.MediaId
	drop table #tmpMediaTbl
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2GetMediaListInContainer')
	delete from GxQscripts where name = 'MMS2GetMediaListInContainer'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetMediaListInContainer')
	delete from GXDBVersions where aliasname = 'MMS2GetMediaListInContainer'
GO

insert into GXDBVersions values(2, 'MMS2GetMediaListInContainer',  '00010012021000030000', 'MMS2GetMediaListInContainer', '00010012021000030000')
GO

