

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GetMediaListInCap.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2GetMediaListInCap.sp,v $ $Id: MMS2GetMediaListInCap.sp,v 1.7.210.2 2018/03/20 19:47:07 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2GetMediaListInCap <<<'

IF EXISTS (select * from sysobjects where name='MMS2GetMediaListInCap')
	drop procedure MMS2GetMediaListInCap
IF EXISTS (select * from GxQscripts where name='MMS2GetMediaListInCap')
	delete from GxQscripts where name = 'MMS2GetMediaListInCap'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetMediaListInCap')
	delete from GXDBVersions where aliasname = 'MMS2GetMediaListInCap'
GO
print '... Creating Procedure: MMS2GetMediaListInCap'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2GetMediaListInCap
  @i_LibraryId integer,
  @i_getFinalMedList integer,
  @i_LibraryControllerId integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_AlertAction integer
  DECLARE @o_Initiator char(255)
  DECLARE @o_ActionId integer
  DECLARE @o_MediaId integer
  DECLARE @o_BarCode char(255)
  DECLARE @o_SourceId integer
  DECLARE @o_InTransitId integer
  DECLARE @o_DestinationId integer
  DECLARE @o_SourceLoc NVARCHAR(255)
  DECLARE @o_DestinationLoc NVARCHAR(255)
  DECLARE @o_ContainerId integer
  DECLARE @o_ContainerName NVARCHAR(255)
  DECLARE @o_PolicyId integer
  DECLARE @o_PolicyName NVARCHAR(255)
  DECLARE @o_ReturnDate bigint
  DECLARE @o_ReturnDateChar varchar(255)
  DECLARE @o_MoreMediaToCome integer
  DECLARE @o_DueBackInDays integer
	declare @l_currentLocalTimeStamp INTEGER
	set @l_currentLocalTimeStamp = dbo.getUnixTime(getDate())
	declare @l_UTCOffSetSeconds INTEGER
	set @l_UTCOffSetSeconds  = datediff(s,getutcdate(), getdate())
	-- above will return a negative value within the USA.
	if object_id('tempdb.dbo.#tmalertstmp') is not null DROP TABLE #tmalertstmp
	declare @l_moreMediaToCome	integer
	declare @l_BayId		integer
	set @l_moreMediaToCome = 0
	declare @l_SoureLocId	integer
	set @l_SoureLocId = (select LocationId from VTLocation where Type = 1 AND Value = @i_LibraryId)
	create table #tmalertstmp
	(
		AlertAction			integer not null,
		Initiator			varchar(128) not null,
		ActionId			integer not null,
		MediaId				integer not null primary key,
		BarCode				varchar(64),
		SourceId			integer not null,
		InTransitId			integer not null,
		DestinationId			integer not null,
		SourceLoc			nvarchar(256),
		DestinationLoc			nvarchar(256),
		ContainerId			integer not null,
		ContainerName			nvarchar(256),
		PolicyId			integer not null,
		PolicyName			nvarchar(256),
		ReturnDate			bigint,
		ReturnDateLocal		bigint,
		ReturnDateChar		varchar(256),
		DueBackInDays		integer
	)
	create index #tmalertstmp_DestinationLoc on #tmalertstmp (DestinationLoc)
	create index #tmalertstmp_ActionId on  #tmalertstmp (ActionId)
	create index #tmalertstmp_PolicyId on  #tmalertstmp (PolicyId)
	set @l_BayId = (select BayId from MMBay where LibraryId = @i_LibraryId)
	--If there are no media in the mail slots of this library, there is nothing much we can do here
	if not exists(select * from MMSlot where SlotType IN(2, 3) and BayId = @l_BayId AND IsOccupied = 1)
	BEGIN
		goto exit_here
	END
	--If not all the mail slots are FULL and there are some media still needs to be exported from
	--other export requests, then don't send the alert now, send it when the mail slots are full
	if exists(select * from MMSlot where BayId = @l_BayId AND SlotType IN(2, 3) AND IsOccupied = 0)
	AND exists(select * from MMMediaExport where ExportPhase = 0 AND LibraryControllerId = @i_libraryControllerId)
	BEGIN
		goto exit_here
	END
	if(@i_getFinalMedList = 0)
	BEGIN
		insert into #tmalertstmp
		select alertaction, initiator, actionid, a.mediaid, '', sourceid, intransitid, destinationid, '', '', 0, '', 0, '', 0, 0, '', 0
		from VTAlerts a, MMSlot as MS
		where a.AlertAction = 41
		AND a.InTransitId >= 0
		AND a.sourceid = @l_SoureLocId
      	AND a.MediaId = MS.MediaId
		AND MS.BayId = @l_BayId
		AND MS.SlotType IN(2, 3)
		-- Include other media in mail slot
		insert into #tmalertstmp
		select alertaction, initiator, actionid, a.mediaid, '', sourceid, intransitid, destinationid, '', '', 0, '', 0, '', 0, 0, '', 0
		from VTAlerts a, MMSlot as MS
		where a.AlertAction = 41
		AND a.InTransitId = -1
		AND a.sourceid = @l_SoureLocId
		AND a.MediaId = MS.MediaId
		AND MS.BayId = @l_BayId
		AND MS.SlotType IN(2, 3)
	END
	ELSE
	BEGIN
		insert into #tmalertstmp
		select alertaction, initiator, actionid, a.mediaid, '', sourceid, intransitid, destinationid, '', '', 0, '', 0, '', 0, 0, '', 0
		from VTAlerts a
		where a.AlertAction = 41
		AND a.InTransitId < 0
		AND a.sourceid = @l_SoureLocId
	END
	update #tmalertstmp
	set sourceloc = (select aliasname from MMLibrary where libraryid = SourceId)
	update #tmalertstmp
	set DestinationLoc = (select aliasname from MMLibrary where libraryid = b.value)
	from #tmalertstmp a, VTLocation b
	where a.destinationid > 0
	and a.DestinationLoc = ''
	and a.destinationid = b.locationid
	and b.type = 1
	and b.value > 0
	update #tmalertstmp
	set DestinationLoc = 'Inside Library'
	from #tmalertstmp a, VTLocation b
	where a.destinationid > 0
	and a.DestinationLoc = ''
	and a.destinationid = b.locationid
	and b.type = 1
	and b.value = 0
	update #tmalertstmp
	set DestinationLoc = (select exportlocation from MMExportLocation where exportlocationid = b.value)
	from #tmalertstmp a, VTLocation b
	where a.destinationid > 0
	and a.DestinationLoc = ''
	and a.destinationid = b.locationid
	and b.type = 2
	update #tmalertstmp
	set DestinationLoc = ''
	where DestinationLoc is null
	update #tmalertstmp
	set PolicyId = TMA.PolicyId, PolicyName = TMP.PolicyName
	from #tmalertstmp as tt, VTAction as TMA, VTPolicy as TMP
	where tt.ActionId > 0 AND tt.ActionId = TMA.ActionId AND TMA.PolicyId = TMP.PolicyId
	update #tmalertstmp
	set PolicyId = TMH.PolicyId, PolicyName = TMH.PolicyName
	from #tmalertstmp as tt, VTHistory as TMH
	where tt.PolicyId = 0 AND tt.ActionId > 0 AND tt.ActionId = TMH.ActionId
	declare @l_MediaIds table (MediaId INTEGER)
	INSERT INTO @l_MediaIds
	select MediaId from #tmalertstmp where PolicyId = 0 AND ActionId > 0
	if (@@rowcount > 0)
	BEGIN
		update #tmalertstmp
		set PolicyId = TMH.PolicyId, PolicyName = TMH.PolicyName
		from VTHistory as TMH, @l_MediaIds as tt
		where TMH.MediaId = tt.MediaId AND #tmalertstmp.MediaId = tt.MediaId
	END
	update #tmalertstmp
	set containerid = b.containerId
	from #tmalertstmp a, MMMedia b
	where a.mediaid > 0 and a.ContainerId = 0
	and a.mediaid = b.mediaid
	update #tmalertstmp
	set containerid = b.containerId
	from #tmalertstmp a, VTPolicy b
	where a.PolicyId > 0 and a.ContainerId = 0
	and a.PolicyId = b.PolicyId
	update #tmalertstmp
 	set BarCode = M.BarCode, returnDate = M.retentionExpireTime,
 			returnDateLocal = CASE WHEN M.retentionExpireTime > 0 then M.retentionExpireTime + @l_UTCOffSetSeconds + 60*60*24 ELSE M.retentionExpireTime END
	from #tmalertstmp as tt, MMMedia as M
	where tt.MediaId = M.MediaId
	update #tmalertstmp
	set ContainerName = C.ContainerName
	from #tmalertstmp as tt, MMContainer as C
	where tt.ContainerId > 0 AND tt.ContainerId = C.ContainerId
/*
	update #tmalertstmp
	set returnDate = TMA.DueBackTime,
			returnDateLocal = CASE WHEN TMA.DueBackTime > 0 then TMA.DueBackTime + @l_UTCOffSetSeconds + 60*60*24 ELSE TMA.DueBackTime END
	from #tmalertstmp as tt, VTActionMedia as TMA
	where TMA.ActionId = tt.ActionId AND TMA.MediaId = tt.MediaId
	update #tmalertstmp
	set returnDate = TMH.DueBackTime,
			returnDateLocal = CASE WHEN TMH.DueBackTime > 0 then TMH.DueBackTime + @l_UTCOffSetSeconds + 60*60*24 ELSE TMH.DueBackTime END
	from #tmalertstmp as tt, VTHistory as TMH
	where TMH.ActionId = tt.ActionId AND TMH.MediaId = tt.MediaId
*/
	if(@i_getFinalMedList = 0)
	BEGIN
		--Set this value to -1 to indicate that the alert for these media is already being sent
		--so that the next time we will not pick these media
		update VTAlerts
		set intransitid = -1
		where MediaId in(select MediaId from #tmalertstmp)
		if exists(select MediaId from MMMediaExport where LibraryControllerId = @i_libraryControllerId
									AND ExportPhase = 0)
		BEGIN
			set @l_moreMediaToCome	= 1
		END
		ELSE
		BEGIN
			set @l_moreMediaToCome	= 0
		END
	END
	ELSE
	BEGIN
		--Set this value to -2 to indicate that the Consolidated e-mail for these media is already being sent
		--so that the next time we will not pick these media and will be deleted by RunTmUpdate
		update VTAlerts
		set intransitid = -2
		where MediaId in(select MediaId from #tmalertstmp)
	END
	-- fix was needed because of following issue:
	-- time now: 23:59 Day 1 UTC
	-- time media retention expires: 0:02 Day 3 UTC
	-- if TZ is UTC, then due back should be 2 days
	-- if TZ is UTC-5 for example, then
	--  time now is in actual fact 18:59 day 1 and
	--  retention expire time is  19:02 day 2 where the difference
	--  is only 1 day which should be returned to the GUI
	-- SO, it is important to use the local time zone
	-- when determining in how many calendar days the retention
	-- time with expire and the media is due back.
	-- Note that we also add a full 24 hours above to make sure
	-- that if the extended retention time in actual fact expires
	-- on a day at 11 PM, that the return date is shown as the next day
	-- so that on that day it is definately due back.
	update #tmalertstmp
	set DueBackInDays = ReturnDateLocal/(60*60*24) - @l_currentLocalTimeStamp/(60*60*24)
	where ReturnDate > 0
	update #tmalertstmp
	set ReturnDateChar = CONVERT(varchar, datepart(YEAR, dbo.GetDateTimeBig(ReturnDateLocal))) + '-' + CONVERT(varchar, datepart(MONTH, dbo.GetDateTimeBig(ReturnDateLocal))) + '-' + CONVERT(varchar, datepart(DAY, dbo.GetDateTimeBig(ReturnDateLocal)))
	where DueBackInDays > 0
	update #tmalertstmp
	set ReturnDateChar = 'Now', ReturnDate = 0, DueBackInDays = 0
	where ReturnDate = 0 OR  (ReturnDate <> -1 AND DueBackInDays <= 0)
	update #tmalertstmp
	set ReturnDateChar = 'Never', DueBackInDays = 36135
	where ReturnDate = -1
exit_here:
	if(@i_getFinalMedList = 0)
	BEGIN
		select AlertAction, Initiator, ActionId, MediaId, BarCode, SourceId, InTransitId,
			DestinationId, SourceLoc, DestinationLoc, ContainerId, ContainerName, PolicyId,
			PolicyName, ReturnDate, ReturnDateChar, @l_moreMediaToCome, DueBackInDays
		from 	#tmalertstmp
		ORDER BY BarCode
	END
	ELSE
	BEGIN
		select AlertAction, Initiator, ActionId, MediaId, BarCode, SourceId, InTransitId,
			DestinationId, SourceLoc, DestinationLoc, ContainerId, ContainerName, PolicyId,
			PolicyName, ReturnDate, ReturnDateChar, @l_moreMediaToCome, DueBackInDays
		from 	#tmalertstmp
		ORDER BY DueBackInDays, BarCode
	END
	drop table #tmalertstmp
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2GetMediaListInCap')
	delete from GxQscripts where name = 'MMS2GetMediaListInCap'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetMediaListInCap')
	delete from GXDBVersions where aliasname = 'MMS2GetMediaListInCap'
GO

insert into GXDBVersions values(2, 'MMS2GetMediaListInCap',  '00010007021000020000', 'MMS2GetMediaListInCap', '00010007021000020000')
GO

