

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GetMediaListByMediaGroup.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2GetMediaListByMediaGroup.sp,v $ $Id: MMS2GetMediaListByMediaGroup.sp,v 1.9.2.3 2018/03/20 20:04:12 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2GetMediaListByMediaGroup <<<'

IF EXISTS (select * from sysobjects where name='MMS2GetMediaListByMediaGroup')
	drop procedure MMS2GetMediaListByMediaGroup
IF EXISTS (select * from GxQscripts where name='MMS2GetMediaListByMediaGroup')
	delete from GxQscripts where name = 'MMS2GetMediaListByMediaGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetMediaListByMediaGroup')
	delete from GXDBVersions where aliasname = 'MMS2GetMediaListByMediaGroup'
GO
print '... Creating Procedure: MMS2GetMediaListByMediaGroup'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2GetMediaListByMediaGroup
  @i_MediaGroupId integer,
  @i_CopyId integer,
  @i_isAged integer,
  @i_uniqueMediaIds integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_MediaId integer
  DECLARE @o_UniqueId char(255)
  DECLARE @o_Barcode char(255)
  DECLARE @o_MediaTypeId integer
  DECLARE @o_CreationTime integer
  DECLARE @o_NumberofReuses integer
  DECLARE @o_LastRestoreTime integer
  DECLARE @o_lastBackupTime integer
  DECLARE @o_LibraryId integer
  DECLARE @o_libraryName NVARCHAR(255)
  DECLARE @o_SpareGroupId integer
  DECLARE @o_spareGroupName NVARCHAR(255)
  DECLARE @o_LastExportTime integer
  DECLARE @o_MediaLocation integer
  DECLARE @o_locationName NVARCHAR(255)
  DECLARE @o_ExternalGUID char(255)
  DECLARE @o_MediaFlags integer
  DECLARE @o_IsOMLWritten integer
  DECLARE @o_MediaStatusReason integer
  DECLARE @o_ExportLocationID integer
  DECLARE @o_SlotID integer
  DECLARE @o_DriveID integer
  DECLARE @o_LastWriteLibraryId integer
  DECLARE @o_lastWriteLibraryName NVARCHAR(255)
  DECLARE @o_Attributes integer
  DECLARE @o_guiAttributes integer
  DECLARE @o_ContainerId integer
  DECLARE @o_OverWriteJobId integer
  DECLARE @o_OrigCCCommcellId integer
  DECLARE @o_origCCMediaId integer
  DECLARE @o_usageCounter integer
  DECLARE @o_mediaGroupId integer
  DECLARE @o_streamNumber integer
  DECLARE @o_isAged integer
  DECLARE @o_isInMediaGroup integer
--Declare the temporary varibles here
	SET NOCOUNT ON
 	IF object_id('tempdb.dbo.#tmpMediaList') is not null DROP TABLE #tmpMediaList
 	IF object_id('tempdb.dbo.#tmpMediaId') is not null DROP TABLE #tmpMediaId
 	IF object_id('tempdb.dbo.#tmpMediaAttribute') is not null DROP TABLE #tmpMediaAttribute
	create table #tmpMediaId(
					mediaId			integer,
					mediaGroupId	integer,
					volumeName		varchar(112))
	create table #tmpMediaList( 	mediaId			integer,
					uniqueId		varchar(256),
					barCode			varchar(256),
					mediaTypeId		integer,
					mediaCreationTime	integer,
					numRestores		integer,
					lastRestoreTime		integer,
					lastBackupTime		integer,
					libraryId		integer,
					libraryName 		nvarchar(256),
					spareGroupId		integer,
					spareGroupName		nvarchar(256),
					lastExportTime		integer,
					mediaLocation		integer,
					locationName		nvarchar(256),
					externalGUId		varchar(256),
					mediaFlags		integer,
					isOMLWritten		integer,
					mediaStatusReason	integer,
					exportLocationId		integer,
					slotId				integer,
					driveId				integer,
					lastWriteLibraryId	integer,
					lastWriteLibraryName 	nvarchar(256),
					attributes		integer,
					containerId		integer,
					overwriteJobId		integer,
					origCCId		integer,
					origCCMediaId		integer,
					usageCounter		integer,
					mediaGroupId		integer,
					streamNum		integer,
					isAged			integer,
					isInMediaGroup	integer)
	create index Idx_tmpMediaList_mediaId ON #tmpMediaList (mediaId)
	create table #tmpMediaAttribute(
								mediaId integer,
								guiAttributes integer,
								primary key(mediaId)
								)
	declare @copy_ext_flag int = 0
	if(@i_copyId > 0)
	begin
		set @copy_ext_flag = ISNULL((select extendedFlags from archGroupCopy with (nolock) where id = @i_CopyId), 0)
if ((@copy_ext_flag & 2) > 0)
		begin
			if (@i_uniqueMediaIds <= 0)
			begin
				insert into #tmpMediaId
				select distinct MediaId, MediaGroupId, VolumeName
				from MMVolume V WITH (NOLOCK),
					(select distinct AC.volumeId
						from archChunk AC with (nolock),
							archChunkMapping ACM with (nolock)
							where AC.id = ACM.archChunkId
							and AC.commCellId = ACM.chunkCommCellId
							and AC.physicalSize > 0 and AC.logicalSize > 0
and (AC.flags & 256) = 0
							and ACM.archCopyId = @i_CopyId) T
				where V.VolumeId = T.volumeId
			end
			else
			begin
				insert into #tmpMediaId
				select distinct V.MediaId, 0, ''
						from MMVolume V WITH (NOLOCK),
							(select distinct AC.volumeId
								from archChunk AC with (nolock),
									archChunkMapping ACM with (nolock)
									where AC.id = ACM.archChunkId
									and AC.commCellId = ACM.chunkCommCellId
									and AC.physicalSize > 0 and AC.logicalSize > 0
and (AC.flags & 256) = 0
									and ACM.archCopyId = @i_CopyId) T
						where V.VolumeId = T.volumeId
						group by V.MediaId
				update #tmpMediaId
				set mediaGroupId = V.MediaGroupId, volumeName = V.VolumeName
				from #tmpMediaId tmp,  MMVolume V with (nolock)
				where tmp.MediaId = V.MediaId and tmp.MediaGroupId = 0 and tmp.VolumeName = ''
			end
		end
		else
		begin
			if (@i_uniqueMediaIds <= 0)
			begin
				insert into #tmpMediaId
				select distinct MediaId, MediaGroupId, VolumeName from MMVolume WITH (NOLOCK)
				where MediaGroupId in (select MediaGroupId from archStream where archGroupCopyId = @i_copyId)
			end
			else
			begin
				insert into #tmpMediaId
				select distinct V.MediaId, 0, '' from MMVolume V JOIN archStream A ON V.MediaGroupId = A.MediaGroupId
						where A.archGroupCopyId = @i_copyId Group By V.MediaId
				update #tmpMediaId
				set mediaGroupId = V.MediaGroupId, volumeName = V.VolumeName
				from #tmpMediaId tmp,  MMVolume V with (nolock)
				where tmp.MediaId = V.MediaId and tmp.MediaGroupId = 0 and tmp.VolumeName = ''
			end
		end
	end
	else
	begin
		if (@i_uniqueMediaIds <= 0)
		begin
			insert into #tmpMediaId
				select distinct MediaId, MediaGroupId, VolumeName from MMVolume
				where MediaGroupId = @i_mediaGroupId
		end
		else
		begin
			insert into #tmpMediaId
			select distinct MediaId, 0, '' from MMVolume
						where MediaGroupId = @i_mediaGroupId group by MediaId
			update #tmpMediaId
			set mediaGroupId = V.MediaGroupId, volumeName = V.VolumeName
			from #tmpMediaId tmp,  MMVolume V with (nolock)
			where tmp.MediaId = V.MediaId and tmp.MediaGroupId = 0 and tmp.VolumeName = ''
		end
	end
	insert into #tmpMediaList
		select distinct mm.MediaId, mm.UniqueId,
		barcode = (case mm.MediaTypeId when 10001 then tt.volumeName else mm.Barcode end),
		mm.MediaTypeId, mm.CreationTime, mm.NumberofReuses,
		mm.LastRestoreTime, mm.lastBackupTime, mm.LibraryId,
		libraryName = (select AliasName from MMLibrary where LibraryId = mm.LibraryId ),
		mm.SpareGroupId, ms.SpareGroupName,
		mm.LastExportTime, mm.MediaLocation, '', mm.ExternalGUID, mm.MediaFlags, mm.IsOMLWritten,
		mm.MediaStatusReason, mm.ExportLocationID, 0, 0, mm.LastWriteLibraryId,
		lastWriteLibraryName = (select AliasName from MMLibrary where LibraryId = mm.LastWriteLibraryId ),
		mm.Attributes, mm.ContainerId, mm.OverWriteJobId, mm.OrigCCCommcellId, mm.origCCMediaId,
		mm.NumberOfReUses, tt.mediaGroupId, 0, mm.IsAged, mm.IsInMediaGroup
		from 	MMMedia as mm, #tmpMediaId as tt, MMSpareGroup AS MS
		where 	mm.MediaId = tt.MediaId and IsAged = @i_isAged
			and ms.SpareGroupId = mm.SpareGroupId
		order by mm.MediaId ASC
	update #tmpMediaList
	set locationName = ms.slotName, slotId = ms.slotId
	from MMSlot as ms, #tmpMediaList as tt
	where ms.MediaId = tt.mediaId and tt.mediaLocation = 1
	update #tmpMediaList
	set locationName = md.AliasName, driveId = md.driveId
	from MMDrive as md, #tmpMediaList as tt
	where md.MediaId = tt.mediaId and tt.mediaLocation = 2
	update #tmpMediaList
	set locationName = me.exportLocation
	from MMExportLocation as me, #tmpMediaList as tt
	where me.ExportLocationId = tt.ExportLocationId and tt.mediaLocation = 3
	update #tmpMediaList
	set locationName = Mp.MountPathName
	from MMS2getMountPathNameGUIView as MP, #tmpMediaList as tt
	where tt.MediaTypeId = 10001 AND MP.MediaId = tt.MediaId
	update #tmpMediaList
	set streamNum = ASt.stream
	from #tmpMediaList as tt, ArchStream as ASt
	where ASt.MediaGroupId = tt.mediaGroupId
	INSERT INTO #tmpMediaAttribute
	SELECT distinct mediaId, 0
	FROM #tmpMediaList
	UPDATE #tmpMediaAttribute SET guiAttributes = dbo.MMS2FUNC_GetGUIMediaAttribute(mediaId)
	select tt.mediaId, tt.uniqueId, tt.barCode, tt.mediaTypeId, tt.mediaCreationTime, tt.numRestores,
	tt.lastRestoreTime, tt.lastBackupTime, tt.libraryId, tt.libraryName, tt.spareGroupId, tt.spareGroupName,
	tt.lastExportTime, tt.mediaLocation, tt.locationName, tt.externalGUId, tt.mediaFlags, tt.isOMLWritten,
	tt.mediaStatusReason, tt.ExportLocationId, tt.slotId, tt.driveId, tt.lastWriteLibraryId, tt.lastWriteLibraryName, tt.attributes,
	ta.guiAttributes, tt.containerId, tt.overwriteJobId, tt.origCCId, tt.origCCMediaId, tt.usageCounter,
	tt.mediaGroupId, tt.streamNum, tt.isAged, tt.isInMediaGroup
	from #tmpMediaList as tt INNER JOIN #tmpMediaAttribute ta ON tt.mediaId = ta.mediaId
	order by tt.barCode ASC
	IF object_id('tempdb.dbo.#tmpMediaList') is not null DROP TABLE #tmpMediaList
 	IF object_id('tempdb.dbo.#tmpMediaId') is not null DROP TABLE #tmpMediaId
	IF object_id('tempdb.dbo.#tmpMediaAttribute') is not null DROP TABLE #tmpMediaAttribute
	SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2GetMediaListByMediaGroup')
	delete from GxQscripts where name = 'MMS2GetMediaListByMediaGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetMediaListByMediaGroup')
	delete from GXDBVersions where aliasname = 'MMS2GetMediaListByMediaGroup'
GO

insert into GXDBVersions values(2, 'MMS2GetMediaListByMediaGroup',  '00010009000200030000', 'MMS2GetMediaListByMediaGroup', '00010009000200030000')
GO

