

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GetMediaListByDriveRecFmt.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2GetMediaListByDriveRecFmt.sp,v $ $Id: MMS2GetMediaListByDriveRecFmt.sp,v 1.5.72.3 2018/03/20 19:55:25 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2GetMediaListByDriveRecFmt <<<'

IF EXISTS (select * from sysobjects where name='MMS2GetMediaListByDriveRecFmt')
	drop procedure MMS2GetMediaListByDriveRecFmt
IF EXISTS (select * from GxQscripts where name='MMS2GetMediaListByDriveRecFmt')
	delete from GxQscripts where name = 'MMS2GetMediaListByDriveRecFmt'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetMediaListByDriveRecFmt')
	delete from GXDBVersions where aliasname = 'MMS2GetMediaListByDriveRecFmt'
GO
print '... Creating Procedure: MMS2GetMediaListByDriveRecFmt'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2GetMediaListByDriveRecFmt
  @in_driveId integer
AS
  DECLARE @o_mediaId integer
  DECLARE @o_mediabarCode varchar(255)
  DECLARE @o_mediaTypeId integer
  DECLARE @o_mediaTypeName varchar(255)
  DECLARE @o_isCleaningMedia integer
  DECLARE @o_isWormMedia integer
  DECLARE @o_libraryId integer
  DECLARE @o_reservationId integer
  DECLARE @o_isAged integer
  DECLARE @o_mediaSideId integer
  DECLARE @o_sideName varchar(255)
  DECLARE @o_isDeprecatable integer
	declare @l_libraryId	integer
	set @l_libraryId	= (select LibraryId from MMMasterPool where MasterPoolId in
					(select MasterPoolId from MMDrive where DriveId = @in_driveId))
	declare @l_mediaTypeId 	integer
	-- MR 176854
	-- set @l_mediaTypeId = (select mt.MediaTypeId from MMMediaType as mt WITH (READUNCOMMITTED), MMDrive as mm WITH (READUNCOMMITTED) where mt.MediaTypeId = mm.DriveTypeId and mm.DriveId = @in_driveId)
	-- seems like above query is not working, therefore fetching mediaTypeId from this query
	set @l_mediaTypeId = (select TOP 1 mt.MediaTypeId from MMMediaType as mt WITH (READUNCOMMITTED), MMDrive as mm WITH (READUNCOMMITTED), MMRecFmtMedTyp as fmt with (READUNCOMMITTED)
							where mt.MediaTypeId = fmt.MediaTypeId and fmt.driveTypeId = mm.DriveTypeId and mm.DriveId = @in_driveId)
	create table #tmpMediaList(	MediaId		integer,
			mediaBarCode			varchar(256),
			MediaType			integer,
			mediaTypeName			varchar(256),
			isCleaningMedia			integer,
			isWormMedia			integer,
			libraryId			integer,
			reservationId			integer,
			isAged				integer,
			mediaSideId			integer,
			mediaSideName			varchar(256),
			spareGroupId			integer,
			spareGroupType			integer,
			mediaLocation			integer,
			SlotType			integer,
			MediaFlags			integer,
			MediaCreationTIme		integer,
			MonthsInUseThreshold		integer,
			NumReuses			integer,
			NumReusesThreshold		integer,
			NumMounts			integer,
			ShortLengthDurabilityThreshold	integer,
			NumSoftErrors			integer,
			NumSoftErrorsThreshold		integer,
			NumHardErrors			integer,
			NumHardErrorsThreshold		integer,
			isMediaDeprecatable		integer,
			SpareGroupAttributes		integer)
	insert into #tmpMediaList
	select distinct mm.Mediaid, mm.Barcode, mt.mediatypeid, mt.mediatypename,
	mt.iscleaningmedia, mt.isWormMedia, mm.libraryId,
	isnull((select ReservationId from MMResource where MediaId = mm.MediaId), 0),
	isAged,	mms.mediaSideId, mms.sideName,
	MM.SpareGroupId, 0, MM.MediaLocation, 0, MM.MediaFlags, MM.CreationTime, MT.MonthsInUseThreshold,
	MM.NumberOfReUses, MT.NumberOfReUsesThreshold, MMS.NumberOfMounts,
	MT.ShortLengthDurabilityThreshold, MMS.NumberOfSoftErrors, MT.NumberOfSoftErrorsThreshold,
	MMS.NumberOfHardErrors, MT.NumberOfHardErrorsThreshold, 0, 0
	from MMMediaType as mt WITH (READUNCOMMITTED), MMDrive as md WITH (READUNCOMMITTED), MMRecFmtMedTyp as mr WITH (READUNCOMMITTED), MMMedia as mm WITH (READUNCOMMITTED),
	MMMediaSide as mms WITH (READUNCOMMITTED)
	where (mt.mediatypeid = mr.mediatypeid or mr.cleaningmediatypeid = mt.mediatypeid)
	and mr.drivetypeid = md.drivetypeid and md.DriveId = @in_driveId
	and mm.MediaTypeId = mt.MediaTypeId and mm.MediaLocation <> 3 and IsInMediaGroup = 0
	and mm.LibraryId = @l_libraryId and mm.MediaId = mms.MediaId
	update #tmpMediaList
	set spareGroupType = MMS.SpareGroupType, SpareGroupAttributes = MMS.Attributes
	from MMSpareGroup as MMS WITH (READUNCOMMITTED), #tmpMediaList as tt WITH (READUNCOMMITTED)
	where tt.SpareGroupId = MMS.SpareGroupId
	update #tmpMediaList
	set SlotType = MMS.SlotType
	from MMSlot as MMS WITH (READUNCOMMITTED), #tmpMediaList as tt WITH (READUNCOMMITTED)
	where tt.MediaId = MMS.MediaId
	IF(@l_mediaTypeId != 10001)
	BEGIN
		update #tmpMediaList
		set SlotType = MMS.SlotType
		from MMSlot as MMS WITH (READUNCOMMITTED), #tmpMediaList as tt WITH (READUNCOMMITTED)
		where tt.MediaId = MMS.MediaId
		update #tmpMediaList
		set isMediaDeprecatable = 1
		where MediaFlags in(2, 3) OR
		((MonthsInUseThreshold > 0) AND
		((((dbo.GetUnixTime(getdate())) - MediaCreationTIme)/2592000) > MonthsInUseThreshold)) OR
		(
		(isCleaningMedia = 1 AND ((NumReusesThreshold > 0) AND (NumMounts > NumReusesThreshold)))
		OR
		(isCleaningMedia = 0 AND ((NumReusesThreshold > 0) AND (NumReuses > NumReusesThreshold)))
		) OR
		((NumSoftErrorsThreshold > 0) AND (NumSoftErrors > NumSoftErrorsThreshold)) OR
		((NumHardErrorsThreshold > 0) AND (NumHardErrors > NumHardErrorsThreshold))
		-- We should compare volume state using media side Id which is unique, then distinct can be removed here
		select tt.Mediaid, tt.MediaBarcode, tt.mediatype, tt.mediatypename,
		tt.iscleaningmedia, tt.isWormMedia, tt.libraryId,
		tt.ReservationId, tt.isAged, tt.mediaSideId, tt.MediasideName, tt.isMediaDeprecatable
		from #tmpMediaList as tt WITH (READUNCOMMITTED), MMVolume as MV WITH (READUNCOMMITTED)
		where spareGroupType in(1,2, 32) and
		(MediaLocation = 2 OR (mediaLocation = 1 and SlotType = 1 ))
		and tt.MediaSideId = MV.MediaSideId and MV.VolumeState <> 2
		-- 05/23/2006 cliu
		-- Sort Meida based on SpareGroupId and NumOfReuses
		-- Spare Group has attributes either MMS2_SPAREGROUP_SELECT_MOST_USED or MMS2_SPAREGROUP_SELECT_LEAST_USED
		-- Funtion SIGN( Attributes & MMS2_SPAREGROUP_SELECT_MOST_USED - 1 ) will return positive (1) for this setting
		-- and negative (-1) for the other setting
		order by	tt.SpareGroupId,
				SIGN( (tt.SpareGroupAttributes & 8) - 1 ) * tt.NumReuses
	END
	ELSE
	BEGIN
		-- for magnetic media, when we do a mount path validation, we should proceed even if there is no volume present.
		declare @b_NoVolumeforMedia integer = 0
		IF NOT EXISTS(select * from #tmpMediaList tt, MMVolume v with (READUNCOMMITTED) where tt.MediaId = v.MediaId and tt.mediaSideId = v.MediaSideId )
		BEGIN
			set @b_NoVolumeforMedia = 1
		END
		IF(@b_NoVolumeforMedia = 0) -- return NON STUCK MEDIA
		BEGIN
			select tt.Mediaid, tt.MediaBarcode, tt.mediatype, tt.mediatypename,
			tt.iscleaningmedia, tt.isWormMedia, tt.libraryId,
			tt.ReservationId, tt.isAged, tt.mediaSideId, tt.MediasideName, tt.isMediaDeprecatable
			from #tmpMediaList as tt WITH (READUNCOMMITTED), MMVolume as MV WITH (READUNCOMMITTED)
			where (MediaLocation = 2 OR (mediaLocation = 1 and SlotType = 1 ))
			and tt.MediaSideId = MV.MediaSideId and MV.VolumeState <> 2
		END
		ELSE
		BEGIN
			select tt.Mediaid, tt.MediaBarcode, tt.mediatype, tt.mediatypename,
			tt.iscleaningmedia, tt.isWormMedia, tt.libraryId,
			tt.ReservationId, tt.isAged, tt.mediaSideId, tt.MediasideName, tt.isMediaDeprecatable
			from #tmpMediaList as tt WITH (READUNCOMMITTED)
			where (MediaLocation = 2 OR (mediaLocation = 1 and SlotType = 1 ))
		END
	END
	drop table #tmpMediaList
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2GetMediaListByDriveRecFmt')
	delete from GxQscripts where name = 'MMS2GetMediaListByDriveRecFmt'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetMediaListByDriveRecFmt')
	delete from GXDBVersions where aliasname = 'MMS2GetMediaListByDriveRecFmt'
GO

insert into GXDBVersions values(2, 'MMS2GetMediaListByDriveRecFmt',  '00010005007200030000', 'MMS2GetMediaListByDriveRecFmt', '00010005007200030000')
GO

