

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GetMediaInfoForCVMMDBInterface.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2GetMediaInfoForCVMMDBInterface.sp,v $ $Id: MMS2GetMediaInfoForCVMMDBInterface.sp,v 1.5 2011/03/31 14:56:05 anarulkar Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2GetMediaInfoForCVMMDBInterface <<<'

IF EXISTS (select * from sysobjects where name='MMS2GetMediaInfoForCVMMDBInterface')
	drop procedure MMS2GetMediaInfoForCVMMDBInterface
IF EXISTS (select * from GxQscripts where name='MMS2GetMediaInfoForCVMMDBInterface')
	delete from GxQscripts where name = 'MMS2GetMediaInfoForCVMMDBInterface'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetMediaInfoForCVMMDBInterface')
	delete from GXDBVersions where aliasname = 'MMS2GetMediaInfoForCVMMDBInterface'
GO
print '... Creating Procedure: MMS2GetMediaInfoForCVMMDBInterface'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2GetMediaInfoForCVMMDBInterface
  @i_MediaId integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_GuiAttribute integer
  DECLARE @o_NumVols integer
  DECLARE @o_SlotId integer
  DECLARE @o_SlotName varchar(255)
  DECLARE @o_DriveId integer
  DECLARE @o_DriveAliasName NVARCHAR(255)
  DECLARE @o_ExportLocationId Integer
  DECLARE @o_ExportLocationName NVARCHAR(255)
  DECLARE @o_ContainerId Integer
  DECLARE @o_ContainerName NVARCHAR(255)
	DECLARE @l_slotId INTEGER
	DECLARE @l_slotName VarChar(255)
	DECLARE @l_driveId INTEGER
	DECLARE @l_driveAliasName NVarChar(255)
	DECLARE @l_exportLocationId INTEGER
	DECLARE @l_exportLocationName NVarChar(255)
	DECLARE @l_containerId INTEGER
	--  find media location
	DECLARE @l_MediaLocation INTEGER
	SELECT @l_MediaLocation = MediaLocation, @l_ExportLocationId = ExportLocationId, @l_containerId = ContainerId
	FROM MMMedia WITH (NOLOCK)
	WHERE MediaId = @i_MediaId
	IF (@l_MediaLocation  = 1)
	BEGIN
		SELECT TOP 1 @l_slotId = slotId, @l_slotName = Slotname
		FROM MMSlot WITH (NOLOCK)
		WHERE MediaId = @i_MediaId
	END
	IF (@l_MediaLocation  = 2)
	BEGIN
		SELECT TOP 1 @l_driveId = driveId, @l_driveAliasName  = aliasName
		FROM MMDrive WITH (NOLOCK)
		WHERE MediaId = @i_MediaId
	END
	IF (@l_MediaLocation = 3)
	BEGIN
		SELECT TOP 1 @l_ExportLocationName = ExportLocation
		FROM MMExportLocation WITH (NOLOCK)
		WHERE ExportLocationId = @l_ExportLocationId
	END
	SELECT
		dbo.MMS2FUNC_GetGUIMediaAttribute(@i_MediaId ) AS GuiAttribute,
		(SELECT count(VolumeId) FROM MMVolume WITH (NOLOCK) WHERE MediaId = @i_MediaId ) AS NumVold,
		isnull(@l_slotId, 0) AS SlotId,
		isnull(@l_slotName, '') AS SlotName,
		isnull(@l_driveId, 0) AS DriveId,
		isnull(@l_driveAliasName, '') AS DriveAliasName,
		@l_ExportLocationId,
		isnull(@l_ExportLocationName, '') AS ExportLocationName,
		@l_containerId,
		isnull((SELECT ContainerName FROM MMContainer WITH (NOLOCK) WHERE ContainerId = @l_ContainerId ), '') AS ContainerName
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2GetMediaInfoForCVMMDBInterface')
	delete from GxQscripts where name = 'MMS2GetMediaInfoForCVMMDBInterface'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetMediaInfoForCVMMDBInterface')
	delete from GXDBVersions where aliasname = 'MMS2GetMediaInfoForCVMMDBInterface'
GO

insert into GXDBVersions values(2, 'MMS2GetMediaInfoForCVMMDBInterface',  '00010005000000000000', 'MMS2GetMediaInfoForCVMMDBInterface', '00010005000000000000')
GO

