

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GetMediaGroupInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2GetMediaGroupInfo.sp,v $ $Id: MMS2GetMediaGroupInfo.sp,v 1.8.208.4 2018/03/20 19:56:50 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "MMS2GetMediaGroupInfo"				|
--	|									|
--	| Execute the System stored procedure to fetch the physical files	|
--	| .. for the (current) database.					|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2GetMediaGroupInfo <<<'

IF EXISTS (select * from sysobjects where name='MMS2GetMediaGroupInfo')
	drop procedure MMS2GetMediaGroupInfo
IF EXISTS (select * from GxQscripts where name='MMS2GetMediaGroupInfo')
	delete from GxQscripts where name = 'MMS2GetMediaGroupInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetMediaGroupInfo')
	delete from GXDBVersions where aliasname = 'MMS2GetMediaGroupInfo'
GO
print '... Creating Procedure: MMS2GetMediaGroupInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2GetMediaGroupInfo
  @i_copyId integer,
  @i_stream integer,
  @i_mediaGroupId integer
AS
  DECLARE @mediaGroupId integer
  DECLARE @drivePoolId integer
  DECLARE @drivePoolType integer
  DECLARE @spareGroupId integer
  DECLARE @hardwareCompressed integer
  DECLARE @desiredMediaTypeId integer
  DECLARE @recordingFormatId integer
  DECLARE @spareGroupName NVARCHAR(255)
  DECLARE @mediaAgentId integer
  DECLARE @mediaAgentName char(255)
  DECLARE @hostAttribute integer
  DECLARE @libraryId integer
  DECLARE @libraryName NVARCHAR(255)
DECLARE @l_ClientId				integer
DECLARE @l_MasterPoolId			integer
DECLARE @l_DrivePoolType		integer
DECLARE @l_DrivePoolId			integer
DECLARE @l_SpareGroupId			integer
DECLARE @l_DesiredMediaTypeId	integer
DECLARE @l_RecordingFormatId	integer
DECLARE @l_IsHardwareCompressed	integer
DECLARE @l_copyId				integer
SET		@l_ClientId = 0
SET		@l_MasterPoolId = 0
SET		@l_DrivePoolType = 0
SET		@l_DrivePoolId = 0
SET		@l_SpareGroupId = 0
SET		@l_DesiredMediaTypeId = 0
SET		@l_RecordingFormatId = 0
SET		@l_IsHardwareCompressed = 0
SET		@l_copyId = 0
DECLARE @l_DataPathId integer = 0
IF	@i_mediaGroupId <= 0
	SELECT	@i_mediaGroupId = archStream.mediaGroupId
	FROM	archStream
	WHERE	archGroupCopyId = @i_copyId AND stream = @i_stream
if ((select COUNT(archGroupCopyId) from archStream where mediaGroupId = @i_mediaGroupId) = 1)
begin
	set @l_copyId = (select ArchGroupCopyId from ArchStream where MediaGroupId = @i_mediaGroupId)
end
else
begin --get the GACP copyinfo
set @l_copyId = (select id from archGroupCopy where id in (select archGroupCopyId from archStream where mediaGroupId = @i_mediaGroupId) and (extendedFlags & 1) > 0)
end
SELECT	@l_DrivePoolId			= DrivePoolId,
		@l_SpareGroupId			= SpareGroupId,
		@l_DesiredMediaTypeId	= DesiredMediaTypeId,
		@l_RecordingFormatId	= RecordingFormatId
FROM	MMMediaGroup
WHERE	MediaGroupId = @i_mediaGroupId
IF @l_DrivePoolId = 0
BEGIN
       SELECT TOP 1 @l_DrivePoolId = DrivePoolId, @l_DatapathId = DataPathId, @l_SpareGroupId = SpareGroupId
       FROM   MMDataPath WITH (NOLOCK)
       WHERE  copyId = @l_copyId
AND    flag & 4 > 0
AND    flag & 16 = 0
AND    flag & 1 > 0
       select top 1 @l_DesiredMediaTypeId = isnull(dt.DefaultMediaTypeId, 0),
                    @l_RecordingFormatId = isnull(rfmt.RecordingFormatId, 0)
       from MMDriveType as dt with (readuncommitted), MMRecFmtMedTyp as rfmt with (readuncommitted),
			MMDrivePool as dp with (readuncommitted), MMDrive as d with (readuncommitted)
       where dp.DrivePoolId = @l_DrivePoolId
	   and	dt.DriveTypeId = d.DriveTypeId
       and	dt.DriveTypeId = rfmt.DriveTypeId
	   and	dp.MasterPoolId = d.MasterPoolId
       order by rfmt.RecordingFormatId desc
       UPDATE 	MMMediaGroup
       SET    	DrivePoolId = @l_DrivePoolId, DataPathId = @l_DatapathId, SpareGroupId = @l_SpareGroupId,
				DesiredMediaTypeId = @l_DesiredMediaTypeId, RecordingFormatId = @l_RecordingFormatId
       WHERE	MediaGroupId = @i_mediaGroupId
END
SELECT	@l_DrivePoolType		= DrivePoolType,
		@l_ClientId				= ClientId,
		@l_MasterPoolId			= MasterPoolId
FROM	MMDrivePool
WHERE	DrivePoolId = @l_DrivePoolId
SELECT	@l_IsHardwareCompressed = IsHardwareCompressed
FROM	MMDataPath
WHERE	CopyId = @l_copyId --(select ArchGroupCopyId from ArchStream where MediaGroupId = @i_mediaGroupId)
	AND	DrivePoolId = @l_DrivePoolId
SELECT	DISTINCT @i_mediaGroupId,
		@l_DrivePoolId,
		@l_DrivePoolType,
		@l_SpareGroupId,
		@l_IsHardwareCompressed,
		@l_DesiredMediaTypeId,
		@l_RecordingFormatId,
		(SELECT SpareGroupName FROM MMSpareGroup WHERE SpareGroupId = @l_SpareGroupId),
		@l_ClientId,
		(SELECT net_hostname FROM APP_Client WHERE id = @l_ClientId),
		(SELECT Attribute FROM MMHost WHERE ClientId = @l_ClientId),
		ml.LibraryId,
		ml.AliasName
FROM	MMMasterPool mm, MMLibrary ml
WHERE	mm.MasterPoolId = @l_MasterPoolId
	AND ml.LibraryId = mm.LibraryId
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2GetMediaGroupInfo')
	delete from GxQscripts where name = 'MMS2GetMediaGroupInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetMediaGroupInfo')
	delete from GXDBVersions where aliasname = 'MMS2GetMediaGroupInfo'
GO

insert into GXDBVersions values(2, 'MMS2GetMediaGroupInfo',  '00010008020800040000', 'MMS2GetMediaGroupInfo', '00010008020800040000')
GO

