

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GetMediaFromWrongLibList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2GetMediaFromWrongLibList.sp,v $ $Id: MMS2GetMediaFromWrongLibList.sp,v 1.2.278.1 2018/03/20 19:55:52 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "MMS2GetMediaFromWrongLibList"				|
--	|									|
--	| Execute the System stored procedure to fetch the physical files	|
--	| .. for the (current) database.					|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2GetMediaFromWrongLibList <<<'

IF EXISTS (select * from sysobjects where name='MMS2GetMediaFromWrongLibList')
	drop procedure MMS2GetMediaFromWrongLibList
IF EXISTS (select * from GxQscripts where name='MMS2GetMediaFromWrongLibList')
	delete from GxQscripts where name = 'MMS2GetMediaFromWrongLibList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetMediaFromWrongLibList')
	delete from GXDBVersions where aliasname = 'MMS2GetMediaFromWrongLibList'
GO
print '... Creating Procedure: MMS2GetMediaFromWrongLibList'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2GetMediaFromWrongLibList
  @i_LibraryId integer
AS
  DECLARE @o_MediaId integer
  DECLARE @o_UniqueId varchar(256)
  DECLARE @o_BarCode varchar(256)
  DECLARE @o_MediaTypeId integer
  DECLARE @o_CreationTime integer
  DECLARE @o_NumberOfReUses integer
  DECLARE @o_LastRestoreTime integer	
  DECLARE @o_LastBackupTime integer
  DECLARE @o_LibraryId integer
  DECLARE @o_SpareGroupId integer
  DECLARE @o_LastExportTime integer
  DECLARE @o_MediaLocation integer
  DECLARE @o_ExternalGUID varchar(256)
  DECLARE @o_MediaFlags integer
  DECLARE @o_IsOMLWritten integer
  DECLARE @o_MediaStatusReason integer
  DECLARE @o_ExportLocationId integer
  DECLARE @o_LastWriteLibraryId integer
  DECLARE @o_Attributes integer
  DECLARE @o_ContainerId integer
  DECLARE @o_OverWritejobId integer
  DECLARE @o_origCCCommCellId integer
  DECLARE @o_OrigCCMediaId integer
  DECLARE @o_IsAged integer
  DECLARE @o_IsInMediaGroup integer
	declare @l_BayId	integer
	set @l_BayId = (select BayId from MMBay WITH (READUNCOMMITTED) where LibraryId = @i_LibraryId)
	IF object_id('tempdb.dbo.#tmpMedList') is not null DROP TABLE #tmpMedList
	create table #tmpMedList(MediaId		integer,
				libraryId		integer,
				spareGroupId		integer,
				hasData			integer,
				isAssigned		integer)
	create index #tmpMedList_mediaId ON #tmpMedList (mediaId)
	declare @lt_slotsInBay TABLE (SlotId Integer primary key, MediaId Integer, BarCode VarChar(256))
	insert into @lt_slotsInBay
	SELECT SlotId, MediaId, BarCode
	FROM MMSlot WITH(INDEX(MMS2Slot_BayId))
	WHERE BayId = @l_BayId AND ( MediaId <> 0 OR BarCode <> '' ) AND SlotType = 1
	insert into #tmpMedList
	select MM.MediaId,
		case
		  when MM.LibraryId > 0 then MM.LibraryId
		  when MM.LibraryId = 0 then MM.LastWriteLibraryId
		end,
		MM.SpareGroupId,
		IsInMediaGroup & IsAged,
		IsInMediaGroup
	from @lt_slotsInBay AS TS
		INNER JOIN MMMedia AS MM WITH (READUNCOMMITTED) ON MM.MediaId = TS.MediaId
	where TS.mediaid > 0
	union all
	select MM.MediaId,
		case
		  when MM.LibraryId > 0 then MM.LibraryId
		  when MM.LibraryId = 0 then MM.LastWriteLibraryId
		end,
		MM.SpareGroupId,
		IsInMediaGroup & IsAged, IsInMediaGroup
	from @lt_slotsInBay AS TS
		INNER JOIN MMMedia AS MM WITH (READUNCOMMITTED) ON MM.Barcode = TS.BarCode
	where TS.BarCode <> '' and TS.mediaid = 0
	update #tmpMedList
	set LibraryId = MMP.LibraryId
	from #tmpMedList as tt
		INNER JOIN MMVolume as MV WITH (READUNCOMMITTED) ON MV.MediaId = tt.Mediaid
		INNER JOIN MMMediaGroup as MMG WITH (READUNCOMMITTED) ON MMG.MediaGroupId = MV.MediaGroupId
		INNER JOIN MMDrivePool as MDP WITH (READUNCOMMITTED) ON MDP.DrivePoolId = MMG.DrivePoolId
		INNER JOIN MMMasterPool as MMp WITH (READUNCOMMITTED) ON MMP.MasterPoolId = MDP.MasterPoolId
	where tt.LibraryId = 0 AND tt.hasData > 0
	update #tmpMedList
	set LibraryId = MSG.LibraryId
	from MMSpareGroup as MSG WITH (READUNCOMMITTED), #tmpMedList as tt
	where tt.LibraryId = 0 AND tt.isAssigned = 0 and tt.SpareGroupId = MSG.SpareGroupId
	--If the both SpareGroupId and MediaGroupId are both are greater than zero
	--then this is an error condition. However if both are equal to zero then it is ok as the library may have been deconfigured
	--We shouldn't do anything on these media. So take them out of the list
	--delete from #tmpMedList
	--where (spareGroupId <> 0 and MediaGroupId <> 0)
	select MM.MediaId, MM.UniqueId, MM.BarCode, MM.MediaTypeId, MM.CreationTime, MM.NumberOfReUses,
	MM.LastRestoreTime,MM.LastBackupTime, MM.LibraryId, MM.SpareGroupId, MM.LastExportTime,
	MM.MediaLocation,MM.ExternalGUID, MM.MediaFlags, MM.IsOMLWritten, MM.MediaStatusReason, MM.ExportLocationId,
	tt.libraryId, MM.Attributes, MM.ContainerId, MM.OverWritejobId, MM.origCCCommCellId, MM.OrigCCMediaId,
	MM.IsAged, MM.IsInMediaGroup
	from MMMedia as MM WITH (READUNCOMMITTED), #tmpMedList as tt
	where MM.MediaId = tt.MediaId and
	( (tt.libraryId <> @i_LibraryId) OR
		(tt.LibraryId = @i_LibraryId AND MM.SpareGroupId NOT IN
			(select SpareGroupId from MMSpareGroup where LibraryId = @i_LibraryId)) )
	drop table #tmpMedList
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2GetMediaFromWrongLibList')
	delete from GxQscripts where name = 'MMS2GetMediaFromWrongLibList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetMediaFromWrongLibList')
	delete from GXDBVersions where aliasname = 'MMS2GetMediaFromWrongLibList'
GO

insert into GXDBVersions values(2, 'MMS2GetMediaFromWrongLibList',  '00010002027800010000', 'MMS2GetMediaFromWrongLibList', '00010002027800010000')
GO

