

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GetMediaBasicInfoSP.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2GetMediaBasicInfoSP.sp,v $ $Id: MMS2GetMediaBasicInfoSP.sp,v 1.12.208.2 2018/03/20 19:50:05 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "MMS2GetMediaBasicInfoSP"				|
--	|									|
--	| Execute the System stored procedure to fetch the physical files	|
--	| .. for the (current) database.					|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2GetMediaBasicInfoSP <<<'

IF EXISTS (select * from sysobjects where name='MMS2GetMediaBasicInfoSP')
	drop procedure MMS2GetMediaBasicInfoSP
IF EXISTS (select * from GxQscripts where name='MMS2GetMediaBasicInfoSP')
	delete from GxQscripts where name = 'MMS2GetMediaBasicInfoSP'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetMediaBasicInfoSP')
	delete from GXDBVersions where aliasname = 'MMS2GetMediaBasicInfoSP'
GO
print '... Creating Procedure: MMS2GetMediaBasicInfoSP'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2GetMediaBasicInfoSP
  @i_mediaId int
AS
  DECLARE @o_numSides integer
  DECLARE @o_libraryId integer
  DECLARE @o_scratchPoolId integer
  DECLARE @o_scratchPoolName NVARCHAR(255)
  DECLARE @o_scratchPoolType integer
  DECLARE @o_barCode char(255)
  DECLARE @o_uniqueId char(255)
  DECLARE @o_creationTime integer
  DECLARE @o_lastExportTime integer
  DECLARE @o_mediaFlags integer
  DECLARE @o_mediaLocation integer
  DECLARE @o_mediaTypeId integer
  DECLARE @o_exportLocationId integer
  DECLARE @o_exportLocation NVARCHAR(255)
  DECLARE @o_driveLocation char(255)
  DECLARE @o_driveId integer
  DECLARE @o_slotLocation char(255)
  DECLARE @o_slotId integer
  DECLARE @o_mediaStatus integer
  DECLARE @o_isCleaningMedia integer
  DECLARE @o_StatusReason integer
  DECLARE @o_lastWriteTime integer
  DECLARE @o_libraryType integer
  DECLARE @o_libraryAliasName NVARCHAR(255)
  DECLARE @o_libExtGUID char(255)
  DECLARE @o_libUseAppendableMedia integer
  DECLARE @o_lastWriteLibraryId integer
  DECLARE @o_lastWriteLibraryType integer
  DECLARE @o_lastWriteLibraryName NVARCHAR(255)
  DECLARE @o_lastWriteLibExtGUID char(255)
  DECLARE @o_lastWriteLibUseAppendableMedia integer
  DECLARE @o_libAttribute integer
  DECLARE @o_lastWriteAttribute integer
  DECLARE @o_mediaAttributes integer
  DECLARE @o_guiAttributes integer
  DECLARE @o_isMediaAtVMS integer
  DECLARE @o_containerId integer
  DECLARE @o_containerName NVARCHAR(255)
  DECLARE @o_mediaGroupId integer
  DECLARE @o_streamNumber integer
  DECLARE @o_origMediaDBCommcellId integer
  DECLARE @o_origMediaCommcellId integer
  DECLARE @o_origMediaCommcellName char(255)
  DECLARE @o_hasExtendedRetentionJobs integer
  DECLARE @o_estimatedReturnToSpareTime bigint
  DECLARE @o_isAged integer
  DECLARE @o_isInMediaGroup integer
  DECLARE @o_pinMediaExpireTime integer
  DECLARE @o_extendedMediaAttribute integer
-- origMediaDBCommcellId the id in the APP_CommCell table (2,3...)
--  origMediaCommcellId is the actual commcellId (which would be 0xF1234)
	declare @l_availableSlots integer
	declare @l_vmsDirection integer
	declare @l_slotId integer
	declare @l_vmsSlotId integer
	declare @l_libraryId integer
	declare @l_bayId integer
	declare @l_mediaGroupId integer
	set @l_libraryId = (select LibraryId from MMMedia where MediaId = @i_mediaId)
	set @l_vmsDirection = (select VMSDirection from MMLibrary where LibraryId = @l_libraryId)
	-- MR 80997
	-- fixed for GP commcell migration problem - startelementaddress was 0 and all elementaddresses were 0
	set @l_vmsSlotId = (select top 1 s.slotId from MMSlot s, MMBay b where s.BayId = b.BayId and b.LibraryId = @l_libraryId and s.ElementAddress =
		(select StartVMSElementAddress from MMLibrary where LibraryId = @l_libraryId))
	set @l_slotId = (select top 1 slotId from MMSlot where mediaId = @i_mediaId)
	set @l_bayId = (select top 1 BayId from MMBay where LibraryId = @l_libraryId)
	set @l_availableSlots = ( select COUNT(*)
	FROM	MMSlot
	WHERE	((@l_vmsDirection = 1 AND
			((@l_slotId >= @l_vmsSlotId AND SlotId >= @l_vmsSlotId AND SlotId < @l_slotId) OR
			(@l_slotId < @l_vmsSlotId AND SlotId >= @l_vmsSlotId)))
	OR		(@l_vmsDirection = 2 AND
			((@l_slotId <= @l_vmsSlotId AND SlotId <= @l_vmsSlotId AND SlotId > @l_slotId) OR
			(@l_slotId > @l_vmsSlotId AND SlotId <= @l_vmsSlotId))))
	AND (	IsOccupied = 0
		OR
		(	IsOccupied = 1
			AND
			(
				MediaId = 0
				OR
				(	MediaId > 0
					AND
					MediaId NOT IN (SELECT MediaId FROM MMMedia WHERE LibraryId = @l_libraryId AND (Attributes & 1) > 0)
				)
			)
		)
	)
	AND BayId = @l_bayId)
	set @l_mediaGroupId = (select top 1 V.mediaGroupId FROM MMVolume AS V WHERE V.mediaId = @i_mediaId)
	select
	(select count(*) from MMMediaSide as ms where ms.mediaid = mm.mediaid) as NumSides,
	mm.libraryid,
	mm.sparegroupid,
	(select SpareGroupName from MMSpareGroup WHERE SpareGroupId = mm.sparegroupid) as SpareGroupName,
	(select SpareGroupType from MMSpareGroup WHERE SpareGroupId = mm.sparegroupid) as SpareGroupType,
	mm.barcode,
	mm.uniqueid,
	mm.creationtime,
	mm.lastexporttime,
	mm.mediaflags,
	mm.medialocation,
	mm.mediatypeid,
	mm.exportlocationid,
	me.exportlocation,
	(select aliasname from MMDrive as md where md.mediaid = mm.mediaid) as DriveLocation,
	(select driveId from MMDrive as md where md.mediaid = mm.mediaid) as DriveId,
	(select  top 1 slotname from MMSlot as ms where ms.mediaid = mm.mediaid) as SlotLocation,
	(select  top 1 slotId from MMSlot as ms where ms.mediaid = mm.mediaid) as SlotId,
	(select top 1 mediastatus from MMSlot as ms where ms.mediaid = mm.mediaid) as MediaStatus,
	mt.iscleaningmedia,
	mm.MediaStatusReason,
	mm.LastBackupTime,
	(select libraryTypeId from MMLibrary where LibraryId = mm.LibraryId) as LibraryType,
	(select aliasName from MMLibrary where LibraryId = mm.LibraryId) as LibraryName,
	(select ExternalGUID from MMLibrary where LibraryId = mm.LibraryId) as LibExtGUID,
	(select UseWithinDaysInSec from MMLibrary where LibraryId = mm.LibraryId) as LibUseAppendableMedia,
	mm.LastWriteLibraryId,
	(select libraryTypeId from MMLibrary where LibraryId = mm.LastWriteLibraryId) as LastWriteLibraryType,
	(select aliasName from MMLibrary where LibraryId = mm.LastWriteLibraryId) as LastWriteLibraryName,
	(select ExternalGUID from MMLibrary where LibraryId = mm.LastWriteLibraryId) as LastWriteLibExtGUID,
	(select UseWithinDaysInSec from MMLibrary where LibraryId = mm.LastWriteLibraryId) as LastWriteLibUseAppendableMedia,
	(select LibraryAttribute from MMLibrary where LibraryId = mm.LibraryId) as LibAttribute,
	(select LibraryAttribute from MMLibrary where LibraryId = mm.LastWriteLibraryId) as LastWriteAttribute,
	mm.Attributes,
	dbo.MMS2FUNC_GetGUIMediaAttribute(mm.mediaId) as GuiAttributes,
	@l_availableSlots as AvailableSlots,
	mm.ContainerId,
	mc.ContainerName,
	isnull(@l_mediaGroupId,0) as MediaGroupId,
isnull((select ASt.stream from ArchStream AS ASt WHERE Ast.MediaGroupId = @l_mediaGroupId and (flags & 2) = 0),0) as StreamNumber,
	mm.origCCcommCellID as origMediaDBCommcellId,
	isnull((select number from APP_CommCell WHERE id = mm.origCCcommCellID), 0) as origMediaCommcellId,
	isnull((select aliasName from APP_CommCell WHERE id = mm.origCCcommCellID), '') as origMediaCommcellName,
	mm.retentionFlags,
	mm.retentionExpireTime,
	mm.IsAged,
	mm.IsInMediaGroup,
	mm.PinMediaExpireTime,
	mm.ExtendedAttributes
	from MMMedia as mm, MMMediaType as mt, MMExportLocation as me, MMContainer mc
	where mt.mediatypeid = mm.mediatypeid and mm.exportlocationid = me.exportlocationid
	and mm.mediaid = @i_mediaId and mc.ContainerId = mm.ContainerId
	return;
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2GetMediaBasicInfoSP')
	delete from GxQscripts where name = 'MMS2GetMediaBasicInfoSP'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetMediaBasicInfoSP')
	delete from GXDBVersions where aliasname = 'MMS2GetMediaBasicInfoSP'
GO

insert into GXDBVersions values(2, 'MMS2GetMediaBasicInfoSP',  '00010012020800020000', 'MMS2GetMediaBasicInfoSP', '00010012020800020000')
GO

