

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GetMediaAgentsForUser.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2GetMediaAgentsForUser <<<'

IF EXISTS (select * from sysobjects where name='MMS2GetMediaAgentsForUser')
	drop procedure MMS2GetMediaAgentsForUser
IF EXISTS (select * from GxQscripts where name='MMS2GetMediaAgentsForUser')
	delete from GxQscripts where name = 'MMS2GetMediaAgentsForUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetMediaAgentsForUser')
	delete from GXDBVersions where aliasname = 'MMS2GetMediaAgentsForUser'
GO
print '... Creating Procedure: MMS2GetMediaAgentsForUser'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2GetMediaAgentsForUser
  @i_userId integer
AS
  DECLARE @o_ClientId integer
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
----------------------------------------------
--------------- Security Check ---------------
----------------------------------------------
DECLARE @userId	INTEGER = @i_userId
DECLARE @csCapabilities bigint = 0
DECLARE @csCapabilitiesForClient bigint = 0
DECLARE @tblSecMediaAgent table (MediaAgentId int, Capabilities bigint)
IF object_id('tempdb.dbo.#tblSecObj_MA') is not null DROP TABLE #tblSecObj_MA
IF object_id('tempdb.dbo.#tblSecObj_Client') is not null DROP TABLE #tblSecObj_Client
create table  #tblSecObj_MA ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
create table  #tblSecObj_Client ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
EXEC sec_getUserObjects @userId, 2048, 0, '#tblSecObj_MA'
EXEC sec_getUserObjects @userId, 2009, 0, '#tblSecObj_Client'
--Only care about visibility, no capability check is needed here!
IF EXISTS (SELECT * FROM #tblSecObj_MA sec WHERE (sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0))
BEGIN
	-- User group associated with CS
SELECT @csCapabilities = capabilities FROM #tblSecObj_MA sec WHERE (sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0)
END
IF EXISTS (SELECT * FROM #tblSecObj_Client sec WHERE (sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0))
BEGIN
	-- User group associated with CS
SELECT @csCapabilitiesForClient = capabilities FROM #tblSecObj_Client sec WHERE (sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0)
END
-- Get all media agents associated specifically to user group
INSERT INTO @tblSecMediaAgent
SELECT	MediaAgentId, capabilities
FROM	#tblSecObj_MA A
		INNER JOIN MMHost MA WITH (READUNCOMMITTED) ON A.clientId = MA.clientId
WHERE	A.MediaAgentId > 0
INSERT INTO @tblSecMediaAgent
SELECT	A.clientId, A.capabilities
FROM	#tblSecObj_Client A
		INNER JOIN MMHost MA WITH (READUNCOMMITTED) ON A.clientId = MA.clientId
WHERE	A.clientId > 0
		AND A.ClientId NOT IN (SELECT MediaAgentId FROM @tblSecMediaAgent)
IF @csCapabilities > 0
BEGIN
	-- Update capabilities for ALL Media Agents
	UPDATE @tblSecMediaAgent
	SET capabilities = capabilities | @csCapabilities | @csCapabilitiesForClient
	INSERT INTO @tblSecMediaAgent
	SELECT ClientId, @csCapabilities
	FROM MMHost WITH (NOLOCK)
	WHERE ClientId > 1
	AND ClientId NOT IN (SELECT MediaAgentId FROM @tblSecMediaAgent)
END
IF object_id('tempdb.dbo.#tblMMS2GetMediaAgentsForUserResult') IS NOT NULL
BEGIN
	INSERT INTO #tblMMS2GetMediaAgentsForUserResult
	SELECT MediaAgentId FROM @tblSecMediaAgent
END
ELSE
BEGIN
	SELECT MediaAgentId FROM @tblSecMediaAgent
END
IF object_id('tempdb.dbo.#tblSecObj_MA') is not null DROP TABLE #tblSecObj_MA
IF object_id('tempdb.dbo.#tblSecObj_Client') is not null DROP TABLE #tblSecObj_Client
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2GetMediaAgentsForUser')
	delete from GxQscripts where name = 'MMS2GetMediaAgentsForUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetMediaAgentsForUser')
	delete from GXDBVersions where aliasname = 'MMS2GetMediaAgentsForUser'
GO

insert into GXDBVersions values(2, 'MMS2GetMediaAgentsForUser',  '00000000000000000000', 'MMS2GetMediaAgentsForUser', '00000000000000000000')
GO

