

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GetMediaAgentList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2GetMediaAgentList.sp,v $ $Id: MMS2GetMediaAgentList.sp,v 1.47.12.8 2020/12/15 21:59:17 cnaik Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "MMS2GetMediaAgentList"				|
--	|									|
--	| Execute the System stored procedure to fetch the physical files	|
--	| .. for the (current) database.					|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MMS2GetMediaAgentList')
BEGIN
	print '>>> Drop Stored Procedure: MMS2GetMediaAgentList <<<'
	drop procedure MMS2GetMediaAgentList
END
IF EXISTS (select * from GxQscripts where name='MMS2GetMediaAgentList')
	delete from GxQscripts where name = 'MMS2GetMediaAgentList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetMediaAgentList')
	delete from GXDBVersions where aliasname = 'MMS2GetMediaAgentList'
GO
print '... Creating Procedure: MMS2GetMediaAgentList'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MMS2GetMediaAgentList
  @i_userId integer,
  @i_maId integer = 0,
  @i_checkMAPermission integer = 0
AS
  DECLARE @o_hostClientId integer
  DECLARE @o_hostName char(255)
  DECLARE @o_hostDisplayName char(255)
  DECLARE @o_hostNetworkName char(255)
  DECLARE @o_hostType integer
  DECLARE @o_softState integer
  DECLARE @o_enabled integer
  DECLARE @o_MAOfflineReason integer
  DECLARE @o_ReleaseId integer
  DECLARE @o_SoftWareRelease char(255)
  DECLARE @o_SoftWareBuildId char(255)
  DECLARE @o_SystemOsVersion char(255)
  DECLARE @o_SystemHardWare char(255)
  DECLARE @o_SystemOsId integer
  DECLARE @o_numLibraries integer   -- Deprecated, not used in GUI/Adminconsole
  DECLARE @o_isCommServer integer
  DECLARE @o_isVirtualClient integer
  DECLARE @o_attribute integer
  DECLARE @o_IsUnlicensedMA integer
  DECLARE @o_isPreConfigured integer
  DECLARE @o_patchStatus integer
  DECLARE @o_isMACatalogServer integer
  DECLARE @o_isEDCDiscovered integer
  DECLARE @o_MAMaxReservations integer
  DECLARE @o_flags integer
  DECLARE @o_description nvarchar(max)
  DECLARE @o_Capabilities bigint
  DECLARE @o_InstalledTime integer
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
----------------------------------------------
--------------- Security Check ---------------
----------------------------------------------
DECLARE @userId	INTEGER = @i_userId
DECLARE @csCapabilities bigint = 0
DECLARE @csCapabilitiesForClient bigint = 0
DECLARE @tblSecMediaAgent table (MediaAgentId int, Capabilities bigint)
IF object_id('tempdb.dbo.#tblSecObj_MA') is not null DROP TABLE #tblSecObj_MA
IF object_id('tempdb.dbo.#tblSecObj_Client') is not null DROP TABLE #tblSecObj_Client
IF object_id('tempdb.dbo.#tmpOSPlatform') is not null DROP TABLE #tmpOSPlatform
create table  #tblSecObj_MA ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
create table  #tblSecObj_Client ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
EXEC sec_getUserObjects @userId, 2048, 0, '#tblSecObj_MA'
EXEC sec_getUserObjects @userId, 2009, 0, '#tblSecObj_Client'
--Only care about visibility, no capability check is needed here!
IF EXISTS (SELECT * FROM #tblSecObj_MA sec WHERE (sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0))
BEGIN
	-- User group associated with CS
SELECT @csCapabilities = capabilities FROM #tblSecObj_MA sec WHERE (sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0)
END
IF EXISTS (SELECT * FROM #tblSecObj_Client sec WHERE (sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0))
BEGIN
	-- User group associated with CS
SELECT @csCapabilitiesForClient = capabilities FROM #tblSecObj_Client sec WHERE (sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0)
END
-- Get all media agents associated specifically to user group
INSERT INTO @tblSecMediaAgent SELECT MediaAgentId, capabilities from #tblSecObj_MA WHERE MediaAgentId > 0 AND @i_maId = 0 OR MediaAgentId = @i_maId
INSERT INTO @tblSecMediaAgent SELECT A.clientId, A.capabilities from #tblSecObj_Client A, MMHost B WITH (NOLOCK) WHERE A.clientId = B.clientId and A.clientId > 0
	AND A.ClientId NOT IN (SELECT MediaAgentId FROM @tblSecMediaAgent) AND (@i_maId = 0 OR A.clientId = @i_maId)
IF @csCapabilities > 0
BEGIN
	-- Update capabilities for ALL Media Agents
	UPDATE @tblSecMediaAgent
	SET capabilities = capabilities | @csCapabilities | @csCapabilitiesForClient
	IF @i_maId <> 0
	BEGIN
		INSERT INTO @tblSecMediaAgent
		SELECT ClientId, @csCapabilities
		FROM MMHost WITH (NOLOCK)
		WHERE ClientId > 1
		AND ClientId NOT IN (SELECT MediaAgentId FROM @tblSecMediaAgent)
		AND ClientId = @i_maId
	END
	ELSE
	BEGIN
		INSERT INTO @tblSecMediaAgent
		SELECT ClientId, @csCapabilities
		FROM MMHost WITH (NOLOCK)
		WHERE ClientId > 1
		AND ClientId NOT IN (SELECT MediaAgentId FROM @tblSecMediaAgent)
	END
END
IF @i_checkMAPermission = 1
BEGIN
	IF OBJECT_ID('tempdb.dbo.#getNonIdaObjects') IS NOT NULL DROP TABLE #getNonIdaObjects
	CREATE TABLE #getNonIdaObjects (entityId INT)
EXEC sec_getNonIdaObjectsForThisUser @userId,11,10,'#getNonIdaObjects'
	DELETE TMP
	FROM @tblSecMediaAgent  TMP
	LEFT OUTER JOIN #getNonIdaObjects TMP1 ON TMP.MediaAgentId = TMP1.entityId
	WHERE TMP1.entityId IS NULL
	IF OBJECT_ID('tempdb.dbo.#getNonIdaObjects') IS NOT NULL DROP TABLE #getNonIdaObjects
END
IF object_id('tempdb.dbo.#tblSecObj_MA') is not null DROP TABLE #tblSecObj_MA
IF object_id('tempdb.dbo.#tblSecObj_Client') is not null DROP TABLE #tblSecObj_Client
    DECLARE  @showHiddenMediaAgentsConfig INTEGER = 0
    ----------------------------------------------
    -- Get 'MMCONFIG_SHOW_MEDIAAGENTS_WITH_NO_LIBRARIES' value from MMConfigs
    ----------------------------------------------
    SELECT @showHiddenMediaAgentsConfig = value
    FROM    MMConfigs WITH (NOLOCK)
    WHERE NAME = 'MMCONFIG_SHOW_MEDIAAGENTS_WITH_NO_LIBRARIES'
----------------------------------------------
/*  o_flags Value        Description
-----------------------------------------------------
      1                   "Enable Snap Backups" is set  and Library is configured with MA
      2                    Not configured with any library
*/
	DECLARE @tmpClientProp TABLE (
	clientId integer,
	attrName nvarchar(max),
	attrVal  nvarchar(max))
	INSERT INTO @tmpClientProp
	SELECT componentNameId,attrName,attrVal  FROM APP_ClientProp cl WITH (NOLOCK) INNER JOIN mmhost ma WITH (NOLOCK) ON cl.componentNameId = ma.ClientId
	where cl.modified = 0  AND
	(cl.attrName IN('Sim OS Info' ,'Virtual Client', 'CS Active Physical Node' ,'Foreign Client Version','Virtual Client' ,'Active Physical Node' ,'Snap Backups Enabled'))
	-- Get the media agent OS information: Use the same logic used in app manager for client list
	CREATE TABLE #tmpOSPlatform  (clientId integer,
	simOSid integer, simHardwareId integer,
	osInfo varchar(1024),
	osName varchar(1024), osRelease varchar(1024), hwName varchar(1024), installedTime integer)
	INSERT INTO #tmpOSPlatform
	SELECT a.clientId, b.simOperatingSystemid, 0, null, '', '', '',0
	FROM MMHost a WITH (NOLOCK), app_client b WITH (NOLOCK), @tblSecMediaAgent S
	WHERE a.clientId = b.id and a.clientId > 1
	AND a.clientId = S.mediaAgentId
	UPDATE #tmpOSPlatform  SET osInfo = attrVal
	FROM #tmpOSPlatform  a, @tmpClientProp b
	WHERE a.clientId = b.clientId AND
	 b.attrName = 'Sim OS Info'
	UPDATE	#tmpOSPlatform
	SET	[osName] = dbo.GetClientOSName(clientId, osInfo),
		[hwName] = dbo.GetClientHardwareName(clientId, osInfo)
 UPDATE	#tmpOSPlatform
	SET installedTime = tmp.InstallTime from
	  (select a.clientId, dbo.GetUnixTime(MIN(simPackHistory.Optime)) InstallTime
		FROM #tmpOSPlatform a,simInstalledPackagesHistory simPackHistory
		WHERE a.clientId = simPackHistory.clientID
AND simPackHistory.simPackageID IN(51,54, 1301,1305)
		Group by a.clientId)as  tmp
	 where tmp.clientid = #tmpOSPlatform.clientid
	UPDATE	#tmpOSPlatform  SET [osName] = name FROM simOperatingSystem S WITH (NOLOCK) WHERE osName = '' AND [simOSid] = S.id
	-- Get all the media agent patch status, reference: getClientListAndInitialProps
	DECLARE @tmpMAPatchStatus TABLE (cId integer, isVirtual integer, physClId integer, patchStatus integer, relId integer, flags integer)
	INSERT INTO @tmpMAPatchStatus
	SELECT	M.clientId,0,0,8,C.releaseId,0
	FROM	MMHost M WITH (NOLOCK), APP_Client C WITH (NOLOCK), @tblSecMediaAgent S
	where C.id=M.ClientId and M.clientId = S.mediaAgentId
   IF (@showHiddenMediaAgentsConfig = 0)
     BEGIN
        DELETE FROM  @tmpMAPatchStatus
	    WHERE  NOT EXISTS (SELECT 1 FROM MMLibraryController WITH (NOLOCK) WHERE cid = clientId) AND
		       NOT EXISTS(SELECT 1 FROM MMDrivepool WITH (NOLOCK) WHERE cid = clientId)
     END
   ELSE
     BEGIN
        UPDATE @tmpMAPatchStatus
	    SET flags = CASE WHEN (((SELECT COUNT(*) FROM MMLibraryController WITH (READUNCOMMITTED) WHERE cid = clientId)>0) OR
								((SELECT COUNT(*) FROM MMDrivepool WITH (READUNCOMMITTED) WHERE cid = clientId)>0) )
		            THEN flags
ELSE (flags|2) END
  	  END
	UPDATE @tmpMAPatchStatus
	SET isVirtual = ISNULL((select CONVERT(INT,attrval) from @tmpClientProp where clientId=cId  and attrName='Virtual Client'),0),
		physClId = ISNULL((select CONVERT(INT,attrval) from @tmpClientProp where clientId=cId  and ((cId =2 and attrName='CS Active Physical Node') or (cId <> 2 and attrName='Active Physical Node')) ),0),
flags =    (CASE WHEN ( ISNULL((SELECT CONVERT(INT,attrval) from @tmpClientProp where clientId=cId and attrName='Snap Backups Enabled'),0) > 0) THEN 1 ELSE 0 END)
	UPDATE @tmpMAPatchStatus
	SET		patchStatus = ISNULL ((SELECT dbo.simGetBaseline(SUM( DISTINCT pinfo.Baseline)) FROM simInstalledPackages as pinfo WITH (NOLOCK) WHERE pinfo.clientId in (cId,physClId) ), 8)
--For the 9.0 and lesser release clients 'Has Diag' will take the precedence than 'Needs Update'.
--For the 10.0 and above release clients 'Needs Update' will take the precedence than 'Has Diag'.
	UPDATE	@tmpMAPatchStatus
	SET		patchStatus =
		CASE WHEN EXISTS (SELECT clientId FROM simInstalledPackages WITH (NOLOCK) WHERE cId = clientId AND Baseline = 0) THEN 0
		ELSE
			( case	WHEN relId < 15 THEN
					(
						CASE WHEN (patchStatus & 8) > 0 THEN 8
						WHEN (patchStatus & 16)> 0 THEN 16
						WHEN (patchStatus & 2) > 0 THEN 2
						WHEN (patchStatus & 4) > 0 THEN 4
						WHEN (patchStatus & 1) > 0 THEN 1
						ELSE  0 END
					)
					else
					(
						CASE WHEN (patchStatus & 8) > 0 THEN 8
						WHEN (patchStatus & 2) > 0 THEN 2
						WHEN (patchStatus & 16)> 0 THEN 16
						WHEN (patchStatus & 4) > 0 THEN 4
						WHEN (patchStatus & 1) > 0 THEN 1
						ELSE  0 END
					)
				end )
		END
	SELECT distinct mh.clientid, cl.name, cl.displayName, cl.net_hostname, mh.mmhosttype,
	mh.mmhostsoftstate, mh.mmhostenabled, mh.OfflineReason, cl.releaseId as ReleaseId,
	( CASE WHEN c.type = 1 THEN GR.release ELSE
	( ISNULL( (SELECT attrVal FROM @tmpClientProp where clientId = mh.clientid and attrName = 'Foreign Client Version'), 'N/A') ) END ),
	--(select top 1 Build from LicUsage where cId = mh.clientid and LicType NOT IN (71, 10, 26)) as Build,
	( ISNULL( (select attrVal from APP_ClientProp WITH (NOLOCK) where
	( (componentNameId = mh.clientid and tt.isVirtual =0 ) or (componentNameId = tt.physClId and tt.isVirtual <> 0) )
	and  attrName = 'SP Version Info' and modified=0), 'N/A' )) as Build,
	sos.osName, sos.hwName, sos.simOSId,
	0 ,
	isCommServer =
	(		select sum(platformType) from APP_Platform WITH (NOLOCK) where clientId = mh.clientid
	),
	isVirtualClient = isnull
	(	(	select 1 from  @tmpClientProp where clientId = mh.clientid  and attrName='Virtual Client'  AND attrVal = '1'
		), 0
	),
	mh.Attribute,
	-- checking whether this MA has consumed a licnese or not.
	isUnlicensedMA= ISNULL(
							(	select 0 FROM LicUsage  WITH (NOLOCK)	where
								cid = mh.clientid AND
								apptype = 1002	  AND
								lictype NOT IN (71, 10, 26, 33554432) AND
								optype = 'Install' AND
								InstallFlag = 0
							),1),
	-- Lookup whether media agent is pre-configured
isPreConfigured = CASE (cl.status & 0x04000) WHEN 0x04000 THEN 1 ELSE 0 END,
	patchStatus = tt.patchStatus,
	isMACatalogServer =
	(
		select count(*) from IdxCache as IC WITH (NOLOCK)
		where IC.CatalogServerClientId = mh.clientid
	),
	isEDCDiscovered= ISNULL(
							(	select 1 FROM APP_CommCell  CC WITH (NOLOCK) , APP_Client as C WITH (NOLOCK)
								where CC.type = 100 and C.origCCId =CC.id and C.id = mh.clientid
							),0),
	mh.MaxReservations,
	tt.flags AS 'MediaAgent Flags',
	cl.clientDescription, SEC.capabilities, sos.installedTime
	FROM  MMHost as mh WITH (NOLOCK), APP_Client as cl WITH (NOLOCK), APP_CommCell c WITH (NOLOCK), @tblSecMediaAgent SEC,#tmpOSPlatform  as sos, simAllGalaxyRel GR WITH (NOLOCK), @tmpMAPatchStatus tt
	WHERE  mh.clientid = cl.id and mh.clientid > 1 and
	mh.clientId = SEC.mediaAgentId and
	sos.clientId = mh.clientId and
	GR.id = cl.releaseId and
	tt.cId = mh.clientId and cl.origCCId = c.id
	and cl.id not in (select APP_VMToPMMap.PMClientId from APP_VMToPMMap WITH (NOLOCK) where APP_VMToPMMap.VMClientId = 2)
	group by mh.clientid, cl.name, cl.displayName, cl.net_hostname, mh.mmhosttype,
	mh.mmhostsoftstate, mh.mmhostenabled, mh.OfflineReason, cl.releaseId,
	GR.release, sos.osName, sos.hwName, sos.simOSId,
	mh.Attribute, cl.status, tt.physClId,tt.isVirtual,tt.patchStatus,tt.flags, cl.clientDescription, c.type, mh.MaxReservations, SEC.capabilities,sos.installedTime
	order by mh.clientId, ReleaseId DESC
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2GetMediaAgentList')
	delete from GxQscripts where name = 'MMS2GetMediaAgentList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetMediaAgentList')
	delete from GXDBVersions where aliasname = 'MMS2GetMediaAgentList'
GO

insert into GXDBVersions values(2, 'MMS2GetMediaAgentList',  '00010047001200080000', 'MMS2GetMediaAgentList', '00010047001200080000')
GO

