

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GetMagVolumeForJob.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2GetMagVolumeForJob.sp,v $ $Id: MMS2GetMagVolumeForJob.sp,v 1.22.50.12 2019/06/26 23:28:07 cliu Exp $";
--
--  +========================================================================+
--  | Stored Precedure: MMS2GetVolumeForJob()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMS2GetMagVolumeForJob')
BEGIN
	print '>>> Drop Stored Procedure: MMS2GetMagVolumeForJob <<<'
	drop procedure MMS2GetMagVolumeForJob
END
IF EXISTS (select * from GxQscripts where name='MMS2GetMagVolumeForJob')
	delete from GxQscripts where name = 'MMS2GetMagVolumeForJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetMagVolumeForJob')
	delete from GXDBVersions where aliasname = 'MMS2GetMagVolumeForJob'
GO
print '... Creating Procedure: MMS2GetMagVolumeForJob'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2GetMagVolumeForJob
  @i_CommCellId integer,
  @i_MountPathId integer,
  @i_MediaGroupID integer,
  @i_SIDBStoreId integer,
  @i_AppId integer,
  @i_JobId integer,
  @i_JobType integer,
  @i_UsePartialFullMedia integer,
  @i_MarkActiveVolumeFull integer,
  @i_currentClientId integer,
  @i_IgnoreOutput integer,
  @o_VolumeId integer OUTPUT
AS
  DECLARE @r_VolumeId integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	set @r_VolumeId = 0
	declare @MediaSideId int
	declare @UseAppendible int
	declare @LibraryId int
	declare @ScheduleRunId bigint
	declare @NoOtherSchedule int
	declare @MediaId  int
	declare @ErrorCode  int
	declare @OverwriteWrongCommcell int
	set @MediaId = 0
set @ErrorCode = 0
	set @UseAppendible = 0
	set @OverwriteWrongCommcell = 0
	select @MediaSideId = isnull(MediaSideId, 0) from MMMountPath with (readuncommitted) where MountPathId = @i_MountPathId
	select @MediaId = MediaId from MMMediaSide with (readuncommitted) where MediaSideId = @MediaSideId
	select @LibraryId = LibraryId from MMMedia with (readuncommitted) where MediaId = @MediaId
select @UseAppendible = (ExtendedAttributes & 1 /*MMS2_LIBRARY_MEDIA_APPEND_ABLE*/) from MMLibrary with (readuncommitted) where LibraryId = @LibraryId
select @OverwriteWrongCommcell = (LibraryAttribute & 32) from MMLibrary with (readuncommitted) where LibraryId = @LibraryId
	DECLARE @l_copyId INT = 0
	DECLARE @cacheMpId	INT = 0
	DECLARE @cacheMediaId INT = 0
	DECLARE @cacheErrorCode INT = 0
	if @i_SIDBStoreId = 0 AND @i_AppId > 0
	begin
		SELECT @l_copyId = archGroupCopyId FROM archStream WITH(READUNCOMMITTED) WHERE mediaGroupId = @i_MediaGroupID
		SELECT 	@i_SIDBStoreId = SIDBStoreId
		FROM	archSubclientCopyDDBMap WITH(READUNCOMMITTED)
		WHERE	appId = @i_AppId
				AND copyId = @l_copyId
	end
	--Find appendable volume with current DDB
	if @i_SIDBStoreId > 0
	begin
		select top 1 @r_VolumeId = VolumeId
		from	MMVolume v with (readuncommitted)
		where	v.MediaGroupId = @i_MediaGroupID
		and		v.MediaSideId = @MediaSideId
		and		v.VolumeFlags = 7 /*VOL_ACTIVE_APPEND*/
		and		v.SIDBStoreId = @i_SIDBStoreId
		order by v.LastBackupTime desc
	end
	if @r_VolumeId = 0 and @i_UsePartialFullMedia > 0 and @UseAppendible > 0
	begin
		-- If the library is set to Mount Path Round-Robin and job option allows to use appendable media (MarkActiveMediaFull),
		-- find the active-appendable volume and set it to active. Attempt to use appendible.
		select top 1 @r_VolumeId = VolumeId
		from	MMVolume v with (readuncommitted), MMMedia m with (readuncommitted)
		where	v.MediaId = m.MediaId
		and		v.MediaGroupId = @i_MediaGroupID
		and		v.MediaSideId = @MediaSideId
		and		v.VolumeFlags = 7 /*VOL_ACTIVE_APPEND*/
		and		(
						(m.origCCCommcellId = @i_CommCellId or m.origCCCommcellId = 0)
						or
(m.Attributes & 268435456 > 0)
						or
						(@OverwriteWrongCommcell > 0)
					)
		and		(@i_SIDBStoreId = 0 OR @i_SIDBStoreId = v.SIDBStoreId)
		order by v.LastBackupTime desc
	end
	if @r_VolumeId > 0
	and EXISTS (SELECT 1 FROM MMHybridCloudMapping WITH (READUNCOMMITTED) WHERE cloudLibId = @LibraryId)
	and EXISTS (SELECT 1 FROM MMCloudVolCacheMountPath WITH (READUNCOMMITTED) WHERE VolumeId = @r_VolumeId)
and EXISTS (SELECT 1 FROM MMMountPath WITH (READUNCOMMITTED) WHERE (Attribute & 2048) > 0 AND MediaSideId = @MediaSideId)
	begin
		SET @cacheMpId = 0
		SET @cacheMediaId = 0
		SELECT TOP 1 @cacheMpId = cacheMountPathId
		FROM	MMCloudVolCacheMountPath WITH (READUNCOMMITTED)
		WHERE VolumeId = @r_VolumeId
		SELECT @cacheMediaId = side.MediaId
		FROM	MMMountPath path WITH (READUNCOMMITTED), MMMediaSide side WITH (READUNCOMMITTED)
		WHERE	path.MountPathId = @cacheMpId AND path.MediaSideId = side.MediaSideId
		IF NOT EXISTS (SELECT MP.MountPathId
						FROM	MMMountPath MP WITH (READUNCOMMITTED), MMMountPathToStorageDevice MSD WITH (READUNCOMMITTED),
								MMDevice DV WITH (READUNCOMMITTED), MMDeviceController DC WITH (READUNCOMMITTED), MMHost H WITH (READUNCOMMITTED), MMLibrary LIB WITH (READUNCOMMITTED)
						WHERE   MP.MountPathId = @cacheMpId
						AND 	MP.MountPathId = MSD.MountPathId
						AND 	MSD.DeviceId = DC.DeviceId
						AND		MSD.DeviceId = DV.DeviceId
						AND 	DC.ClientId = H.ClientId
						AND		MP.LibraryId = LIB.LibraryId
						AND 	MP.IsEnabled = 1
						AND		MP.IsOffline = 0
						AND 	H.MmHostEnabled = 1
						AND		H.MmHostSoftState = 1
						AND		DC.DeviceAccessible = 1
						AND		DC.DeviceControllerEnabled = 1
						AND		LIB.LibrarySoftState >0 AND LIB.LibraryEnabled >0 AND LIB.LibraryBroken = 0
						AND		DV.DeviceBroken = 0 AND	DV.DeviceEnabled = 1
						-- Make sure only to use mount path can be accessed by curent reserved media agent
						AND		(@i_currentClientId = 0 OR H.ClientId = @i_currentClientId)
					)
		BEGIN
			SET @r_VolumeId = 0
		END
		IF @r_VolumeId > 0
		AND EXISTS (SELECT 1
					FROM MMMountPath mp WITH (READUNCOMMITTED)
					WHERE	@cacheMpId = mp.MountPathId
					AND		mp.MaxConcurrentWriters = 0
					)
		BEGIN
			SET @r_VolumeId = 0
		END
		IF @r_VolumeId > 0
		AND NOT EXISTS (SELECT 1
					FROM	MMMountPathToStorageDevice ms WITH (READUNCOMMITTED), MMDeviceController dc WITH (READUNCOMMITTED)
					WHERE	@cacheMpId = ms.MountPathId
					AND		ms.DeviceId = dc.DeviceId
					AND		(@i_currentClientId = 0 OR dc.ClientId = @i_currentClientId)
AND		(dc.DeviceAccessType & 2) > 0
					)
		BEGIN
			SET @r_VolumeId = 0
		END
		IF @r_VolumeId > 0
		AND EXISTS (SELECT 1
					FROM MMMedia media WITH (READUNCOMMITTED)
					WHERE	@cacheMediaId = media.MediaId
					AND		media.MediaFlags = 4 /*E_MM_MOUNTPATH_WRITE_DISABLED*/
					)
		BEGIN
			SET @r_VolumeId = 0
		END
		IF @r_VolumeId > 0
		BEGIN
			SET @cacheErrorCode = dbo.MMS2FUNC_IsMountPathHasSpaceRequired(@cacheMpId, @cacheMediaId)
			IF  @cacheErrorCode <> 0
			BEGIN
				SET @r_VolumeId = 0
			END
		END
	end
	-- If the ative-appendable volume exists, mark it active and return.
	if @r_VolumeId > 0
	begin
		update MMVolume
		set		VolumeFlags = 1 /*VOL_ACTIVE*/
		where	VolumeId = @r_VolumeId
	end
if @r_VolumeId = 0
begin
	declare @FlushBlockSizeKB int
	declare @CopyDedupeFlags int
	set @FlushBlockSizeKB = 0
	set @CopyDedupeFlags = 0
	declare @RecordingFormatId int
select @RecordingFormatId = isnull(RecordingFormatId, 10001) from MMMediaGroup with (readuncommitted) where MediaGroupId = @i_MediaGroupId
	--Get the correct block size.
	--1) If the media type is Magnetic and MountPath type is centera, always set it to 32 KB
	--2) Else If the DataPath table has the Flush Block size set, then honor it.
	--3) Else if the datapath is for a non-dedupe copy with magnetic recording format, set to default 512 KB.
	--4) Else get the value from the recording format table
	if exists (select MountPathId from MMMountPath with (readuncommitted) where MountPathId = @i_MountPathId and MountPathTypeId = 1 /*MOUNT_PATH_CENTERA*/)
	begin
set @FlushBlockSizeKB = 32
	end
	else
	begin
		select	top 1 @FlushBlockSizeKB = FlushBlockSizeKB
		from		MMDataPath with (readuncommitted)
		where		CopyId in (select ArchGroupCopyId from ArchStream with (readuncommitted) where MediaGroupId = @i_MediaGroupId)
		and			DrivePoolId in (select DrivePoolId from MMDrivePool a with (readuncommitted), MMMasterPool b with (readuncommitted) where a.MasterPoolId = b.MasterPoolId and b.LibraryId = @LibraryId)
		and			SpareGroupId = 0
	end
	select top 1 @CopyDedupeFlags = c.dedupeFlags
	from	ArchGroupCopy c with (readuncommitted), ArchStream s with (readuncommitted)
	where	c.Id = s.ArchGroupCopyId
	and		s.MediaGroupId = @i_MediaGroupId
	if @FlushBlockSizeKB = 0
	begin
if (@i_SIDBStoreId = 0 and (@CopyDedupeFlags & 262144) = 0 and @RecordingFormatId = 10001)
		begin
set @FlushBlockSizeKB = 512
		end
		else
		begin
		select @FlushBlockSizeKB = FlushBlockSizeKB
		from	MMRecordingFormats with (readuncommitted)
		where RecordingFormatId = (select RecordingFormatId from MMMediaGroup with (readuncommitted) where MediaGroupId = @i_MediaGroupId)
		end
	end
	SELECT @l_copyId = archGroupCopyId FROM archStream WITH(READUNCOMMITTED) WHERE mediaGroupId = @i_MediaGroupID
	if @i_SIDBStoreId = 0 AND @i_AppId > 0
	begin
		SELECT 	@i_SIDBStoreId = SIDBStoreId
		FROM	archSubclientCopyDDBMap WITH(READUNCOMMITTED)
		WHERE	appId = @i_AppId
				AND copyId = @l_copyId
	end
	IF EXISTS (SELECt 1 FROM MMHybridCloudMapping WITH (READUNCOMMITTED) WHERE cloudLibId = @LibraryId)
	BEGIN
		DECLARE @CacheLibId INT
		SELECT @CacheLibId = diskLibId FROM MMHybridCloudMapping WITH (READUNCOMMITTED) WHERE cloudLibId = @LibraryId
		declare @tbl_MountPaths     TABLE (MPId int, MediaId int, MediaSideId int, ClientId int, DeviceId int, magSpaceResrvMB int, freeSpaceMB bigint, errorCode int)
		-- Get all online mountpaths for this library.
		INSERT INTO @tbl_MountPaths
		SELECT  MP.MountPathId, side.MediaId, MP.MediaSideId, H.ClientId, DC.DeviceId, MIN(MP.MagneticSpaceRsrvInMB), 0, 0
		FROM    MMMountPath MP WITH (READUNCOMMITTED), MMMountPathToStorageDevice MSD WITH (READUNCOMMITTED),
				MMDeviceController DC WITH (READUNCOMMITTED), MMHost H WITH (READUNCOMMITTED),
				MMMediaSide side WITH (READUNCOMMITTED)
		WHERE   MP.LibraryId = @CacheLibId
		AND MP.MountPathId = MSD.MountPathId
		AND MSD.DeviceId = DC.DeviceId
		AND DC.ClientId = H.ClientId
		-- Make sure only to use mount path can be accessed by curent reserved media agent
		AND (@i_currentClientId = 0 OR H.ClientId = @i_currentClientId)
		GROUP BY MP.MountPathId, side.MediaId, MP.MediaSideId, H.ClientId, DC.DeviceId
		UPDATE a
SET		errorCode = 20400
		FROM 	@tbl_MountPaths a, MMHost host WITH (READUNCOMMITTED)
		WHERE	a.ClientId = host.ClientId
		AND		(host.MmHostEnabled = 0 or host.MmHostSoftState = 0)
		AND		a.errorCode = 0
		UPDATE a
SET		errorCode = 20401
		FROM 	@tbl_MountPaths a, MMMountPath mp WITH (READUNCOMMITTED), MMLibrary lib WITH (READUNCOMMITTED)
		WHERE	a.MPId = mp.MountPathId
		AND		mp.LibraryId = lib.LibraryId
		AND		(lib.LibrarySoftState = 0 or lib.LibraryEnabled = 0 or lib.LibraryBroken = 1)
		AND		a.errorCode = 0
		UPDATE a
SET		errorCode = case when dv.DeviceBroken = 0	then 20413
when dv.DeviceEnabled <> 1	then 20414
								 else 0
							end
		FROM 	@tbl_MountPaths a, MMDevice dv  WITH (READUNCOMMITTED)
		WHERE	a.DeviceId = dv.DeviceId
		AND		(dv.DeviceBroken = 1 OR dv.DeviceEnabled <> 1)
		AND		a.errorCode = 0
		UPDATE a
SET		errorCode = case when dc.DeviceAccessible = 0			then 20406
when dc.DeviceControllerEnabled = 0	then 20405
else 20407
							end
		FROM 	@tbl_MountPaths a, MMDeviceController dc  WITH (READUNCOMMITTED)
		WHERE	a.DeviceId = dc.DeviceId
		AND		a.ClientId = dc.ClientId
AND		(dc.DeviceAccessible = 0 or dc.DeviceControllerEnabled = 0 or (dc.DeviceAccessType & 2) = 0)
		AND		a.errorCode = 0
		UPDATE a
SET		errorCode = case when mp.MaxConcurrentWriters = 0 then 20409
else 20408
							end
		FROM 	@tbl_MountPaths a, MMMountPath mp WITH (READUNCOMMITTED)
		WHERE	a.MPId = mp.MountPathId
		AND		(mp.IsEnabled = 0 or mp.IsOffline = 1 or mp.MaxConcurrentWriters = 0)
		AND		a.errorCode = 0
		UPDATE a
SET		errorCode = 20410
		FROM 	@tbl_MountPaths a, MMMedia media WITH (READUNCOMMITTED)
		WHERE	a.MediaId = media.MediaId
		AND		media.MediaFlags = 4
		AND		a.errorCode = 0
		UPDATE a
		SET 	freeSpaceMB = (MS.FreeBytesMB - a.magSpaceResrvMB)
		FROM	@tbl_MountPaths a, MMMediaSide MS WITH (READUNCOMMITTED)
		WHERE	a.MediaSideId = MS.MediaSideId
		AND		a.errorCode = 0
		SET @cacheMPId = 0
		SET @cacheMediaId = 0
		SET @cacheErrorCode = 0
		WHILE (EXISTS (SELECT 1 FROM @tbl_MountPaths WHERE errorCode = 0))
		BEGIN
			SELECT TOP 1 @cacheMpId = MPId, @cacheMediaId = MediaId FROM @tbl_MountPaths WHERE errorCode = 0 ORDER BY freeSpaceMB DESC
			SET @cacheErrorCode = dbo.MMS2FUNC_IsMountPathHasSpaceRequired(@cacheMpId, @cacheMediaId)
			IF  @cacheErrorCode <> 0
			BEGIN
				UPDATE	@tbl_MountPaths
SET		errorCode = case when @cacheErrorCode = 20010 		then 20411
when @cacheErrorCode = 20011 	then 20412
else 484 end
				WHERE MPId = @cacheMPId
				AND		errorCode = 0
				SET @cacheMPId = 0
				SET @cacheMediaId = 0
				SET @cacheErrorCode = 0
				CONTINUE
			END
			ELSE
			BEGIN
				BREAK
			END
		END
		IF @cacheMpId = 0
		BEGIN
			SELECT TOP 1 @ErrorCode = errorCode FROM @tbl_MountPaths WHERE errorCode != 0 Order By freeSpaceMB DESC, MPId
IF @ErrorCode = 0
SET @ErrorCode = 484
			goto ERROR_EXIT
		END
	END
  -- create a new mag vol
  insert into MMVolume (VolumeName, CreationTime, VolumeFlags, VolumeInitialized, FlushBlockSizeKB, NumberOfRestores, NumberOfBackups, NumberOfMounts,
                 NumberOfSoftErrors, NumberOfHardErrors, LastRestoreTime, LastBackupTime, LogicalBytesMB, PhysicalBytesMB, NumberOfActiveFiles,
                 LastFile, RecordingFormatId, ExternalGUID, OMLVersion, VolumeState, VolumeFullReason, VolumeFullTime, VolumeFullJobId, origCCcommCellID,
                 origCCvolumeID, MediaId, MediaSideId, Attributes, MediaGroupId, ReformatTime, RMSpareStatus, RMSpareStatusUpdateTime, SIDBStoreId, SiloStatus,
                 CurrMountPathId, FailureErrorCode, MMSpareStatus)
  values(
		-- VolumeName
		'V_x',
		--CreationTime		TIME_T,
		dbo.GetUnixTime(getutcdate()),
		--VolumeFlags			integer,
		1, /*VOL_ACTIVE*/
		--VolumeInitialized	integer,
		0,
		--FlushBlockSizeKB	integer,
		@FlushBlockSizeKB,
		--NumberOfRestores	integer,
		0,
		--NumberOfBackups		integer,
		0,
		--NumberOfMounts		integer,
		0,
		--NumberOfSoftErrors	integer,
		0,
		--NumberOfHardErrors	integer,
		0,
		--LastRestoreTime		TIME_T,
		0,
		--LastBackupTime		TIME_T,
		0,
		--LogicalBytesMB		integer,
		0,
		--PhysicalBytesMB		integer,
		0,
		--NumberOfActiveFiles	integer,
		0,
		--LastFile			integer,
		0,
		--RecordingFormatId	integer,
		@RecordingFormatId,
		--ExternalGUID		varchar(MMS2_GUIDLEN, MIN_DEFAULT_REC_SIZE),
		'',
		--OMLVersion			integer,
		2, /*OML_31*/
		--VolumeState			integer,
		0,
		--VolumeFullReason	integer,
		0,
		--VolumeFullTime		integer,
		0,
		--VolumeFullJobId		bigint,
		0,
		--origCCcommCellID	integer,
		@i_CommCellId,
		--origCCvolumeID		integer,
		0,
		--MediaId				integer,
		@MediaId,
		--MediaSideId			integer,
		@MediaSideId,
		--Attributes			integer,
		0,
		--MediaGroupId		integer,
		@i_MediaGroupID,
		--ReformatTime		TIME_T,
		0,
		--RMSpareStatus							integer,
		-1,
		--RMSpareStatusUpdateTime		integer,
		0,
		--SIDBStoreId		integer,
		@i_SIDBStoreId,
		--SiloStatus		integer,
case when @i_SIDBStoreId > 0 and (@CopyDedupeFlags & 2097152 > 0)
					then 1 /*SILO_VOLUME_TO_BE_MIGRATED*/
					else -1 end,
		-- CurrMountPathId	integer,
		@i_MountPathId,
		-- FailureErrorCode
		0,
		-- MMSpareStatus
		0)
	select @r_VolumeId = @@identity
	update MMVolume set VolumeName = 'V_' + cast(@r_VolumeId as varchar(10)), origCCvolumeId = @r_VolumeId where VolumeId = @r_VolumeId
	IF EXISTS (SELECt 1 FROM MMHybridCloudMapping WITH (READUNCOMMITTED) WHERE cloudLibId = @LibraryId)
	AND @cacheMpId > 0
	BEGIN
		INSERT INTO MMCloudVolCacheMountPath
		VALUES (@r_VolumeId, @cacheMpId)
		UPDATE MMMountPath
SET Attribute |= 2048
		WHERE MediaSideId = @MediaSideId
	END
end
NORMAL_EXIT:
ERROR_EXIT:
	if @i_IgnoreOutput = 0
	begin
		select @r_VolumeId
	end
	else
	begin
		set @o_VolumeId = @r_VolumeId
	end
  return @ErrorCode
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2GetMagVolumeForJob')
	delete from GxQscripts where name = 'MMS2GetMagVolumeForJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetMagVolumeForJob')
	delete from GXDBVersions where aliasname = 'MMS2GetMagVolumeForJob'
GO

insert into GXDBVersions values(2, 'MMS2GetMagVolumeForJob',  '00010022005000120000', 'MMS2GetMagVolumeForJob', '00010022005000120000')
GO

