

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GetMAinGridStoreList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "MMS2GetMAinGridStoreList"			|
--	|									|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2GetMAinGridStoreList <<<'

IF EXISTS (select * from sysobjects where name='MMS2GetMAinGridStoreList')
	drop procedure MMS2GetMAinGridStoreList
IF EXISTS (select * from GxQscripts where name='MMS2GetMAinGridStoreList')
	delete from GxQscripts where name = 'MMS2GetMAinGridStoreList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetMAinGridStoreList')
	delete from GXDBVersions where aliasname = 'MMS2GetMAinGridStoreList'
GO
print '... Creating Procedure: MMS2GetMAinGridStoreList'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2GetMAinGridStoreList
  @i_mediaAgentId integer
AS
  DECLARE @o_mediaAgentId integer
--  given ma, get all MAs in gridstore
--  given clientId, get all MAs associated to this client
--  given maId, get all clients associated to this ma
DECLARE @l_UseSCDataPaths int
create table #tempClientList(clientId int);
select VMClientId
into #tempVMPMMap
from APP_VMToPMMap
where PMClientId = @i_mediaAgentId
insert into #tempVMPMMap
select @i_mediaAgentId
INSERT INTO #tempClientList
	SELECT distinct(HostClientId) FROM MMDataPath WHERE CopyId IN ( SELECT distinct(CopyId) FROM MMDataPath WHERE HostClientId in (select * from #tempVMPMMap) )
	-- get all the subclients associated to this client
	SELECT distinct id
	INTO #tempSubClList
	FROM APP_Application
	WHERE clientId = @i_mediaAgentId
	SET @l_UseSCDataPaths =
 		isnull
 		(
 			( SELECT TOP 1 attrVal from APP_SubClientProp WITH (NOLOCK)
 			  where componentnameId in (select * from #tempSubClList) AND
 			  attrName = N'Full Failover to SP dataPaths' and modified = 0
 			  order by Id DESC
 			), 0
 		)
	-- get all the storage policy copies for this client from the APP_Application table.
	SELECT distinct dataArchGrpId as archGroupId
	INTO #tempArchGrpList
	FROM APP_Application
	WHERE clientId in (select * from #tempVMPMMap)
	-- also insert the log storage policy for this client if its missed out in previous step
	INSERT INTO #tempArchGrpList
	SELECT distinct logArchGrpId as archGroupId
	FROM APP_Application
	WHERE clientId in (select * from #tempVMPMMap) AND logArchGrpId not in (select * from #tempArchGrpList)
	-- get all the copies for the list of storage policies
	SELECT distinct id
	INTO #tempArchGrpCopyList
	FROM archGroupCopy AGC, #tempArchGrpList T
	WHERE AGC.archGroupId = T.archGroupId
IF (@l_UseSCDataPaths = 0)
BEGIN
	INSERT INTO #tempClientList
 	SELECT distinct H2DP.ClientId
 	FROM 	MMDataPath AS DPath, MMDrivePool AS H2DP, IdxAccessPath AS IDXAP  INNER JOIN IdxCache AS IC ON IC.IdxCacheId = IDXAP.IdxCacheId
 	WHERE	DPath.CopyId in (select * from #tempArchGrpCopyList) AND
 		H2DP.DrivePoolId = DPath.DrivePoolId AND IDXAP.ClientId = H2DP.ClientId AND IC.IdxCacheType = 1 AND
 		(DPath.Flag & 16) = 0
 		AND H2DP.ClientId not in (select * from #tempClientList)
 	--ORDER BY DPath.Priority, H2DP.ClientId
END ELSE
BEGIN
	INSERT INTO #tempClientList
 	SELECT 	distinct H2DP.ClientId
 	FROM 	MMDataPath AS DPath, MMDrivePool AS H2DP, IdxAccessPath AS IDXAP  INNER JOIN IdxCache AS IC ON IC.IdxCacheId = IDXAP.IdxCacheId,
 		APP_AppToDataPath AS A2DP
 	WHERE	DPath.CopyId in (select * from #tempArchGrpCopyList) AND
 		A2DP.dataType = 1 AND A2DP.ComponentNameId in (select * from #tempSubClList) AND
 		H2DP.DrivePoolId = DPath.DrivePoolId AND IDXAP.ClientId = H2DP.ClientId AND
 		A2DP.DataPathId = DPath.DataPathId AND IC.IdxCacheType = 1 AND
 		(DPath.Flag & MMS2_REPLICATION_DATAPATH) = 0
 		AND H2DP.ClientId not in (select * from #tempClientList)
 	--ORDER BY A2DP.precedence, H2DP.ClientId
END
--	Fix - to not return client list MR 60102.
--	-- get all the archGroupIds from the MMDatapath for this MA
--	SELECT AGC.archGroupId
--	INTO #tempArchGroupList
--	FROM MMDataPath MMDP, MMDrivePool MMD, archGroupCopy AGC
--	WHERE MMDP.HostClientId = @i_mediaAgentId and MMDP.DrivePoolId = MMD.DrivePoolId and MMD.ClientId in (select * from #tempVMPMMap)
--	and AGC.id = MMDP.CopyId
--	-- find all the clients associated with the storagepolicy list from APP_Application
--	INSERT INTO #tempClientList
--	SELECT distinct ClientId
--	FROM APP_Application
--	WHERE (dataArchGrpId in (select * from #tempArchGroupList)
--	or logArchGrpId in (select * from #tempArchGroupList))
--	AND clientId not in (select * from #tempClientList)
	delete from #tempClientList where clientId = 1
	select T.ClientId
	from #tempClientList T, APP_Client APPC
	where T.ClientId = APPC.id
and APPC.releaseId < 16
        drop table #tempClientList
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2GetMAinGridStoreList')
	delete from GxQscripts where name = 'MMS2GetMAinGridStoreList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetMAinGridStoreList')
	delete from GXDBVersions where aliasname = 'MMS2GetMAinGridStoreList'
GO

insert into GXDBVersions values(2, 'MMS2GetMAinGridStoreList',  '00000000000000000000', 'MMS2GetMAinGridStoreList', '00000000000000000000')
GO

