

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GetMAAndDPForVolume.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2GetMAAndDPForVolume.sp,v $ $Id: MMS2GetMAAndDPForVolume.sp,v 1.153.2.52.16.1 2021/02/03 16:33:04 cliu Exp $";
--
--  +========================================================================+
--  | Stored Precedure: MMS2GetMAAndDPForVolume()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MMS2GetMAAndDPForVolume')
BEGIN
	print '>>> Drop Stored Procedure: MMS2GetMAAndDPForVolume <<<'
	drop procedure MMS2GetMAAndDPForVolume
END
IF EXISTS (select * from GxQscripts where name='MMS2GetMAAndDPForVolume')
	delete from GxQscripts where name = 'MMS2GetMAAndDPForVolume'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetMAAndDPForVolume')
	delete from GXDBVersions where aliasname = 'MMS2GetMAAndDPForVolume'
GO
print '... Creating Procedure: MMS2GetMAAndDPForVolume'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MMS2GetMAAndDPForVolume
  @i_volumeId integer,
  @i_isSpareVolume integer,
  @i_destinationClient integer,
  @i_destCopyId integer,
  @i_jobId integer,
  @i_ignoreVersionForRestore integer,
  @i_archFileId integer = 0,
  @i_commCellId integer = 0,
  @i_curMediaAgentsXML XML = ''
AS
  DECLARE @i_retcode integer;
  DECLARE @s_mediaAgentName varchar(1024);
  DECLARE @i_clientId integer;
  DECLARE @i_nasClientId integer;
  DECLARE @i_clientReleaseId integer;
  DECLARE @s_filerName varchar(1024);
  DECLARE @i_hostId integer;
  DECLARE @i_drivepoolId integer;
  DECLARE @i_drivepoolType integer;
  DECLARE @i_libraryId integer;
  DECLARE @i_libraryTypeId integer;
  DECLARE @i_libraryAttribute integer;
  DECLARE @s_libraryName varchar(128);
  DECLARE @s_libraryAliasName NVARCHAR(128);
  DECLARE @s_barCode varchar(256);
  DECLARE @o_volumeId integer;
  DECLARE @i_mediaLocation integer;
  DECLARE @i_jobOpType integer;
  DECLARE @i_failureType integer;
/* below defines are from enum : OpwindowRuleLevel*/
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
-- initialize output parameters
set @i_retcode = 259
set @s_mediaAgentName = ''
set @i_clientId = 0
set @i_nasClientId = 0
set @s_filerName = ''
set @i_hostId = 0
set @i_drivepoolId = 0
set @i_drivepoolType = 0
set @i_libraryId = 0
set @s_libraryName = ''
set @s_libraryAliasName = ''
set @s_barCode = ''
set @i_failureType = 0
-- define constants
declare @CVDP_REGULAR integer
declare @CVDP_NAS integer
declare @CVDP_NRS integer
set @CVDP_REGULAR = 0
set @CVDP_NAS = 1
set @CVDP_NRS = 2
declare @LOCATION_SLOT integer
declare @LOCATION_DRIVE integer
declare @LOCATION_SHELF integer
declare @LOCATION_SWITCHED integer
set @LOCATION_SLOT		= 1
set @LOCATION_DRIVE		= 2
set @LOCATION_SHELF		= 3
set @LOCATION_SWITCHED	= 4
declare @BACKUP			integer
declare @RESTORE		integer
declare @INDEXRESTORE	integer
declare @AUXCOPY		integer
declare @SYNTHFULL		integer
declare @ARCHIVECHECK	integer
declare @OFFLINECI		integer
declare @MEDIAREFRESH	integer
declare @DEDUPDBSYNC	integer
declare @AUXCOPY2		integer
declare @DEDUPDBSYNC2	integer
declare @TAPEERASE		integer
set @BACKUP			= 4
set @RESTORE		= 5
set @INDEXRESTORE	= 12
set @AUXCOPY		= 13
set @SYNTHFULL		= 14
set @ARCHIVECHECK	= 31
set @TAPEERASE		= 32
set @OFFLINECI		= 53
set @MEDIAREFRESH	= 74
set @DEDUPDBSYNC	= 80
set @AUXCOPY2		= 104
set @DEDUPDBSYNC2	= 131
declare @ARCHIVECHECK2	integer = 106
DECLARE @taskId INTEGER = 0
declare @OS_TYPE_GALAXYREMOTESERVER integer
set @OS_TYPE_GALAXYREMOTESERVER = 5
DECLARE @HOST_STATUS_POWER_MANAGED_VM		INTEGER
SET			@HOST_STATUS_POWER_MANAGED_VM		= 7
-- local variables
declare @mediaAgentId int
declare @drivepoolId integer
declare @drivepoolType integer
declare @libraryId integer
declare @masterpoolid int
declare @mediaGroupId integer
declare @volSIDBStoreId integer
declare @copySIDBStoreId integer
declare @siloRestoreMAId integer
declare @mediaId integer
declare @mediaTypeId integer
declare @mediaLocation integer
declare @lastWriteLibraryId integer
declare @VolumeFormatId integer
declare @dataPathType integer
declare @ndmpHostId integer
declare @jobType integer
declare @jobClientId integer
declare @backupDrivePoolId integer
declare @mountPathId integer
declare @mountPathTypeId integer
declare @cloudId int
declare @sourceCopyId int
declare @preferCopyDataPaths integer
declare @preferMAPreferredToMP integer
declare @honorLoadBalance integer
declare @isStandAloneLibrary bit
declare @jobPhase integer
DECLARE @OPWindowRetCode INTEGER = -1
set @mediaAgentId = 0
set @drivepoolId = 0
set @drivepoolType = 0
set @libraryId = 0
set @masterpoolid = 0
set @mediaGroupId = 0
set @volSIDBStoreId = 0
set @copySIDBStoreId = 0
set @siloRestoreMAId = 0
set @mediaId = 0
set @mediaTypeId = 0
set @mediaLocation = 0
set @lastWriteLibraryId = 0
set @dataPathType = @CVDP_REGULAR
set @ndmpHostId = 0
set @jobType = 0
set @jobClientId = 0
set @backupDrivePoolId = 0
set @mountPathId = 0
set @sourceCopyId = 0
set @preferCopyDataPaths = 0
set @preferMAPreferredToMP = 0
set @honorLoadBalance = 0
set @isStandAloneLibrary = 0
set	@jobPhase = 0
declare @jobSubOpType integer = 0
-- this table will contain all datapaths for a given copy
create table #tmpcopydrivepools
(
	drivePoolId	int,
	flag int
)
-- this table will contain all available drivepools for restore
create table #tmpDrivePool
(
  -- drive pool
	DrivePoolId			int,
	DrivePoolType		int,
	DrivePoolSoftState	int,
	DrivePoolEnabled	int,
  -- master pool
	MasterPoolId		int,
	MasterPoolSoftState	int,
	MasterPoolEnabled	int,
	TotalDrives			int,
  -- library
	LibraryId			int,
	LibraryTypeId		int,
	LibrarySoftState	int,
	LibraryEnabled		int,
	LibraryBroken		int,
	LibraryAttribute	int,
	ExtendedAttributes	int,
LibraryName			varchar(128),
LibraryAliasName	nvarchar(128),
  -- host
	ClientId			int,
	NDMPHostId			int,
	ClientReleaseId		int,
	ClientStatus		int,
	MmHostSoftState		int,
	HostOfflineReason	int,
	MmHostEnabled		int,
	NasClientid			int,
	Attribute			int,
NetHostName			varchar(1024),
NasFilerName		varchar(1024),
  -- idx access path
	IdxAccessPathId		int,
	AccessPathEnabled	int,
	AccessPathSoftState	int,
	OrderBy				int,
	isPreferredMAForMP	int
)
create table #destClientIds
(
	destClientId		int,
	clientReleaseId		int
)
create table #tmpLicUsage (id int, CId int, ReleaseId int)
DECLARE @isPowerVMFeatureEnabled INT
SET @isPowerVMFeatureEnabled = ISNULL ((SELECT value FROM MMConfigs WHERE name LIKE 'MMCONFIG_CLOUD_VM_MANAGEMENT_ENABLED_FLAG'), 0)
declare @tblPreferedMAGroup table (clientId int)
INSERT INTO #destClientIds
SELECT CL.id, 0
     FROM @i_curMediaAgentsXML.nodes('/curMediaAgents/MediaAgent') T(item)
	 inner join APP_Client CL ON CL.name = T.item.value('@name','VARCHAR(MAX)')
-- get media properties
if @i_volumeId <= 0
begin
	-- volume cannot be zero
set @i_retcode = 393
	goto ERROR_EXIT
end
select	@mediaId = MediaId,
		@mediaGroupId = MediaGroupId,
		@volSIDBStoreId = SIDBStoreId,
		@VolumeFormatId = RecordingFormatId
from	MMVolume WITH (NOLOCK)
where	VolumeId = @i_volumeId
-- Get the source copy id for if the give copy is a silo copy, Since V11 silo copies don't have SIDBStoreId
SELECT	@copySIDBStoreId = C.SIDBStoreId,@sourceCopyId =
											case
when c.flags&524288 != 0 then sourceCopyId
												else 0
											end, @siloRestoreMAId = siloRestoreMAClientId
FROM	archGroupCopy C WITH (NOLOCK), archStream S WITH (NOLOCK)
WHERE	C.id = S.archGroupCopyId AND S.mediaGroupId = @mediaGroupId
if(@copySIDBStoreId = 0 and @sourceCopyId != 0)
begin
	SELECT	@copySIDBStoreId = C.SIDBStoreId
	FROM	archGroupCopy C WITH (NOLOCK)
	WHERE	C.id = @sourceCopyId
end
-- Here should we get the candidate drivepools from MMDataPath for the @mediaGroupId?
if	@mediaId is null or @mediaId <= 0
begin
	-- media does not exit
set @i_retcode = 401
	goto ERROR_EXIT
end
select	@mediaTypeId = isnull(MediaTypeId, 0),
		@mediaLocation = MediaLocation,
		@libraryId = LibraryId,
		@lastWriteLibraryId = LastWriteLibraryId,
		@s_barCode = BarCode
from	MMMedia WITH (NOLOCK)
where	MediaId = @mediaId
--For orphaned tape we should fail immediately since getChunkInfo for DM fails and job can't proceed.
if @mediaTypeId <> 10001 AND (@libraryId = 0 OR EXISTS(SELECT 1 FROM MMLibrary WITH(READUNCOMMITTED) WHERE LibraryId = @libraryId AND LibraryTypeId IN (8 /*CV_LIB_SHELF*/, 9 /*CV_LIB_DECONFIGURED*/)))
begin
set @i_retcode = 273
	goto ERROR_EXIT
end
if	@mediaTypeId = 10001
begin
	select	@mountPathId = mp.MountPathId, @mountPathTypeId = mp.MountPathTypeId
	from	MMMountPath mp WITH (NOLOCK), MMMediaSide ms WITH (NOLOCK)
	where	ms.MediaId = @mediaId
	and    	ms.MediaSideId = mp.MediaSideId
end
set @isStandAloneLibrary = (case when exists(select 1 from MMLibrary with (readuncommitted) where LibraryId = @libraryId
and LibraryTypeId in (4, 5))
								 then 1 else 0 end)
-- determine datapath type
if @i_isSpareVolume = 0
begin
	if @mediaGroupId <= 0 or @mediaGroupId is null
	begin
		-- volume is not in media group
set @i_retcode = 411
		goto ERROR_EXIT
	end
	if exists (select count(distinct dp.DrivePoolType)
						from MMDrivePool dp WITH (NOLOCK), MMMasterPool mp WITH (NOLOCK)
						where dp.MasterPoolId = mp.MasterPoolId
						and mp.LibraryId = @libraryId
						having (count(distinct dp.DrivePoolType) > 1)
	)
	begin
		select Top 1 @drivePoolId = drivepool.DrivePoolId
		from	archchunk chunk with (NOLOCK), archChunkMapping mapping with (NOLOCK),
				archFileCopy copy with (NOLOCK), MMDrivePool drivepool with (NOLOCK)
		where	chunk.volumeid = @i_volumeId
		and		copy.archCopyId = @sourceCopyId
		and		chunk.id = mapping.archChunkId
		and		chunk.commCellId = mapping.commCellId
		and		mapping.archFileId = copy.archFileId
		and		mapping.commCellId = copy.CommCellId
		and		copy.drivePoolId = drivepool.DrivePoolId
		order by copy.modifiedTime desc
	end
	if @drivePoolId is null or @drivePoolId <= 0
	begin
		select	@drivePoolId = isnull(DrivePoolId, 0)
		from	MMMediaGroup WITH (NOLOCK)
		where	MediaGroupId = @mediaGroupId
	end
	if @drivePoolId <= 0 or @drivePoolId is null
	begin
if	@mediaTypeId = 10001
		begin
			select TOP 1 @drivePoolId = DP.DrivePoolId
			from	MMDrivePool DP WITH (NOLOCK), MMMasterPool MP WITH (NOLOCK)
			where	DP.MasterPoolId = MP.MasterPoolId
			and		MP.TotalDrives > 0
			and		MP.LibraryId = @libraryId
		end
		else
		begin
			select	TOP 1 @drivePoolId = DP.DrivePoolId
			from	MMDrivePool DP WITH (NOLOCK), MMMasterPool MP WITH (NOLOCK)
			where	DP.MasterPoolId = MP.MasterPoolId
			and		((@lastWriteLibraryId > 0 AND MP.LibraryId = @lastWriteLibraryId) OR (@lastWriteLibraryId = 0 AND MP.LibraryId = @libraryid))
			and		MP.TotalDrives > 0
			and		MP.MasterPoolId in (select distinct MasterPoolId from MMRecFmtMedTyp FMT, MMDrive D where D.DriveTypeId = FMT.DriveTypeId
																and		FMT.RecordingFormatId = @VolumeFormatId and FMT.MediaTypeId = @mediaTypeId
																and		(
@jobType = @TAPEERASE AND (FMT.CompatibilityType & 2) > 0
																		  OR
@jobType != @TAPEERASE AND (FMT.CompatibilityType & 4) > 0
																		))
		end
		if @drivePoolId <= 0 or @drivePoolId is null
		begin
			-- media group does not have valid drive pool
set @i_retcode = 934
			goto ERROR_EXIT
		end
	end
	set @backupDrivePoolId = @drivePoolId
	select	@drivePoolType = DrivePoolType, @ndmpHostId = NDMPHostId
	from	MMDrivePool WITH (NOLOCK)
	where	DrivePoolId = @drivePoolId
if	@drivePoolType = 3
	begin
		set @dataPathType = @CVDP_NAS
	end
	else
	if	@ndmpHostId > 0
	and exists (select * from MMNDMPHostInfo WITH (NOLOCK) where NDMPHostId = @ndmpHostId and OSType = @OS_TYPE_GALAXYREMOTESERVER)
	begin
		set @dataPathType = @CVDP_NRS
	end
end
if	@i_jobId > 0
begin
	set @jobType= dbo.GetJobTypeForJobID(@i_jobId)
	-- Double check if the job is synthetic full or backup
	select @jobSubOpType = ISNULL(subOpType, 0), @jobPhase = ISNULL(currentPhase, 0),
			@jobType = CASE WHEN optype = @SYNTHFULL THEN optype ELSE @jobType END
	from jmjobinfo with (nolock) where jobId = @i_jobId
end
DECLARE @dedupeValidate INT = 0
DECLARE @defragment INT = 0
DECLARE @orphanListing INT = 0
DECLARE	@opId INT = 0
if (@jobType =  @ARCHIVECHECK)
begin
	SELECT	@opId = id
	FROM	JMOpTable WITH (READUNCOMMITTED)
	WHERE	operation=31 /*ARCHIVECHECK*/
	SELECT	 @dedupeValidate = phase
	FROM	JMPhase WITH (READUNCOMMITTED)
	WHERE	opTableId = @opId and name = 'Validate Dedupe Data'
	SELECT	 @orphanListing = phase
	FROM	JMPhase WITH (READUNCOMMITTED)
	WHERE	opTableId = @opId and name = 'Orphan Chunk listing'
	SELECT	 @defragment = phase
	FROM	JMPhase WITH (READUNCOMMITTED)
	WHERE	opTableId = @opId and name = 'Defragment Data'
end
-- Lookup the cloud id for offline CI job
if @jobType = @OFFLINECI
begin
	select 	@cloudId = isnull(CloudId, 0)
	from	ArchContentIndexingRules a with (NOLOCK), archStream b with (NOLOCK)
	where	b.MediaGroupId = @MediaGroupId
	and		b.ArchGroupId = a.ArchGroupId
end
declare @tblPreferedDrivePool table (DrivePoolId int)
if (@jobType = @AUXCOPY AND @i_destCopyId  = 0 AND @i_destinationClient > 0)
BEGIN
	-- begin of fix added by mklose - form 3932, fix 2
	DECLARE @l_AuxcopySourceDrivePool int
	DECLARE @l_AuxcopySourceHostclientId int
	select @l_AuxcopySourceDrivePool = MR.drivepoolid, @l_AuxcopySourceHostclientId = NI.ClientId
	from mmresourcetojob RJ
			INNER JOIN MMResource MR ON MR.reservationId = RJ.ReservationId
				AND MR.volumeId = @i_volumeId AND MR.ReservationType = 1
			INNER JOIN MMDrivePool DP ON DP.drivePoolId = MR.drivePoolId
			LEFT OUTER JOIN MMNDMPHostInfo NI ON NI.ndmphostId = DP.ndmphostId
	where RJ.jobId_l = @i_jobId
	-- regression limiting joins, to do in future - discuss if we can remove joins below this - not for this update
		 AND DP.ClientId = @i_destinationClient AND DP.DrivePoolType = 3 AND NI.ClientID <> DP.ClientId
	/* TR- 1-301118
		In this TR, this stored proc returned the wrong result. Reason being that AuxcopyReserve called
		this SP with a copy passed in, and a drivepool got chosen which reflects NAS.
		However, when the MA came in and requested the mount to MM, MM passed in the clientId of the drivepool.
		This lead to a different drivepool being chosen (probably an NRS drivepool matching the drivepool of the MA)
		The above code makes sure to catch this particular case.  In case of auxcopy when no destcopy is passed in,
		it now looks to see if there is a read reservation for this auxcopy job where the reserved drivepool is nas,
		the drivepool MA matches the one passed in and the NDMPHostId's clientid is different to the passed in destination clientid
		(which in the case of MM would be the drivepool MA rather than the actual clientId).
		If all the above is true, then we set the reserved drivepool to the preferred drivepool and set the destination
		client to the nas filer.
		In all other cases follow the regular code flow.
		It could be argued that if no dest copy is passed in and the job type is auxcopy and a read reservation is found already
		for the volume, that we should always use this code flow and not just in the case of the NAS issue described above.
		However that adds regression.
	*/
	IF (@l_AuxcopySourceDrivePool is not null)
	BEGIN
		delete from @tblPreferedDrivePool -- you cannot specify a preferred drivepool for auxcopy anyway, so this will always be empty
		insert into @tblPreferedDrivePool
		select @l_AuxcopySourceDrivePool
		insert into #destClientIds
		SELECT @l_AuxcopySourceHostclientId, 0
	END
	-- if we fall through here, follow regular logic.
END
declare	@tblNameId table (name varchar(16), id int)
if	@jobType = @RESTORE
begin
	insert	into @tblNameId
select	'DRIVE_POOL_ID',  cast(dbo.GetJobOption(@i_jobId, 131207187) as integer)
	insert	into @tblNameId
select	'MEDIA_AGENT_ID', cast(dbo.GetJobOption(@i_jobId, 1254245399) as integer)
	insert	into @tblNameId
select	'DRIVE_ID',				cast(dbo.GetJobOption(@i_jobId, 785491355) as integer)
end
else if @jobType in (@ARCHIVECHECK)
	AND EXISTS (
			SELECT * FROM JMJobOptions WITH (NOLOCK)
		 	WHERE jobId = @i_jobId AND commcellId = 2
AND attributeId = 41
			--AND attributeName = JM_STORE_BASED_DV_JOB_MEDIAAGENT_NAME
		)
begin
	if (@jobType = @ARCHIVECHECK AND @jobPhase IN (@defragment/*DEFRAGMENT*/) AND @mountPathTypeId = 7 /*MOUNT_PATH_EXTERNAL_REMOTE_HOST*/)
	begin
		DECLARE @iCopyId INT = (SELECT	CS.CopyId
								FROM	archCopySIDBStore CS
										INNER JOIN archGroupCopy AGC ON CS.CopyId = AGC.id
								WHERE	CS.SIDBStoreId = @volSIDBStoreId
AND AGC.dedupeFlags & 134217728 = 0)
		DECLARE @iHostId INT = 0
		SELECT	@iHostId = DPool.ClientId
		FROM	MMDataPath DPath
				INNER JOIN MMDrivePool DPool ON DPool.DrivePoolId = DPath.DrivePoolId
				INNER JOIN  MMMountPath MP  ON MP.MasterPoolId = DPool.MasterPoolId
		WHERE   DPath.CopyId = @iCopyId
AND MP.Attribute & 256 > 0
AND MP.Attribute & 32 > 0
AND DPath.flag & (/*MMS2_PREFERRED_PRUNER |*/ 64 | 4) = (/*MMS2_PREFERRED_PRUNER |*/ 64 | 4)
				AND MountPathTypeId = 7 /*MOUNT_PATH_EXTERNAL_REMOTE_HOST*/
		IF (@iHostId = 0)
		BEGIN
			SELECT @iHostId = DC.ClientId
			FROM   MMDeviceController DC
						  INNER JOIN MMMountPathToStorageDevice MSD ON DC.DeviceId = MSD.DeviceId
						  INNER JOIN MMMountPath MP ON MSD.MountPathId = MP.MountPathId
						  INNER JOIN MMDrivePool DPool ON MP.MasterPoolId = DPool.MasterPoolId AND DPool.ClientId = DC.ClientId
						  INNER JOIN MMDataPath DPath ON DPool.DrivePoolId = DPath.DrivePoolId AND DPath.CopyId = @iCopyId
			WHERE
MP.Attribute & 256 = 0
AND MP.Attribute & 32 > 0
						  AND MountPathTypeId = 7 /*MOUNT_PATH_EXTERNAL_REMOTE_HOST*/
AND (DC.UseCount & 1) > 0
		END
		IF (@iHostId = 0)
		BEGIN
			-- no drivepool is configured for the preferred MA
set @i_retcode = 486
			goto ERROR_EXIT
		END
		insert	into @tblNameId
		select	'MEDIA_AGENT_ID', @iHostId
	END
	ELSE
	BEGIN
		insert	into @tblNameId
select	'MEDIA_AGENT_ID', cast(dbo.GetJobOption(@i_jobId, 1564054677) as integer)
		if not exists (select * from @tblNameId where name = 'MEDIA_AGENT_ID' and id > 0)
			INSERT INTO @tblNameId
			SELECT	'MEDIA_AGENT_ID', CAST(attributeValueInt AS INT)
			FROM	JMJobOptions WITH (NOLOCK)
		 	WHERE	jobId = @i_jobId AND commcellId = 2
AND	attributeId = 41
			--AND attributeName = JM_STORE_BASED_DV_JOB_MEDIAAGENT_NAME
			AND	attributeValueInt > 0
	END
end
else
if	@jobType in (@AUXCOPY, @ARCHIVECHECK, @OFFLINECI, @MEDIAREFRESH, @AUXCOPY2)
	insert	into @tblNameId
select	'MEDIA_AGENT_ID', cast(dbo.GetJobOption(@i_jobId, 1564054677) as integer)
else
if	@jobType = @DEDUPDBSYNC
BEGIN
	DECLARE @xmlValue XML = dbo.GetXMLJobOptions(@i_jobId)
	insert	into @tblNameId
select	'MEDIA_AGENT_ID', cast(dbo.GetJobOption(@i_jobId, 628224051) as integer)
	UNION
	SELECT 'MEDIA_AGENT_ID', T.x.value('@mediaAgentId', 'integer')
	FROM @xmlValue.nodes('TMMsg_JobOption/adminOpts/reconstructDedupDBOption/mediaAgents') AS T(x)
	WHERE T.x.value('@mediaAgentId', 'integer') IS NOT NULL
END
else
if @jobType = @SYNTHFULL
BEGIN
	insert	into @tblNameId
select	'MEDIA_AGENT_ID', cast(dbo.GetJobOption(@i_jobId, 18276681) as integer)
END
ELSE
-- Add support for job option when doing tape erase jobs
IF @jobType = @TAPEERASE
BEGIN
	insert	into @tblNameId
select	'DRIVE_POOL_ID',  cast(dbo.GetJobOption(@i_jobId, 131207187) as integer)
	insert	into @tblNameId
select	'MEDIA_AGENT_ID', cast(dbo.GetJobOption(@i_jobId, 1254245399) as integer)
	insert	into @tblNameId
select	'DRIVE_ID',		 cast(dbo.GetJobOption(@i_jobId, 785491355) as integer)
END
-- If this is for Silo restore, use silo restore MA if it is set for the copy
if not exists (select * from @tblNameId where id > 0)
and @i_destCopyId = 0 and @volSIDBStoreId = 0 and @copySIDBStoreId > 0 and @siloRestoreMAId > 0
begin
	insert	into @tblNameId
	select	'MEDIA_AGENT_ID', @siloRestoreMAId
end
-- If there is drive id specified for the job, only use the drive pool that can access the given drive.
-- When doing actual reservation, only given drive will be considered based on the selected drive pool.
if	exists (select * from @tblNameId where name = 'DRIVE_ID' and id > 0)
and not exists (select * from @tblNameId where name = 'DRIVE_POOL_ID' and id > 0)
begin
	insert	into @tblPreferedDrivePool
	select	DrivePoolId
	from		MMDrivePool WITH (NOLOCK)
	where		MasterPoolId in (select MasterPoolId from MMDrive WITH (NOLOCK) where DriveId in (select id from @tblNameId where name = 'DRIVE_ID' AND id > 0))
end
else if	exists (select * from @tblNameId where name = 'DRIVE_POOL_ID' and id > 0)
begin
	insert	into @tblPreferedDrivePool
	select	id from @tblNameId where name = 'DRIVE_POOL_ID' and id > 0
end
else
if @jobType in (@ARCHIVECHECK, @DEDUPDBSYNC)
	and (select count(distinct id) from @tblNameId where name = 'MEDIA_AGENT_ID' and id > 0) > 1
begin
	insert	into @tblPreferedDrivePool
	select	distinct DrivePoolId
	from	MMDrivePool WITH (NOLOCK)
	where	ClientId in (select id from @tblNameId where name = 'MEDIA_AGENT_ID' and id > 0)
	if not exists (select drivepoolid from @tblPreferedDrivePool)
	begin
		SELECT @i_clientId = Id, @s_mediaAgentName = name,
				@i_libraryId = 0, @s_libraryName = '', @s_libraryAliasName = ''
		FROM	App_Client WITH (NOLOCK)
		WHERE	Id = (select top 1 id from @tblNameId where name = 'MEDIA_AGENT_ID' and id > 0)
		-- no drivepool is configured for the preferred MA
set @i_retcode = 322
		goto ERROR_EXIT
	end
end
else
if	exists (select * from @tblNameId where name = 'MEDIA_AGENT_ID' and id > 0)
begin
	insert	into @tblPreferedDrivePool
	select	distinct DrivePoolId
	from	MMDrivePool WITH (NOLOCK)
	where	ClientId = (select top 1 id from @tblNameId where name = 'MEDIA_AGENT_ID' and id > 0)
	if @jobType in (@AUXCOPY, @ARCHIVECHECK, @OFFLINECI, @MEDIAREFRESH, @DEDUPDBSYNC, @AUXCOPY2)
	and not exists (select drivepoolid from @tblPreferedDrivePool)
	begin
		SELECT @i_clientId = Id, @s_mediaAgentName = name,
				@i_libraryId = 0, @s_libraryName = '', @s_libraryAliasName = ''
		FROM	App_Client WITH (NOLOCK)
		WHERE	Id = (select top 1 id from @tblNameId where name = 'MEDIA_AGENT_ID' and id > 0)
		-- no drivepool is configured for the preferred MA
set @i_retcode = 322
		goto ERROR_EXIT
	end
end
-- When there is reservation exists by this job for the volume, consider the reserved drive poold as preferred drive pool also.
-- Later logic should pick the reserved drive pool only.
if exists (select * from @tblPreferedDrivePool)
and exists (select ReservationId from MMResource WITH (NOLOCK)
						where VolumeId = @i_volumeId
						and	 ReservationId in (select ReservationId from MMResourceToJob WITH (NOLOCK) where JobId_l = @i_JobId))
begin
	insert into @tblPreferedDrivePool
	select distinct a.DrivePoolId
	from MMResource a WITH (NOLOCK), MMResourceToJob b WITH (NOLOCK)
	where	a.VolumeId = @i_volumeId
	and		b.JobId_l = @i_JobId
	and		a.ReservationId = b.ReservationId
	and		a.HasJobInterrupted = 0
	and		(b.InUse != 0 or b.ReleaseTime = 0)
end
if exists (select drivepoolid from @tblPreferedDrivePool) and @jobType != @SYNTHFULL
begin
	-- check whether the preferred drive pool can access the given volume
	declare @temp_drivepool table (drivepoolId int)
	if @mediaLocation = @LOCATION_SLOT
	begin
		insert into @temp_drivepool
    	select d.drivepoolid
	  	from MMBay a, MMSlot b, MMMasterPool c, MMDrivePool d
	  	where a.bayid = b.bayid
	 	and b.mediaid = @mediaid
	 	and a.libraryid = c.libraryid
	 	and c.masterpoolid = d.masterpoolid
		delete @tblPreferedDrivePool
		where drivepoolid not in (select drivepoolid from @temp_drivepool)
	end
	if @mediaLocation = @LOCATION_DRIVE
	begin
		insert into @temp_drivepool
		select b.drivepoolid
		from MMDrive a, MMDrivePool b
		where a.mediaid = @mediaid
		and a.masterpoolid = b.masterpoolid
		delete @tblPreferedDrivePool
		where drivepoolid not in (select drivepoolid from @temp_drivepool)
	end
	-- If there is none left, check if there are any accessible for the given MA only.
	if not exists (select * from @tblPreferedDrivePool) and @jobType = @RESTORE
	begin
		if	exists (select * from @tblNameId where name = 'MEDIA_AGENT_ID' and id > 0)
		begin
			insert	into @tblPreferedDrivePool
			select	distinct DrivePoolId
			from	MMDrivePool WITH (NOLOCK)
			where	ClientId = (select top 1 id from @tblNameId where name = 'MEDIA_AGENT_ID' and id > 0)
			and		DrivePoolId in (select drivepoolid from @temp_drivepool)
		end
	end
	insert	into #tmpDrivePool
	select	distinct DP.DrivePoolId, DP.DrivePoolType, DP.DrivePoolSoftState, DP.DrivePoolEnabled,
			DP.MasterPoolId, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '',
			DP.ClientId, DP.NDMPHostId, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0
	from	@tblPreferedDrivePool T, MMDrivePool DP WITH (NOLOCK), MMDrive D WITH (NOLOCK), MMRecFmtMedTyp FMT WITH (NOLOCK)
	where	DP.DrivePoolId = T.DrivePoolId
		and D.MasterPoolId = DP.MasterPoolId
		and FMT.DriveTypeId = D.DriveTypeId
		and FMT.RecordingFormatId = @VolumeFormatId
		and FMT.MediaTypeId = @mediaTypeId
		and (
@jobType = @TAPEERASE AND (FMT.CompatibilityType & 2) > 0
				OR
@jobType != @TAPEERASE AND (FMT.CompatibilityType & 4) > 0
			)
	-- We don't know if the preferred Drive pool can actually access volume or not, for example offline, no drive, and so on.
	-- If the option set, just select all the available drive pool and make the preferred drive pool has higher priority.
	if @jobType in (@RESTORE, @INDEXRESTORE)
	and  exists (select * from MMConfigs WITH (NOLOCK) where name = 'MMCONFIG_RESOURCEMANAGER_ALLOW_RESTORE_USE_DIFF_MA_AND_DRIVEPOOL' and value > 0)
	begin
		insert	into #tmpDrivePool
		select	distinct DP.DrivePoolId, DP.DrivePoolType, DP.DrivePoolSoftState, DP.DrivePoolEnabled,
				DP.MasterPoolId, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '',
				DP.ClientId, DP.NDMPHostId, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0
		from	MMDrivePool DP WITH (NOLOCK), MMDrive D WITH (NOLOCK), MMRecFmtMedTyp FMT WITH (NOLOCK)
		where	((not exists (select DrivePoolId from @tblPreferedDrivePool))
				  OR DP.DrivePoolId not in (select DrivePoolId from @tblPreferedDrivePool))
			and D.MasterPoolId = DP.MasterPoolId
			and FMT.DriveTypeId = D.DriveTypeId
			and FMT.RecordingFormatId = @VolumeFormatId
			and FMT.MediaTypeId = @mediaTypeId
			and	(
@jobType = @TAPEERASE AND (FMT.CompatibilityType & 2) > 0
					OR
@jobType != @TAPEERASE AND (FMT.CompatibilityType & 4) > 0
				)
		if @mediaLocation in (@LOCATION_DRIVE, @LOCATION_SLOT)
			delete #tmpDrivePool
			where drivepoolid not in (select drivepoolid from @temp_drivepool)
	end
	if not exists (select * from #tmpDrivePool)
	begin
		if	exists (select * from @tblNameId where name = 'DRIVE_ID' and id > 0)
		begin
			SELECT @i_libraryId = 0, @s_libraryName = '', @s_libraryAliasName = '',
					@i_clientId = 0, @s_mediaAgentName = ''
			-- FROM	MMDrive d WITH (NOLOCK), MMLibrary lib WITH (NOLOCK), MMMasterPool mp WITH (NOLOCK)
			-- WHERE	d.DriveId = (select top 1 id from @tblNameId where name = 'DRIVE_ID' and id > 0)
			-- AND		d.MasterPoolId = mp.MasterPoolId
			-- AND		mp.LibraryId = lib.LibraryId
			if @jobType in (@RESTORE, @INDEXRESTORE)
set @i_retcode = 20171
			else
set @i_retcode = 20168
		end
		else if	exists (select * from @tblNameId where name = 'DRIVE_POOL_ID' and id > 0)
		begin
			SELECT TOP 1 @i_clientId = client.Id, @s_mediaAgentName = client.name,
						@i_libraryId = 0, @s_libraryName = '', @s_libraryAliasName = ''
			FROM	App_Client client WITH (NOLOCK), MMDrivePool dp WITH (NOLOCK), MMLibrary lib WITH (NOLOCK), MMMasterPool mp WITH (NOLOCK)
			WHERE	dp.DrivePoolId = (select top 1 id from @tblNameId where name = 'DRIVE_POOL_ID' and id > 0)
			AND		dp.ClientId = client.Id
			AND		dp.MasterPoolId = mp.MasterPoolId
			AND		mp.LibraryId = lib.LibraryId
			if @jobType in (@RESTORE, @INDEXRESTORE)
set @i_retcode = 20172
			else
set @i_retcode = 20169
		end
		else if	exists (select * from @tblNameId where name = 'MEDIA_AGENT_ID' and id > 0)
		begin
			SELECT @i_clientId = Id, @s_mediaAgentName = name,
					@i_libraryId = 0, @s_libraryName = '', @s_libraryAliasName = ''
			FROM	App_Client WITH (NOLOCK)
			WHERE	Id = (select top 1 id from @tblNameId where name = 'MEDIA_AGENT_ID' and id > 0)
			if @jobType in (@RESTORE, @INDEXRESTORE)
set @i_retcode = 20173
			else
set @i_retcode = 20170
		end
		else
		begin
			-- recording format does not match
			-- For restore job return new error code that gives advice to set config param to select all available drive pools instead of preferred drive pool.
			if @jobType in (@RESTORE, @INDEXRESTORE)
set @i_retcode = 342
			else
set @i_retcode = 322
		end
		goto ERROR_EXIT
	end
	update	#tmpDrivePool
	set		MasterPoolSoftState = b.MasterPoolSoftState, MasterPoolEnabled = b.MasterPoolEnabled,
			TotalDrives = b.TotalDrives, LibraryId = b.LibraryId
	from	#tmpDrivePool a, MMMasterPool b WITH (NOLOCK)
	where	b.MasterPoolId = a.MasterPoolId
	goto PROCESS_MA_LIST
end
if	@mediaTypeId = 10001
begin
	insert	into #tmpDrivePool
	select	distinct DP.DrivePoolId, DP.DrivePoolType, DP.DrivePoolSoftState, DP.DrivePoolEnabled,
			MP.MasterPoolId, MP.MasterPoolSoftState, MP.MasterPoolEnabled, MP.TotalDrives,
			MP.LibraryId, 0, 0, 0, 0, 0, 0, '', '',
			DP.ClientId, DP.NDMPHostId, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0
	from	MMDrivePool DP WITH (NOLOCK), MMMasterPool MP WITH (NOLOCK)
where	DP.DrivePoolType <> 3
		and DP.MasterPoolId = MP.MasterPoolId and MP.TotalDrives > 0
		and MP.LibraryId = (select LibraryId from MMMedia WITH (NOLOCK) where MediaId = @mediaid)
	goto PROCESS_MA_LIST
end
if (@mediaLocation = @LOCATION_DRIVE) AND (@jobType = @AUXCOPY)
begin
	-- added by mklose - form 3932, fix 1
	-- problem is that in the case of auxcopy, we get
	-- a reservation first before coming in here. So the drive
	-- where the media is in is irrelevant in case RM already decided
	-- to use a whole other drivepool meaning we need to remount.
	-- so in case of the media being in the drive and in case of auxcopy,
	-- just get the drive pool candidates based on the library and media
	-- alone and not on the drive it is in as the drivepool to use
	-- has already been decided.
	-- further down in the code we will then actually pick the drivepool
	-- from the reservation.
	set @mediaLocation = @LOCATION_SLOT
end
if	@mediaLocation = @LOCATION_DRIVE
begin
	declare @tDriveId int
	declare @tDrivePoolId int
	set @tDriveId = 0
	set @tDrivePoolId = 0
	select	@masterpoolid = MasterPoolId, @tDriveId = DriveId
	from	MMDrive WITH (NOLOCK)
	where	mediaid = @mediaid
	if	@tDriveId > 0
and @mediaTypeId = 11002
	begin
		select	@tDrivePoolId = DrivePoolId
		from	MMDriveController WITH (NOLOCK)
		where	driveid = @tDriveId
	end
	if @masterpoolid <= 0
	or @masterpoolid is null
	begin
		-- try if media is in slot
		set @mediaLocation = @LOCATION_SLOT
	end
	else
	begin
		insert	into #tmpDrivePool
		select	distinct DP.DrivePoolId, DP.DrivePoolType, DP.DrivePoolSoftState, DP.DrivePoolEnabled,
				MP.MasterPoolId, MP.MasterPoolSoftState, MP.MasterPoolEnabled, MP.TotalDrives,
				MP.LibraryId, 0, 0, 0, 0, 0, 0, '', '',
				DP.ClientId, DP.NDMPHostId, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0
		from	MMDrivePool DP WITH (NOLOCK), MMMasterPool MP WITH (NOLOCK)
		where	(@tDrivePoolId = 0 or (DP.DrivePoolId = @tDrivePoolId))
			and DP.MasterPoolId = MP.MasterPoolId and MP.MasterPoolId = @masterpoolid and MP.TotalDrives > 0
	end
end
if @mediaLocation = @LOCATION_SLOT
begin
	select	@libraryid = a.LibraryId
	from	MMBay a WITH (NOLOCK), MMSlot b WITH (NOLOCK)
	where	a.BayId = b.BayId
		and b.MediaId = @mediaid
	if @libraryid <= 0
	or @libraryid is null
	begin
		-- media location is wrong
set @i_retcode = 400
		goto ERROR_EXIT
	end
	insert	into #tmpDrivePool
	select	distinct DP.DrivePoolId, DP.DrivePoolType, DP.DrivePoolSoftState, DP.DrivePoolEnabled,
			MP.MasterPoolId, MP.MasterPoolSoftState, MP.MasterPoolEnabled, MP.TotalDrives,
			MP.LibraryId, 0, 0, 0, 0, 0, 0, '', '',
			DP.ClientId, DP.NDMPHostId, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0
	from	MMDrivePool DP WITH (NOLOCK), MMMasterPool MP WITH (NOLOCK)
	where	DP.MasterPoolId = MP.MasterPoolId and MP.LibraryId = @libraryid and MP.TotalDrives > 0
		and MP.MasterPoolId in (select distinct MasterPoolId from MMRecFmtMedTyp FMT, MMDrive D where D.DriveTypeId = FMT.DriveTypeId
								and FMT.RecordingFormatId = @VolumeFormatId and FMT.MediaTypeId = @mediaTypeId
								and (
@jobType = @TAPEERASE AND (FMT.CompatibilityType & 2) > 0
										OR
@jobType != @TAPEERASE AND (FMT.CompatibilityType & 4) > 0
									))
end
if @mediaLocation = @LOCATION_SHELF
or @mediaLocation = @LOCATION_SWITCHED
begin
	insert	into #tmpDrivePool
	select	distinct DP.DrivePoolId, DP.DrivePoolType, DP.DrivePoolSoftState, DP.DrivePoolEnabled,
			MP.MasterPoolId, MP.MasterPoolSoftState, MP.MasterPoolEnabled, MP.TotalDrives,
			MP.LibraryId, 0, 0, 0, 0, 0, 0, '', '',
			DP.ClientId, DP.NDMPHostId, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, abs(MP.LibraryId - @lastWriteLibraryId), 0
	from	MMDrivePool DP WITH (NOLOCK), MMMasterPool MP WITH (NOLOCK)
	where	DP.MasterPoolId = MP.MasterPoolId and MP.LibraryId > 0 and MP.TotalDrives > 0
		and MP.MasterPoolId in (select distinct MasterPoolId from MMRecFmtMedTyp FMT, MMDrive D where D.DriveTypeId = FMT.DriveTypeId
													and FMT.RecordingFormatId = @VolumeFormatId and FMT.MediaTypeId = @mediaTypeId
													and	(
@jobType = @TAPEERASE AND (FMT.CompatibilityType & 2) > 0
															OR
@jobType != @TAPEERASE AND (FMT.CompatibilityType & 4) > 0
														))
end
if @i_isSpareVolume = 0
begin
-- DataPathType and DrivePoolType should match
	delete	from #tmpdrivepool
where	@dataPathType = @CVDP_REGULAR and DrivePoolType = 3
or	@dataPathType = @CVDP_NAS and DrivePoolType != 3
or	@dataPathType = @CVDP_NRS and (DrivePoolType = 3 or NDMPHostId = 0)
end
PROCESS_MA_LIST:
if not exists (select 1 from #tmpDrivePool)
begin
set @i_retcode = 322
	goto ERROR_EXIT
end
if	@dataPathType = @CVDP_NAS
begin
	update	#tmpDrivePool
	set		NasClientId = a.ClientId
	from	MMNDMPHostInfo a WITH (NOLOCK)
	where	#tmpDrivePool.NDMPHostId > 0 and a.NDMPHostId = #tmpDrivePool.NDMPHostId
	update	#tmpDrivePool
	set		ClientReleaseId = a.ReleaseId, ClientStatus = a.status, NasFilerName = a.name
	from	APP_Client a WITH (NOLOCK)
	where	#tmpDrivePool.NasClientId > 0 and a.id = #tmpDrivePool.NasClientId
	update	#tmpDrivePool
	set		NetHostName = a.name
	from	APP_Client a WITH (NOLOCK)
	where	a.id = #tmpDrivePool.ClientId
end
else
begin
	update	#tmpDrivePool
	set		ClientReleaseId = a.ReleaseId, ClientStatus = a.status, NetHostName = a.name
	from	APP_Client a WITH (NOLOCK)
	where	a.id = #tmpDrivePool.ClientId
end
delete	from #tmpDrivePool
where	(ClientStatus & 16384) != 0
update	#tmpDrivePool
set		LibraryTypeId		= x.LibraryTypeId,
		LibrarySoftState	= x.LibrarySoftState,
		LibraryEnabled		= x.LibraryEnabled,
		LibraryBroken		= x.LibraryBroken,
		LibraryAttribute	= x.LibraryAttribute,
		ExtendedAttributes	= x.ExtendedAttributes,
		LibraryName			= x.LibraryName,
		LibraryAliasName	= x.AliasName,
		MmHostSoftState		= y.MmHostSoftState,
		MmHostEnabled		= y.MmHostEnabled,
		HostOfflineReason	= y.OfflineReason,
		Attribute			= y.Attribute,
		IdxAccessPathId		= z.idxAccessPathId
from	#tmpDrivePool t, MMLibrary x, MMHost y, idxAccessPath z
where	x.LibraryId = t.LibraryId
	and y.ClientId = t.ClientId
	and z.ClientId = t.ClientId
update 	#tmpDrivePool
set	 	AccessPathEnabled	= z.enabled,
		AccessPathSoftState	= z.SoftState
from	#tmpDrivePool t, idxAccessPath z, IdxCache c, App_Client cn
where	z.ClientId = t.ClientId
	and c.IdxCacheId = z.IdxCacheId AND c.IdxCacheType = 1
	and t.ClientId = cn.id and cn.ReleaseId < 16
update 	#tmpDrivePool
set	 	AccessPathEnabled	= CONVERT(INT, cp.attrVal),
		AccessPathSoftState	= CONVERT(INT, cp.attrVal)
from	#tmpDrivePool t, App_Client cn, App_ClientProp cp
where	cn.id = t.ClientId
	and cn.id = cp.componentNameId	and cn.ReleaseId >= 16
	and cp.attrName = 'Idx: cache enabled'
-- If the media is magnetic, make sure the selected drive pool belongs to the current library based on the volume
if @mediaTypeId = 10001
begin
	IF NOT EXISTS (SELECT * FROM #tmpDrivePool WHERE libraryId = @libraryId)
	BEGIN
		SELECT TOP 1 @i_libraryId = LibraryId, @s_libraryName = LibraryName, @s_libraryAliasName = LibraryAliasName,
					@i_clientId = 0, @s_mediaAgentName = ''
		FROM	#tmpDrivePool dp
	END
	delete #tmpDrivePool
	where libraryId <> @libraryId
	if not exists (select * from #tmpdrivepool)
	begin
set @i_retcode = 922
		goto ERROR_EXIT
	end
	-- Make sure the drive pool can access the given volume
	if exists (select c.DeviceId
				from	MMVolume a WITH (NOLOCK), MMMountPath b WITH (NOLOCK), MMMountPathToStorageDevice c WITH (NOLOCK)
				where	a.VolumeId = @i_VolumeId
				and		a.MediaSideId = b.MediaSideId
				and		b.MountPathId = c.MountPathId
				and		c.DeviceId > 0)
	begin
		SELECT TOP 1 @i_clientId = ClientId, @s_mediaAgentName = NetHostName,
					@i_libraryId = LibraryId, @s_libraryName = LibraryName, @s_libraryAliasName = LibraryAliasName
		FROM	#tmpDrivePool
		delete #tmpDrivePool
		where DrivePoolId not in
		(
			select	t.DrivePoolId
			from	#tmpDrivePool t, MMVolume a WITH (NOLOCK), MMMountPath b WITH (NOLOCK), MMMountPathToStorageDevice c WITH (NOLOCK), MMDeviceController d WITH (NOLOCK)
			where	a.VolumeId = @i_VolumeId
			and		a.MediaSideId = b.MediaSideId
			and		b.MountPathId = c.MountPathId
			and		c.DeviceId = d.DeviceId
			and		t.ClientId = d.ClientId
			and		((d.DeviceControllerEnabled = 1 and d.DeviceAccessible = 1) or (@jobType = @ARCHIVECHECK AND b.OfflineReason = 6 /*MOUNTPATH_MARKED_PERMANENTLY_OFFLINE_BY_USER*/ ))
		)
		if not exists (select * from #tmpdrivepool)
		begin
set @i_retcode = 317
			goto ERROR_EXIT
		end
	end
end
-- Check if the media agent can access the index data
if @jobType in (@INDEXRESTORE)
and exists (
				select ClientId	from #tmpDrivePool
				where	ClientReleaseId >= 14 /* release 9.0 */
			)
begin
	SELECT TOP 1 @i_clientId = ClientId, @s_mediaAgentName = NetHostName,
				@i_libraryId = 0, @s_libraryName = '', @s_libraryAliasName = ''
	FROM	#tmpDrivePool
	where	ClientReleaseId < 14
	delete	from #tmpDrivePool
	where		ClientReleaseId < 14
	if	not exists (select * from #tmpdrivepool)
	begin
		set @i_failureType = 1
set @i_retcode = 20063
		goto ERROR_EXIT
	end
end
--Create and populate the shared temp table before submitting the cloud VM power on request to MM
if object_id('tempdb.dbo.#tmpVMPowerOnReq') is not null DROP TABLE #tmpVMPowerOnReq
CREATE TABLE #tmpVMPowerOnReq (
		RMRequestId		INT,
		HostId			INT,
		jobId 			INT,
		commCellId 		INT,
		PRIMARY KEY (jobId, HostId)
	)
IF @isPowerVMFeatureEnabled > 0
BEGIN
IF NOT EXISTS (SELECT 1 FROM #tmpDrivePool WHERE HostOfflineReason <> @HOST_STATUS_POWER_MANAGED_VM AND Attribute & 32768 = 0
							  AND LibraryEnabled = 1
							  AND MasterPoolEnabled = 1
							  AND DrivePoolEnabled = 1
							  AND MmHostEnabled = 1
							  AND AccessPathEnabled = 1	)
	BEGIN
		SELECT TOP 1 @i_clientId = ClientId, @s_mediaAgentName = NetHostName,
					@i_libraryId = LibraryId, @s_libraryName = LibraryName, @s_libraryAliasName = LibraryAliasName
		FROM	#tmpDrivePool
WHERE	HostOfflineReason = @HOST_STATUS_POWER_MANAGED_VM AND Attribute & 32768 > 0
				  AND LibraryEnabled = 1
				  AND MasterPoolEnabled = 1
				  AND DrivePoolEnabled = 1
				  AND MmHostEnabled = 1
				  AND AccessPathEnabled = 1
	END
	delete	#tmpdrivepool
where HostOfflineReason = @HOST_STATUS_POWER_MANAGED_VM AND Attribute & 32768 > 0
		  AND LibraryEnabled = 1
		  AND MasterPoolEnabled = 1
		  AND DrivePoolEnabled = 1
		  AND MmHostEnabled = 1
		  AND AccessPathEnabled = 1
	if	not exists (select * from #tmpdrivepool)
	begin
		/* Submit clould VM power on request */
		INSERT INTO #tmpVMPowerOnReq
		SELECT 0, @i_ClientId, @i_jobId, 2
		EXEC @i_retcode = RMSubmitVMPowerONRequest 0
		IF @i_retcode > 0
		BEGIN
SET @i_retcode 	= 415
SET @i_failureType 	= 2
		END
		ELSE
		BEGIN
SET @i_retcode 	= 346
SET @i_failureType 	= 1
		END
		DELETE FROM #tmpVMPowerOnReq
		set @i_failureType = 1
		goto ERROR_EXIT
	end
END
-- Filter out drivepools which are not useable and return a specific error code when no drivepool is available
if	@i_drivePoolId <= 0 and exists (select * from #tmpdrivepool)
begin
	IF NOT EXISTS (SELECT * FROM #tmpDrivePool WHERE LibrarySoftState = 1 and LibraryEnabled = 1 and LibraryBroken = 0)
	BEGIN
		SELECT TOP 1 @i_libraryId = LibraryId, @s_libraryName = LibraryName, @s_libraryAliasName = LibraryAliasName,
					@i_clientId = 0, @s_mediaAgentName = ''
		FROM	#tmpDrivePool
		WHERE	LibrarySoftState = 0 or LibraryEnabled = 0 or LibraryBroken = 1
	END
	delete	#tmpdrivepool
	where	LibrarySoftState = 0 or LibraryEnabled = 0 or LibraryBroken = 1
	if	not exists (select * from #tmpdrivepool)
	begin
		set @i_failureType = 1
set @i_retcode = 270
		goto ERROR_EXIT
	end
IF NOT EXISTS (SELECT * FROM #tmpDrivePool WHERE (ExtendedAttributes & 512) = 0)
	BEGIN
		SELECT TOP 1 @i_libraryId = LibraryId, @s_libraryName = LibraryName, @s_libraryAliasName = LibraryAliasName,
					@i_clientId = 0, @s_mediaAgentName = ''
		FROM	#tmpDrivePool
WHERE	(ExtendedAttributes & 512) > 0
	END
	delete	#tmpdrivepool
where	(ExtendedAttributes & 512) = 512
	if	not exists (select * from #tmpdrivepool)
	begin
		set @i_failureType = 1
set @i_retcode = 20037
		goto ERROR_EXIT
	end
	IF NOT EXISTS (SELECT * FROM #tmpDrivePool WHERE MasterPoolSoftState = 1 and MasterPoolEnabled = 1)
	BEGIN
		SELECT TOP 1 @i_libraryId = LibraryId, @s_libraryName = LibraryName, @s_libraryAliasName = LibraryAliasName,
					@i_clientId = 0, @s_mediaAgentName = ''
		FROM	#tmpDrivePool
		WHERE	MasterPoolSoftState = 0 or MasterPoolEnabled = 0
	END
	delete	#tmpdrivepool
	where	MasterPoolSoftState = 0 or MasterPoolEnabled = 0
	if	not exists (select * from #tmpdrivepool)
	begin
		set @i_failureType = 1
set @i_retcode = 271
		goto ERROR_EXIT
	end
	IF NOT EXISTS (SELECT * FROM #tmpDrivePool WHERE DrivePoolSoftState = 1 and DrivePoolEnabled = 1)
	BEGIN
		SELECT TOP 1 @i_clientId = ClientId, @s_mediaAgentName = NetHostName,
					@i_libraryId = LibraryId, @s_libraryName = LibraryName, @s_libraryAliasName = LibraryAliasName
		FROM	#tmpDrivePool
		WHERE	DrivePoolSoftState = 0 or DrivePoolEnabled = 0
	END
	delete	#tmpdrivepool
	where	DrivePoolSoftState = 0 or DrivePoolEnabled = 0
	if	not exists (select * from #tmpdrivepool)
	begin
		set @i_failureType = 1
set @i_retcode = 256
		goto ERROR_EXIT
	end
	-- Auxiliary Copy, Data Verification and Offline Content Indexing, and SIDB recontruction don't use index cache
	if	@jobType NOT IN (@AUXCOPY, @ARCHIVECHECK, @OFFLINECI, @DEDUPDBSYNC, @AUXCOPY2)
	begin
		IF NOT EXISTS (SELECT * FROM #tmpDrivePool WHERE AccessPathEnabled = 1 and AccessPathSoftState = 1)
		BEGIN
			SELECT TOP 1 @i_clientId = ClientId, @s_mediaAgentName = NetHostName,
						@i_libraryId = LibraryId, @s_libraryName = LibraryName, @s_libraryAliasName = LibraryAliasName
			FROM	#tmpDrivePool
			WHERE	AccessPathEnabled = 0 or AccessPathSoftState = 0
		END
		delete	#tmpdrivepool
		where	AccessPathEnabled = 0 or AccessPathSoftState = 0
		if	not exists (select * from #tmpdrivepool)
		begin
			set @i_failureType = 1
set @i_retcode = 840
			goto ERROR_EXIT
		end
	end
	IF NOT EXISTS (SELECT * FROM #tmpDrivePool WHERE MmHostSoftState = 1 and MmHostEnabled = 1)
	BEGIN
		SELECT TOP 1 @i_clientId = ClientId, @s_mediaAgentName = NetHostName,
					@i_libraryId = LibraryId, @s_libraryName = LibraryName, @s_libraryAliasName = LibraryAliasName
		FROM	#tmpDrivePool
		WHERE	MmHostSoftState = 0 or MmHostEnabled = 0
	END
	delete	#tmpdrivepool
	where	MmHostSoftState = 0 or MmHostEnabled = 0
	if	not exists (select * from #tmpdrivepool)
	begin
		set @i_failureType = 1
set @i_retcode = 357
		goto ERROR_EXIT
	end
IF NOT EXISTS (SELECT * FROM #tmpDrivePool WHERE (Attribute & 16) = 0)
	BEGIN
		SELECT TOP 1 @i_clientId = ClientId, @s_mediaAgentName = NetHostName,
					@i_libraryId = LibraryId, @s_libraryName = LibraryName, @s_libraryAliasName = LibraryAliasName
		FROM	#tmpDrivePool
WHERE	(Attribute & 16) > 0
	END
	delete	#tmpdrivepool
where	(Attribute & 16) = 16
	if	not exists (select * from #tmpdrivepool)
	begin
		set @i_failureType = 1
set @i_retcode = 20036
		goto ERROR_EXIT
	end
	-- Check mountpaths
	IF @mountPathId > 0 AND NOT EXISTS (SELECT * FROM MMMountPath WITH (NOLOCK) WHERE MountPathId = @mountPathId
			AND (IsOffline = 0 OR (@jobType = @ARCHIVECHECK AND OfflineReason = 6 /*MOUNTPATH_MARKED_PERMANENTLY_OFFLINE_BY_USER*/)) AND IsEnabled = 1)
	BEGIN
		SELECT TOP 1 @i_libraryId = LibraryId, @s_libraryName = LibraryName, @s_libraryAliasName = LibraryAliasName,
					@i_clientId = 0, @s_mediaAgentName = ''
		FROM	#tmpDrivePool
	END
	delete	#tmpdrivepool
where	DrivePoolType = 10001
		and not exists (select * from MMMountPath WITH (NOLOCK)
						where MountPathId = @mountPathId
						and (IsOffline = 0 OR (@jobType = @ARCHIVECHECK AND OfflineReason = 6 /*MOUNTPATH_MARKED_PERMANENTLY_OFFLINE_BY_USER*/)) AND IsEnabled = 1)
	if	not exists (select * from #tmpdrivepool)
	begin
		set @i_failureType = 1
set @i_retcode = 312
		goto ERROR_EXIT
	end
	-- Check MMDevice
	IF @mountPathId > 0
	AND EXISTS (SELECT MD.MountPathId
					FROM MMMountPathToStorageDevice MD WITH (NOLOCK) LEFT JOIN MMDevice Device WITH (NOLOCK)
						 ON MD.MountPathId = @mountPathId AND MD.DeviceId = Device.DeviceId
					WHERE	MD.DeviceId != 0
					AND 	(Device.DeviceBroken = 1 OR Device.DeviceEnabled = 0))
	BEGIN
		SELECT TOP 1 @i_libraryId = LibraryId, @s_libraryName = LibraryName, @s_libraryAliasName = LibraryAliasName,
					@i_clientId = 0, @s_mediaAgentName = ''
		FROM	#tmpDrivePool
		delete	#tmpdrivepool
where	DrivePoolType = 10001
		if	not exists (select * from #tmpdrivepool)
		begin
			set @i_failureType = 1
SELECT @i_retcode = CASE WHEN Device.DeviceBroken = 1 THEN 442
ELSE 441 END
			FROM MMMountPathToStorageDevice MD WITH (NOLOCK), MMDevice Device WITH (NOLOCK)
			WHERE MD.MountPathId = @mountPathId AND MD.DeviceId = Device.DeviceId
			AND (Device.DeviceBroken = 1 OR Device.DeviceEnabled = 0)
			goto ERROR_EXIT
		end
	END
	-- Check drive controller for non-magnetic library, make sure there is drive controller available.
	IF @mountPathId = 0
	BEGIN
		SELECT TOP 1 @i_libraryId = a.LibraryId, @s_libraryName = a.LibraryName, @s_libraryAliasName = a.LibraryAliasName,
					@i_clientId = a.ClientId, @s_mediaAgentName = a.NetHostName
		FROM #tmpdrivepool a
		LEFT JOIN (SELECT DISTINCT DrivePoolId, ClientId, DriveControllerId FROM MMDriveController WITH (NOLOCK)) AS b
		ON a.DrivePoolId = b.DrivePoolId AND a.ClientId = b.ClientId
		WHERE b.DriveControllerId IS NULL
		DELETE #tmpdrivepool
		FROM #tmpdrivepool a
		LEFT JOIN (SELECT DISTINCT DrivePoolId, ClientId, DriveControllerId FROM MMDriveController WITH (NOLOCK)) AS b
		ON a.DrivePoolId = b.DrivePoolId AND a.ClientId = b.ClientId
		WHERE b.DriveControllerId IS NULL
		if	not exists (select * from #tmpdrivepool)
		begin
			set @i_failureType = 1
set @i_retcode = 405
			goto ERROR_EXIT
		end
	END
end
create index tmpdrivepool_drivepoolid on #tmpdrivepool(drivepoolid)
create index tmpdrivepool_libraryid on #tmpdrivepool(libraryid)
-- populate #destClientIds
if	@dataPathType = @CVDP_NAS and @jobType in (@BACKUP, @INDEXRESTORE, @RESTORE)
begin
	set	@jobClientId = dbo.GetClientIdForJob(@i_jobId)
end
-- if the destination client is a NAS client with license type 25, then ignore the client and media agent version check
if @jobType in (@BACKUP, @INDEXRESTORE, @RESTORE)
begin
	if @jobClientId > 0
	begin
		if exists (select	id
				from	LicUsage WITH (NOLOCK)
where	cid = @jobClientId AND LicType IN (25 /*SIM_CSL_AT_V2_NAS */) AND OpType = 'Install'
			)
			set @i_ignoreVersionForRestore = 1
	end
	else if @i_destinationClient > 0
	begin
		if exists (select	id
				from	LicUsage WITH (NOLOCK)
where	cid = @i_destinationClient AND LicType IN (25 /*SIM_CSL_AT_V2_NAS*/) AND OpType = 'Install'
			)
			set @i_ignoreVersionForRestore = 1
	end
end
if  @jobClientId > 0
begin
	insert	into #destClientIds
	select	@jobClientId, 0
end
else
begin
	-- For Offline Content Indexing job, the destination Client id is the CloundClient Id.
	-- When using FAST, this CloudClientId will be the only one that can index data.
	-- But when using SOLR, all client within the same Cloud Id can be used for indexing.
	-- Therefore, destination client id will be a set of clients that can do indexing for SOLR.
	-- cliu 2012-9-21
	-- Destination client id may not valid. We need to use volume mediagroup id to look up the cloud id.
	if @jobType = @OFFLINECI /* and @i_destinationClient > 0*/
	begin
		--select @cloudId = isnull(componentId, 0) from APP_ComponentProp with (readuncommitted)
--where componentType = 2 /* CV_COMPONENT_TYPE_FASTINDEX_CLOUD*/
--and propertyTypeId = 1008 /* CV_COMPONENT_CI_ENGINE_CLIENTID_PROP*/
		--and modified = 0
		--and longVal = @i_destinationClient
		if @cloudId = 0
		begin
			if exists (select * from app_client with (nolock) where id = @i_destinationClient)
				insert	into #destClientIds
				select	@i_destinationClient, 0
		end
		-- cliu 2013-06-25
		-- MR 98750, Enable mutiple auxcopy.exe's to run and facilitate Load balancing between both Lan and non-Lan free MA's
		-- This change is to ignore the CI engine Media Agents for CI job and allow all the usble MA to access the source data.
		-- In the following logic, MA will be selected based on loadbalance for CI job.
		-- And CI engine will be selected based on option of loadbalance or preferred lan-free during actual reservations.
		else if not exists (select * from MMConfigs with (nolock)
							where name = 'Allow Content Indexing jobs to do load-balance among Lan and Lan-Free Media Agents for processing and pushing data'
							and value > 0)
		-- else
		begin
			insert	into #destClientIds
			select	distinct a.ClientId, 0
			from 	DM2SearchServerCoreInfo a with (readuncommitted), MMHost b with (readuncommitted)
			where	a.CloudId = @CloudId
and		a.CoreRoles & 16 > 0
			and		a.Enabled > 0
			and		a.ClientId = b.ClientId
			and		b.MMHostSoftState > 0 and b.MMHostEnabled > 0
			if @@ROWCOUNT = 0
			begin
				if exists (select * from app_client with (nolock) where id = @i_destinationClient)
					insert	into #destClientIds
					select	@i_destinationClient, 0
			end
		end
	end
	else
	begin
		if	@i_destinationClient > 0
		begin
			insert	into #destClientIds
			select	@i_destinationClient, 0
		end
		if	@i_destCopyId > 0 and @jobType not in (@RESTORE, @INDEXRESTORE)
		begin
			insert	into #destClientIds
			select	distinct HostClientId, 0
			from	MMDataPath WITH (NOLOCK)
			where	CopyId = @i_destCopyId
				and HostClientId != @i_destinationClient
and (Flag & 4) > 0
		end
	end
end
if	(
	 (@i_ignoreVersionForRestore <= 0 and @jobType in (@RESTORE, @INDEXRESTORE))
	 or
	 (@jobType in (@AUXCOPY, @OFFLINECI, @AUXCOPY2))
	)
	and exists (select * from #destClientIds)
	and exists (select * from #tmpdrivepool)
begin
	-- delete ma that have older version than APP_Client
	insert	into #tmpLicUsage
	select	0, c.Id, c.ReleaseId
	from	APP_Client c WITH (NOLOCK), #destClientIds T
	where	c.id = T.destClientId
	insert	into #tmpLicUsage
	select	0, c.Id, c.ReleaseId
	from	APP_Client c WITH (NOLOCK), #tmpdrivepool T
	where	c.id = T.clientId
	/*
	insert	into #tmpLicUsage
	select	LU.id, LU.CId, LU.ReleaseId
	from	LicUsage LU WITH (NOLOCK), #destClientIds T
	where	LU.cid = T.destClientId AND LU.LicType NOT IN (71, 10, 26) AND LU.OpType = 'Install'
	insert	into #tmpLicUsage
	select	LU.id, LU.CId, LU.ReleaseId
	from	LicUsage LU WITH (NOLOCK), #tmpdrivepool T
	where	LU.cid = T.clientId AND LU.LicType NOT IN (71, 10, 26) AND LU.OpType = 'Install'
	*/
	update	#destClientIds
	set		clientReleaseId = (SELECT TOP 1 ReleaseId FROM #tmpLicUsage WHERE CId = #destClientIds.destClientId ORDER BY id DESC)
	if	@jobType in (@AUXCOPY, @AUXCOPY2)
	begin
		SELECT TOP 1 @i_clientId = ClientId, @s_mediaAgentName = NetHostName,
					@i_libraryId = LibraryId, @s_libraryName = LibraryName, @s_libraryAliasName = LibraryAliasName
		FROM	#tmpDrivePool
		-- if either source data is from NAS drive pool, or destination is going to use NAS data path, skip the version check.
		if	@dataPathType != @CVDP_NAS
		and (@i_destCopyId <= 0
				or not exists (
							select drivepool.DrivePoolId
							from MMDataPath datapath WITH (NOLOCK), MMDrivePool drivepool WITH (NOLOCK)
							where	datapath.CopyId = @i_destCopyId
							and		datapath.drivepoolId = drivepool.drivepoolId
							and		drivepool.NDMPHostId > 0
				)
			)
		begin
			-- THIS DOESN'T APPLY ANYMORE "delete drive pool from #tmpdrivepool if there is no same version of ma from #destclientIds"
			-- MR 108886, adding support for using 9.0 source Media Agent and 10.0 destination Media Agent
			-- Only case we don't support is when 10.0 is using multiple split for DDB store. This is done during reservation.
			-- And we don't support from later (10.0) source MediaAgent to older (9.0) destination Media agent. This is handled below.
			delete	from #tmpdrivepool
			where	-- No destination match the source MA version and source MA version is greater than all the destination MAs
				not exists (select client.destClientId from #tmpLicUsage LU, #destClientIds client
						where LU.CId = #tmpdrivepool.clientid and LU.releaseid /*Source MA version*/ <= client.clientReleaseId)
		end
	end
	else if @jobType in (@OFFLINECI)
	begin
		IF EXISTS ( SELECT COUNT (*)
						FROM (SELECT DISTINCT clientReleaseId FROM #destClientIds WHERE clientReleaseId > 0) a
						HAVING COUNT(*) > 1
			)
		begin
			SELECT TOP 1 @i_clientId = ClientId, @s_mediaAgentName = NetHostName,
						@i_libraryId = LibraryId, @s_libraryName = LibraryName, @s_libraryAliasName = LibraryAliasName
			FROM	#tmpDrivePool
			delete	from #tmpdrivepool
			set @i_failureType = 1
set @i_retcode = 20116
			goto ERROR_EXIT
		end
		-- skip the check for FAST search engine
		IF @cloudId IS NOT NULL AND @cloudId > 0
		AND EXISTS (
			select id from APP_ComponentProp with (readuncommitted)
			where componentId = @cloudId
and componentType = 2 /* CV_COMPONENT_TYPE_FASTINDEX_CLOUD*/
and propertyTypeId = 1014 /* CV_COMPONENT_CI_ENGINE_VERSION_PROP*/
			and modified = 0
			and stringVal like '%SOLR%'
			)
		begin
			-- table #destClientIds contains all the CI engine ma
			SELECT TOP 1 @i_clientId = ClientId, @s_mediaAgentName = NetHostName,
						@i_libraryId = LibraryId, @s_libraryName = LibraryName, @s_libraryAliasName = LibraryAliasName
			FROM	#tmpDrivePool
			-- delete drive pool from #tmpdrivepool if there is no same version of ma from #destclientIds
			delete	from #tmpdrivepool
			where	not exists (select client.destClientId from #tmpLicUsage LU, #destClientIds client
								where LU.CId = #tmpdrivepool.clientid and LU.releaseid = client.clientReleaseId)
		end
	end
	else -- jobtype is @RESTORE, @INDEXRESTORE
	begin
		-- MA is older than client
		SELECT TOP 1 @i_clientId = ClientId, @s_mediaAgentName = NetHostName,
					@i_libraryId = LibraryId, @s_libraryName = LibraryName, @s_libraryAliasName = LibraryAliasName
		FROM	#tmpDrivePool
		-- Backward compatibility support when media agent is one release earlier than client, starting from release 11.0
		if exists (select clientReleaseId from #destClientIds where clientReleaseId >= 16 /*release 11.0*/)
		begin
			delete	from #tmpdrivepool
			where	ClientId in (select distinct LU.CId from #tmpLicUsage LU
					where 	(LU.ReleaseId + 1) <  (select top 1 clientReleaseId from #destClientIds order by clientReleaseId desc /*where destClientId = LU.CId*/))
				and ClientId not in (select distinct LU.CId from #tmpLicUsage LU
					where LU.ReleaseId >= (select top 1 clientReleaseId from #destClientIds order by clientReleaseId desc /*where destClientId = LU.CId*/))
		end
		else
		begin
		delete	from #tmpdrivepool
		where	ClientId in (select distinct LU.CId from #tmpLicUsage LU
				where LU.ReleaseId <  (select top 1 clientReleaseId from #destClientIds order by clientReleaseId desc /*where destClientId = LU.CId*/))
			and ClientId not in (select distinct LU.CId from #tmpLicUsage LU
				where LU.ReleaseId >= (select top 1 clientReleaseId from #destClientIds order by clientReleaseId desc /*where destClientId = LU.CId*/))
	end
	end
    if	not exists (select * from #tmpdrivepool)
    begin
		if	@jobType = @AUXCOPY OR @jobType = @AUXCOPY2
set @i_retcode = 20042
		else if @jobType = @OFFLINECI
set @i_retcode = 20115
		else --@jobtype is @RESTORE, @INDEXRESTORE
set @i_retcode = 20012
		goto ERROR_EXIT
    end
end
-- For auxcopy job, if the destination copy is using sidb store with partinations,
-- the source media agent must be 10.0 or later
if (@jobType in (@AUXCOPY) AND @i_destCopyId > 0)
BEGIN
	IF EXISTS (SELECT substore.SIDBStoreId FROM ArchGroupCopy copy with (readuncommitted), IdxSIDBSubStore substore with (readuncommitted)
				WHERE		copy.id = @i_destCopyId
				AND			copy.SIDBStoreId = substore.SIDBStoreId
				GROUP BY substore.SIDBStoreId
				HAVING COUNT(substore.SubStoreId) > 1
			)
	begin
			SELECT TOP 1 @i_clientId = ClientId, @s_mediaAgentName = NetHostName,
						@i_libraryId = 0, @s_libraryName = '', @s_libraryAliasName = ''
			FROM	#tmpDrivePool
			where	clientid in (
									SELECT a.clientId FROM #tmpdrivepool a with (readuncommitted), App_Client cl with (readuncommitted)
									WHERE	a.clientid = cl.Id AND cl.ReleaseId <= 14 /* release 9.0 */
								)
			delete	from #tmpdrivepool
			where	clientid in (
									SELECT a.clientId FROM #tmpdrivepool a with (readuncommitted), App_Client cl with (readuncommitted)
									WHERE	a.clientid = cl.Id AND cl.ReleaseId <= 14 /* release 9.0 */
								)
	end
	-- If it is not use ddb split
	ELSE IF EXISTS (SELECT copy.SIDBStoreId FROM ArchGroupCopy copy with (readuncommitted)
WHERE		copy.id = @i_destCopyId AND copy.SIDBStoreId > 0 AND (extendedFlags & 32) = 0)
	BEGIN
			DECLARE @sidbMAReleaseId INT = 0
			SET @sidbMAReleaseId = ISNULL( ( SELECT TOP 1 cl.releaseId
											FROM	 App_Client cl with (readuncommitted), ArchGroupCopy copy with (readuncommitted), IdxSIDBSubStore store with (readuncommitted)
											WHERE		copy.id = @i_destCopyId
											AND			copy.SIDBStoreId = store.SIDBStoreId
											AND			store.clientId = cl.id
											ORDER BY cl.releaseId desc), 0)
			SELECT TOP 1 @i_clientId = ClientId, @s_mediaAgentName = NetHostName,
						@i_libraryId = 0, @s_libraryName = '', @s_libraryAliasName = ''
			FROM	#tmpDrivePool
			where	clientid in (
									SELECT a.clientId FROM #tmpdrivepool a with (readuncommitted), App_client lu with (readuncommitted)
									WHERE	a.clientid = lu.Id AND lu.ReleaseId != @sidbMAReleaseId
								)
			-- Additional check for destination copy's DDB MA version. Need to make sure the selected source MA will not cause problem later
			delete	from #tmpdrivepool
			where	-- destination copy should have compatible DDB MA compared to source MA
					exists (select LU.ID from App_Client LU WITH (readuncommitted)
							where LU.Id = #tmpdrivepool.clientid
							and (
									(@sidbMAReleaseId <= 14 and LU.releaseid != @sidbMAReleaseId)
									--or
									--(@sidbMAReleaseId > 14 and LU.releaseid <= 14)
								)
							)
	END
	if	not exists (select * from #tmpdrivepool)
	begin
set @i_retcode = 20111
		goto ERROR_EXIT
	end
END
ELSE if (@jobType in (@AUXCOPY2)
		or (@jobType = @ARCHIVECHECK and @jobSubOpType = @ARCHIVECHECK2))
BEGIN
	SELECT TOP 1 @i_clientId = ClientId, @s_mediaAgentName = NetHostName,
				@i_libraryId = 0, @s_libraryName = '', @s_libraryAliasName = ''
	FROM	#tmpDrivePool
	where	clientid in (
							SELECT a.clientId FROM #tmpdrivepool a with (readuncommitted), #tmpLicUsage lu
							WHERE	a.clientid = lu.CId AND lu.ReleaseId < 16 /* release 11.0 */
						)
	-- For DASH copy or DV2 job, only 11 or later MA are supported
	delete	from #tmpdrivepool
	where	exists (select LU.ID from App_client LU with (readuncommitted) where LU.Id = #tmpdrivepool.clientid and LU.releaseid < 16 /* release 11.0 */)
	if	not exists (select * from #tmpdrivepool)
	begin
set @i_retcode = 344
		goto ERROR_EXIT
	end
END
ELSE IF @jobType in (@DEDUPDBSYNC)
AND @i_volumeId > 0
begin
	DECLARE @DDBSyncCopyId integer = 0
	SELECT @DDBSyncCopyId = S.archGroupCopyId
	FROM	archStream S WITH (NOLOCK), MMVolume V with (NOLOCK)
	WHERE	S.mediaGroupId = v.MediaGroupId AND V.VolumeId = @i_volumeId
	DECLARE @DDBSyncSIDBMAReleaseId INT = 0
	SET @DDBSyncSIDBMAReleaseId = ISNULL( ( SELECT TOP 1 cl.releaseId
									FROM	 App_Client cl with (readuncommitted), ArchGroupCopy copy with (readuncommitted), IdxSIDBSubStore store with (readuncommitted)
									WHERE		copy.id = @DDBSyncCopyId
									AND			copy.SIDBStoreId = store.SIDBStoreId
									AND			store.clientId = cl.id
									ORDER BY cl.releaseId desc), 0)
	SELECT TOP 1 @i_clientId = ClientId, @s_mediaAgentName = NetHostName,
			@i_libraryId = 0, @s_libraryName = '', @s_libraryAliasName = ''
	FROM	#tmpDrivePool
	where	clientid in (
							SELECT a.clientId FROM #tmpdrivepool a with (readuncommitted), App_client lu with (readuncommitted)
							WHERE	a.clientid = lu.Id AND lu.ReleaseId != @DDBSyncSIDBMAReleaseId
						)
	-- Make sure source media agent has the same version as DDB media agent
	delete	from #tmpdrivepool
	where	exists (select LU.ID from App_Client LU WITH (readuncommitted)
					where LU.Id = #tmpdrivepool.clientid
					and LU.releaseid != @DDBSyncSIDBMAReleaseId)
	if	not exists (select * from #tmpdrivepool)
	begin
set @i_retcode = 20111
		goto ERROR_EXIT
	end
	if @jobSubOpType = @DEDUPDBSYNC2
	begin
		SELECT TOP 1 @i_clientId = ClientId, @s_mediaAgentName = NetHostName,
					@i_libraryId = 0, @s_libraryName = '', @s_libraryAliasName = ''
		FROM	#tmpDrivePool
		where	clientid in (
								SELECT a.clientId FROM #tmpdrivepool a with (readuncommitted), app_client c with (readuncommitted), simInstalledPackages p with (readuncommitted)
								WHERE	a.clientid = c.id and c.id = p.clientid AND (c.ReleaseId < 16 /* release 11.0 */ OR (c.ReleaseId = 16 AND p.HighestSP < 14))
							)
		-- For  DEDUPDBSYNC2 job, only 11 SP14 or later MA are supported
		delete	from #tmpdrivepool
		where	exists (select 1 from app_client c with (readuncommitted), simInstalledPackages p with (readuncommitted)
						where c.Id = #tmpdrivepool.clientid and c.id = p.clientid AND (c.ReleaseId < 16 /* release 11.0 */ OR (c.ReleaseId = 16 AND p.HighestSP < 14)))
		if	not exists (select * from #tmpdrivepool)
		begin
set @i_retcode = 344
			goto ERROR_EXIT
		end
	end
end
--For DASH copy check operation window on MA
if @jobType = @AUXCOPY2
BEGIN
	SELECT TOP 1 @i_clientId = ClientId, @s_mediaAgentName = NetHostName,
				@i_libraryId = 0, @s_libraryName = '', @s_libraryAliasName = ''
	FROM	#tmpDrivePool
	SET @taskId = ISNULL((SELECT TOP 1 jobReq.taskId FROM TM_Jobs jobs WITH(NOLOCK) INNER JOIN TM_JobRequest jobReq WITH(NOLOCK)
										ON jobs.jobId = @i_jobId AND jobs.jobRequestId = jobReq.jobRequestId ),0)
	delete	from #tmpdrivepool
	where	dbo.IsOperationAllowedV2(16 /*OPERATION_AUX_COPY*/, 2 /*CommCellId*/, ClientId, 0 /*AppType*/, 0 /*InstanceId*/, 0 /*BackupsetId*/, 0 /*SubClientId*/,@taskId) <> -1
	if	not exists (select * from #tmpdrivepool)
	begin
		SET @OPWindowRetCode = dbo.IsOperationAllowedV2(16 /*OPERATION_AUX_COPY*/, 2 /*CommCellId*/, @i_clientId, 0 /*AppType*/, 0 /*InstanceId*/, 0 /*BackupsetId*/, 0 /*SubClientId*/,@taskId)
set @i_retcode = CASE WHEN @OPWindowRetCode = 0 THEN 84001
WHEN @OPWindowRetCode = 1 THEN 84002
WHEN @OPWindowRetCode = 2 THEN 84003
WHEN @OPWindowRetCode = 3 THEN 84004
WHEN @OPWindowRetCode = 4 THEN 84005
WHEN @OPWindowRetCode = 5 THEN 84006
WHEN @OPWindowRetCode = 6 THEN 84007
WHEN @OPWindowRetCode = 7 THEN 84008
WHEN @OPWindowRetCode = 8 THEN 84009
ELSE 84001 END
		goto ERROR_EXIT
	end
END
-- For synthetic full job, the source media agent has to have the same version as any reserved write media agent
if @jobType = @SYNTHFULL
and exists (select * from MMResourceToJob with (NOLOCK) where JobId_l = @i_jobId and ReservationType = 2 and (InUse != 0 or ReleaseTime = 0))
begin
	delete from #tmpLicUsage
	insert	into #tmpLicUsage
	select	0, c.Id, c.ReleaseId
	from	APP_Client c WITH (NOLOCK),
			(
				select	res.clientId
				from	MMResource res with (NOLOCK), MMResourceToJob restojob with (NOLOCK)
				where	res.ReservationId = restojob.ReservationId
				and		restojob.JobId_l = @i_jobId and restojob.ReservationType = 2 and (restojob.InUse != 0 or restojob.ReleaseTime = 0)
			) b
	where	c.id = b.clientId
	SELECT TOP 1 @i_clientId = ClientId, @s_mediaAgentName = NetHostName,
				@i_libraryId = LibraryId, @s_libraryName = LibraryName, @s_libraryAliasName = LibraryAliasName
	FROM	#tmpDrivePool
	-- delete drive pool from #tmpdrivepool if there is no same version of ma from #tmpLicUsage
	delete	from #tmpdrivepool
	where	not exists (select LU.CId from #tmpLicUsage LU, APP_Client c with (NOLOCK)
						where c.Id = #tmpdrivepool.clientid and c.releaseid = LU.ReleaseId)
    if	not exists (select * from #tmpdrivepool)
    begin
		set @i_failureType = 1
set @i_retcode = 20117
		goto ERROR_EXIT
    end
end
if	@mediaTypeId = 10001
	and not exists (select * from #tmpdrivepool where libraryid = @libraryid)
begin
	SELECT TOP 1 @i_libraryId = LibraryId, @s_libraryName = LibraryName, @s_libraryAliasName = LibraryAliasName,
				@i_clientId = 0, @s_mediaAgentName = ''
	FROM	#tmpDrivePool
set @i_retcode = 922
	goto ERROR_EXIT
end
/* If prefer copy datapaths config param is set then we give preference to data paths over lan-free,
 * so commenting out below code, available MA will be picked based rules.
 */
--if	@dataPathType = @CVDP_NAS
--begin
--	if	exists (select * from #tmpdrivepool where nasClientId in (select destClientId from #destClientIds))
--	begin
--		delete from #tmpdrivepool where nasClientId not in (select destClientId from #destClientIds)
--		-- There may be different drive pools using the same media agent, but not all of them have available drives to use right now.
--		-- Following check only consider the drive pool id from current media group. If there is no drive available, we cannot switch to the other lan-free drive pool.
--		-- Therefore, remove the following code and check the drive avaliability later.
--		/*
--		if	@drivepoolid > 0 and @i_drivepoolid = 0	and exists (select * from #tmpdrivepool where drivepoolid = @drivepoolid)
--		begin
--			delete from #tmpdrivepool where drivepoolid != @drivepoolid
--		end
--		*/
--		goto FOUND_MA
--	end
--end
--else
--begin
--	if	exists (select * from #tmpdrivepool where clientid in (select destClientId from #destClientIds))
--	and
--	-- check if the passing in media agent have access to the drive when media is in drive and reserved
--	( 	@mediaTypeId = CV_MAGNETIC_MEDIA
--		or
--		-- check if the passing in media agent have access to the drive when media is in drive and reserved.
--		-- Otherwise, we always return the media agent reserving the media at the end.
--		(
--			not exists (select * from MMResource WITH (NOLOCK) where MediaId = @mediaId
--									and	HasJobInterrupted = 0 and IntrJobId_l = 0)
--			and
--			(
--				@mediaLocation != @LOCATION_DRIVE
--				or
--				exists	(
--								select * from #tmpdrivepool a, #destClientIds b, MMDriveController c WITH (NOLOCK), MMDrive d WITH (NOLOCK)
--								where	a.clientId = b.destClientId
--								and		a.drivepoolid = c.drivepoolid
--								and		c.driveid = d.driveId
--								and		d.mediaid = @mediaId
--							)
--			)
--		)
--	)
--	begin
--		delete from #tmpdrivepool where clientId not in (select destClientId from #destClientIds)
--		-- There may be different drive pools using the same media agent, but not all of them have available drives to use right now.
--		-- Following check only consider the drive pool id from current media group. If there is no drive available, we cannot switch to the other lan-free drive pool.
--		-- Therefore, remove the following code and check the drive avaliability later.
--		/*
--		if	@drivepoolid > 0 and @i_drivepoolid = 0 and exists (select * from #tmpdrivepool where drivepoolid = @drivepoolid)
--		begin
--			delete from #tmpdrivepool where drivepoolid != @drivepoolid
--		end
--		*/
--		goto FOUND_MA
--	end
--end
--if	@i_isSpareVolume > 0
--begin
--	if	exists (select * from #tmpdrivepool)
--		goto FOUND_MA
--	set	@i_retcode = E_MM_DB_NO_COMPATIBLE_DRIVEPOOLS
--	goto ERROR_EXIT
--end
---- If there is already reservation exists from the same job, just skip the rest of the check.
---- The reserving drive pool will be returned always in this case.
--if exists (select DrivePoolId from MMResource WITH (NOLOCK)
--		where	volumeid = @i_volumeid
--		and ReservationId in (select ReservationId from MMResourceToJob WITH (NOLOCK) where JobId_l = @i_jobId)
--		and HasJobInterrupted = 0)
--begin
--	goto FOUND_MA
--end
--Prefer copy data paths if config param is set.
if exists (select 1 from MMConfigs WITH (NOLOCK) where name = 'RM_CONFIG_PREFER_COPY_DATAPATHS_FOR_PICKING_READ_MA' and value > 0)
begin
	SET @preferCopyDataPaths = 1
end
-- Populate copy datapaths
declare @copyId integer
set @copyId = (select top 1 (case when (S.flags & 2) = 0 then S.ArchGroupCopyId else (select archGroupCopyId from archStream WITH (NOLOCK) where MediaGroupId = S.mediaGroupId and (flags & 2) = 0) end)
				from archStream S WITH (NOLOCK) where mediaGroupId = @mediaGroupId)
if	@copyId > 0
begin
	insert	into #tmpcopydrivepools
	select	DrivePoolId, flag
	from	MMDataPath WITH (NOLOCK)
	where	copyId = @copyId
and		(Flag & 4) > 0
and 	(Flag & 16) = 0
	create index tmpcopydrivepools_drivepoolid on #tmpcopydrivepools(drivepoolid)
end
--
-- Give preference to default datapath.
--
-- If there exists an online datapath whose library is the same as the media's current libraryId (if in slot,drive), choose this.
-- Else if media is exported, and lastwritelibrary is also default drivepool's libraryId, choose this.
-- Delete the rest.
set @drivepoolid = 0
select	top 1 @drivepoolid = a.DrivePoolId
from	#tmpdrivepool a, #tmpcopydrivepools b
where	a.DrivePoolId = b.DrivePoolId
and (b.flag & 1) > 0
	and (@mediaLocation in (@LOCATION_SHELF, @LOCATION_SWITCHED) AND a.LibraryId = @lastWriteLibraryId
	  OR @mediaLocation in (@LOCATION_SLOT, @LOCATION_DRIVE) AND a.LibraryId = @libraryId)
-- In the case of shared mount paths, pick the media agent based on device access type instead of default data path
if @mediaTypeId = 10001 and @mountPathId > 0
begin
	--Prefer MA preferred to mount path over load balance if config param is set.
	if exists (select 1 from MMConfigs WITH (READUNCOMMITTED) where name = 'RM_CONFIG_PREFER_MA_PREFERRED_TO_MP_FOR_READ' and value > 0)
	begin
		SET @preferMAPreferredToMP = 1
	end
	if exists(select 1 from MMConfigs WITH(READUNCOMMITTED) where name = 'RM_CONFIG_HONOR_LOAD_BALANCE_FOR_PICKING_READ_MA' and value > 0)
	begin
		SET @honorLoadBalance = 1
	end
	UPDATE	a
	SET		isPreferredMAForMP = 1
	FROM	#tmpdrivepool a, MMMountPathToStorageDevice MD WITH (NOLOCK), MMDeviceController DC  WITH (NOLOCK)
	WHERE	a.ClientId = DC.ClientId
	AND		MD.MountPathId = @mountpathId
	AND		MD.DeviceId = DC.DeviceId
AND		DC.DeviceAccessType & 8 >0
end
if (@mediaTypeId != 10001 and
exists (select DriveId from MMDrive with (readuncommitted) where MediaId = @MediaId)
and not exists (select d.DriveId from MMDrive d with (readuncommitted), MMDriveController dc with (readuncommitted)
								where d.MediaId = @MediaId and d.DriveId = dc.DriveId and dc.DrivePoolId = @drivePoolId))
OR  -- if load balance is set on copy then set default drivePoolId to 0 so that we pick the least used drivePool.
(
exists (select 1 from ArchGroupCopy WITH(READUNCOMMITTED) where Id = @copyId and (flags & 512 > 0))
)
begin
	set @drivepoolid = 0
end
/* There is nothing we are doing other than jumping to FOUND_MA, we anyway goto FOUND_MA which is immediate next to this code.
 * Therefore removing this code.
 */
--if isnull(@drivepoolid,0) > 0
--begin
--	-- There may be different drive pools can access the volume, but not all of them have available drives to use right now.
--	-- Following check only consider the drive pool id from the data path list. If there is no drive available, we cannot switch to the other drive pool.
--	-- Therefore, remove the following code and check the drive avaliability later.
--	/*
--	delete from #tmpdrivepool where drivepoolid != @drivepoolid
--	*/
--	goto FOUND_MA
--end
---- If default datapath is not available, check if there are any other datapaths in the copy that we can use.
---- If we found the drivepool inside the copy datapaths, then use this one.
---- Do not go to FOUND_MA if no drivepools exist in the copy's datapath or the copy no longer exists
--if	exists (select * from #tmpdrivepool a, #tmpcopydrivepools b where a.drivepoolid = b.drivepoolid)
--begin
--	-- There may be different drive pools can access the volume, but not all of them have available drives to use right now.
--	-- Following check only consider the drive pool id from the data path list. If there is no drive available, we cannot switch to the other drive pool.
--	-- Therefore, remove the following code and check the drive avaliability later.
--	/*
--	delete from #tmpdrivepool where DrivePoolId not in (select DrivePoolId from #tmpcopydrivepools)
--	*/
--	goto FOUND_MA
--end
--if	exists (select * from #tmpdrivepool where LibraryId = @lastWriteLibraryId)
--begin
--	-- There may be different drive pools can access the volume, but not all of them have available drives to use right now.
--	-- Following check only consider the drive pool id from the data path list. If there is no drive available, we cannot switch to the other drive pool.
--	-- Therefore, remove the following code and check the drive avaliability later.
--	/*
--	delete from #tmpdrivepool where LibraryId != @lastWriteLibraryId
--	*/
--	goto FOUND_MA
--end
FOUND_MA:
if	not exists (select * from #tmpdrivepool)
begin
	-- no ma found
set @i_retcode = 322
	goto ERROR_EXIT
end
-- filter out other drivepools if one is already in use by this job. Should this be done earlier?
declare @reservedDrivepoolId int
set @reservedDrivepoolId = 0
if	@dataPathType = @CVDP_NAS
begin
	select	TOP 1 @reservedDrivepoolId = DrivePoolId
	from	MMResource WITH (NOLOCK)
	where	volumeid = @i_volumeid
	and ReservationId in (select ReservationId from MMResourceToJob WITH (NOLOCK) where JobId_l = @i_jobId)
	and DrivePoolId in (select DrivePoolId from #tmpdrivepool where nasclientId in (select destClientId from #destClientIds))
	order by HasJobInterrupted
end
else
begin
    select	TOP 1 @reservedDrivepoolId = DrivePoolId
    from	MMResource WITH (NOLOCK)
    where	volumeid = @i_volumeid
    and ReservationId in (select ReservationId from MMResourceToJob WITH (NOLOCK) where JobId_l = @i_jobId)
    and DrivePoolId in (select DrivePoolId from #tmpdrivepool where clientId in (select destClientId from #destClientIds))
	order by HasJobInterrupted
end
if @reservedDrivepoolId = 0
begin
	select	TOP 1 @reservedDrivepoolId = DrivePoolId
	from	MMResource WITH (NOLOCK)
	where	volumeid = @i_volumeid
	and ReservationId in (select ReservationId from MMResourceToJob WITH (NOLOCK) where JobId_l = @i_jobId and (InUse != 0 or ReleaseTime = 0))
	order by HasJobInterrupted
end
-- For replciate job, if the given destincation client is not the same as the current one reserving the volume, ignore the resevation.
-- Later the given destination client will be picked instead.
-- This is because we don't do reservation for source magnetic volume, but the same volume can be reserved for write for other copies.
if @jobType in (@AUXCOPY, @ARCHIVECHECK, @OFFLINECI, @MEDIAREFRESH, @DEDUPDBSYNC, @AUXCOPY2)
and @i_destinationClient > 0
and @reservedDrivepoolId > 0
and @dataPathType != @CVDP_NAS
begin
	if not exists (select * from MMDrivePool with (Readuncommitted) where ClientId = @i_destinationClient and DrivePoolId = @reservedDrivepoolId)
		set @reservedDrivepoolId = 0
end
/*
if	@reservedDrivepoolId > 0
begin
	delete	#tmpdrivepool
	where	DrivePoolId != @reservedDrivepoolId
end
*/
-- if not exists (select * from #tmpdrivepool)
-- set a specific error code?
declare @availableDPNum int
select @availableDPNum = count(*) from #tmpdrivepool
if @availableDPNum > 1
begin
	-- if there is more than one drive pool available, count the number of free drives that can access the volume as the order.
	update #tmpdrivepool
set orderby = case when DrivePoolType = 10001
					then (select TotalDrives from MMMasterPool WITH (NOLOCK) where MasterPoolId = #tmpdrivepool.MasterPoolId)
					else (select count(*) - (select count(DriveId) from MMResource WITH (NOLOCK) where DrivePoolId = #tmpdrivepool.DrivePoolId)
							from	MMDrive drive WITH (NOLOCK)
							where	drive.MasterPoolId = #tmpdrivepool.MasterPoolId
							and		(drive.DriveSoftState = 1 and drive.DriveEnabled = 1 and drive.DriveBroken = 0)
						 )
					end
end
-- If the job is auxcopy and destination copy specified, we should pick the media agent based on destination copy data path configuration setting.
-- If will optimize the auxcopy performance by selecting less used media agent
declare @preferredDestClientId int
declare @preferredClientReleaseId int
set @preferredDestClientId = 0
set @preferredClientReleaseId = 0
if (@jobType in (@AUXCOPY, @SYNTHFULL))
begin
	if  @i_destCopyId > 0
	begin
		if @i_destinationClient > 0
		and exists (select Id from ArchGroupCopy WITH (NOLOCK) where Id = @i_destCopyId and flags & (2 + 4) = (2 + 4) /*CVA_MULTIPLEXSTREAMS_FLAG + CVA_COMBINESTREAMS_FLAG*/)
		begin
			set @preferredDestClientId = @i_destinationClient
			-- The same volume may be reserved by the job already for different source stream due to DSA, ignore the reserved drive pool
			set @reservedDrivepoolId = 0
		end
		-- based on destination copy, should we do default, or round-robin
		-- lan-free is always honorred before that.
		-- if lan-free is available, then there are only lan-free ones left right now
else if exists (select Id from ArchGroupCopy where Id = @i_destCopyId and (flags & 512 > 0))
		begin
			select top 1 @preferredDestClientId = isnull(tmp.ClientId, 0)
			from	#tmpdrivepool tmp, MMDataPath dp WITH (NOLOCK)
			where	dp.CopyId = @i_destCopyId
			and		tmp.ClientId = dp.HostClientId
and 	(dp.flag & (4)) > 0
			-- Less used Media Agent first
			order by (case when @preferCopyDataPaths = 1 and  exists (select DrivePoolId from #tmpcopydrivepools where DrivePoolId = tmp.drivepoolid)
						then 0 else 1 end),
					(case when @preferMAPreferredToMP = 1 then tmp.isPreferredMAForMP else 0 end) desc,
					(select count(ReservationId) from MMResource WITH (NOLOCK) where ClientId = tmp.ClientId),
					 tmp.isPreferredMAForMP desc
		end
		else
		-- only consider the default one
		begin
			select @preferredDestClientId = isnull(tmp.ClientId, 0)
			from	#tmpdrivepool tmp, MMDataPath dp WITH (NOLOCK)
			where	dp.CopyId = @i_destCopyId
			and		tmp.ClientId = dp.HostClientId
and 	(dp.flag & (1 | 4)) =  (1 | 4)
		end
	end
	else if @i_destinationClient > 0
	begin
		set @preferredDestClientId = @i_destinationClient
	end
	select	top 1 @preferredClientReleaseId = releaseId
	from 	#tmpLicUsage
	where	CId = @preferredDestClientId
	ORDER BY releaseId DESC
end
else if @jobType = @AUXCOPY2
begin
	if @i_destinationClient > 0
	and exists (select * from app_client with (nolock) where id = @i_destinationClient)
		set @preferredDestClientId = @i_destinationClient
	else
	begin
		declare @destReservedCopyId int
		set @destReservedCopyId = @i_destCopyId
		-- In the case of GACP, the reservation happens on GACP copy id and stream
if exists (select Id from ArchGroupCopy with (readuncommitted) where Id = @i_destCopyId and ExtendedFlags & 2 > 0 and destMediaCopyId > 0)
		begin
			select @destReservedCopyId = destMediaCopyId from ArchGroupCopy with (readuncommitted) where Id = @i_destCopyId
		end
		if exists (
					select * from
						(select * from ArchStream with (nolock) where ArchGroupCopyId = @i_destCopyId and isActive = 1) stream left join
						(select * from MMResource with (nolock) where copyId = @destReservedCopyId and streamId > 0 and HasJobInterrupted = 0) res
						on stream.stream = res.StreamId
					where res.StreamId is NULL
				)
		begin
			-- If there is still active stream avaliable, then pick preferred destination media agent based on load-balance
			select top 1 @preferredDestClientId = isnull(tmp.ClientId, 0)
			from	#tmpdrivepool tmp
			-- LAN-free and Less used Media Agent first
			order by (case when @preferCopyDataPaths = 1 and  exists (select DrivePoolId from #tmpcopydrivepools where DrivePoolId = tmp.drivepoolid)
						then 0 else 1 end),
					(case when exists(select 1 from #destClientIds where (@dataPathType = @CVDP_NAS and destclientId = tmp.nasClientId) or (@dataPathType != @CVDP_NAS and 	destclientId = tmp.clientId)) then 0 else 1 end),
					(case when @preferMAPreferredToMP = 1 then tmp.isPreferredMAForMP else 0 end) desc,
					(select count(StreamReaderId) from ArchJobStreamStatus WITH (NOLOCK) where SrcMAId = tmp.ClientId and JobId = @i_jobId),
				tmp.isPreferredMAForMP desc
		end
		else
		begin
			-- All the streams are reserved. Check the media agents currently in use only as preferred one.
			select top 1 @preferredDestClientId = isnull(tmp.ClientId, 0)
			from	#tmpdrivepool tmp
			where	tmp.ClientId in (select ClientId from MMResource with (nolock) where copyId = @destReservedCopyId and streamId > 0 and HasJobInterrupted = 0)
			-- LAN-free and Less used Media Agent first
			order by (case when @preferCopyDataPaths = 1 and  exists (select DrivePoolId from #tmpcopydrivepools where DrivePoolId = tmp.drivepoolid)
						then 0 else 1 end),
					(case when exists(select 1 from #destClientIds where (@dataPathType = @CVDP_NAS and destclientId = tmp.nasClientId) or (@dataPathType != @CVDP_NAS and destclientId = tmp.clientId)) then 0 else 1 end),
(case when @preferMAPreferredToMP = 1 then tmp.isPreferredMAForMP else 0 end) desc,
					(select count(StreamReaderId) from ArchJobStreamStatus WITH (NOLOCK) where SrcMAId = tmp.ClientId and JobId = @i_jobId),
				tmp.isPreferredMAForMP desc
		end
	end
	select	top 1 @preferredClientReleaseId = releaseId
	from 	#tmpLicUsage
	where	CId = @preferredDestClientId
	ORDER BY releaseId DESC
end
-- If the job is DataVerification, Offline CI, Media Refresh, and DDB Reconstruction, pick the less used Media Agent first to allow load-balance
else if (@jobType = @ARCHIVECHECK AND @jobPhase IN (@dedupeValidate, @orphanListing, @defragment) ) /*DEDUPVALIDATE, ORPHANLISTING, DEFRAGMENT*/
begin
	if @i_destinationClient > 0
	and exists (select * from app_client with (nolock) where id = @i_destinationClient)
		set @preferredDestClientId = @i_destinationClient
	else
	begin
		declare @maxMediaAgentsTobeSelected integer = 0
declare @maxMediaAgentsTobeUsed integer = 5
		select	@maxMediaAgentsTobeUsed = value
		from	MMConfigs
		where	name = 'MMCONFIG_MA_COUNT_DURING_VALIDATE_DDB'
		declare @allowedMediaAgents table (clientId integer)
		insert INTO @allowedMediaAgents
		select	distinct tmp.ClientID
		from	#tmpdrivepool tmp,
			(select	distinct R.ClientId from JMJobResourceHistory R with (nolock)  where R.JobId = @i_jobId
			union
			select	distinct R.ClientId from MMResource R with (nolock), MMResourceToJob J with (nolock)  where J.JobId_l = @i_jobId AND R.ReservationId = J.ReservationId) T
		where	tmp.clientID = T.ClientId
		SET @maxMediaAgentsTobeSelected = @maxMediaAgentsTobeUsed - (select count(*) FROM @allowedMediaAgents)
		--If the number mediaagent used is less then maxallowed then select different MA
		if (@maxMediaAgentsTobeSelected > 0)
		begin
			select top 1 @preferredDestClientId = isnull(tmp.ClientId, 0)
			from	#tmpdrivepool tmp LEFT OUTER JOIN @allowedMediaAgents A ON tmp.clientId = A.ClientId
			WHERE	a.ClientId IS NULL
			-- Less used Media Agent first
			order by (case when exists(select 1 from #destClientIds where (@dataPathType = @CVDP_NAS and destclientId = tmp.nasClientId) or (@dataPathType != @CVDP_NAS and destclientId = tmp.clientId)) then 0 else 1 end),
					(case when @preferMAPreferredToMP = 1 then tmp.isPreferredMAForMP else 0 end) desc,
					(select count(ReservationId) from MMResource WITH (nolock) where ClientId = tmp.ClientId) + dbo.MMS2FUNC_GetReadStreamCountForMA(tmp.ClientId, 1 /*notReserved*/),
					tmp.isPreferredMAForMP desc
		end
		--If the number mediaagent used is greater or equal then maxallowed then select used MA
		if (@preferredDestClientId = 0)
		begin
			select top 1 @preferredDestClientId = isnull(tmp.ClientId, 0)
			from	#tmpdrivepool tmp INNER JOIN @allowedMediaAgents A ON tmp.clientId = A.ClientId
			-- Less used Media Agent first
			order by (case when exists(select 1 from #destClientIds where (@dataPathType = @CVDP_NAS and destclientId = tmp.nasClientId) or (@dataPathType != @CVDP_NAS and destclientId = tmp.clientId)) then 0 else 1 end),
					(case when @preferMAPreferredToMP = 1 then tmp.isPreferredMAForMP else 0 end) desc,
					(select count(ReservationId) from MMResource WITH (nolock) where ClientId = tmp.ClientId) + dbo.MMS2FUNC_GetReadStreamCountForMA(tmp.ClientId, 1 /*notReserved*/),
					tmp.isPreferredMAForMP desc
		end
		--if nothing is selected pick any MA
		if (@preferredDestClientId = 0)
		begin
			select top 1 @preferredDestClientId = isnull(tmp.ClientId, 0)
			from	#tmpdrivepool tmp
			-- Less used Media Agent first
			order by (case when exists(select 1 from #destClientIds where (@dataPathType = @CVDP_NAS and destclientId = tmp.nasClientId) or (@dataPathType != @CVDP_NAS and destclientId = tmp.clientId)) then 0 else 1 end),
					(case when @preferMAPreferredToMP = 1 then tmp.isPreferredMAForMP else 0 end) desc,
					(select count(ReservationId) from MMResource WITH (nolock) where ClientId = tmp.ClientId) + dbo.MMS2FUNC_GetReadStreamCountForMA(tmp.ClientId, 1 /*notReserved*/),
					tmp.isPreferredMAForMP desc
		end
	end
end
else if (@jobType = @ARCHIVECHECK and @jobSubOpType = @ARCHIVECHECK2)
		or (@jobType = @DEDUPDBSYNC and @jobSubOpType = @DEDUPDBSYNC2)
begin
	if @i_destinationClient > 0
	and exists (select * from app_client with (nolock) where id = @i_destinationClient)
		set @preferredDestClientId = @i_destinationClient
	else
	begin
		select top 1 @preferredDestClientId = isnull(tmp.ClientId, 0)
		from	#tmpdrivepool tmp
		-- LAN-free and Less used Media Agent first
		order by (case when @preferCopyDataPaths = 1 and  exists (select DrivePoolId from #tmpcopydrivepools where DrivePoolId = tmp.drivepoolid)
						then 0 else 1 end),
				(case when exists(select 1 from #destClientIds where (@dataPathType = @CVDP_NAS and destclientId = tmp.nasClientId) or (@dataPathType != @CVDP_NAS and destclientId = tmp.clientId)) then 0 else 1 end),
				(case when @preferMAPreferredToMP = 1 then tmp.isPreferredMAForMP else 0 end) desc,
				(select count(StreamReaderId) from ArchJobStreamStatus WITH (NOLOCK) where SrcMAId = tmp.ClientId and JobId = @i_jobId),
				tmp.isPreferredMAForMP desc
	end
	select	top 1 @preferredClientReleaseId = releaseId
	from 	#tmpLicUsage
	where	CId = @preferredDestClientId
	ORDER BY releaseId DESC
end
else if (@jobType in (@ARCHIVECHECK, @OFFLINECI, @MEDIAREFRESH, @DEDUPDBSYNC))
begin
	if @i_destinationClient > 0
	and exists (select * from app_client with (nolock) where id = @i_destinationClient)
		set @preferredDestClientId = @i_destinationClient
	else
	begin
		select top 1 @preferredDestClientId = isnull(tmp.ClientId, 0)
		from	#tmpdrivepool tmp
		-- Less used Media Agent first
		order by (case when @preferCopyDataPaths = 1 and  exists (select DrivePoolId from #tmpcopydrivepools where DrivePoolId = tmp.drivepoolid)
						then 0 else 1 end),
				(case when exists(select 1 from #destClientIds where (@dataPathType = @CVDP_NAS and destclientId = tmp.nasClientId) or (@dataPathType != @CVDP_NAS and destclientId = tmp.clientId)) then 0 else 1 end),
				(case when @preferMAPreferredToMP = 1 then tmp.isPreferredMAForMP else 0 end) desc,
				(select count(ReservationId) from MMResource WITH (NOLOCK) where ClientId = tmp.ClientId) + dbo.MMS2FUNC_GetReadStreamCountForMA(tmp.ClientId, 1 /*notReserved*/),
				tmp.isPreferredMAForMP desc
	end
end
else if @jobType in (@RESTORE, @INDEXRESTORE) and @i_destinationClient > 0 and @reservedDrivepoolId = 0
and exists (select * from MMConfigs where name = 'MMCONFIG_CHECK_LAST_SEEN_INDEX_MEDIAAGENT' and value > 0) and @i_archFileId > 0
begin
	--get the MA name from JM options table here and see if that MA is online. If so return that MA. We have to find only snap index cache MA here.
	DECLARE @MaName     NVARCHAR(512) = ''
	DECLARE @MAId	    INT = 0
	DECLARE @jobId	    INT = 0
	DECLARE @commCellId INT = 0
	DECLARE @fileType   INT = 0
    DECLARE @appId      INT = 0
	--SELECT TOP 1 @jobId = jobId, @commCellId = commCellId, @fileType = fileType FROM archFile WITH (NOLOCK) WHERE id = @i_archFileId AND commCellId = @origCCcommCellID
	SELECT TOP 1 @appId = appId, @fileType = fileType FROM archFile WITH (NOLOCK) WHERE id = @i_archFileId AND commCellId = @i_commCellId
	SELECT TOP 1 @jobId = jobId, @commCellId = commCellId FROM JMBkpStats WITH (NOLOCK) WHERE appId = @appId AND status = 1 ORDER BY servEndDate DESC
IF @fileType = 2
SET @MaName = ISNULL((SELECT attributeValue FROM JMJobOptions WITH (NOLOCK) WHERE jobId=@jobId AND commCellId=@commCellId AND attributeId=28), '')
ELSE IF @fileType = 6
SET @MaName = ISNULL((SELECT attributeValue FROM JMJobOptions WHERE jobId=@jobId AND commCellId=@commCellId AND attributeId=27), '')
	IF @MaName <> ''
	BEGIN
		SET @MAId = ISNULL((SELECT id FROM APP_Client WITH (NOLOCK) WHERE name = @MaName), 0)
		IF @MAId <> 0
		BEGIN
		    SELECT TOP 1 @preferredDestClientId = isnull(tmp.ClientId, 0)
		    FROM    #tmpdrivepool tmp, MMHost Host with (nolock)
		    WHERE   tmp.ClientId = Host.ClientId
		    AND     Host.MmHostSoftState = 1
		    AND     Host.MmHostEnabled = 1
		    AND tmp.ClientId = @MAId
		END
	END
end
else if @jobType in (@RESTORE, @INDEXRESTORE) and @i_destinationClient > 0 and @reservedDrivepoolId = 0
and exists (select * from MMConfigs where name = 'MMCONFIG_RESOURCEMANAGER_ALLOW_RESTORE_CONSIDER_GEOMETRY_LOCATION' and value > 0)
begin
	-- Pick the media agent that has priority on the mount path even though current preferred media agent has closer geo location
	if exists (select 1 from #tmpdrivepool where isPreferredMAForMP = 1)
	begin
		select	top 1 @preferredDestClientId = a.ClientId
		FROM	#tmpdrivepool a
		WHERE	isPreferredMAForMP = 1
	end
	-- select preferred media agent based on geometry information
	else
	begin
		IF OBJECT_ID('tempdb..#prefDestClient') IS NOT NULL
		DROP TABLE #prefDestClient
		create table #prefDestClient (prefDestClientId int)
		DECLARE @SQLStr VARCHAR(2048)
		SET @SQLStr = '
		DECLARE @clientGeoInfo	geography
		DECLARE @clientGeoXML	XML
		SELECT @clientGeoXML = ISNULL(AttrVal, '''') FROM App_ClientProp WITH (NOLOCK) WHERE componentNameId = '+ CONVERT(VARCHAR(16), @i_destinationClient) + ' AND AttrName = ''Client Geo Location'' AND Modified = 0 ' + '
		SET @clientGeoInfo = geography::Point(ISNULL(@clientGeoXML.value(''/App_GeoLocation[1]/@latitude'', ''float''), 0),
											ISNULL(@clientGeoXML.value(''/App_GeoLocation[1]/@longitude'', ''float''), 0),
											4326)
		INSERT INTO #prefDestClient
		SELECT TOP 1 isnull(tmp.ClientId, 0)
		FROM	#tmpdrivepool tmp, App_ClientProp client with (nolock)
		WHERE	tmp.ClientId = client.componentNameId
		AND		client.AttrName = ''Client Geo Location''
		AND		client.Modified = 0
		ORDER BY	@clientGeoInfo.STDistance(geography::Point(ISNULL(CAST(client.AttrVal AS XML).value(''/App_GeoLocation[1]/@latitude'', ''float''), 0),
																ISNULL(CAST(client.AttrVal as XML).value(''/App_GeoLocation[1]/@longitude'', ''float''), 0),
																4326)
											),
			(select count(ReservationId) from MMResource WITH (NOLOCK) where ClientId = tmp.ClientId) + dbo.MMS2FUNC_GetReadStreamCountForMA(tmp.ClientId, 1 /*notReserved*/)
		'
		EXEC (@SQLStr)
		SELECT @preferredDestClientId = prefDestClientId FROM #prefDestClient
	end
end
else
begin
	-- Drivepool list contains non lan-free MAs also when lan-free is available, earlier we used to remove non lan-free and keeps only lan-free MAs.
	-- For restores if we don't hit any of the above conditions then preferredDestClientId wont be set and we may end up picking non lan-free MA.
	select top 1 @preferredDestClientId = dc.destClientId
	from #destClientIds dc, #tmpdrivepool tmp
	where (@dataPathType = @CVDP_NAS and dc.destclientId = tmp.nasClientId) or
		(@dataPathType != @CVDP_NAS and dc.destclientId = tmp.clientId)
	-- Less used Media Agent first
	order by (case when @preferCopyDataPaths = 1 and  exists (select DrivePoolId from #tmpcopydrivepools where DrivePoolId = tmp.drivepoolid)
						then 0 else 1 end),
			(case when @preferMAPreferredToMP = 1 then tmp.isPreferredMAForMP else 0 end) desc,
			(select count(ReservationId) from MMResource WITH (NOLOCK) where ClientId = tmp.ClientId),
			 tmp.isPreferredMAForMP desc
end
--
-- Check if client to MA pairing exists
--
if @jobType in (@RESTORE, @INDEXRESTORE) and exists(select 1 from #destClientIds) and @reservedDrivepoolId = 0
and exists (select 1 from MMConfigs where name = 'RM_CONFIG_PREFER_MA_FROM_PREFERRED_MEDIA_AGENT_GROUP' and value > 0)
begin
    -- select preferred media agent based on client advance setting PreferredMediaAgentGroup.
	DECLARE @preferredMediaAgentGroup nvarchar(max)
SET @preferredMediaAgentGroup = dbo.AppGetAdditionalSettingForClient((select top 1 destClientId from #destClientIds), 'PreferredMediaAgentGroup', 'CommServDb.ResourceManager')
	IF ISNULL(@preferredMediaAgentGroup, '') <> ''
	BEGIN
		INSERT INTO @tblPreferedMAGroup
		SELECT  ClientId
		FROM    #tmpdrivepool
WHERE   @preferredMediaAgentGroup = dbo.AppGetAdditionalSettingForClient((case when NasClientId > 0 then NasClientId else ClientId end), 'PreferredMediaAgentGroup', 'CommServDb.ResourceManager')
	END
end
/*
	Available drive pool list includes
	1. If there is reservation exists on the given volume, drive pool that reserves current volume
	2. If there is preferred drive pool in job option selection, the drive pool associated with the selecting media agent, drive pool or drive.
	3. If the media is in drive, the drive pool associated with current master pool that the drive belongs to
	4. If the media is in slot, the drive pool associated withe current library that the media belongs to
	5. If the media is in shelf, the drive pools that can access the volume
	6. If there is destination client specified, the drive pools can be accessed by the destination client (media agent). That is a additional check for above conditions.
	Selection Order
	1. If there is reservation on the volume, drive pool id is from current reservation (there is only reserving drive pool left in the list anyway)
	2. If the media in drive or slot, pick the current library first
	3. If the drive pool exists in the perferred drive pool list, pick that drive pool first
	4. If media is in drive, there must be a drive controller available between the drive and drive pool, ignore this drivePool if passing in MA doesn't have access to it
	5. There is available drive in the drive pool first
	6.Prefer copy datapaths when config param is set
	7. If job is auxcopy and the media agent also use by destination copy data paths
		-- if the destination copy data path set to use Round-Robin, pick the less used media agent first
		-- Otherwise, pick the default client from destination copy.
		-- If the job is not auxcopy, pick the one with less reservations first
		-- Make sure the selected MA has the same release as the preferred media agent for destination copy
		-- When using NAS data path, the chekc for desitnation MA shoud be done based on NAS clientId. Also, in one special case  of shared NAS client, chck passing in MA again
	8.Pick the one from PreferredMediaAgentGroup defined on client.
	9. Pick the MA which is preferred for the mountpath.
	10. If there is drive pool id specified, pick it first
		-- if there is lan-free media agent, the drive pool id is the one used by the current media group
		-- if there is no lan-free media agent, drive pool id is the default data path from backup copy if available
	11.Prefer copy default datapath when prefer copy datapaths config param is set
	12 Pick the one exists in copy's data path list first
	13. If the media is in shelf, pick the last write library first
	14. Pick the one with least reserved drives first for tape libraries
	15. Pick the MA with least streams running
*/
select	top 1 @i_drivepoolId = DrivePoolId
from	#tmpdrivepool
order by
		case when drivepoolId = @reservedDrivepoolId
			then 0 else 1 end,
		case when ( @mediaLocation in (@LOCATION_SLOT, @LOCATION_DRIVE) AND LibraryId = @libraryId)
			then 0 else 1 end,
		case when (exists (select * from @tblPreferedDrivePool where DrivePoolId = #tmpdrivepool.drivepoolId))
			then 0 else 1 end,
		case when exists (select d.driveid from mmdrive d with (nolock), mmdrivecontroller dc with (nolock)
			where d.Mediaid = @mediaId and d.driveid = dc.DriveId and #tmpdrivepool.drivepoolid = dc.DrivePoolId
					and (@i_destinationClient = 0 or @i_destinationClient = dc.ClientId))
			then 0 else 1 end,
		case when (@isStandAloneLibrary = 1 AND @mediaLocation in (@LOCATION_SHELF, @LOCATION_SWITCHED) AND LibraryId = @lastWriteLibraryId)
			then 0 else 1 end,
		sign(orderby) desc,
		case when (@preferCopyDataPaths = 1 and  exists (select DrivePoolId from #tmpcopydrivepools where DrivePoolId = #tmpdrivepool.drivepoolid))
			then 0 else 1 end,
		case when ((@preferredDestClientId > 0 and @dataPathType != @CVDP_NAS and @preferredDestClientId = clientId)
					or
					(@preferredDestClientId > 0 and @dataPathType = @CVDP_NAS and @preferredDestClientId = nasClientId))
			then 0 else 1 end,
		case when (@dataPathType = @CVDP_NAS and @i_destinationClient > 0 and @i_destinationClient = clientid)
			then 0 else 1 end,
		case when (@preferredClientReleaseId > 0 and exists (select CId from #tmpLicUsage where CId = #tmpdrivepool.clientId and releaseId = @preferredClientReleaseId))
			then 0 else 1 end,
		case when (exists (select 1 from @tblPreferedMAGroup where clientId = #tmpdrivepool.clientId))
			then 0 else 1 end,
		(case when @honorLoadBalance = 1 then 0 else isPreferredMAForMP end) desc,
		case when (@drivepoolid > 0 and @i_drivepoolid = 0 and drivepoolid = @drivepoolid)
			then 0 else 1 end,
		case when exists (select DrivePoolId from #tmpcopydrivepools where DrivePoolId = #tmpdrivepool.drivepoolid)
			then 0 else 1 end,
		case when (@mediaLocation in (@LOCATION_SHELF, @LOCATION_SWITCHED) AND LibraryId = @lastWriteLibraryId)
			then 0 else 1 end,
(select count(DriveId) from MMResource WITH (NOLOCK) where DrivePoolId = #tmpdrivepool.DrivePoolId and #tmpdrivepool.DrivePoolType <> 10001), --desc
		(select count(ReservationId) from MMResource WITH (NOLOCK) where ClientId = #tmpdrivepool.ClientId) + dbo.MMS2FUNC_GetReadStreamCountForMA(#tmpdrivepool.ClientId, 1 /*notReserved*/)
set @i_retcode = 0
ERROR_EXIT:
IF @i_LibraryId = 0 AND @mediaId > 0
BEGIN
	SELECT TOP 1 @i_LibraryId = l.LibraryId, @s_LibraryName = l.LibraryName, @s_LibraryAliasName = l.AliasName
	FROM MMLibrary l WITH (NOLOCK), MMMedia m WITH (NOLOCK)
	WHERE	m.MediaId = @mediaId
	AND		(
			 m.LibraryId > 0 AND m.LibraryId = l.LibraryId
			 OR
			 m.LibraryId = 0 AND m.LastWriteLibraryId > 0 AND m.LastWriteLibraryId = l.LibraryId
			)
END
drop table #destClientIds
drop table #tmpcopydrivepools
drop table #tmpLicUsage
/* This call is to record the power VM usage. */
IF EXISTS(	SELECT 1 FROM MMHost H WITH (NOLOCK) INNER JOIN MMDrivePool DP WITH (NOLOCK) ON H.clientId = DP.clientId
			  WHERE DP.drivepoolId = @i_drivepoolId
AND H.Attribute & 32768 = 32768
			  AND H.MmHostSoftState = 1 )
BEGIN
	INSERT INTO #tmpVMPowerOnReq
	SELECT 0, H.ClientId, @i_jobId, 2
	FROM MMHost H INNER JOIN MMDrivePool DP ON H.clientId = DP.clientId
	WHERE DP.drivepoolId = @i_drivepoolId
AND H.Attribute & 32768 = 32768
	AND H.MmHostSoftState = 1
	EXEC RMSubmitVMPowerONRequest 0
	DELETE FROM #tmpVMPowerOnReq
END
if object_id('tempdb.dbo.#tmpVMPowerOnReq') is not null
DROP TABLE #tmpVMPowerOnReq
if not exists (select * from #tmpdrivepool)
begin
	IF object_id('tempdb.dbo.#tmpMA_DP') IS NOT NULL
	BEGIN
		INSERT INTO #tmpMA_DP
		select	@i_retcode, CASE WHEN @i_ClientId > 0 THEN @s_mediaAgentName ELSE '' END, @i_ClientId, 0, 0, '', 0, 0, 0,
			@i_LibraryId, 0, 0, CASE WHEN @i_LibraryId > 0 THEN @s_LibraryName ELSE '' END, CASE WHEN @i_LibraryId > 0 THEN @s_LibraryAliasName ELSE '' END,
			CASE WHEN @mountPathId = 0 THEN @s_barCode ELSE (SELECT TOP 1 MountPathName FROM MMS2getMountPathList with (NOLOCK) WHERE MountPathId = @mountPathId ORDER BY case when @i_ClientId = ClientId then 0 else 1 end) END,
			@i_volumeId, 0, 0, @i_failureType
	END
	ELSE
	BEGIN
		select	@i_retcode, CASE WHEN @i_ClientId > 0 THEN @s_mediaAgentName ELSE '' END, @i_ClientId, 0, 0, '', 0, 0, 0,
			@i_LibraryId, 0, 0, CASE WHEN @i_LibraryId > 0 THEN @s_LibraryName ELSE '' END, CASE WHEN @i_LibraryId > 0 THEN @s_LibraryAliasName ELSE '' END,
			CASE WHEN @mountPathId = 0 THEN @s_barCode ELSE (SELECT TOP 1 MountPathName FROM MMS2getMountPathList with (NOLOCK) WHERE MountPathId = @mountPathId ORDER BY case when @i_ClientId = ClientId then 0 else 1 end) END,
			@i_volumeId, 0, 0, @i_failureType
	END
end
else
begin
	IF object_id('tempdb.dbo.#tmpMA_DP') IS NOT NULL
	BEGIN
		INSERT INTO #tmpMA_DP
		select	@i_retcode, NetHostName, ClientId, NasClientId, ClientReleaseId, NasFilerName, ClientId, DrivePoolId, DrivePoolType,
			LibraryId, LibraryTypeId, LibraryAttribute, LibraryName, LibraryAliasName,
			@s_barCode,
			@i_volumeId, @mediaLocation, @jobType, @i_failureType
		from	#tmpdrivepool
		where	DrivePoolId = @i_drivepoolId
	END
	ELSE
	BEGIN
		select	@i_retcode, NetHostName, ClientId, NasClientId, ClientReleaseId, NasFilerName, ClientId, DrivePoolId, DrivePoolType,
			LibraryId, LibraryTypeId, LibraryAttribute, LibraryName, LibraryAliasName,
			@s_barCode,
			@i_volumeId, @mediaLocation, @jobType, @i_failureType
		from	#tmpdrivepool
		where	DrivePoolId = @i_drivepoolId
	END
end
drop table #tmpdrivepool
return @i_retcode
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2GetMAAndDPForVolume')
	delete from GxQscripts where name = 'MMS2GetMAAndDPForVolume'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetMAAndDPForVolume')
	delete from GXDBVersions where aliasname = 'MMS2GetMAAndDPForVolume'
GO

insert into GXDBVersions values(2, 'MMS2GetMAAndDPForVolume',  'v1.153.2.52.16.1', 'MMS2GetMAAndDPForVolume', 'v1.153.2.52.16.1')
GO

