

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GetListOfAliveDeviceControllerByDeviceId.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2017  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2GetListOfAliveDeviceControllerByDeviceId.sp,v $ $Id: MMS2GetListOfAliveDeviceControllerByDeviceId.sp,v 1.1.2.2 2020/12/29 18:57:49 pveeravalli Exp $";
--
--  +========================================================================+
--  |   Procedure:  MMS2GetListOfAliveDeviceControllerByDeviceId
--  |
--  | Description:  Retrieves the device controller's info based on the information passed
--  |
--  |       Input:  Entity Id, Entity Type, Credential Id, Flag to indicate an updation is requires
--  |
--  |      Output:  Credential assoc ID if a valid credential ID was passed
--  |
--  |      Notes:	None at this time
--  |
--  |   Revisions  Author			Description
--  |   ---------  -------			---------------------------------------------
--  |   1.1        aselvanayagam 	Stored procedure to get device controllers info
--	|								that are alive by performing an extra lookup
--	|								to get the right credentials
--  +========================================================================+
--
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MMS2GetListOfAliveDeviceControllerByDeviceId')
BEGIN
	print '>>> Drop Stored Procedure: MMS2GetListOfAliveDeviceControllerByDeviceId <<<'
	drop procedure MMS2GetListOfAliveDeviceControllerByDeviceId
END
IF EXISTS (select * from GxQscripts where name='MMS2GetListOfAliveDeviceControllerByDeviceId')
	delete from GxQscripts where name = 'MMS2GetListOfAliveDeviceControllerByDeviceId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetListOfAliveDeviceControllerByDeviceId')
	delete from GXDBVersions where aliasname = 'MMS2GetListOfAliveDeviceControllerByDeviceId'
GO
print '... Creating Procedure: MMS2GetListOfAliveDeviceControllerByDeviceId'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MMS2GetListOfAliveDeviceControllerByDeviceId
  @i_deviceId integer
AS
  DECLARE @o_deviceControllerId integer
  DECLARE @o_clientId integer
  DECLARE @o_deviceId integer
  DECLARE @o_deviceControllerActive integer
  DECLARE @o_deviceControllerEnabled integer
  DECLARE @o_SNRVolumeId integer
  DECLARE @o_useCount integer
  DECLARE @o_userName varchar(1024)
  DECLARE @o_userPassword varchar(2048)
  DECLARE @o_folder varchar(1024)
  DECLARE @o_deviceMounted integer
  DECLARE @o_deviceAccessible integer
  DECLARE @o_volumeRecoveryStatus integer
  DECLARE @o_volumeRecoveryTime integer
  DECLARE @o_volumeScsiReserved integer
  DECLARE @o_DeviceAccessType integer
  DECLARE @o_RMStatus integer
  DECLARE @o_RMStatusUpdateTime integer
  DECLARE @o_credentialAssocId integer
SET NOCOUNT ON
IF OBJECT_ID('tempdb.dbo.#deviceControllerTable') IS NOT NULL
    DROP TABLE #deviceControllerTable
CREATE TABLE #deviceControllerTable
(
    deviceControllerId INT,
    clientId INT,
    deviceId INT,
    deviceControllerActive INT,
    deviceControllerEnabled INT,
    SNRVolumeId INT,
    useCount INT,
userName VARCHAR(1024),
userPassword VARCHAR(2048),
folder VARCHAR(1024),
	deviceMounted INT,
	deviceAccessible INT,
	volumeRecoveryStatus INT,
	volumeRecoveryTime INT,
	volumeScsiReserved INT,
	DeviceAccessType INT,
	RMStatus INT,
	RMStatusUpdateTime INT,
	credentialAssocId INT
)
BEGIN
	INSERT INTO #deviceControllerTable ( deviceControllerId, clientId, deviceId, deviceControllerActive, deviceControllerEnabled, SNRVolumeId, useCount, userName, userPassword, folder, deviceMounted, deviceAccessible, volumeRecoveryStatus,	volumeRecoveryTime,	volumeScsiReserved,	DeviceAccessType, RMStatus,	RMStatusUpdateTime,	credentialAssocId)
        SELECT
           DC.DeviceControllerId,
		   DC.ClientId,
		   DC.DeviceId,
		   DC.DeviceControllerActive,
		   DC.DeviceControllerEnabled,
		   DC.SNRVolumeId,
		   DC.UseCount,
		   DC.UserName,
		   DC.UserPassword,
		   DC.Folder,
		   DC.DeviceMounted,
		   DC.DeviceAccessible,
		   DC.VolumeRecoveryStatus,
		   DC.VolumeRecoveryTime,
		   DC.VolumeScsiReserved,
		   DC.DeviceAccessType,
		   DC.RMStatus,
		   DC.RMStatusUpdateTime,
		   DC.CredentialAssocId
	FROM   MMDeviceController DC WITH(READUNCOMMITTED)
		INNER JOIN MMHost H WITH(READUNCOMMITTED) ON DC.ClientId = H.ClientId
		WHERE DC.DeviceId = @i_deviceId
			AND DC.DeviceControllerEnabled = 1
			AND DC.DeviceAccessible = 1
			AND H.MmHostSoftState = 1 and H.MmHostEnabled = 1
	BEGIN
		EXEC MMS2GetDeviceControllerCredentials
	END
		SELECT deviceControllerId,
			clientId,
			deviceId,
			deviceControllerActive,
			deviceControllerEnabled,
			SNRVolumeId,
			useCount,
			userName,
			userPassword,
			folder,
			deviceMounted,
			deviceAccessible,
			volumeRecoveryStatus,
			volumeRecoveryTime,
			volumeScsiReserved,
			DeviceAccessType,
			RMStatus,
			RMStatusUpdateTime,
			credentialAssocId
		FROM #deviceControllerTable
	IF OBJECT_ID('tempdb.dbo.#deviceControllerTable') IS NOT NULL
		DROP TABLE #deviceControllerTable
END
SET NOCOUNT OFF;
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2GetListOfAliveDeviceControllerByDeviceId')
	delete from GxQscripts where name = 'MMS2GetListOfAliveDeviceControllerByDeviceId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetListOfAliveDeviceControllerByDeviceId')
	delete from GXDBVersions where aliasname = 'MMS2GetListOfAliveDeviceControllerByDeviceId'
GO

insert into GXDBVersions values(2, 'MMS2GetListOfAliveDeviceControllerByDeviceId',  '00010001000200020000', 'MMS2GetListOfAliveDeviceControllerByDeviceId', '00010001000200020000')
GO

