

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GetListOfAccessibleDeviceControllersByDeviceId.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2017  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2GetListOfAccessibleDeviceControllersByDeviceId.sp,v $ $Id: MMS2GetListOfAccessibleDeviceControllersByDeviceId.sp,v 1.1.2.2 2020/12/29 18:58:04 pveeravalli Exp $";
--
--  +========================================================================+
--  |   Procedure:  MMS2GetListOfAccessibleDeviceControllersByDeviceId
--  |
--  | Description:  Retrieves the device controller's info based on the information passed
--  |
--  |       Input:  Device Id
--  |
--  |      Output:  MMDeviceController table struct
--  |
--  |      Notes:	None at this time
--  |
--  |   Revisions  Author			Description
--  |   ---------  -------			---------------------------------------------
--  |   1.1        aselvanayagam 	Stored procedure to get accessible device controllers
--	|								for a given device ID by performing
--	|								an extra lookup to get the right credentials
--  +========================================================================+
--
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MMS2GetListOfAccessibleDeviceControllersByDeviceId')
BEGIN
	print '>>> Drop Stored Procedure: MMS2GetListOfAccessibleDeviceControllersByDeviceId <<<'
	drop procedure MMS2GetListOfAccessibleDeviceControllersByDeviceId
END
IF EXISTS (select * from GxQscripts where name='MMS2GetListOfAccessibleDeviceControllersByDeviceId')
	delete from GxQscripts where name = 'MMS2GetListOfAccessibleDeviceControllersByDeviceId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetListOfAccessibleDeviceControllersByDeviceId')
	delete from GXDBVersions where aliasname = 'MMS2GetListOfAccessibleDeviceControllersByDeviceId'
GO
print '... Creating Procedure: MMS2GetListOfAccessibleDeviceControllersByDeviceId'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MMS2GetListOfAccessibleDeviceControllersByDeviceId
  @i_deviceId integer
AS
  DECLARE @o_deviceControllerId integer
  DECLARE @o_clientId integer
  DECLARE @o_deviceId integer
  DECLARE @o_deviceControllerActive integer
  DECLARE @o_deviceControllerEnabled integer
  DECLARE @o_SNRVolumeId integer
  DECLARE @o_useCount integer
  DECLARE @o_userName varchar(1024)
  DECLARE @o_userPassword varchar(2048)
  DECLARE @o_folder varchar(1024)
  DECLARE @o_deviceMounted integer
  DECLARE @o_deviceAccessible integer
  DECLARE @o_volumeRecoveryStatus integer
  DECLARE @o_volumeRecoveryTime integer
  DECLARE @o_volumeScsiReserved integer
  DECLARE @o_DeviceAccessType integer
  DECLARE @o_RMStatus integer
  DECLARE @o_RMStatusUpdateTime integer
  DECLARE @o_credentialAssocId integer
SET NOCOUNT ON
IF OBJECT_ID('tempdb.dbo.#deviceControllerTable') IS NOT NULL
    DROP TABLE #deviceControllerTable
CREATE TABLE #deviceControllerTable
(
    deviceControllerId INT,
    clientId INT,
    deviceId INT,
    deviceControllerActive INT,
    deviceControllerEnabled INT,
    SNRVolumeId INT,
    useCount INT,
userName VARCHAR(1024),
userPassword VARCHAR(2048),
folder VARCHAR(1024),
	deviceMounted INT,
	deviceAccessible INT,
	volumeRecoveryStatus INT,
	volumeRecoveryTime INT,
	volumeScsiReserved INT,
	DeviceAccessType INT,
	RMStatus INT,
	RMStatusUpdateTime INT,
	credentialAssocId INT
)
BEGIN
	INSERT INTO #deviceControllerTable ( deviceControllerId, clientId, deviceId, deviceControllerActive, deviceControllerEnabled, SNRVolumeId, useCount, userName, userPassword, folder, deviceMounted, deviceAccessible, volumeRecoveryStatus,	volumeRecoveryTime,	volumeScsiReserved,	DeviceAccessType, RMStatus,	RMStatusUpdateTime,	credentialAssocId)
        SELECT
           DC.DeviceControllerId,
		   DC.ClientId,
		   DC.DeviceId,
		   DC.DeviceControllerActive,
		   DC.DeviceControllerEnabled,
		   DC.SNRVolumeId,
		   DC.UseCount,
		   DC.UserName,
		   DC.UserPassword,
		   DC.Folder,
		   DC.DeviceMounted,
		   DC.DeviceAccessible,
		   DC.VolumeRecoveryStatus,
		   DC.VolumeRecoveryTime,
		   DC.VolumeScsiReserved,
		   DC.DeviceAccessType,
		   DC.RMStatus,
		   DC.RMStatusUpdateTime,
		   DC.CredentialAssocId
	FROM   MMDeviceController DC WITH(READUNCOMMITTED)
		INNER JOIN MMHost H WITH(READUNCOMMITTED) ON DC.ClientId = H.ClientId
		WHERE DC.DeviceId = @i_deviceId
			AND DC.DeviceAccessible = 1
			AND DC.DeviceControllerEnabled = 1
			AND H.MmHostEnabled = 1
		ORDER BY VolumeScsiReserved DESC, DeviceMounted DESC
	BEGIN
		EXEC MMS2GetDeviceControllerCredentials
	END
		SELECT deviceControllerId,
			clientId,
			deviceId,
			deviceControllerActive,
			deviceControllerEnabled,
			SNRVolumeId,
			useCount,
			userName,
			userPassword,
			folder,
			deviceMounted,
			deviceAccessible,
			volumeRecoveryStatus,
			volumeRecoveryTime,
			volumeScsiReserved,
			DeviceAccessType,
			RMStatus,
			RMStatusUpdateTime,
			credentialAssocId
		FROM #deviceControllerTable
	IF OBJECT_ID('tempdb.dbo.#deviceControllerTable') IS NOT NULL
		DROP TABLE #deviceControllerTable
END
SET NOCOUNT OFF;
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2GetListOfAccessibleDeviceControllersByDeviceId')
	delete from GxQscripts where name = 'MMS2GetListOfAccessibleDeviceControllersByDeviceId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetListOfAccessibleDeviceControllersByDeviceId')
	delete from GXDBVersions where aliasname = 'MMS2GetListOfAccessibleDeviceControllersByDeviceId'
GO

insert into GXDBVersions values(2, 'MMS2GetListOfAccessibleDeviceControllersByDeviceId',  '00010001000200020000', 'MMS2GetListOfAccessibleDeviceControllersByDeviceId', '00010001000200020000')
GO

