

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GetLicenseInUse.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2GetLicenseInUse.sp,v $ $Id: MMS2GetLicenseInUse.sp,v 1.6.86.2 2018/03/20 19:42:10 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 						Cursor: "MMS2GetLicenseInUse"								|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2GetLicenseInUse <<<'

IF EXISTS (select * from sysobjects where name='MMS2GetLicenseInUse')
	drop procedure MMS2GetLicenseInUse
IF EXISTS (select * from GxQscripts where name='MMS2GetLicenseInUse')
	delete from GxQscripts where name = 'MMS2GetLicenseInUse'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetLicenseInUse')
	delete from GXDBVersions where aliasname = 'MMS2GetLicenseInUse'
GO
print '... Creating Procedure: MMS2GetLicenseInUse'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2GetLicenseInUse
-- The following two lines indicate, in order, parameters that will be
--  expected in the "setValues()" method, as well as the order in which
--  they will be provided as arguments to the SQLSTRING command
  @LicenseToken varchar(20),
  @LicenseType integer 
AS
--	The next two lines are the columns, in order, that will be in the
--  result set for this cursor.  EXTREME CAUTION must be exercised to
--  ensure that these match up with the result set in terms of type, size,
--  and order!
  DECLARE @nLicenseInUse integer
-- These lines represent the actual SQL code that will get executed.  Note
-- The "printf" style substitutions.  These should match up exactly with
-- :PARAM input lines
	SET NOCOUNT ON
	declare @licensetocheck varchar(20)
	declare @licenseinuse integer
	declare @ClientId integer
	declare @libraryid integer
	declare @tmpcount integer
	set @licensetocheck = @LicenseToken
	set @licenseinuse = 0
if @licensetocheck = 'Centera' or @LicenseType = 71
	begin
		select @licenseinuse = count(*) from MMLibrary
		where librarylicensetype = @licensetype
		and libraryid > 0
	end
if @licensetocheck = 'VaultTracker' or @LicenseType = 82
	begin
		select @licenseinuse = count(*) from VTPolicy
		where policyid > 0
	end
if @licensetocheck = 'DDO' or @LicenseType = 84
	begin
		DECLARE	gethost CURSOR FOR
		select ClientId from MMHost where ClientId > 1
		OPEN	gethost
		FETCH	NEXT FROM gethost
		INTO	@ClientId
		WHILE	@@FETCH_STATUS = 0
		BEGIN
			if exists (select * from MMMountPath where
					MediaSideId in
					(select MS.MediaSideId from MMMediaSide as MS,
					MMMedia as M, MMLibrary as L,
					MMLibraryController as LC
					where L.LibraryId > 0
					AND MountPathTypeId = 0 AND
					MS.MediaId = M.MediaId AND
					M.MediaTypeId = 10001 AND
					M.LibraryId = L.LibraryId AND
					L.LibraryId = LC.LibraryId AND
					LC.ClientId = @ClientId)
					OR
					(MountPathTypeId IN (4)
					AND MountPathId IN (SELECT MountPathId from MMMountPathToStorageDevice as MPS,
							MMDeviceController as DC where MPS.DeviceId = DC.DeviceId and DC.ClientId = @ClientId)
					)
				)
				set @licenseinuse = @licenseinuse + 1
			FETCH	NEXT FROM gethost
			INTO	@ClientId
		end
		CLOSE		gethost
		DEALLOCATE	gethost
	end
if @licensetocheck = 'Worm' or @LicenseType = 90
	begin
		if exists (select * from MMMedia where mediatypeid in
				(select mediatypeid from MMMediaType where iswormmedia = 1)
			)
			select @licenseinuse = 1
	end
	if @licensetocheck = 'UDO'
	begin
		if exists (select * from MMMedia where mediatypeid in
				(select mediatypeid from MMMediaType where mediatypename like '%UDO%')
			)
			select @licenseinuse = 1
	end
	if @licensetocheck = 'DVD'
	begin
		if exists (select * from MMMedia where mediatypeid in
				(select mediatypeid from MMMediaType where mediatypename like '%DVD%')
			)
			select @licenseinuse = 1
	end
declare @268435456 integer
set @268435456 = 268435456
if @licensetocheck = 'CAS' or @LicenseType = 105
	begin
if exists (select * from MMLibrary where (LibraryAttribute & @268435456) > 0 and libraryid > 0)
			select @licenseinuse = 1
	end
if @licensetocheck = 'GridStor' or @LicenseType = 91
	begin
		if exists (select copyid from MMDataPath
				group by copyid
				having count(*) > 1)
			select @licenseinuse = 1
	end
	if @licensetocheck = 'DynamicMPSharing'
	begin
		DECLARE	gethost2 CURSOR FOR
		select ClientId from MMHost where ClientId > 1
		OPEN	gethost2
		FETCH	NEXT FROM gethost2
		INTO	@ClientId
		WHILE	@@FETCH_STATUS = 0
		BEGIN
			if exists (select * from MMMountPath where
					MountPathTypeId IN (2)
					AND MountPathId IN (SELECT MountPathId from MMMountPathToStorageDevice as MPS,
							MMDeviceController as DC where MPS.DeviceId = DC.DeviceId and DC.ClientId = @ClientId)
				)
				set @licenseinuse = @licenseinuse + 1
			FETCH	NEXT FROM gethost2
			INTO	@ClientId
		end
		CLOSE		gethost2
		DEALLOCATE	gethost2
	end
declare @16777216 integer
set @16777216 = 16777216
	if @licensetocheck = 'SCSI3'
	begin
select @licenseinuse = count(*) from MMLibrary where (LibraryAttribute & @16777216) > 0 and libraryid > 0
	end
declare @2 integer
set @2 = 2
	if @licensetocheck = 'NativeDriver'
	begin
select @licenseinuse = count(*) from MMHost where (Attribute & @2) > 0
	end
	if @licensetocheck = 'StdAlnDrivePooling'
	begin
		select @licenseinuse = count(*) from MMLibrary
		where librarytypeid in (4,5)
		and libraryid in (select libraryid from MMMasterPool where masterpoolid in
					(select masterpoolid from MMDrive
					group by masterpoolid
					having count(*) > 1)
				)
	end
	if @licensetocheck = 'MixedDriveType'
	begin
		DECLARE	getlibrary CURSOR FOR
		select libraryid from MMLibrary where libraryid > 0 and librarytypeid != 3
		OPEN	getlibrary
		FETCH	NEXT FROM getlibrary
		INTO	@libraryid
		WHILE	@@FETCH_STATUS = 0
		BEGIN
			set @tmpcount = (select  count(distinct drivetypeid) from MMDrive where
			masterpoolid IN (SELECT masterpoolid from MMMasterPool where libraryid = @libraryid))
			if @tmpcount > 1
				set @licenseinuse = @licenseinuse + 1
			FETCH	NEXT FROM getlibrary
			INTO	@libraryid
		end
		CLOSE		getlibrary
		DEALLOCATE	getlibrary
	end
	if @licensetocheck = 'USBFirewireIPLibrary'
	begin
		DECLARE	getlibrary CURSOR FOR
		select libraryid from MMLibrary where libraryid > 0 and librarytypeid != 3
		OPEN	getlibrary
		FETCH	NEXT FROM getlibrary
		INTO	@libraryid
		WHILE	@@FETCH_STATUS = 0
		BEGIN
			if exists (select * from MMLibraryController
					where libraryid = @libraryid
					and ConnectionType in (1,2))
				set @licenseinuse = @licenseinuse + 1
			else if exists (Select * from MMDriveController where DrivePoolId In(
							Select DrivePoolId from MMDrivePool where MasterPoolId in(
							Select MasterPoolId from MMMasterPool where LibraryId = @libraryid))
					and (scsiid like '%P:USB%' OR scsiid like '%P:ATAPI%' OR scsiid like '%P:ATA%' OR scsiid like '%P:1394%'))
				set @licenseinuse = @licenseinuse + 1
			FETCH	NEXT FROM getlibrary
			INTO	@libraryid
		end
		CLOSE		getlibrary
		DEALLOCATE	getlibrary
	end
	if @licensetocheck = 'UnbufferredIO'
	begin
	--MNTPTH_ATTRIB_BUFFERED_IO (1<<0) 1
		select @licenseinuse = count(*) from MMMountPath
		where MountPathTypeId != 2
		AND (Attribute & 1) > 0
	end
	if @licensetocheck = 'CloudStorage'
	begin
		select @licenseinuse = count(*) from MMLibrary
		where librarylicensetype = @licensetype
		and libraryid > 0
	end
	select @licenseinuse
	SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2GetLicenseInUse')
	delete from GxQscripts where name = 'MMS2GetLicenseInUse'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetLicenseInUse')
	delete from GXDBVersions where aliasname = 'MMS2GetLicenseInUse'
GO

insert into GXDBVersions values(2, 'MMS2GetLicenseInUse',  '00010006008600020000', 'MMS2GetLicenseInUse', '00010006008600020000')
GO

