

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GetLibListByDPAndMA.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2GetLibListByDPAndMA.sp,v $ $Id: MMS2GetLibListByDPAndMA.sp,v 1.7.88.9 2018/12/18 21:07:06 pveeravalli Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "MMS2GetLibListForHost"				|
--	|									|
--	| Execute the System stored procedure to fetch the physical files	|
--	| .. for the (current) database.					|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMS2GetLibListByDPAndMA')
BEGIN
	print '>>> Drop Stored Procedure: MMS2GetLibListByDPAndMA <<<'
	drop procedure MMS2GetLibListByDPAndMA
END
IF EXISTS (select * from GxQscripts where name='MMS2GetLibListByDPAndMA')
	delete from GxQscripts where name = 'MMS2GetLibListByDPAndMA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetLibListByDPAndMA')
	delete from GXDBVersions where aliasname = 'MMS2GetLibListByDPAndMA'
GO
print '... Creating Procedure: MMS2GetLibListByDPAndMA'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MMS2GetLibListByDPAndMA
  @i_mediaAgentId integer
AS
  DECLARE @o_LibraryId integer
  DECLARE @o_AliasName NVARCHAR(255)
  DECLARE @o_LibraryTypeId integer
  DECLARE @o_libraryVTLType integer
  DECLARE @o_librarySoftState integer
  DECLARE @o_libraryEnabled integer
  DECLARE @o_libraryBroken integer
  DECLARE @o_barcodeReaderPresent integer
  DECLARE @o_libraryVendor char(255)
  DECLARE @o_libraryModel char(255)
  DECLARE @o_libraryAttribute integer
  DECLARE @o_libraryExtendedAttributes integer
  DECLARE @o_isConvertedToSited integer
  DECLARE @o_driveCount integer
  DECLARE @o_isControllingArm integer
  DECLARE @o_emptySlotCount integer
  DECLARE @o_libraryMediaTypeId integer
  DECLARE @o_libHasSiloData integer
  DECLARE @o_associatedMediaAgents NVARCHAR(max)
  DECLARE @o_freeSpaceOnLib bigint
  DECLARE @o_capacity bigint
  DECLARE @o_PrivateData CHAR(256)
  DECLARE @o_associatedMediaAgentsDisplayName NVARCHAR(max)
	IF object_id('tempdb.dbo.#tmpLibList') is not null DROP TABLE #tmpLibList
	IF object_id('tempdb.dbo.#librariesOnMA') is not null DROP TABLE #librariesOnMA
	CREATE TABLE  #librariesOnMA
	(  libraryId integer,
aliasName NVARCHAR(255),
       libraryTypeId integer,
       libraryVTLType integer,
       librarySoftState integer,
       libraryEnabled integer,
       libraryBroken integer,
       barcodeReaderPresent integer,
libraryVendor varchar(255),
libraryModel varchar(255),
       libraryAttribute integer,
       libraryExtendedAttributes integer,
       isConvertedToSited integer,
	   driveCount integer,
	   isControllingArm integer,
	   emptySlotCount integer,
	   libraryMediaTypeId integer,
       libHasSiloData integer,
	   associatedMediaAgents NVARCHAR(max),
	   freeSpaceOnLib bigint,
	   capacity bigint,
	   privateData CHAR(256),
	   associatedMediaAgentsDisplayName NVARCHAR(max)
	)
    CREATE CLUSTERED INDEX librariesOnMA_LibId ON #librariesOnMA (libraryId)
	create table #tmpLibList(	LibraryId		integer,
				NumberOfEmptySlots	integer,
				PRIMARY KEY (LibraryId) )
	DECLARE @showHiddenLibConfig INTEGER = 0
	-------------------------------------------------
    -- Get 'MMCONFIG_SHOW_HIDDEN_LIBRARIES' value from MMConfigs
    -------------------------------------------------
    SELECT @showHiddenLibConfig = value
    FROM    MMConfigs WITH (NOLOCK)
    WHERE NAME = 'MMCONFIG_SHOW_HIDDEN_LIBRARIES'
	insert into #tmpLibList
	select LibraryId, (select count(*)
	from MMSlot as MS WITH (READUNCOMMITTED), MMBay as MB WITH (READUNCOMMITTED)
	where ML.LibraryId = MB.LibraryId
	and MB.BayId = MS.BayId and MS.IsOccupied = 0 and MS.SlotType = 1)
	from MMLibrary as ml WITH (READUNCOMMITTED)
	where LibraryId > 0
and (LibraryTypeId <> 9)
and ( (@showHiddenLibConfig = 1) OR (ML.ExtendedAttributes & 33554432 = 0) )
	INSERT INTO #librariesOnMA
	select ml.libraryid, ml.aliasname, ml.librarytypeid, ml.VTLType, ml.LibrarySoftState, ml.LibraryEnabled,
	ml.LibraryBroken, ml.BarcodeReaderPresent, ml.LibraryVendor, ml.LibraryModel,
	ml.LibraryAttribute, ml.ExtendedAttributes, ml.IsconvertedToSited, ml.driveCount, mc.LibraryControllerActive as isControllingArm,
	tt.NumberOfEmptySlots,
case ml.LibraryTypeId when 3 then 10001	else
(select sp.MediaTypeId from MMSpareGroup as sp WITH (READUNCOMMITTED) where sp.LibraryId = ml.LibraryId and sp.SpareGroupType = 2 )
	end,
	case when exists (select * from MMVolume V WITH (READUNCOMMITTED), MMMedia M WITH (READUNCOMMITTED) WHERE V.MediaId = M.MediaId AND M.LibraryId = ml.LibraryId AND V.SiloStatus > 0) then 1 else 0 end,
	'',-1,-1,ml.PrivateData ,''
	from MMLibrary as ml WITH (READUNCOMMITTED), MMLibraryController as mc WITH (READUNCOMMITTED),  #tmpLibList as tt
where ml.libraryid = mc.libraryid and ml.libraryTypeId <> 8  and
	mc.clientid =  @i_mediaAgentId	and mc.LibraryControllerId > 0
	and ML.LibraryId = tt.LibraryId
	INSERT INTO #librariesOnMA
	select ml.libraryid, ml.aliasname, ml.librarytypeid, ml.VTLType, ml.LibrarySoftState, ml.LibraryEnabled,
	ml.LibraryBroken, ml.BarcodeReaderPresent, ml.LibraryVendor, ml.LibraryModel,
	ml.LibraryAttribute, ml.ExtendedAttributes, ml.IsconvertedToSited, ml.driveCount, isControllingArm = 0,
	tt.NumberOfEmptySlots,
case ml.LibraryTypeId when 3 then 10001	else
(select sp.MediaTypeId from MMSpareGroup as sp WITH (READUNCOMMITTED) where sp.LibraryId = ml.LibraryId and sp.SpareGroupType = 2 )
	end,
	case when exists (select * from MMVolume V WITH (READUNCOMMITTED), MMMedia M WITH (READUNCOMMITTED) WHERE V.MediaId = M.MediaId AND M.LibraryId = ml.LibraryId AND V.SiloStatus > 0) then 1 else 0 end,
	'',-1,-1,ml.PrivateData,''
	from MMDrivePool as mdp WITH (READUNCOMMITTED), MMMasterPool as mp WITH (READUNCOMMITTED),
    MMLibrary as ml WITH (READUNCOMMITTED) INNER JOIN  #tmpLibList as tt ON ML.LibraryId = tt.LibraryId
    LEFT OUTER JOIN #librariesOnMA  as lma ON tt.LibraryId = lma.libraryId
	where mp.MasterPoolId = mdp.MasterPoolId and
ml.LibraryId = mp.LibraryId and ml.libraryTypeId <> 8  and mdp.clientId = @i_mediaAgentId
	AND lma.LibraryId IS NULL
	UPDATE  #librariesOnMA
	SET
	freeSpaceOnLib = A.freespace,
	capacity=A.Lcapacity
	FROM
	(SELECT  L.LibraryId as libId,
freespace = SUM(CASE WHEN mp.MountPathTypeId = 7  AND  S.freebytesmb = 1048576  /*MOUNT_PATH_EXTERNAL_REMOTE_HOST (Cloud)*/
					 THEN -1
					 ELSE S.FreeBytesMB END),
Lcapacity= SUM(CASE WHEN mp.MountPathTypeId = 7  AND S.TotalSpaceMB = 1048576  /*MOUNT_PATH_EXTERNAL_REMOTE_HOST (Cloud)*/
					 THEN -1
					 ELSE S.totalSpaceMB END)
	FROM    MMMedia L WITH (NOLOCK) INNER JOIN #librariesOnMA t ON t.LibraryId = L.LibraryId
INNER JOIN MMMediaSide S  WITH (NOLOCK) ON L.MediaId=S.MediaId AND L.MediaTypeId = 10001
	INNER JOIN MMMountPath mp WITH (NOLOCK) ON mp.MediaSideId = S.MediaSideId
	GROUP BY L.LibraryId) A
	Where A.libId = libraryId
	UPDATE #librariesOnMA
	SET associatedMediaAgents = ISNULL ( (select stuff((select ','+ name from app_client as c WITH (READUNCOMMITTED)  INNER JOIN mmlibrarycontroller AS m WITH (READUNCOMMITTED)  ON c.id = m.ClientId AND m.Libraryid = t.LibraryId
    FOR XML PATH(''), TYPE).value('.', 'varchar(max)'),1,1,' ')),'') ,
	associatedMediaAgentsDisplayName = ISNULL ( (select stuff((select ','+ displayName from app_client WITH (READUNCOMMITTED)  INNER JOIN mmlibrarycontroller AS m WITH (READUNCOMMITTED)  ON id = m.ClientId AND m.Libraryid = t.LibraryId
    FOR XML PATH(''), TYPE).value('.', 'varchar(max)'),1,1,' ')),'') FROM  #librariesOnMA as t
	SELECT libraryId ,  aliasName , libraryTypeId ,libraryVTLType ,librarySoftState , libraryEnabled ,
           libraryBroken , barcodeReaderPresent , libraryVendor , libraryModel , libraryAttribute ,
           libraryExtendedAttributes ,isConvertedToSited , driveCount , isControllingArm ,
	       emptySlotCount , libraryMediaTypeId , libHasSiloData , SUBSTRING(associatedMediaAgents, 0, 4096) AS associatedMediaAgents ,
	       freeSpaceOnLib , capacity , privateData , SUBSTRING(associatedMediaAgentsDisplayName, 0, 4096) AS associatedMediaAgentsDisplayName
		   FROM #librariesOnMA ORDER BY libraryid ASC, isControllingArm DESC
	IF object_id('tempdb.dbo.#tmpLibList') is not null DROP TABLE #tmpLibList
	IF object_id('tempdb.dbo.#librariesOnMA') is not null DROP TABLE #librariesOnMA
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2GetLibListByDPAndMA')
	delete from GxQscripts where name = 'MMS2GetLibListByDPAndMA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetLibListByDPAndMA')
	delete from GXDBVersions where aliasname = 'MMS2GetLibListByDPAndMA'
GO

insert into GXDBVersions values(2, 'MMS2GetLibListByDPAndMA',  '00010007008800090000', 'MMS2GetLibListByDPAndMA', '00010007008800090000')
GO

