

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GetIdxSubStoreInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2GetIdxSubStoreInfo.sp,v $ $Id: MMS2GetIdxSubStoreInfo.sp,v 1.1.2.2 2018/10/24 18:53:10 aselvanayagam Exp $";
--  +===============================================================================================================+
--  | MMS2GetUnAssignedIdxSubStoreInfo - Retrieve list of App_IdxSubStoreInfo for given clientId or subclient Id	|
--  +===============================================================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMS2GetIdxSubStoreInfo')
BEGIN
	print '>>> Drop Stored Procedure: MMS2GetIdxSubStoreInfo <<<'
	drop procedure MMS2GetIdxSubStoreInfo
END
IF EXISTS (select * from GxQscripts where name='MMS2GetIdxSubStoreInfo')
	delete from GxQscripts where name = 'MMS2GetIdxSubStoreInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetIdxSubStoreInfo')
	delete from GXDBVersions where aliasname = 'MMS2GetIdxSubStoreInfo'
GO
print '... Creating Procedure: MMS2GetIdxSubStoreInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MMS2GetIdxSubStoreInfo
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS                         ---
  @i_clientId integer,
  @i_subClientId integer = 0
-----------------------------------------------------------
AS
  DECLARE @o_SIDBStoreId integer
  DECLARE @o_SIDBSubStoreId integer
  DECLARE @o_ClientId integer
  DECLARE @o_IdxAccessPath VARCHAR(1024)
  DECLARE @o_DDBSubClientId integer
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT SIDBStoreId,
	SubStoreId,
	SIDB.ClientId,
	AP.Path,
	SIDB.DDBSubClientId
FROM IdxSIDBSubStore SIDB WITH(READUNCOMMITTED)
INNER JOIN IdxAccessPath AP WITH(READUNCOMMITTED) ON AP.IdxAccessPathId = SIDB.IdxAccessPathId
WHERE ((SIDB.DDBSubClientId = 0 OR SIDB.DDBSubClientId = @i_subClientId)
	OR (@i_subClientId = -1)) -- Indicates all DDB stores (unassigned and assigned) irrespective of the associated DDB subclient Id
AND SIDB.ClientId = @i_clientId
AND SIDB.SealedTime = 0
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2GetIdxSubStoreInfo')
	delete from GxQscripts where name = 'MMS2GetIdxSubStoreInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetIdxSubStoreInfo')
	delete from GXDBVersions where aliasname = 'MMS2GetIdxSubStoreInfo'
GO

insert into GXDBVersions values(2, 'MMS2GetIdxSubStoreInfo',  '00010001000200020000', 'MMS2GetIdxSubStoreInfo', '00010001000200020000')
GO

