

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GetExtendedMediaPropJobs.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2GetExtendedMediaPropJobs.sp,v $ $Id: MMS2GetExtendedMediaPropJobs.sp,v 1.10.208.1 2017/02/10 20:26:43 sjohnson Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2GetExtendedMediaPropJobs <<<'

IF EXISTS (select * from sysobjects where name='MMS2GetExtendedMediaPropJobs')
	drop procedure MMS2GetExtendedMediaPropJobs
IF EXISTS (select * from GxQscripts where name='MMS2GetExtendedMediaPropJobs')
	delete from GxQscripts where name = 'MMS2GetExtendedMediaPropJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetExtendedMediaPropJobs')
	delete from GXDBVersions where aliasname = 'MMS2GetExtendedMediaPropJobs'
GO
print '... Creating Procedure: MMS2GetExtendedMediaPropJobs'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2GetExtendedMediaPropJobs
  @i_queryIdentifier integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_VolumeId Integer
  DECLARE @o_MediaSideName varchar(256)
  DECLARE @o_JobId Integer
  DECLARE @o_JobRetentionFlags Integer
  DECLARE @o_JobCopyStatus Integer
  DECLARE @o_JobStatus Integer
  DECLARE @o_jobDisabledFlags Integer
  DECLARE @o_archFileDataType Integer
  DECLARE @o_archFileName NVARCHAR(2048)
  DECLARE @o_archFileCreateTime Integer
  DECLARE @o_clientId Integer
  DECLARE @o_clientName varchar(256)
  DECLARE @o_appTypeId Integer
  DECLARE @o_appTypeName varchar(256)
  DECLARE @o_backupSetId Integer
  DECLARE @o_backupSetName varchar(256)
  DECLARE @o_appId Integer
  DECLARE @o_subclientName varchar(256)
  DECLARE @o_backupLevel Integer
  DECLARE @o_instanceId Integer
  DECLARE @o_instanceName varchar(256)
  DECLARE @o_fullCycleNum integer
  DECLARE @o_cycleSeqNum integer
-- get Archive Group Type for this media
Declare @l_CopyId	integer
Declare @ArchGroupId	integer
DECLARE @l_AgType INTEGER
set @ArchGroupId = 1
set @l_AgType	= 1
Set @l_CopyId = isNull	(	(	SELECT TOP 1 CopyId
								FROM ##MMS2MediaJobs70
								WHERE queryIdentifier = @i_queryIdentifier
							), 0
						)
IF(@l_CopyId > 0)
BEGIN
	SET @ArchGroupId = (SELECT ArchGroupId
								FROM ArchGroupCopy
								where ID = @l_CopyId)
	SET @l_AgType = (SELECT Type from ArchGroup where Id = @ArchGroupId)
END
-- now actually return
select distinct tt.VolumeId, MS.SideName, tt.jobId,
	(tt.jobRetentionFlags & 256) As isAged, tt.jobStatus,
	isnull(JABS.Status, isnull(JBS.Status, 1)),
	tt.jobDisabledFlags,
	tt.dataType, AF.name as ArchFileName,
	AF.CTime,
	Cl.Id AS ClientId, Cl.name AS ClientName,
	App.AppTypeId,  ApT.name as AppTypeName,
	App.BackupSet AS BackupSetId, BS.name as BackupSetName,
	App.Id as AppId, App.subClientName,
	AF.backupLevel,
	ISN.id AS InstanceId,
	(CASE WHEN AFO.instanceId IS Null THEN ISN.name ELSE (SELECT name FROM APP_InstanceName WHERE id = AFO.instanceId) END) as InstanceName,
	JBS.fullCycleNum, JBS.cycleSequence
from 	##MMS2MediaJobs70 AS tt
     	INNER JOIN MMVolume as V ON V.VolumeId = tt.VolumeId
     	INNER JOIN MMMediaSide AS MS ON MS.MediaSideId = V.MediaSideId
 	INNER JOIN APP_Application AS App ON App.Id = tt.AppId
	INNER JOIN APP_Client AS Cl ON Cl.Id = App.ClientId
	INNER JOIN APP_iDAType AS ApT ON ApT.Type = App.AppTypeId
	INNER JOIN ArchFile AS AF ON AF.id = tt.ArchFileId AND AF.commcellId = tt.CommcellId
	INNER JOIN APP_BackupSetName AS BS ON BS.id = APP.BackupSet
	INNER JOIN APP_InstanceName AS ISN ON ISN.id = APp.Instance
	LEFT OUTER JOIN JMBkpStats AS  JBS ON JBS.jobId = tt.JobId AND JBS.commcellId = tt.CommcellId AND @l_AgType <> 2
	LEFT OUTER JOIN JMAdminJobStatsTable AS JABS ON JABS.jobId = tt.JobId AND JABS.commcellId = tt.CommcellId and ( @l_AgType = 2 OR JABS.opType IN (11,44) )
	LEFT OUTER JOIN archFileOracle AS AFO ON AFO.ArchFileId = tt.ArchFileId AND AFO.commcellId = tt.CommcellId
where queryIdentifier = @i_queryIdentifier
ORDER BY tt.VolumeId, tt.jobId, tt.datatype, isAged, af.name
DELETE FROM ##MMS2MediaJobs70 WHERE queryIdentifier = @i_queryIdentifier
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2GetExtendedMediaPropJobs')
	delete from GxQscripts where name = 'MMS2GetExtendedMediaPropJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetExtendedMediaPropJobs')
	delete from GXDBVersions where aliasname = 'MMS2GetExtendedMediaPropJobs'
GO

insert into GXDBVersions values(2, 'MMS2GetExtendedMediaPropJobs',  '00010010020800010000', 'MMS2GetExtendedMediaPropJobs', '00010010020800010000')
GO

