

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GetExtendedMediaPropInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2GetExtendedMediaPropInfo.sp,v $ $Id: MMS2GetExtendedMediaPropInfo.sp,v 1.7.208.2 2018/03/20 19:55:13 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "MMS2GetExtendedMediaPropInfo"				|
--	|									|
--	| Execute the System stored procedure to fetch the physical files	|
--	| .. for the (current) database.					|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2GetExtendedMediaPropInfo <<<'

IF EXISTS (select * from sysobjects where name='MMS2GetExtendedMediaPropInfo')
	drop procedure MMS2GetExtendedMediaPropInfo
IF EXISTS (select * from GxQscripts where name='MMS2GetExtendedMediaPropInfo')
	delete from GxQscripts where name = 'MMS2GetExtendedMediaPropInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetExtendedMediaPropInfo')
	delete from GXDBVersions where aliasname = 'MMS2GetExtendedMediaPropInfo'
GO
print '... Creating Procedure: MMS2GetExtendedMediaPropInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2GetExtendedMediaPropInfo
  @i_queryIdentifier Integer,
  @i_MediaId integer
AS
  DECLARE @o_SideAVolId Integer
  DECLARE @o_SideAVolData bigint
  DECLARE @o_SideBVolId Integer
  DECLARE @o_SideBVolData bigint
  DECLARE @o_isNeededForAuxCopy Integer
SET NOCOUNT ON
declare @l_RequestTimeStamp INTEGER
set @l_RequestTimeStamp = datediff(second,'01/01/1970', getutcdate())
IF object_id('tempdb.dbo.#tempChunk') is not null DROP TABLE #tempChunk
IF object_id('tempdb.dbo.#tempACM') is not null DROP TABLE #tempACM
IF object_id('tempdb.dbo.##MMS2MediaJobs70') is null
BEGIN
	-- drop table ##MMS2MediaJobs70
	create table ##MMS2MediaJobs70 (	RequestTimestamp Integer,
						queryIdentifier Integer,
						VolumeId Integer,
						JobId Integer,
						CopyId Integer,
						CommcellId Integer,
						AppId	Integer,
						archFileId Integer,
						dataType Integer,
						jobRetentionFlags Integer,
						jobDisabledFlags Integer,
						jobStatus Integer,
						hasAgedChunks	Integer,
						hasNonAgedChunks Integer,
						AFCValid	Integer,
						AFCFlags	Integer
					)
	create index ##MMS2MediaJobs70_id1 on ##MMS2MediaJobs70 (queryIdentifier)
	create index ##MMS2MediaJobs70_id2 on ##MMS2MediaJobs70 (archFileId, queryIdentifier)
	create index ##MMS2MediaJobs70_id3 on ##MMS2MediaJobs70 (jobId, queryIdentifier)
	create index ##MMS2MediaJobs70_id4 on ##MMS2MediaJobs70 (jobStatus,AFCValid,queryIdentifier  )
	create index ##MMS2MediaJobs70_id5 on ##MMS2MediaJobs70 (hasNonAgedChunks, AFCValid, queryIdentifier )
END
ELSE
BEGIN
	declare @l_20minutesago INTEGER
	set @l_20minutesago = datediff(second,'01/01/1970', getutcdate()) - 20*60
	delete from  ##MMS2MediaJobs70 where requesttimestamp < @l_20minutesago
	delete from ##MMS2MediaJobs70  where queryIdentifier = @i_queryIdentifier
END
create table #tempChunk (archChunkId bigint, commcellId Integer, VolumeId Integer, isAged Integer, primary key (archChunkId,commcellId))
create index #tempChunk_isAged ON #tempChunk  (isAged)
insert into #tempChunk
SELECT AC.id, AC.commCellId, V.VolumeId, (AC.flags &  256)
FROM   archChunk as AC  WITH (INDEX(chunk_idx1))
			 INNER JOIN MMVolume as V   ON AC.VolumeId = V.VolumeId AND V.MediaId = @i_MediaId
create table #tempACM (	archFileId Integer,
			copyId Integer,
			archGroupId Integer,
			archChunkId bigint,
			commCellId Integer,
			isAged Integer,
			chunkPhysicalSize bigint,
			VolumeId Integer,
			JobId Integer,
			fileType Integer,
			primary key (archFileId, archChunkId, commcellId))
create index #tempACM_isAged ON #tempACM (isAged)
create index #tempACM_2 ON #tempACM (archFileId, copyId, commcellId)
create index #tempACM_jobId ON #tempACM  (jobId)
insert into #tempACM
SELECT distinct A.archFileId,
		A.archCopyId,
		0,
		A.ArchChunkId,
		A.commCellId,
		(B.isAged | A.flags) & 256 ,
		 A.physicalsize,
		B.volumeId,
		0,
		0
FROM   archChunkMapping A , #tempChunk B
WHERE  A.archChunkId = B.archChunkid AND A.chunkCommCellId = B.commCellId
-- put in archgroupIds
UPDATE #tempACM
SET ArchGroupId = AGC.archGroupId
FROM #tempACM as tt, ArchGroupCopy as AGC
WHERE AGC.id = tt.copyId
UPDATE #tempACM
SET jobId = AF.jobId, fileType = AF.fileType
FROM #tempACM as tt, ArchFile as AF
WHERE AF.id = tt.ArchFileId AND AF.archgroupId = tt.archGroupId AND AF.commcellId = tt.commcellId
-- now put entries into result table
INSERT INTO ##MMS2MediaJobs70
SELECT distinct @l_RequestTimeStamp,
	@i_queryIdentifier ,
	tt.VolumeId,
	tt.JobId,
	tt.copyId,
	tt.CommcellId,
	0,
	tt.archFileId,
	tt.fileType,
	0, tt.isAged, 0, 0, 0, 1, 0
-- 	(jobRetentionFlags, jobDisabledFlags, jobStatus, hasAgedChnks, hasNonAgedChunks, AFCValid, AFCFlags)
FROM #tempACM as tt
UPDATE ##MMS2MediaJobs70
SET hasAgedChunks = 1
FROM ##MMS2MediaJobs70 as tt
WHERE
queryIdentifier = @i_queryIdentifier  AND EXISTS
(
	SELECT tACM.jobId
	FROM #tempACM as tACM
	WHERE 	tACM.jobId = tt.jobId AND tACM.FileType = tt.dataType AND
		tACM.commcellId = tt.commcellId AND
		tACM.isAged = 256
)
UPDATE ##MMS2MediaJobs70
SET hasNonAgedChunks = 1
FROM ##MMS2MediaJobs70 as tt
WHERE
queryIdentifier = @i_queryIdentifier  AND EXISTS
(
	SELECT tACM.jobId
	FROM #tempACM as tACM
	WHERE 	tACM.jobId = tt.jobId AND tACM.FileType = tt.dataType AND
		tACM.commcellId = tt.commcellId AND
		tACM.isAged = 0
)
UPDATE ##MMS2MediaJobs70
SET AFCValid = AFC.isValid, AFCFlags = AFC.Flags
FROM ##MMS2MediaJobs70 as tt, ArchFileCopy as AFC
WHERE
	queryIdentifier = @i_queryIdentifier  AND
	AFC.commcellId = tt.commcellId AND
	AFC.archFileId = tt.archFileId AND AFC.archCopyId = tt.copyId
-- Show the data status for the archive file in this media, not the data status for the job.
UPDATE ##MMS2MediaJobs70
SET 	jobStatus = JDS.status,
	jobDisabledFlags = (jobDisabledFlags | JDS.disabled),
	jobRetentionFlags = JDS.retentionFlags,
	AppId = JDS.AppId
FROM ##MMS2MediaJobs70 as tt, JMJobDataStats as JDS
WHERE tt.queryIdentifier = @i_queryIdentifier  AND
	JDS.jobId = tt.jobId and
	JDS.commcellId = tt.commcellId and
	JDS.dataType = tt.dataType and
	JDS.archGrpCOpyId = tt.CopyId
declare @l_tabVolumeIds TABLE (volumeId Integer, mediaGroupId INTEGER)
INSERT INTO @l_tabVolumeIds
SELECT distinct VolumeId, mediaGroupId from MMVolume where mediaid = @i_MediaId
ORDER BY VolumeId
set @o_sideAVolId = isnull((select top 1 volumeId from @l_tabVolumeIds), 0)
set @o_sideBVolId = isnull((select top 1 volumeId from @l_tabVolumeIds where volumeId <> @o_sideAVolId), 0)
set @o_SideAVolData = isnull (
	(
		select sum(A.physicalsize)
		from
		(	SELECT tACM.ChunkphysicalSize AS physicalSize
			FROM #tempACM AS tACM, ##MMS2MediaJobs70 as tAFC
			WHERE 	tACM.VolumeId = @o_sideAVolId AND
				tAFC.queryIdentifier = @i_queryIdentifier  AND
				tAFC.hasNonAgedChunks = 1 AND
				tACM.isAged = 0 AND (tAFC.AFCFlags & 256) = 0 AND
				tAFC.archFileId = tACM.archFileId AND tACM.CopyId = tAFC.CopyId AND
				tAFC.commcellID = tACM.commcellId AND tAFC.AFCValid = 1
		) as A
	)
 , 0 )
IF (@o_sideBVolId <> 0)
BEGIN
	set @o_SideBVolData = isnull (
	(
		select sum(A.physicalsize)
		from
		(	SELECT tACM.ChunkphysicalSize AS physicalSize
			FROM #tempACM AS tACM, ##MMS2MediaJobs70 as tAFC
			WHERE 	tACM.VolumeId = @o_sideBVolId AND
				tAFC.queryIdentifier = @i_queryIdentifier  AND
				tAFC.hasNonAgedChunks = 1 AND
				tACM.isAged = 0 AND (tAFC.AFCFlags & 256) = 0 AND
				tAFC.archFileId = tACM.archFileId AND tACM.CopyId = tAFC.CopyId AND
				tAFC.commcellID = tACM.commcellId AND tAFC.AFCValid = 1
		) as A
	), 0 )
END ELSE
BEGIN
	set @o_SideBVolData = 0
END
DECLARE @l_mediaGroupId INTEGER
SET @l_mediaGroupId = isNull((SELECT TOP 1 MediaGroupId FROM @l_tabVolumeIds), 0)
set @o_isNeededForAuxCopy = 0
IF (@l_mediaGroupId = 0)
BEGIN
	GOTO ENDAUXCOPYCHECK
	-- not part of a media group, it will not have jobs
END
-- Media could be needed for Auxcopy
DECLARE @l_SPId INTEGER
DECLARE @l_defCopyId INTEGER
DECLARE @l_MediaCopyId INTEGER
DECLARE @l_MediaCommcellId INTEGER
SELECT @l_MediaCopyId = ISNULL((case when (S.flags & 2) = 0 then S.ArchGroupCopyId else (select archGroupCopyId from archStream WITH (NOLOCK) where MediaGroupId = S.mediaGroupId and (flags & 2) = 0) end),  0),
@l_SPId  =  ISNULL((case when (S.flags & 2) = 0 then S.ArchGroupId else (select archGroupId from archStream WITH (NOLOCK) where MediaGroupId = S.mediaGroupId and (flags & 2) = 0) end), 0)
FROM archStream S  WHERE S.mediaGroupId = @l_mediaGroupId
IF (@l_MediaCopyId = 0) OR (@l_SPId  = 0)
BEGIN
	GOTO ENDAUXCOPYCHECK
END
SELECT @l_defCopyId = defaultCopy FROM ArchGroup WHERE id = @l_SPId
DECLARE @l_copyList TABLE (copyId INTEGER)
INSERT INTO @l_copyList
SELECT id FROM archGroupCopy
WHERE  id <> @l_defCopyId AND archGroupId = @l_SPId AND isActive = 1
   AND ((@l_MediaCopyId = @l_defCopyId AND sourceCopyId = 0) OR sourceCopyId = @l_MediaCopyId)
IF EXISTS
 (
	SELECT distinct tt.copyId
	FROM ##MMS2MediaJobs70 as tt, JMJobDataStats as JDS, @l_copyList as tCL
	WHERE tt.queryIdentifier = @i_queryIdentifier AND
	tt.AFCValid = 1 AND tt.hasNonAgedChunks = 1 AND tt.JobStatus = 100 AND (tt.JobDisabledFlags &  (1 + 256)) = 0 AND
	JDS.jobId = tt.jobId AND JDS.commcellId = tt.COmmcellId AND  JDS.dataType = tt.DataType AND
	JDS.archGrpCopyId = tCL.copyId AND JDS.Status in (101,102, 103) AND (JDS.disabled & (1+256)) = 0
 )
BEGIN
	SET @o_isNeededForAuxCopy = 1
END
ENDAUXCOPYCHECK:
DROP TABLE #tempChunk
DROP TABLE #tempACM
select @o_sideAVolId as SideAVolId, @o_SideAVolData as SideAVolData, @o_sideBVolId AS SideBVolId, @o_SideBVolData AS SideBVolData, @o_isNeededForAuxCopy as isMediaNeededForAuxcopy
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2GetExtendedMediaPropInfo')
	delete from GxQscripts where name = 'MMS2GetExtendedMediaPropInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetExtendedMediaPropInfo')
	delete from GXDBVersions where aliasname = 'MMS2GetExtendedMediaPropInfo'
GO

insert into GXDBVersions values(2, 'MMS2GetExtendedMediaPropInfo',  '00010007020800020000', 'MMS2GetExtendedMediaPropInfo', '00010007020800020000')
GO

