

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GetDriveThroughPut.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2GetDriveThroughPut.sp,v $ $Id: MMS2GetDriveThroughPut.sp,v 1.1.304.2 2018/03/20 20:00:17 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2GetDriveThroughPut <<<'

IF EXISTS (select * from sysobjects where name='MMS2GetDriveThroughPut')
	drop procedure MMS2GetDriveThroughPut
IF EXISTS (select * from GxQscripts where name='MMS2GetDriveThroughPut')
	delete from GxQscripts where name = 'MMS2GetDriveThroughPut'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetDriveThroughPut')
	delete from GXDBVersions where aliasname = 'MMS2GetDriveThroughPut'
GO
print '... Creating Procedure: MMS2GetDriveThroughPut'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2GetDriveThroughPut
  @in_driveId integer,
  @in_Hours integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_DataWritten integer
  DECLARE @o_DataRead integer
  DECLARE @o_WrittenDuration bigint
  DECLARE @o_ReadDuration bigint
	select sum(MDH.DataWritten), sum(MDH.DataRead), sum(cast(MDH.DataWriteDurationSec as bigint)), sum(cast(MDH.DataReadDurationSec as bigint))
	from MMDriveHistory as MDH
	where driveId = @in_driveId
	and datediff(Hour, MDH.Modified, getutcdate()) <= @in_Hours
	and (MDH.DataWriteDurationSec > 0 or MDH.DataReadDurationSec > 0)
	-- Andre Madeira - QNet changes
	-- Just get the HistoryTypes = 2 (immediate basis, see trigger) so that we are more accurate.
	and HistoryType = 2
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2GetDriveThroughPut')
	delete from GxQscripts where name = 'MMS2GetDriveThroughPut'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetDriveThroughPut')
	delete from GXDBVersions where aliasname = 'MMS2GetDriveThroughPut'
GO

insert into GXDBVersions values(2, 'MMS2GetDriveThroughPut',  '00010001030400020000', 'MMS2GetDriveThroughPut', '00010001030400020000')
GO

