

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GetDrivePoolList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2GetDrivePoolList.sp,v $ $Id: MMS2GetDrivePoolList.sp,v 1.5.36.2 2018/03/20 19:47:01 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "MMS2GetDrivePoolList"				|
--	|									|
--	| Execute the System stored procedure to fetch the physical files	|
--	| .. for the (current) database.					|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2GetDrivePoolList <<<'

IF EXISTS (select * from sysobjects where name='MMS2GetDrivePoolList')
	drop procedure MMS2GetDrivePoolList
IF EXISTS (select * from GxQscripts where name='MMS2GetDrivePoolList')
	delete from GxQscripts where name = 'MMS2GetDrivePoolList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetDrivePoolList')
	delete from GXDBVersions where aliasname = 'MMS2GetDrivePoolList'
GO
print '... Creating Procedure: MMS2GetDrivePoolList'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2GetDrivePoolList
  @i_libraryId integer,
  @i_masterPoolId integer,
  @i_mediaAgentId integer
AS
  DECLARE @o_drivePoolId integer
  DECLARE @o_drivePoolName NVARCHAR(255)
  DECLARE @o_softState integer
  DECLARE @o_enabled integer
  DECLARE @o_drivePoolType integer
  DECLARE @o_hostClientId integer
  DECLARE @o_hostName char(255)
  DECLARE @o_NDMPHostId integer
  DECLARE @o_NDMPHostName char(255)
  DECLARE @o_totalDrives integer
  DECLARE @o_hostClientName char(255)
	select distinct dp.drivepoolid, dp.drivepoolname, dp.drivepoolsoftstate,
	dp.drivepoolenabled, dp.drivepooltype, mh.clientid, cl.net_hostname,
	ndmphostid= dp.NDMPHostId,
	ndmphostname=(select APP_Client.Net_HostName FROM APP_Client, MMNDMPHostInfo
	WHERE APP_Client.id=MMNDMPHostInfo.ClientId AND MMNDMPHostInfo.ndmphostid = dp.NDMPHostId),
	totalDrives = (select count(*) from MMDriveController as md where
	dp.DrivePoolId = MD.DrivePoolId AND Dp.ClientId = MD.ClientId),
	cl.name
	from MMDrivePool as dp, MMMasterPool as mp,	MMHost as mh, APP_Client as cl
	where 	mh.ClientId = dp.ClientId and
		cl.id = dp.clientid and
		(
			@i_mediaAgentId = 0 OR
			(
				@i_mediaAgentId > 0
			   and	dp.clientid = @i_mediaAgentId
			)
		) and
		dp.masterpoolid = mp.masterpoolid and
		(
			@i_libraryId = 0 OR
			(
				@i_libraryId > 0
			  and	mp.libraryId = @i_libraryId
			)
		) and
		(
			@i_masterPoolId = 0 OR
			(
				@i_masterPoolId > 0
			   and	mp.masterpoolid = @i_masterPoolId
			)
		)
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2GetDrivePoolList')
	delete from GxQscripts where name = 'MMS2GetDrivePoolList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetDrivePoolList')
	delete from GXDBVersions where aliasname = 'MMS2GetDrivePoolList'
GO

insert into GXDBVersions values(2, 'MMS2GetDrivePoolList',  '00010005003600020000', 'MMS2GetDrivePoolList', '00010005003600020000')
GO

