

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GetDrivePoolInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2GetDrivePoolInfo.sp,v $ $Id: MMS2GetDrivePoolInfo.sp,v 1.14.36.3 2018/03/20 19:42:44 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "MMS2GetDrivePoolInfo"				|
--	|									|
--	| Execute the System stored procedure to fetch the physical files	|
--	| .. for the (current) database.					|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2GetDrivePoolInfo <<<'

IF EXISTS (select * from sysobjects where name='MMS2GetDrivePoolInfo')
	drop procedure MMS2GetDrivePoolInfo
IF EXISTS (select * from GxQscripts where name='MMS2GetDrivePoolInfo')
	delete from GxQscripts where name = 'MMS2GetDrivePoolInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetDrivePoolInfo')
	delete from GXDBVersions where aliasname = 'MMS2GetDrivePoolInfo'
GO
print '... Creating Procedure: MMS2GetDrivePoolInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2GetDrivePoolInfo
  @i_drivePoolId integer
AS
  DECLARE @o_libraryId integer
  DECLARE @o_libraryName char(255)
  DECLARE @o_libraryAliasName NVARCHAR(255)
  DECLARE @o_drivePoolName NVARCHAR(255)
  DECLARE @o_softState integer
  DECLARE @o_enabled integer
  DECLARE @o_drivePoolType integer
  DECLARE @o_maxDrivesToSwitch integer
  DECLARE @o_totalDrives integer
  DECLARE @o_hostClientId integer
  DECLARE @o_hostClientName NVARCHAR(255)
  DECLARE @o_hostName NVARCHAR(255)
  DECLARE @o_hostClientReleaseId integer
  DECLARE @o_libraryType integer
  DECLARE @o_BarCodeReaderPresent integer
  DECLARE @o_costCategoryId integer
  DECLARE @o_DisplayName NVARCHAR(255)
  DECLARE @o_Description NVARCHAR(255)
  DECLARE @o_UnitType integer
  DECLARE @o_UnitCost bigint
  DECLARE @o_ndmpHostClientId integer
  DECLARE @o_ndmpHostName NVARCHAR(255)
  DECLARE @o_DrivePoolDescription NVARCHAR(255)
	-- We need consider client ID for NDMP drive pool, which is from MMNDMPHostInfo table
	select mm.libraryid, ml.libraryName, ml.AliasName, md.drivepoolname, md.drivepoolsoftstate,
	md.drivepoolenabled, md.drivepooltype, md.maxdrivestoswitch,
	totalDrives = (select count(*) from MMDriveController as mdc where
								 md.DrivePoolId = mdc.DrivePoolId AND md.ClientId = mdc.ClientId),
	cl.id, cl.name, cl.net_hostname, cl.releaseId, ml.libraryTypeId, ml.BarCodeReaderPresent,
	md.CostCategoryId, '', '', -1,-1,
case md.DrivePoolType when 3
						  then (select ndmp.ClientId from MMNDMPHostInfo as ndmp where md.NDMPHostId = ndmp.NDMPHostId)
						  else 0 end,
case md.DrivePoolType when 3
						  then (select acl.net_hostname from MMNDMPHostInfo as ndmp, App_Client as acl
								where md.NDMPHostId = ndmp.NDMPHostId and ndmp.ClientId = acl.id)
						  else '' end,
	md.Descript
	from MMDrivePool as md, MMMasterPool as mm, APP_Client as cl, MMLibrary as ml
	where cl.id = md.Clientid and
	mm.masterpoolid = md.masterpoolid and
	mm.LibraryId = ml.LibraryId and md.drivepoolid = @i_drivePoolId
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2GetDrivePoolInfo')
	delete from GxQscripts where name = 'MMS2GetDrivePoolInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetDrivePoolInfo')
	delete from GXDBVersions where aliasname = 'MMS2GetDrivePoolInfo'
GO

insert into GXDBVersions values(2, 'MMS2GetDrivePoolInfo',  '00010014003600030000', 'MMS2GetDrivePoolInfo', '00010014003600030000')
GO

