

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GetDriveListV2.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2GetDriveListV2.sp,v $ $Id: MMS2GetDriveListV2.sp,v 1.10.200.2 2018/03/20 20:02:22 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "MMS2GetDriveListV2"				|
--	|									|
--	| Execute the System stored procedure to fetch the physical files	|
--	| .. for the (current) database.					|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2GetDriveListV2 <<<'

IF EXISTS (select * from sysobjects where name='MMS2GetDriveListV2')
	drop procedure MMS2GetDriveListV2
IF EXISTS (select * from GxQscripts where name='MMS2GetDriveListV2')
	delete from GxQscripts where name = 'MMS2GetDriveListV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetDriveListV2')
	delete from GXDBVersions where aliasname = 'MMS2GetDriveListV2'
GO
print '... Creating Procedure: MMS2GetDriveListV2'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2GetDriveListV2
  @i_drivePoolId integer,
  @i_masterPoolId integer
AS
  DECLARE @o_driveId integer 
  DECLARE @o_aliasName NVARCHAR(255)
  DECLARE @o_driveTypeId integer 
  DECLARE @o_driveTypeStr char(255)
  DECLARE @o_enabled integer 
  DECLARE @o_broken integer 
  DECLARE @o_softState integer 
  DECLARE @o_cleaningRequired integer 
  DECLARE @o_dmsId integer 
  DECLARE @o_dmsSoftState integer 
  DECLARE @o_dmsDrivePoolId integer 
  DECLARE @o_dmsDPMAId integer 
  DECLARE @o_dmsDPMAName char(255)
  DECLARE @o_canBeCleaned integer 
  DECLARE @o_externalGUID char(255)
  DECLARE @o_driveOfflineReason integer 
  DECLARE @o_isDriveReserved integer 
  DECLARE @o_driveNumber integer 
  DECLARE @o_driveElementAddress integer 
  DECLARE @o_numMountsLifeTime integer 
  DECLARE @o_numMinutesUsedSinceClean integer 
  DECLARE @o_numMinutesUsedLifeTime integer	
  DECLARE @o_usesScsi2reservation integer
-- and resource information
  DECLARE @o_mountStatus integer 
  DECLARE @o_mediaId integer 
  DECLARE @o_barCode char(255)
  DECLARE @o_jobId bigint 
  DECLARE @o_ReserveBitMask integer
  DECLARE @o_ReleaseTime integer
  DECLARE @o_LogicalRelease integer 
  DECLARE @o_OpPhase integer
  DECLARE @o_CopyId integer
  DECLARE @o_StoragePolicyId integer
  DECLARE @o_StoragePolicyName NVARCHAR(256)
-- Additional info for CleanDrives dialog
  DECLARE @o_numSoftErrorsLifeTime integer
  DECLARE @o_numSoftErrorsSinceClean integer
  DECLARE @o_numHardErrorsLifeTime integer
  DECLARE @o_numHardErrorsSinceClean integer
  DECLARE @o_DriveAccessible integer
  DECLARE @o_driveAttributes integer
  DECLARE @o_slotElementAddress integer
  DECLARE @o_DriveOccupied integer
  DECLARE @o_LSCSName nvarchar(256)
	SET NOCOUNT ON
	declare @tmpDriveCtrls	table (
					DriveId					integer,
					DrivePoolId				integer,
					MasterPoolId			integer,
					DriveControllerId		integer,
					DriveAccessible			integer,
					DriveControllerActive	integer,
					DriveControllerSoftState integer,
					DriveControllerEnabled	integer,
					ClientId				integer,
					hasSCSIReserved			integer,
					MediaId					integer
				)
	-- determine drives to display
	if object_id('tempdb.dbo.#tmpDrive') is not null DROP TABLE #tmpDrive
	create table #tmpDrive	(
					driveId				integer,
				 	scsiReserved		integer,
				 	activeDCId			integer,
				 	DCDPId				integer,
				 	DCDPMAId			integer,
				 	DCDPMAName			varchar(256),
				 	dmsSoftState		integer,
				 	isDriveReserved		integer,
					MediaId				integer,
					ReservationId		integer,
					LogicalRelease		integer,
					OpPhase				integer,
					CopyId				integer,
					StoragePolicyId		integer,
					StoragePolicyName	nvarchar(256),
					driveAccessible		integer,
					ElementAddress		integer
				  )
	insert into @tmpDriveCtrls
	select  md.driveId, mdc.drivePoolId, md.MasterPoolId,
			mdc.driveControllerId, mdc.DriveAccessible,
			mdc.DriveControllerActive, mdc.DriveControllerSoftState,
			mdc.DriveControllerEnabled,
			mdc.ClientId, mdc.hasSCSIReserved, md.MediaId
	from	MMDrive as md, MMDriveController as mdc
	where	md.driveId = mdc.driveId
	update @tmpDriveCtrls
	set		DriveAccessible = 0
	where	DriveControllerEnabled = 0
	or		DriveControllerSoftState = 0
	declare @tmpDriveAccessible table (
			driveId integer,
			driveAccessible integer,
			numDriveController integer,
			numAccessibleController integer
			)
	insert	into @tmpDriveAccessible
	select	driveId, 2, count(DriveControllerId), sum(DriveAccessible)
	from	@tmpDriveCtrls
	group	by driveId
	-- update the accessibility
	-- driveAccessible is default to 2 - Partially accessible.
	-- driveAccessible is set to 1 if it is fully accessible.
	-- driveAccessible is set to 0 if it is not accessible at all.
	update	@tmpDriveAccessible set driveAccessible = 1
	where	numDriveController = numAccessibleController
	update	@tmpDriveAccessible set driveAccessible = 0
	from	@tmpDriveAccessible tt, MMDrive md
	where	tt.driveId = md.driveId
	and		(tt.numAccessibleController = 0
			or md.DriveEnabled = 0
			or md.DriveSoftState = 0
			or md.DriveBroken = 1)
	-- compute the drive controller property
	insert into #tmpDrive
	select	distinct a.DriveId, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, 0, 0, 0, '',
			b.driveAccessible, 0
	from	@tmpDriveCtrls a, @tmpDriveAccessible b
	where	a.driveId = b.driveId
	and		((@i_drivePoolId > 0 and drivePoolId = @i_drivePoolId)
	or		(@i_drivePoolId = 0 and masterPoolId = @i_masterPoolId))
	update #tmpDrive
	set scsiReserved = 1
	from @tmpDriveCtrls as tdc, #tmpDrive as tt
	where tdc.DriveId = tt.DriveId and tdc.hasSCSIReserved != 0
	update #tmpDrive
	set	activeDCId = tdc.DriveControllerId, dmsSoftState = tdc.DriveControllerSoftState,
		DCDPId = tdc.DrivePoolId, DCDPMAName = cc.Name, DCDPMAId = cc.id
	from	@tmpDriveCtrls as tdc, #tmpDrive as tt, App_client as cc
	where	tdc.DriveControllerActive = 1 and tdc.DriveId = tt.DriveId and
		tdc.ClientId = cc.id
	-- ** get reservation infos **
	-- is drive reserved and get mediaInfo
	update #tmpDrive
	set isDriveReserved = 1, ReservationId = MR.ReservationId, MediaId = MR.MediaId, LogicalRelease = MR.LogicalRelease,
	CopyId = MR.CopyId
	from MMResource as mr, #tmpDrive as tt
	where tt.DriveId = mr.DriveId
	update #tmpDrive
	set	MediaId = tdc.MediaId
	from	@tmpDriveCtrls as tdc, #tmpDrive as tt
	where	tt.MediaId = 0 and tdc.DriveId = tt.DriveId and tdc.MediaId > 0
	update #tmpDrive
	set	StoragePolicyId = ag.id, StoragePolicyName = ag.name
	from	archGroupCopy as AGC, archGroup as AG, #tmpDrive as tt
	where	tt.CopyId > 0 AND tt.CopyId = AGC.Id AND AGC.ArchGroupId = ag.id
	update #tmpDrive
	set ElementAddress = (MD.DriveNumber + ML.BaseAddress -1)
	from MMDrive as MD, MMMasterPool AS MMP, MMLibrary as ML, #tmpDrive as tt
	where MD.DriveId = tt.DriveId AND MD.MasterPoolId = MMP.MasterPoolId
	AND MMP.LibraryId = ML.LibraryId
	-- ** now return all the info
	SELECT 	tt.DriveId, md.AliasName, mt.drivetypeid, mt.drivetypename,
		md.DriveEnabled, md.DriveBroken, md.DriveSoftState,
		md.CleaningRequired,
	       	tt.activeDCId,  tt.dmsSoftState, tt.DCDPId,  tt.DCDPMAId, tt.DCDPMAName, mt.canbecleaned,
	       	md.externalguid, md.OfflineReason, tt.isDriveReserved, md.DriveNumber,
	       	tt.ElementAddress, md.NumMountsLifeTime, md.MinutesUsedSinceClean, md.MinutesUsedLifeTime,
	       	tt.scsiReserved, md.MountStatus,
	       	tt.MediaId, isnull(mm.BarCode,''),
		JobId = convert(bigint,isnull(MJ.jobId_h, 0))*2147483648+convert(bigint,isnull(MJ.jobId_l,0)),
		isnull(MJ.ReservebitMask, 0), isnull(MJ.ReleaseTime, 0), tt.LogicalRelease, MD.OpPhase,
		tt.CopyId, StoragePolicyId, StoragePolicyName, md.NumSoftErrsLifeTime, md.NumSoftErrsSinceClean,
		md.NumHardErrsLifeTime, md.NumHardErrsSinceClean, tt.driveAccessible, md.Attributes, md.SlotElementAddress, md.DriveOccupied, md.LSCSName
	FROM 	#tmpDrive AS tt LEFT OUTER JOIN mmresourcetojob AS MJ ON MJ.ReservationId = tt.ReservationId
		LEFT OUTER JOIN MMMedia as MM ON MM.MediaId = tt.MediaId,
		MMDrive as md, MMDriveType as mt
	WHERE MD.driveId = tt.driveId and mt.DriveTypeId = MD.DriveTypeId
	ORDER BY tt.DriveId, JobId
	DROP TABLE #tmpDrive
	SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2GetDriveListV2')
	delete from GxQscripts where name = 'MMS2GetDriveListV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetDriveListV2')
	delete from GXDBVersions where aliasname = 'MMS2GetDriveListV2'
GO

insert into GXDBVersions values(2, 'MMS2GetDriveListV2',  '00010010020000020000', 'MMS2GetDriveListV2', '00010010020000020000')
GO

